P $!------------------------------------------------------------------------------0 $!  Compile and/or link JUMP under VAX or Alpha. $!  $!  Optional P1 parameter value: $!; $!      None    - if P1 is missing, link with NO TRACEBACK. = $!      C       - if "C" is in P1, compile Pascal sources and 0 $!                       link with NO TRACEBACK.N $!      D       - if "D" is in P1, compile ALL possible Pascal sources for theP $!                       current architecture (for building a JUMP distribution)C $!                       and link as appropriate with NO TRACEBACK. : $!      L       - if "L" is in P1, link with NO TRACEBACK.7 $!      T       - if "T" is in P1, link with TRACEBACK.  $!1 $!  If P1 contains both "L" and "T", "T" is used. P $!..............................................................................+ $!  Author and Maintainer: Jonathan Ridler. H $!  Maintained on behalf of ITS, The University of Melbourne, Australia. $!+ $!  Internet: jump-enquiries@unimelb.edu.au P $!..............................................................................; $!  With new releases of OpenVMS, JUMP *MUST* be re-linked.  $! $!  History:6 $!      25-Sep-2001     JER     Updated for JUMP V4.0.: $!      07-May-2002     JER     Allow distribution builds.: $!      01-Apr-2004     JER     Allow build under V7.3-2+.I $!                              Also, display JUMP version at build time. 1 $!      27-May-2004     JER     Allow IA64 build. P $!------------------------------------------------------------------------------ $  $ on ERROR  then  EXIT $ say    := write SYS$OUTPUTJ $ arch    = f$getsyi ("ARCH_NAME")                      ! "VAX" or "Alpha"I $ version = f$edit (f$getsyi ("VERSION"),"TRIM")        ! OpenVMS version L $ VMS     = f$extract (f$locate(version,"."),5,version) ! = "X.X" or "X.X-X" $ trace  := /notraceback $ F $ p1    = f$edit (p1+p2+p3+p4+p5+p6+p7+p8,"UPCASE,UNCOMMENT,COLLAPSE") $ p1len = f$length (p1) ) $ dist  = (f$locate ("D",p1) .nes. p1len) 5 $ compile = (f$locate ("C",p1) .nes. p1len) .or. dist F $ linking = (p1 .eqs. "")  .or. (f$locate ("L",p1) .nes. p1len) .or. -8             compile .or. (f$locate ("T",p1) .nes. p1len) $ pid   = f$getjpi ("","PID")  $  $ arch_defs = ""< $ if f$search ("SYS$LIBRARY:ARCH_DEFS.MAR") .nes. ""  then -4      arch_defs = "SYS$LIBRARY:ARCH_DEFS+SYS$DISK:[]" $  $ not_arch = ""  $ < $ if (arch .eqs. "VAX")                   ! VAX architecture $ then $   nowarning = "" $   not_arch  = "Alpha"  $ endif  $ > $ if (arch .eqs. "Alpha")                 ! Alpha architecture $ then( $   nowarning = "/warning=noinformation" $   not_arch  = "VAX"  $ endif  $ @ $ if (arch .eqs. "IA64")                  ! Itanium architecture $ then( $   nowarning = "/warning=noinformation" $   not_arch  = "VAX"  $ endif  $  $ if (not_arch .eqs. "") $ thenG $   say "%JUMPBUILD-F-NOSUPPORT, Architecture (''arch') not supported." 
 $   EXIT 1 $ endif  $ L $ perform = 1   ! If the Pascal compiler is V5.2 or earlier, set perform = 0 $  $ if perform $ then? $   usage_types = "all,noperformance"   ! Assume Pascal >= v5.3  $ else? $   usage_types = "all"                 ! Assume Pascal <= v5.2  $ endif  $ B $ arb_module = "jump_noarb"             ! Assume ARB not supported@ $ other_arb_module = "jump_arb"         ! For distribution build $ J $ if (VMS .lts. "7.2") .or. (arch .eqs. "VAX") ! PSB not on VAX or pre-7.2 $ thenD $   dummy_psb  = "jump_dummy_psb"       ! Supply dummy PSB variables $ else< $   dummy_psb = ""                      ! Use the real thing- $!  Check if ARB full support is required ... & $   if f$getsyi ("ARB_SUPPORT") .eq. 3 $   then $     arb_module = "jump_arb" @ $     other_arb_module = "jump_noarb"   ! For distribution build	 $   endif  $ endif  $ * $! Use the OPT file to get the version ... $  $ jump_version = "" . $ temp := SYS$SCRATCH:JUMP_TEMP_FILE_'pid'.TMP/ $ search jump.opt identification /output='temp'  $ close fyl /nolog7 $ open fyl 'temp' /read /error=FYL_ERROR /end=FYL_ERROR 7 $ read fyl jump_version /error=FYL_ERROR /end=FYL_ERROR < $ jump_version = jump_version - "IDENTIFICATION = """ - """"* $ jump_version = "(" + jump_version + ") " $FYL_ERROR:  $ close fyl /nolog; $ if f$search (temp) .nes. ""  then  delete /nolog 'temp';*  $ G $ say "Building JUMP ''jump_version'for OpenVMS ''arch' ''version' ..." * $ if dist  then  say "Distribution build." $ L $!  Not all sites will have a Pascal compiler, so only compile if requested. $  $ if compile $ then+ $   say "Compiling JUMP Pascal sources ..."   $   say "  ... Main program ..."> $   pascal jump /usage=('usage_types') /object=jump.obj_'arch' $ 9 $   say "  ... Dummy ''not_arch' architecture module ..." 9 $   pascal jump_dummy_'not_arch' /usage=('usage_types') - 3            /object=jump_dummy_'not_arch'.obj_'arch'  $ & $   if (dummy_psb .eqs. "") .and. dist $   then& $     say "  ... Dummy PSB module ..."4 $     pascal jump_dummy_psb /usage=('usage_types') -.              /object=jump_dummy_psb.obj_'arch'	 $   endif  $  $   if dummy_psb .nes. ""  $   then& $     say "  ... Dummy PSB module ..."N $     pascal 'dummy_psb' /usage=('usage_types') /object='dummy_psb'.obj_'arch'	 $   endif  $  $   say "  ... ARB module ..."N $   pascal 'arb_module' /usage=('usage_types') /object='arb_module'.obj_'arch' $  $   if dist  $   then& $     say "  ... Other ARB module ..."8 $     pascal 'other_arb_module' /usage=('usage_types') -2              /object='other_arb_module'.obj_'arch'	 $   endif  $ endif  $ F $ if dummy_psb .nes. ""  then  dummy_psb = dummy_psb + ".obj_''arch'," $ H $!  Macro, CLD and Message compilers are standard on OpenVMS, so compileC $!  each time to ensure the object is correct for the architecture.  $ ' $ say "Compiling JUMP Macro source ..." B $ macro 'arch_defs'jump_parse_id 'nowarning' /object=jump_parse_id $ % $ say "Compiling JUMP CLD source ..."  $ set command /object jump_cld $ ) $ say "Compiling JUMP Message source ..."  $ message jump_msg $  $ if linking $ thenA $   if (f$locate ("T",p1) .nes. p1len)  then  trace := /traceback  $   say "Linking JUMP ..." $  $   if arch .eqs. "VAX"  $   then) $     link 'trace'                      - )                 jump.obj_vax,           - D                 jump_dummy_alpha.obj_vax, -     ! Yes, that's right!)                 'arb_module'.obj_vax,   - )                 'dummy_psb'             - )                 jump_parse_id.obj,      - )                 jump_cld.obj,           - )                 jump_msg.obj,           - )                 jump.opt/option,        - ,                 SYS$SYSTEM:SYS.STB/select, -!                 SYSDEF.STB/select  $     link_status = $status 	 $   endif  $  $   if arch .eqs. "Alpha"  $   then) $     link /sysexe 'trace'              - )                 jump.obj_alpha,         - D                 jump_dummy_vax.obj_alpha, -     ! Yes, that's right!)                 'arb_module'.obj_alpha, - )                 'dummy_psb'             - )                 jump_parse_id.obj,      - )                 jump_cld.obj,           - )                 jump_msg.obj,           - )                 jump.opt/option,        - 5                 SYS$LOADABLE_IMAGES:SYSDEF.STB/select  $     link_status = $status 	 $   endif  $  $   if arch .eqs. "IA64" $   then) $     link /sysexe 'trace'              - (                 jump.obj_ia64,         -C                 jump_dummy_vax.obj_ia64, -     ! Yes, that's right! (                 'arb_module'.obj_ia64, -)                 'dummy_psb'             - )                 jump_parse_id.obj,      - )                 jump_cld.obj,           - )                 jump_msg.obj,           - )                 jump.opt/option,        - 5                 SYS$LOADABLE_IMAGES:SYSDEF.STB/select  $     link_status = $status 	 $   endif  $ endif  $  $ if linking .and. link_status $ then8 $   say "*** JUMP ''jump_version'built successfully ***"N $   say "Remember to install JUMP according to the installation instructions!" $ endif  $  $ EXIT 1