/* Program Name            : DIRECT.H                                   */
/*   Original Author       : C. K. Hun                                  */
/*   Date                  : 20-MAY-1991                                */
/*   Program Description   :                                            */  
/*                         :                                            */ 
/* Revision History follows                                             */
/*

/* **	MACRO DEFINITIONS ** */

#define DIRTREE_PBD_ROW			4
#define DIRTREE_PBD_COLUMN		1
#define DIRTREE_CMDS_PBD_ROW		1
#define DIRTREE_CMDS_PBD_COLUMN		1
#define DIRTREE_DIRECT_ROW		3
#define DIRTREE_CMDS_RSV_LNS		5

#define LINESPACE			2	/**  Vertical distance	     **/
#define LINE_NODE_DISTANCE		2
#define LINE_COUNT			3	/**  Horizontal distance     **/
#define DISTANCE_COUNT			11	/**  MAXDIRSPEC + LINE_COUNT **/
#define MAXDIRSPEC			8	/**  Max char # in dir name  **/

#define DIRTREE_PFS    	"1HELP   2DIRECT 3FIND/F 4FIND/N 5FIRST  6LAST   7INITAL 8PAGE   9       0CANCEL "


/* ****	GLOBAL DECLARATIONS *** */
typedef struct node_tag {
	char full_path_name[MAXFILESPEC+1];
	char short_path_name[MAXFILESPEC+1];
	int row,
	    column;
	struct node_tag *left,
			*right,
			*up,
			*down;
} TD_NODE_TAG;

enum dirtree_directions_tag {
	left, right, up, down, dummy
};


/* ****	FUNCTION PROTOTYPING *** */

int filer_direct(void);
int direct_process_loop(void);
int find_root(char *, char *);
TD_NODE_TAG *create_node(char *, int, int);
int build_tree(TD_NODE_TAG **, char *);
TD_NODE_TAG *add_node(TD_NODE_TAG **, char *, TD_NODE_TAG *);
TD_NODE_TAG *find_prev_node(TD_NODE_TAG *);
TD_NODE_TAG *find_next_node(TD_NODE_TAG *);
int traverse_tree(TD_NODE_TAG *, TD_NODE_TAG *, int, int, enum directions);
TD_NODE_TAG *search_node(TD_NODE_TAG *, char *);
void paint_dirtree_display(TD_NODE_TAG *);
int free_dirtree(TD_NODE_TAG **, TD_NODE_TAG *);    
int put_dirtree_title(TD_NODE_TAG *);
int direct_helpdir(void);
int direct_alarm_working(void);

