/* Program Name            : FILERPRT.C                                 */
/*   Original Author       : C. K. Hung					*/
/*   Date                  : 3-AUG-1990					*/
/*   Program Description   :                                            */
/*                         :                                            */
/* Revision History follows                                             */
 
#include "global.h"
#include "dx.h"
#include "filer.h"
#include "filerkpd.h"
#include "filerprt.h"
#include "inquire.h"
#include <jbcmsgdef.h>
#include <sjcdef.h>
 
 
/*
**  MACRO DEFINITIONS
**/
 
/**  Default line printer type			**/
#define DEFAULT_PRINTER				"SYS$PRINT"
 
 
/*
**
**  INTERNAL FUNCTION PROTOTYPING
**
**/
 
 

/*
**++
**  FUNCTIONAL DESCRIPTION:
**
**      tbs
**
**--
**/
int	filer_print()
{
    if (DX_CURRENT_DIRECTORY.filemode == multiple)
	filer_multiple_print();
    else
	filer_single_print();
     return DX__NORMAL;
}
 
 
/*
**++
**  FUNCTIONAL DESCRIPTION:
**
**      to be specified
**
**--
**/
int	filer_multiple_print()
{
    char dummy[] = "";
    char errmsg[MAXFILESPEC+1];
 
    strcpy(errmsg, "Error printing file");
    multi_get_userinput_and_exec(
        filer_print$1,
        "Multiple Print",
        "Print to queue: ",
        "",
        errmsg);
     return DX__NORMAL;
}
 
 
/*
**++
**  FUNCTIONAL DESCRIPTION:
**
**      to be specified
**
**--
**/
int	filer_single_print()
{
    char dummy[] = "";
    char errmsg[MAXFILESPEC+1];
    char fn[MAXFILESPEC+1];
 
    if (!strcmp(DX_CURRENT_FILE->fn, "[-]"))
    {
        signal_err("Print a parent directory file not allowed", bell);
    }
    else
    {
	find_full_path_name(DX_CURRENT_FILE->fn, fn, cntrl_info_block.cur_win);
	strcpy(errmsg, "Error printing file");
	get_userinput_and_execute(
	    filer_print$1,
	    "Print File",
	    "Ouput to queue: ",
	    DEFAULT_PRINTER,
	    errmsg,
	    fn);
    }
     return DX__NORMAL;
}
 
 
/*
**++
**  FUNCTIONAL DESCRIPTION:
**
**      to be specified
**
**--
**/
int	filer_print$1(queue_name, filespec, errmsg)
char *queue_name;
char *filespec;
char *errmsg;
{
    unsigned long entry_number;
    struct item_list_3
    {
	unsigned short buf_len;
	unsigned short item_code;
	char *buf_addr;
	unsigned short *ret_len;
    } itmlst[] =
    {
	{ strlen(filespec), SJC$_FILE_SPECIFICATION, filespec, 0 },
	{ strlen(queue_name), SJC$_QUEUE, queue_name, 0 },
	{ sizeof (unsigned long), SJC$_ENTRY_NUMBER_OUTPUT, &entry_number, 0 },
	{ 0, 0, 0, 0 }
    };
 
    unsigned long status;
    unsigned int iosb[2];
    char msg[512];
 
    sys$sndjbcw (
	     0,
	     SJC$_ENTER_FILE,
	     0,
	     &itmlst,
	     iosb,
	     0,
	     0);
 
    if (iosb[0] != JBC$_NORMAL)
    {
	sprintf(errmsg, "Insufficient privilege for print operation");
	return DX__ERROR;
    }
 
    sprintf(msg, "%s has been sent to \"%s\"", filespec, queue_name);
    signal_err(msg, silence);
 
    return DX__NORMAL;
}
