#include "tachyon_utilities:sample_dispatcher.h"
#include "tachyon_utilities:sample_unpriv_c_services.h"
#include <lib$routines.h>
#include <stdio.h>
#include <starlet.h>
#include <string.h>
#include <descrip.h>



/************************************************************************/
/*									*/
/* This module contains functions that execute in user mode.  It is 	*/
/* better to separate privileged routines from unprivileged and place   */
/* them into two separate shareable images.  Unprivileged routines call */
/* system services, run-time library routines, etc.  Some of these 	*/
/* have baggage that causes problems when linked into a shareable	*/
/* image (the image must be made writeable, etc.).  Also, privileged    */
/* routines must not call unprivileged shareable images.  		*/
/*									*/
/************************************************************************/



/************************************************************************/
/*									*/
/*									*/
/*    print_control_block_address(block,what)				*/
/*									*/
/*    This routine executes in user mode 				*/
/*									*/
/************************************************************************/

void print_control_block_address(long block,char what[])

{
printf("The %s address is: %x\n",what,block);
}

/************************************************************************/
/*									*/
/* get_date_time_string(date_time_quad,date_time_string)		*/
/*									*/
/*    This routine executes in user mode 				*/
/*									*/
/************************************************************************/


long get_date_time_string(Date date_time_quad, char date_time_string[])


{
int sts, ascii_time_len;
$DESCRIPTOR (ascii_time, "XX-XXX-XXXX 00:00:00.00"); /* Filler */

ascii_time.dsc$a_pointer = date_time_string;
ascii_time_len = 0;
sts = sys$asctim(&ascii_time_len, &ascii_time, &date_time_quad, 0);
if (!(sts & 1)) return sts;
date_time_string[ascii_time_len] = '\0';
return sts;
}

/************************************************************************/
/*									*/
/* assign_channel (dev_name,flags)					*/
/*									*/
/*    This routine executes in user mode 				*/
/*									*/
/************************************************************************/

long assign_channel (char dev_name[],long flags)

{
long temp_chan;
long sts;
struct dsc$descriptor device_desc;

  /* assign i/o channel to device */


  /* set up file name descriptor */
  device_desc.dsc$b_dtype = DSC$K_DTYPE_T;
  device_desc.dsc$b_class = DSC$K_CLASS_S;
  device_desc.dsc$a_pointer = dev_name;
  device_desc.dsc$w_length = strlen(dev_name);

  temp_chan = 0; /* zero out the high order word */

  sts = sys$assign (&device_desc, &temp_chan, 0, 0,flags); /* assign i/o channel */

  if (!(sts & 1)) return 0;

  return temp_chan;
}
