$ dbg = "''f$verify( f$integer( f$trnlnm( "f$verify" ) ) )'"
$!++
$! BUILD.COM - Build Procedure for IMGID and IMGID extras
$! (c) Copyright 1995, Mellon Bank of PA
$! All rights reserved
$! 
$! ENVIRONMENT
$! 
$!    OpenVMS v5.5-2
$!    OpenVMS DCL
$! 
$! ABSTRACT
$! 
$!    Build and link for IMGID.C and the package "extra" .DCL file.
$!    Some logic borrowed from Ehud Gavron's CLRREF build procedure
$!    (that is dynamically building the required .H files for IMGID
$!    from LIB.MLB extracts).
$!
$!    Takes into account GNU C if installed properly on your system.
$!
$! AUTHOR, INSTALLATION and DATE
$! 
$!    Chris Olive
$!    Senior Programmer Analyst
$!    Mellon Bank
$!    Pittsburgh, PA
$!    3/4/96
$! 
$! MODIFICATION HISTORY
$! 
$!    Revision    Date          Author/Comments
$!    ----------- ------------- ---------------------------------------------
$!    v1.01-000   3/7/96        Chris Olive
$!
$!    o Made Alpha-ready to the extent possible without having an Alpha
$!      around!  I believe it'll work though...
$!    o Added "options" to build process.  They are as follows:
$!
$!         NOGENERATE - Do not generate headers from SYS$LIBRARY:*.MLB
$!         NOLINK     - Do not link; only compile
$!         LINK       - Go directly to link; do not generate or compile
$!
$!      These should be specified on the command line as the first parameter
$!      and comma delimited if they are used at all.  If LINK and NOLINK are
$!      both specified, LINK takes precedence.
$!
$!      Example: $ @BUILD NOGENERATE   ! Build everything but headers
$!               $ @BUILD NOLINK       ! Build everything but don't link
$!               $ @BUILD LINK         ! Link all objects directly; no build
$!               $ @BUILD NOGEN,NOLINK ! Build source file object from headers
$!                                     ! currently in directory and do not link
$!--
$
$!--- Setup section ---
$
$ __GNUC__  = f$trnlnm( "GNU_CC" ) .nes. ""      ! Using GNU C?
$ __ALPHA__ = f$getsyi( "HW_MODEL" ) .ge. 1024   ! Using an ALPHA?
$
$ arch := VAX
$ if __ALPHA__ then arch := ALPHA
$
$ if __GNUC__
$    then
$    compile := gcc
$    ! GNU C is not yet Alpha-ready, hence no __ALPHA__ check here like below!
$    load := 'xlink
$ else
$    compile := cc
$    if __ALPHA__ then compile := cc/define=__ALPHA__
$    load := link/notrace/user
$ endif
$
$ options = "," + p1
$ ask    := read sys$command/prompt=
$ echo   := write sys$output
$ mtoh   := call mtoh
$ really  = " "
$
$ if f$locate( ",LINK", options ) .lt. f$length( options ) then goto direct_link
$
$!--- Build header files ---
$
$ if f$locate( ",NOGEN", options ) .lt. f$length( options ) then goto skip_gen
$
$ echo f$fao( "Generating required !AS .h files...", arch )
$ if __ALPHA__
$    then
$    mtoh $eihddef eihddef.h
$    mtoh $eihidef eihidef.h
$ else
$    mtoh $ihddef ihddef.h
$    mtoh $ihidef ihidef.h
$ endif
$ mtoh $libdef libdef.h starlet
$
$!--- Compile ---
$
$ skip_gen:
$ echo f$fao( "Compiling IMGID.C using !AS options and headers...", arch )
$ on warning then exit
$ on error then exit
$ compile imgid
$
$!--- Link ---
$
$ if f$locate( ",NOLIN", p1 ) .lt. f$length( p1 ) then goto skip_link
$
$ direct_link:
$ echo "Linking IMGID.OBJ..."
$ define/nolog/user lnk$library sys$library:vaxcrtl
$ load imgid
$
$!--- Other ---
$
$ skip_link:
$ ask "Rename all IMGID*.DCL command files to .COM (Y/N)? " yn
$ if f$integer( yn )
$    then
$    echo "Renaming IMGID*.DCL command files..."
$    really rename/nolog imgid*.dcl .com
$ endif
$
$!--- Bye! ---
$
$ echo "IMGID build complete!"
$ exit 1+0*f$verify( dbg )
$
$!--- Subroutines ---
$
$ mtoh: subroutine
$    module  = p1
$    header  = p2
$    library = f$parse( p3, "SYS$LIBRARY:LIB.MLB" )
$    name    = f$parse( header,,, "NAME", "SYNTAX_ONLY" )
$    macro  := sys$scratch:'name'.mar;
$
$    echo f$fao( "!_!AS", header )
$
$    really library/extract='module'/output='macro 'library
$    open/read  mar% 'macro
$    open/write h% 'header
$    write h% "/* Autogenerated header"
$    write h% ""
$    write h% f$fao( "!_ Library: !AS", library )
$    write h% f$fao( "!_Platform: !AS", arch    )
$    write h% f$fao( "!_DateTime: !%D", 0       )
$    write h% f$fao( "!_Code-Gen: !AS", f$environment( "PROCEDURE" ) )
$    write h% ""
$    write h% "*/"
$    while:
$       read/end=end/error=end mar% record
$       record = f$edit( record, "COMPRESS,TRIM" )
$       if f$element( 0, " ", record ) .eqs. "$EQU"
$          then
$          write h% f$fao( "#define!_!AS !AS", f$element( 1, " ", record ), f$element( 2, " ", record ) )
$       endif
$       goto while
$    end:
$    close mar%
$    close h%
$    really delete/nolog/noconfirm 'macro
$    exit
$ endsubroutine
