$ dbg = "''f$verify( f$integer( f$trnlnm( "f$verify" ) ) )'"
$!++
$! IMGID_USING_SCAN4 - Image Header Information Area Display using SCAN4
$! (c) Copyright 1996, Chris Olive
$! All rights reserved
$! 
$! ENVIRONMENT
$! 
$!    OpenVMS v5.5-2
$!    OpenVMS DCL
$! 
$! ABSTRACT
$! 
$!    Driver/wrapper for SCAN4 utility found at
$!    ftp://ftp.wku.edu/vms/fileserv/scan4.zip.
$!
$!    This seems like shameless self-promotion, but after spending the
$!    time writing IMGID.C, I realized (a) I could have gotten the same
$!    imformation easier in a quick DCL hack, also provided (IMGID.DCL),
$!    or (b) a very useful utility called SCAN4 could have given me
$!    much the same information without writing ANYTHING, which is why
$!    I *wrote* SCAN4 to begin with!  So I thought I'd at least promote
$!    SCAN4 here since it would have saved me a few hours time writing
$!    a hack I didn't need to start with.  SCAN4 will reduce many such
$!    hacks, and I recommend it for the busy programmer/administrator.
$! 
$! AUTHOR, INSTALLATION and DATE
$! 
$!    Chris Olive
$!    Senior Programmer Analyst
$!    Mellon Bank
$!    Pittsburgh, PA
$!    3/4/96
$! 
$! MODIFICATION HISTORY
$! 
$!    Date        Author        Modification(s)
$!    ----------- ------------- ---------------------------------------------
$!--
$
$!--- Setup section ---
$
$ echo := write sys$output
$
$!--- See if SCAN4 is defined as a foreign command, and if not give error ---
$
$ if f$type( scan4 ) .eqs. ""
$    then
$    echo "You don't appear to have SCAN4 installed and working on your system!"
$    exit 1+0*f$verify( dbg )
$ endif
$
$!--- Get filename and make sure it exists ---
$
$ filename = p1
$ if filename .eqs. "" then inquire filename "_Filename"
$ if filename .eqs. "" then exit
$
$ filename = f$parse( filename, "SYS$DISK:[]*.EXE" )
$ if f$search( filename ) .eqs. ""
$    then
$    echo f$fao( "Error opening image file !AS", filename )
$    exit 1+0*f$verify ( dbg )
$ endif
$
$!--- SCAN4 "ident" in the output of the ANALYZE/IMAGE command ---
$
$ scan4 "ident" analyze/image 'filename
$
$!--- Bye! ---
$
$ exit 1+0*f$verify( dbg )
