# Copyright  1994 by Brian Schenkenberger.  All rights reserved.
##################################################################
##  MMS build rules for CTRL-Verify 
##  Author: Brian Schenkenberger
##################################################################

* : 
    @ ARCH_TYPE = "VAX"
    @ IF F$GETSYI("HW_MODEL").GE.1024 THEN $ ARCH_TYPE = "ALPHA"
    @ Write SYS$OUTPUT "''F$FAO("Building !AS version of CTRL-Verify!/",ARCH_TYPE)'"
    @ $(MMS)$(MMSQUALIFIERS)/MACRO=(__'ARCH_TYPE'__=1) CTRLVerify

.IFDEF __ALPHA__	## extension macros for use on OpenVMS AXP
OPT = .AXP_OPT
.ELSE			## extension macros for use on OpenVMS VAX
OPT = .OPT
.ENDIF

OBJ = .OBJ
EXE = .EXE

.MAR$(OBJ) :
	     $(MACRO)$(MACROFLAGS)/OBJECT=$@ $<
MACRO	   = MACRO

.IFDEF __ALPHA__	## qualifier macros for use on OpenVMS AXP
MACROFLAGS = /LIST/MACHINE
LINKFLAGS  = /MAP/FULL/NOTRACEBACK/NATIVE_ONLY/BPAGE=13
SYSEXE	   = /SYSEXE=SELECTIVE
.ELSE			## qualifier macros for use on OpenVMS VAX
MACROFLAGS = /LIST
LINKFLAGS  = /MAP/FULL/NOTRACEBACK
SYSEXE	   =
.ENDIF

##
## CTRL-Verify is composed of the following files:
##
	
CTRLVerify : LOAD_CTRLV$(EXE),VAST_SHARE$(EXE),CTRLV.HLB
	     @ CONTINUE

##
## Build rules for individual CTRL-Verify components:
##

LOAD_CTRLV$(EXE) : LOAD_CTRLV$(OBJ),CTRLVCMD$(OBJ)
		   $(LINK)$(LINKFLAGS)$(SYSEXE)/P0IMAGE -
			LOAD_CTRLV$(OBJ),-
			CTRLVCMD$(OBJ)

VAST_SHARE$(EXE) : VAST_SHARE$(OBJ),VAST_SHARE$(OPT)
		   $(LINK)$(LINKFLAGS)$(SYSEXE)/SHAREABLE/NOSYSSHR -
			VAST_SHARE$(OBJ),-
			VAST_SHARE$(OPT)/OPTIONS

LOAD_CTRLV$(OBJ) : LOAD_CTRLV.MAR
VAST_SHARE$(OBJ) : VAST_SHARE.MAR
CTRLVCMD$(OBJ)   : CTRLVCMD.CLD

CTRLV.HLP	 : CTRLV.RNH
CTRLV.HLB	 : CTRLV.HLP

