 /**  ; Facility: ' ;	FTS.MAR - Functionality Testing Suite 7 ;	FTS.C	Copyright (c) 1991	Bruce R. Miller and TGV Inc.  ;  ; Abstract: 8 ;	(unjustifiable) Self-defence for the VMS system hacker ; 	 ; Author: ! ;	Bruce R. Miller, MILLER@TGV.COM  ;	TGV, Inc.  ;	603 Mission St.  ;	Santa Cruz, CA 95060 ;	(408) 427-4366 ;  ; Date:		May 14,1991 ;  ; Wishlist:  ;   ;	Can we monitor timer activity? ;  ;	Ned's library monitor  ;  ;	Ehud's hotkey code ; > ;	Allow certain variables to be maintained across invocations.@ ;	Perhaps stored in logical names, or in a section of some sort. ; > ;	Add code to do lib$signal in the context of another process. ; / ; Copyright (c) 1991,1992,1993	Bruce R'. Miller  ; All rights reserved. ; A ;	Redistribution and use in source and binary forms are permitted A ;	provided that the above copyright notice and this paragraph are : ;	duplicated in all such forms and that any documentation,< ;	advertising materials, and other materials related to suchB ;	distribution and use acknowledge that the software was developed ;	by Bruce R. Miller. > ;	THIS SOFTWARE IS PROVIDED AS IS'' AND WITHOUT ANY EXPRESS OR@ ;	IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIEDE ;	WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.  ;  ; Modifications: ; - ; 16-FEB-1993 22:42:40		Bruce R'. Miller, TGV  ;	Converted to C.  ;  ;  **/    #include <chfdef.h>  #include <climsgdef.h> #include <descrip.h> #include <rmsdef.h>  #include <ssdef.h> #include <stsdef.h>  #include <smgdef.h>    #include "fts.h"   globalref FTS_Parse;   unsigned long Exit_Handler();   ; unsigned long	exit_condition;		/* condition causing exit */  struct { 	unsigned long      flink; 	unsigned long      exh_addr;  	unsigned long      arg_count;$ 	unsigned long      addr_cond_value; 	unsigned long      args[1];8 	} exh_block = { 0, Exit_Handler, 0, &exit_condition };;     /**  ;	Exit_Handler ;  ; Function: 9 ;	This routine is an exit handler.  It cleans up cleanly.  ;  ; Input: ;	4(AP) - Condition address  **/   " unsigned long Exit_Handler(cc_ptr)      unsigned long *cc_ptr;  {  	/*  	 * Did we get an error code?  	 */2 	if (ERROR(*cc_ptr))		/* Print an error message */1 		printf("Leaving in a huff...  0x%x\n",*cc_ptr);    	/*  	 * Call it a day  	 */ 	return(*cc_ptr);  }        /** " ;	FTS_Handler - FTS signal catcher ;  ; Input:! ;	4(AP) - address of signal array $ ;	8(AP) - address of mechanism array" ;	12(AP) - address of enable array ;  **/    FTS_Handler(sig,mech,enable)"      struct chf$signal_array *sig;!      struct chf$mech_array *mech;       int enable; {  	unsigned long rc;   	rc = SS$_RESIGNAL; ' 	if (sig->chf$l_sig_name == SS$_UNWIND)  		return(SS$_NORMAL); ( 	if (sig->chf$l_sig_name == CLI$_NOCOMD) 		return(SS$_CONTINUE); % 	if (sig->chf$l_sig_name == RMS$_EOF)  		rc = sys$unwind(0,0);  	return(rc); }      /** : ;	Do_Abort - FTS command has failed, return to FTS> prompt ;  ; Input:! ;	4(AP) - address of signal array $ ;	8(AP) - address of mechanism array **/    Do_Abort(sig,mech)"      struct chf$signal_array *sig;!      struct chf$mech_array *mech;  {  	sig->chf$l_sig_args -= 2; 	sys$putmsg(sig,0,0,0); - 	mech->chf$l_mch_savr0 = sig->chf$l_sig_name;  	return(sys$unwind(0,0));  }    /** 4 ;	Do_Continue - Print an error message then continue ;  ; Input:! ;	4(AP) - address of signal array $ ;	8(AP) - address of mechanism array **/    Do_Continue(sig,mech) "      struct chf$signal_array *sig;!      struct chf$mech_array *mech;  {  	sig->chf$l_sig_args -= 2; 	sys$putmsg(sig,0,0,0);  	return(SS$_CONTINUE); }    /** 2 ;	Do_Exit - Print an error message then exit image ;  ; Input:! ;	4(AP) - address of signal array $ ;	8(AP) - address of mechanism array **/    Do_Exit(sig,mech) "      struct chf$signal_array *sig;!      struct chf$mech_array *mech;  {       sig->chf$l_sig_args -= 2;      sys$putmsg(sig,0,0,0); 1      mech->chf$l_mch_savr0 = sig->chf$l_sig_name; 5      sys$exit(sig->chf$l_sig_name | STS$M_INHIB_MSG);  }        /** ' ;	FTS_Routine_Handler - Caught a signal  ;  ; Functional Description: 5 ;	Conditions that occur while processing FTS commands 4 ;	come through here.  We decide whether to continue,4 ;	exit the image, or unwind back to the FTS> prompt.4 ;	We also handle internal signals here, like ACCVIO. ;  ; Input:! ;	4(AP) - address of signal array $ ;	8(AP) - address of mechanism array" ;	12(AP) - address of enable array ;  **/   $ FTS_Routine_Handler(sig,mech,enable)"      struct chf$signal_array *sig;!      struct chf$mech_array *mech;       int enable; {  	unsigned long rc;   	rc = sig->chf$l_sig_name; 	switch (rc) { 		case SS$_UNWIND :  			return(SS$_NORMAL); 		case SS$_ACCVIO :  		case SS$_ROPRAND : 		case SS$_TBIT :  		case SS$_RADRMOD : 		case SS$_DEBUG : 			return(rc); 		default :  			Do_Abort(sig,mech); /*			Do_Continue(sig,mech); */ /*			Do_Exit(sig,mech); */	 			break;  		}  	return(rc); }      /** - ;	Do_Parse - Run the command line through DCL  ;  ; Functional Description: < ;	A routine to call the CLI$DCL_Parse routine with the right> ;	arguements.  The reason that this isn't inline is because it; ;	sets up the condition handler for handling the errors and $ ;	warnings and Control_C situations. ; 8 ;	So, if someone types Control_C while getting input, he7 ;	will handle the Control_C in the appropriate fashion.  ;  ; Input: ;	None ;  ; Values Returned: ; . ;	1) Anything returned by the CLI Routines. Or. ;	2) Anything that FTS_GET_INPUT would return. ; D ; Note: that some CLI routine values are signalled others are merely ;	returned.  **/   
 Do_Parse() {  	unsigned long rc,rc2;D 	struct dsc$descriptor desc = { 0, DSC$K_DTYPE_T, DSC$K_CLASS_D, 0}; 	$DESCRIPTOR(prompt,"FTS> ");  	short len;    	/* " 	 * Establish a condition handler. 	 */$ 	lib$establish(FTS_Routine_Handler);   	/*  	 * Get a line of input. 	 */( 	rc = FTS_Get_Input(&desc,&prompt,&len);  	if (rc == RMS$_EOF) return(rc); 	if (ERROR(rc)) lib$signal(rc);    	/*  	 * Check out the line.  	 */- 	if (len && (desc.dsc$a_pointer[0] == '?')) { O 		printf("Hello, sailor!\nFor assistance, type 'HELP' at the FTS> prompt.\n");	 	 	} else {  	    /* . 	     * Send the line down to DCL to be parsed 	     */0 	    rc = cli$dcl_parse(&desc,&FTS_Parse,0,0,0); 	}   	/* # 	 * Free up the command line string  	 */ 	rc2 = str$free1_dx(&desc); ! 	if (ERROR(rc2)) lib$signal(rc2);    	return(rc); }        /**  ;	FTS_Dispatch -   ;  ; Functional Description:  ; > ;	This routine simply calls CLI$DISPATCH.  The reason we don't< ;	call CLI$DISPATCH directly is that we might want to attach@ ;	a condition handler to this stack frame.  Then, when a command* ;	fails, we can unwind back to this point. ;  ; Input: ;	None.  ; 	 ; Output: * ;	Whatever the dispatched routines return. **/    FTS_Dispatch() { $ 	lib$establish(FTS_Routine_Handler);   	return(cli$dispatch()); }        /**  ;	Command_Loop ;  ; Functional Description: 0 ;	This routines prompts for the command and then$ ;	dispatches to the correct routine. **/    Command_Loop() {  	unsigned long rc;   	while (1) { 		rc = Do_Parse(); 		if (!ERROR(rc))  			rc = FTS_Dispatch();  		if (rc == RMS$_EOF) 	 			break;  		}  	return(SS$_NORMAL); }        /**  ;	Check_Invocation_Line  ;  ; Functional Description: @ ;	Parse the arguements on the command line when program invoked. ; . ; Returns:  Number of characters on input line **/    Check_Invocation_Line()  {  	unsigned long rc; 	char buffer[512]; 	short retlen;0 	unsigned long line_desc[2] = { 511-1, buffer };  $ 	/* Establish a condition catcher */) /*	lib$establish(FTS_Routine_Handler); */    	/*  	 * Read command line  	 */- 	rc = lib$get_foreign(line_desc,0,&retlen,0);  	if (ERROR(rc)) lib$signal(rc);  	if (retlen == 0) return(0); 	line_desc[0] = retlen;  	buffer[retlen] = '\0';    	/*  	 * Check for a '?'  	 */ 	if (buffer[0] == '?') { 		printf("Hello, sailor!\n"); > 		printf("For assistance, type 'HELP' at the FTS> prompt.\n"); 		return(SS$_NORMAL);  	}   	/* * 	 * Send the line down to DCL to be parsed 	 */0 	rc = cli$dcl_parse(line_desc,&FTS_Parse,0,0,0); 	if (!ERROR(rc)) 		FTS_Dispatch();  	return(SS$_NORMAL); }       
 FTS_Init() {  	unsigned long rc;   	/*  	 * Declare an exit handler  	 */ 	rc = sys$dclexh(&exh_block);  	if (ERROR(rc)) lib$signal(rc);    	/* % 	 * Initialize the terminal interface  	 */ 	rc = FTS_SMG_Init();  	return(rc); }      /**  ;	main - image entry point ;  ; Functional Description: < ;	The main routine.  Parse the arguements. Get the log file.: ;	Start the I/O. Then Hibernate while the AST's do all the ;	work.  **/    main() {  	unsigned long rc;   	/* . 	 * Establish a condition handler, first thing 	 */ 	lib$establish(FTS_Handler);   	/*  	 * Do initialization  	 */ 	FTS_Init();   	/*   	 * Invoked with a command line? 	 */ 	rc = Check_Invocation_Line(); 	if (ERROR(rc)) {  		Command_Loop();  		rc = SS$_NORMAL; 	}   	return(sys$exit(rc)); } 