 /*++  *  RECALL_GET_INPUT  *G  *      The RECALL_GET_INPUT routine gets one record of ASCII text from E  *      the current controlling input device, specified by SYS$INPUT. I  *      This routine has the same interface as LIB$GET_INPUT but supports <  *      multiple commands recall if SYS$INPUT is a terminal.  *?  *      See documentation of LIB$GET_INPUT for further details.   *  *	Author - Unknown   *  *--  */    /*  *  Global definitions  */    #include descrip #include ssdef #include iodef #include tt2def  #include trmdef  #include dvidef  #include dcdef #include rmsdef  #include libdef  #include starlet #include lib$routines    /*/  *  Definition of values for special characters   */    #define CTRL_B   2 #define LF      10 #define CR      13 #define CTRL_Z  26   /*  *  Global constants  */   < #define INPUTSIZ  1024   /* Maximum size of an input line */< #define PROMPTSIZ  255   /* Maximum size of a prompt line */J #define RECALLSIZ   20   /* Maximum number of buffered lines for recall */G #define ESCSEQSIZ   20   /* Maximum size of an input escape sequence */    /*(  *  Definition of standard integer types  */    typedef unsigned char ubyte; typedef unsigned short uword;  typedef unsigned long ulong;% typedef struct {ulong lo, l1;} uquad;    /*1  *  Definition of a standard VMS I/O Status Block   */    typedef struct {     uword status;      uword count;     ulong devdep;  } tiosb;   /*F  *  Definition of an I/O Status Block for terminal read with item list  */    typedef struct {     uword status;      uword count;     ubyte terminator;      ubyte reserved;      ubyte termsize;      ubyte position;  } tiosb_tt_itmread;    /*9  *  Definition of a standard item for VMS system services   */    typedef struct {     uword length;      uword code;      char *buffer;      uword *retlen; } titem;   /*2  *  Definition of a terminal characteristics block  */    typedef struct {     ubyte class  : 8;      ubyte type   : 8;      uword width  : 16;     ulong char1  : 24;     ubyte length : 8;      ulong char2  : 32;
 } tttchar;   /*$  *  Function of a terminator string.  */    typedef enum {0     rt_previous,      /* Recall previous line */,     rt_next,          /* Recall next line */A     rt_same,          /* Invalid terminator, re-edit same line */ A     rt_done           /* Input complete, return line to caller */ 
 } trecall;   /*F  *  Each input line terminator is a string described in a tterminator.  */    typedef struct {-     char *string;     /* Terminator string */ 1     int length;       /* Length of this string */ /     trecall action;   /* Function to perform */  } tterminator;   /*#  *  List of all terminator strings.   */   / static tterminator const terminator_list [] = { *  {"\002",   1, rt_previous},  /* Ctrl-B */<  {"\033[A", 3, rt_previous},  /* CSI A (7 bits), Arrow Up */<  {"\233A",  2, rt_previous},  /* CSI A (8 bits), Arrow Up */?  {"\033A",  2, rt_previous},  /* ESC A, Arrow Up, VT 52 mode */ I  {"\033OA", 3, rt_previous},  /* SS3 A (7 bits), Arrow Up, Application */ I  {"\213A",  2, rt_previous},  /* SS3 A (8 bits), Arrow Up, Application */ >  {"\033[B", 3, rt_next},      /* CSI B (7 bits), Arrow Down */>  {"\233B",  2, rt_next},      /* CSI B (8 bits), Arrow Down */A  {"\033B",  2, rt_next},      /* ESC B, Arrow Down, VT 52 mode */ F  {"\033OB", 3, rt_next},      /* SS3 B (7 bits), Arrow Down, Appli. */F  {"\213B",  2, rt_next},      /* SS3 B (8 bits), Arrow Down, Appli. */3  {"\015",   1, rt_done},      /* Carriage Return */ )  {"\032",   1, rt_done},      /* Ctrl-Z*/ D  {0,        0, rt_same}};     /* All other sequence => edit again */   /*  *  RECALL_GET_INPUT routine  */   J ulong RECALL_GET_INPUT (resultant_string, prompt_string, resultant_length) uquad *resultant_string; uquad *prompt_string;  uword *resultant_length; { >  /* Description of the input terminal (if it is a terminal) */G  static int terminal_init = 0;      /* Boolean: terminal initialized */ K  static int input_is_terminal = 0;  /* Boolean : SYS$INPUT is a terminal */ I  static tttchar inchar;             /* Characteristics of the terminal */ @  static uword input_channel;        /* Input terminal channel */  $  /* Recall buffer management data */>  static char recbuf [INPUTSIZ * RECALLSIZ];  /* Input lines */>  static uword recsiz [RECALLSIZ];            /* Lines sizes */E  static int last_entered;                    /* Index of last line */ G  static int oldest_entered = 0;              /* Index of oldest line */ K  static int buf_volume = 0;                  /* Number of recorded lines */ E  static int last_recalled = 0;               /* Last recalled line */     /* Local variables */:  int argcnt;                          /* Argument count */D  uquad *i_prompt;                     /* Prompt string descriptor */D  uword *i_length;                     /* Resultant length address */H  ulong status;                        /* Status from various routines */?  tiosb_tt_itmread iosb;               /* IOSB for input $QIO */ D  titem itmlst [5];                    /* Item-list for input $QIO */J  ulong itmlst_size;                   /* Size in bytes of the item-list */=  char inbuf [INPUTSIZ + ESCSEQSIZ];   /* Input line buffer */ C  char recalled [INPUTSIZ];            /* Initial string for $QIO */ E  char nprompt [PROMPTSIZ];            /* User prompt without CR/LF */ G  int nprompt_done;                    /* Boolean : prompt in nprompt */ J  tterminator *rp;                     /* Pointer inside terminator_list */J  char *p1, *p2, *end;                 /* Miscellaneous working pointers */C  uword rslength;                      /* Resultant string length */ J  int same;                            /* Boolean : same string as prev. */    /* Fetch optional arguments */ -  argcnt = *((ubyte*)(&resultant_string) - 4); +  i_prompt = argcnt > 1 ? prompt_string : 0; .  i_length = argcnt > 2 ? resultant_length : 0;  3  /* Initialize the input terminal the first time */   if (!terminal_init) {  ulong devclass;
  tiosb iosb1; &  $DESCRIPTOR (sys_input, "SYS$INPUT");  0  /* Set the flag so that we won't do it again */  terminal_init = 1;   #  /* Check if input is a terminal */ @  status = lib$getdvi (&DVI$_DEVCLASS, 0, &sys_input, &devclass);  if (!(status & 1))   return status;   C  /* If input is a terminal, keep a channel on it and trap Ctrl-C */ 0  if (input_is_terminal = devclass == DC$_TERM) {8  status = sys$assign (&sys_input, &input_channel, 0, 0);  if (!(status & 1))   return status;   ,  /* Get characteristics of input terminal */B  status = sys$qiow (0, input_channel, IO$_SENSEMODE, &iosb1, 0, 0,E                                &inchar, sizeof (inchar), 0, 0, 0, 0);   if (!(status & 1))       return status;   if (!(iosb1.status & 1)) $                 return iosb1.status;	         }      }   /  /* If input is not a terminal, let RMS play */      if (!input_is_terminal) B       return lib$get_input (resultant_string, i_prompt, i_length);  A  /* Input is a terminal. Build an item list for terminal input */   itmlst[0].retlen = 0;  itmlst[0].length = 0;#  itmlst[0].code   = TRM$_MODIFIERS; /  itmlst[0].buffer = (char*)(TRM$M_TM_NORECALL | 8                              /* Disable driver recall */E                     TRM$M_TM_ESCAPE   |   /* Stop on esc. sequence */ D                     TRM$M_TM_TRMNOECHO);  /* Don't output termin. */       itmlst[1].retlen = 0;      itmlst[1].length = 0; !     itmlst[1].code   = TRM$_TERM; J     itmlst[1].buffer = (char*)((1 << CTRL_B) | (1 << CR) | (1 << CTRL_Z));       itmlst[2].retlen = 0; %     itmlst[2].code   = TRM$_INISTRNG;       itmlst[2].buffer = recalled;I     itmlst[2].length = 0;             /* First initial string is empty */        itmlst[3].retlen = 0;      itmlst[3].length = 0; &     itmlst[3].code   = TRM$_ESCTRMOVR;*     itmlst[3].buffer = (char*)(ESCSEQSIZ);  2     /* Include prompt in item list if specified */     if (i_prompt == 0))         itmlst_size = 4 * sizeof (titem); 
     else {         nprompt_done = 0; )         itmlst_size = 5 * sizeof (titem);          itmlst[4].retlen = 0; %         itmlst[4].code = TRM$_PROMPT; "         status = lib$analyze_sdescK                           (i_prompt, &itmlst[4].length, &itmlst[4].buffer);          if (!(status & 1))             return status;     }   @     /* Read the input, loop upon recall, exit on <return> key */     do {     /* Read one input line */ K     status = sys$qiow (0, input_channel, IO$_READVBLK | IO$M_EXTEND, &iosb, C                            0, 0, inbuf, INPUTSIZ + ESCSEQSIZ, 0, 0, 1                            &itmlst, itmlst_size);          if (!(status & 1))             return status;         if (!(iosb.status & 1))              return iosb.status;   2         /* Check terminator for known sequences */9         for (rp = terminator_list; rp->string != 0; rp++) .             if (iosb.termsize == rp->length) {(                 p1 = inbuf + iosb.count;                  p2 = rp->string;>                 for (end = p1 + iosb.termsize; p1 < end; p1++)%                     if (*p1 != *p2++)                          break;                 if (p1 >= end)                     break;
             }   *         /* Perform corresponding action */         switch (rp->action) {              case rt_previous: *                 /* Recall previous line */'                 if (last_recalled >= 0) $                     last_recalled--;&                 if (last_recalled < 0))                     itmlst[2].length = 0;                  else {I                     int n = (oldest_entered + last_recalled) % RECALLSIZ; "                     p1 = recalled;/                     p2 = recbuf + n * INPUTSIZ; I                     for (end = p1 + recsiz [n]; p1 < end; *p1++ = *p2++); 1                     itmlst[2].length = recsiz[n];                  }                  break;               case rt_next: %                 /* Recall next line*/ /                 if (last_recalled < buf_volume) $                     last_recalled++;0                 if (last_recalled >= buf_volume))                     itmlst[2].length = 0;                  else {I                     int n = (oldest_entered + last_recalled) % RECALLSIZ; "                     p1 = recalled;/                     p2 = recbuf + n * INPUTSIZ; I                     for (end = p1 + recsiz [n]; p1 < end; *p1++ = *p2++); 1                     itmlst[2].length = recsiz[n];                  }                  break;               case rt_same: C                 /* Re-edit same line (unhandled escape sequence) */                  p1 = recalled;                 p2 = inbuf; E                 for (end = p1 + iosb.count; p1 < end; *p1++ = *p2++); .                 itmlst[2].length = iosb.count;                 break;	         }   H   /* If input complete or terminal is not a DEC-CRT, output a newline */=   /* Else (recall and DEC-CRT), redisplay on the same line */ A      if (rp->action == rt_done || !(inchar.char2 & TT2$M_DECCRT)) 8      sys$qiow (0, input_channel, IO$_WRITEVBLK, 0, 0, 0,2                       "", 0, 0, 0x8D000000, 0, 0);         else8      sys$qiow (0, input_channel, IO$_WRITEVBLK, 0, 0, 0,4                       "\015\033[2K", 5, 0, 0, 0, 0);  E   /* If line has to be re-entered, strip CR and LF from the prompt */ F         if (i_prompt != 0 && rp->action != rt_done && !nprompt_done) {=             end = (p1 = itmlst[4].buffer) + itmlst[4].length; '             itmlst[4].buffer = nprompt;              nprompt_done = 1; 6             for (itmlst[4].length = 0; p1 < end; p1++)+                 if (*p1 != CR && *p1 != LF) 7                     nprompt [itmlst[4].length++] = *p1; 	         }   $     } while (rp->action != rt_done);  7     /* If input was aborted, returns an empty string */ C     if (iosb.status == SS$_CONTROLC || iosb.status == SS$_CONTROLY)          iosb.count = 0;   2     /* Copy input string inside user descriptor */C     status = lib$scopy_r_dx (&iosb.count, inbuf, resultant_string);      if (!(status & 1))         return status;  <     /* Read back the number of actually copied characters */B     status = lib$analyze_sdesc (resultant_string, &rslength, &p1);     if (!(status & 1))         return status;     if (rslength < iosb.count)         iosb.count = rslength;  3     /* If resultant_length specified, returns it */      if (i_length != 0)         *i_length = iosb.count;   F     /* Check if input line is the same as the previous recorded one */H     if (same = buf_volume != 0 && recsiz [last_entered] == iosb.count) {.         p1 = recbuf + last_entered * INPUTSIZ;         p2 = inbuf; M         for (end = p2 + iosb.count; same && p2 < end; same = *p1++ == *p2++);      }   B     /* If input line is not empty and not identical to previous */8     /* recorded line, store it into the recall buffer */"     if (iosb.count > 0 && !same) {4     /* Allocate an index for the new input string */H     last_entered = buf_volume == 0 ? 0 : (last_entered + 1) % RECALLSIZ;  H     /* Update overall volume of recall buffer and oldest string index */     if (buf_volume < RECALLSIZ)              buf_volume++;          else>             oldest_entered = (oldest_entered + 1) % RECALLSIZ;  )         /* Update last recalled string */ #         last_recalled = buf_volume;   #         /* Now stores the string */ +         recsiz [last_entered] = iosb.count; .         p1 = recbuf + last_entered * INPUTSIZ;G         for (end = (p2 = inbuf) + iosb.count; p2 < end; *p1++ = *p2++);      }   E     /* Return End-of-File on a ^Z, LIB$STRTRU on string truncation */ 3     return (iosb.terminator == CTRL_Z) ? RMS$_EOF : 2            (iosb.count > rslength) ? LIB$_STRTRU :            SS$_NORMAL; } 