             
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *
 *
 *
 *                %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%\
 *                %% \___________________________________%% \
 *                %% |                                   %%  \
 *                %% |                NOPE               %%   \
 *                %% |           nope.c  c2004           %%    \
 *                %% |            Lyle W. West           %%    |
 *                %% |                                   %%    |
 *                %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%    |
 *                \                                        \   |
 *                 \                                        \  |
 *                  \                                        \ |
 *                   \________________________________________\|
 *
 *
 *
 *  Copyright (C) 2004 Lyle W. West, All Rights Reserved.
 *  Permission is granted to copy and use this program so long as [1] this
 *  copyright notice is preserved, and [2] no financial gain is involved
 *  in copying the program.  This program may not be sold as "shareware"
 *  or "public domain" software without the express, written permission
 *  of the author.
 *
 *  This is a new release of the NOPE (NO PurgE) originally from the
 *  VAX87C Fall 1987 VAX SIG DECUS tape. Much of the original code has
 *  been replaced by my own code, primarily to simplify maintaining the
 *  code subsequent to adding command line parsing and substantial output
 *  formatting changes. The original code is available in this archive in
 *  the directory ORIG_NOPE.DIR for those interested.
 *
 *  This application must be relinked if the current VMS version
 *  is upgraded to version 7.3-2 or higher.
 *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
 
#define VERSION "V1.2-1"
#pragma module NOPE VERSION

#include <stdio.h>
#include <climsgdef.h>
#include <descrip.h>
#include <file.h>
#include <iodef.h>
#include <rms.h>
#include <ssdef.h>
#include <string.h>

int BckBin[2];              /* quadword value for Backup date */
int CreBin[2];              /* quadword value for Create date */
int ExpBin[2];              /* quadword value for Expire date */
int RevBin[2];              /* quadword value for Revision date */
int CurBin[2];              /* quadword value for /BEFORE or /SINCE date */ 

int status;

short BeforeFlg;            /* user specified /BEFORE qualifier */
short KeepCount;            /* number of times current filenam found */
short KeepFlg;              /* user specified /KEEP qualifier */
short KeepValue;            /* value specified with /KEEP qualifier */
short QualFlg;              /* use BACKUP, CREATE, EXPIRE or MODIFY time stamps */
short SinceFlg;             /* user specified /SINCE qualifier */

char Buffer[80];            /* cli value string */
char CmdVerb[32];           /* foreign command invoking this image */
char DateStr[28];           /* date string for ascii date to bin date */
char InputFile[132];        /* input file from command line */

struct FAB WildFab;         /* Used in wildcard search */
struct NAM WildNam;         /* Used in conjunction with WildFab */
struct FAB SizeFab;         /* Used in retreiving file allocation */

#define BACKUP_DATE 1
#define CREATE_DATE 2
#define EXPIRE_DATE 4
#define REVISE_DATE 8

int main()
{
    char template[] = "*.*;*";  /* Default template */
    char CmdLine[80];
    char FullName[256];         /* Input file spec given by user */
    char Expanded[256];         /* File spec after logical expansion */
    char Result[256];           /* Result from search */
    char LastName[256];         /* Last search Result */
    char LastDir[256];
    char *ptr = 0;

    int TotalBlocks = 0;
    int TotalFiles = 0;
    int ThisDirlen = 0;
    int LastDirlen = 0;
    int CompareNamelen = 0;
    int LastNamelen = 0;
    int ThisNamelen = 0;
    int CompareDirlen = 0;
    int counter = 0;
    int status;

    short CmdLen;
    short CvLen;                /* Length of command verb */

    $DESCRIPTOR(DscCmd, CmdLine);
    $DESCRIPTOR(DscVerb, CmdVerb);  /* foreign invoking symbol name */

        /* Initialize the wildcard FAB & NAM */

    WildFab = cc$rms_fab;       /* Initialize the FAB structure */
    WildNam = cc$rms_nam;       /* Initialize the NAM structure */

        /* get the command line used to invoke this image */
 
    status = GetCmdLine(&DscCmd, &CvLen);  /* get invoking foreign cmd str */
    if(status != SS$_NORMAL) exit(status);
    CmdLine[CvLen] = 0;
 
        /* extract foreign cmd verb from CmdLine */
 
    sscanf(CmdLine, "%s", &CmdVerb);
    ptr = strchr(CmdVerb, '/');
    if(ptr) *ptr = '\0';
    DscVerb.dsc$w_length = strlen(CmdVerb);
    status = str$upcase(&DscVerb, &DscVerb);
 
        /* get parameter and qualifier(s) from command line */
 
    GetCliInfo();
 
    WildFab.fab$l_fna = InputFile;
    WildFab.fab$b_fns = strlen(InputFile);
    WildFab.fab$b_fac = FAB$M_GET;
    WildFab.fab$l_fop = FAB$V_NAM;
    WildFab.fab$l_nam = &WildNam;
    WildFab.fab$l_dna = template;
    WildFab.fab$b_dns = strlen(template);
    
    WildNam.nam$l_esa = Expanded;
    WildNam.nam$b_ess = 255;
    WildNam.nam$l_rsa = Result;
    WildNam.nam$b_rss = 255;

        /* Initialize the size FAB & NAM */

    SizeFab = cc$rms_fab;

    SizeFab.fab$l_fna = Result;
    SizeFab.fab$b_fac = FAB$M_GET;
    SizeFab.fab$b_shr = FAB$M_SHRGET;

        /* perform $PARSE on target filepath to verifiy validity */

    status = SYS$PARSE(&WildFab, 0, 0);
    if(status != RMS$_NORMAL) {
        if(status == RMS$_DNF) {
            printf("%%NOPE-W-SEARCHFAIL, error searching for %s\n",
                InputFile);
            printf("%%NOPE-E-DNF, directory not found\n");
            printf("%%NOPE-W-NOSUCHFILE, no such file\n");
            printf("%%NOPE-I-NOFILPURG, no files would be purged\n");
            exit(SS$_NORMAL);
        }
        else exit(status);
    }

        /* Main loop */

    while(TRUE) {
        status = SYS$SEARCH(&WildFab, 0, 0);
        if(status != RMS$_NORMAL) {
            if(status == RMS$_NMF) break;
            if(status == RMS$_FNF) {
                ptr = strchr(Result, ' ');
                if(ptr) *ptr = 0;
                printf("%%NOPE-W-SEARCHFAIL, error searching for %s\n",
                    Result);
                printf("%%NOPE-E-FNF, file not found\n");
                break;
            }
            else exit(status);
        }

        /* insert null at end of result strings */

        Expanded[WildNam.nam$b_esl] = 0;
        Result[WildNam.nam$b_rsl] = 0;

        /* Establish some pointers and counters for comparison */

        ThisDirlen = WildNam.nam$b_dev + WildNam.nam$b_dir;
        ThisNamelen = WildNam.nam$b_name + WildNam.nam$b_type;
        ptr = WildNam.nam$l_name;

        /* Compare directories, print if new directory */

        if (ThisDirlen > LastDirlen) CompareDirlen = ThisDirlen;
            else CompareDirlen = LastDirlen;
        if (strncmp(LastDir, Result, CompareDirlen) != 0) {
            LastNamelen = ThisNamelen;
            strcpy(LastName, ptr);
            LastName[ThisNamelen] = '\0';
            LastDirlen = ThisDirlen;
            strncpy(LastDir, Result, ThisDirlen);
            LastDir[ThisDirlen] = '\0';
            continue;
        }

        /* Compare filename, print if this file would be purged */

        if (ThisNamelen > LastNamelen) CompareNamelen = ThisNamelen;
        else CompareNamelen = LastNamelen;
        if (strncmp(LastName, ptr, CompareNamelen) == 0) {
            SizeFab.fab$b_fns = strlen(Result);
            KeepCount++;
            if (((status = SYS$OPEN(&SizeFab)) &1) != 1) {
                if (status == RMS$_FLK) {
                    printf("%-50s <file locked>\n", Result);
                    continue;
                }
            }

            status = SYS$CLOSE(&SizeFab);

            if(BeforeFlg || SinceFlg) {
                status = GetDateInfo();
                if(status) {
                    if(KeepFlg) {
                        if(KeepCount >= KeepValue) {
                            printf("%%NOPE-I-FILE, %-30s (%d blocks)\n",
                                Result, SizeFab.fab$l_alq);
                            TotalFiles++;
                            TotalBlocks += SizeFab.fab$l_alq;
                        }
                    }
                    else {
                        printf("%%NOPE-I-FILE, %-30s (%d blocks)\n",
                            Result, SizeFab.fab$l_alq);
                        TotalFiles++;
                        TotalBlocks += SizeFab.fab$l_alq;
                    }
                }
            }
            else {
                if(KeepFlg) {
                    if(KeepCount >= KeepValue) {
                        printf("%%NOPE-I-FILE, %-30s (%d blocks)\n",
                            Result, SizeFab.fab$l_alq);
                        TotalFiles++;
                        TotalBlocks += SizeFab.fab$l_alq;
                    }
                }
                else {
                    printf("%%NOPE-I-FILE, %-30s (%d blocks)\n",
                        Result, SizeFab.fab$l_alq);
                    TotalFiles++;
                    TotalBlocks += SizeFab.fab$l_alq;
                }
            }
        }
        else {
            KeepCount = 0;
            LastNamelen = ThisNamelen;
            strncpy(LastName, ptr, ThisNamelen);
            LastName[ThisNamelen] = '\0';
        }
    }

    if(TotalFiles > 1)
        printf("%%NOPE-I-TOTAL,  %d files total (%d blocks)\n",
            TotalFiles, TotalBlocks);
    if(TotalFiles == 0)
        printf("%%NOPE-I-NOFILPURG, no files would be purged\n");
    exit(SS$_NORMAL);
}


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *
 *  ShowHelp - Display a brief summary of NOPE parameters and qualifiers.
 *             Provides command line interface info for the Nope utility.
 *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
void ShowHelp()
{
    printf("\n\n  %s (%s)\n\n", CmdVerb, VERSION);
    printf("\t%s was born out of the need for a way to see which files would\n",
        CmdVerb);
    printf("\tbe purged and the number of disk blocks freed if an actual purge\n");
    printf("\twere to be done. %s uses the same file specification syntax as\n",
        CmdVerb);
    printf("\tthe PURGE command. %s also provides a nearly identical\n",
        CmdVerb);
    printf("\toutput format to that of PURGE.\n\n");
    printf("\tAs shown below, %s supports many of the same qualifiers as\n",
        CmdVerb);
    printf("\tPURGE. Additionally, the /BEFORE and /SINCE qualifiers will\n");
    printf("\taccept an absolute or delta time or the following keywords:\n");
    printf("\tBOOT, LOGIN, TODAY (default), TOMORROW, or YESTERDAY.\n");
    printf("\tSpecify /BACKUP, /CREATED (default), /EXPIRED, or /MODIFIED\n");
    printf("\twith /BEFORE and /SINCE for comparison date values.\n\n");
    printf("     Parameters:\n\n");
    printf("\t%s accepts one parameter, a VMS filespec. If omitted, the \n",
        CmdVerb);
    printf("\tdefault filepath plus *.* is used.\n\n");
        printf("     Qualifiers\n\n");
    printf("\t/BACKUP - if present, modifies the time value specified with\n");
    printf("\t\tthe /BEFORE or the /SINCE qualifier.\n\n");
    printf("\t/BEFORE[=time] - if present, selects only those files dated\n");
    printf("\t\tprior to the specified time.\n\n"); 
    printf("\t/CREATED - if present, modifies the time value specified with\n");
    printf("\t\tthe /BEFORE or the /SINCE qualifier.\n\n");
    printf("\t/EXPIRED - if present, modifies the time value specified with\n");
    printf("\t\tthe /BEFORE or the /SINCE qualifier.\n\n");
    printf("\t/KEEP=n - Specifies the maximum number of versions of the\n");
    printf("\t\tspecified files to be retained in the directory.\n\n");
    printf("\t/MODIFIED - if present, modifies the time value specified with\n");
    printf("\t\tthe /BEFORE or the /SINCE qualifier.\n\n");
    printf("\t/SINCE[=time] - if present, selects only those files dated\n");
    printf("\t\tafter the specified time.\n\n");
    printf("\t/HELP - Displays this text\n\n");
    printf("\t/VERSION - %s displays version, build date,\n", CmdVerb);
    printf("\t\tand required privs for VMS Install utility.\n\n");
    exit(1);
}


                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          