   J /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  *  *<  *                %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%\=  *                %% \___________________________________%% \ >  *                %% |                                   %%  \?  *                %% |              PERSONA              %%   \ @  *                %% |          command.c  c2004         %%    \@  *                %% |            Lyle W. West           %%    |@  *                %% |                                   %%    |@  *                %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%    |@  *                \                                        \   |@  *                 \                                        \  |@  *                  \                                        \ |@  *                   \________________________________________\|  *  *  *?  *  Copyright (C) 1999, 2004 Lyle W. West, All Rights Reserved. J  *  Permission is granted to copy and use this program so long as [1] thisH  *  copyright notice is preserved, and [2] no financial gain is involvedH  *  in copying the program.  This program may not be sold as "shareware"G  *  or "public domain" software without the express, written permission   *  of the author.  *@  *  This application must be relinked if the current VMS version+  *  is upgraded to version 7.3-2 or higher.   *K  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */     #include "version.h" #pragma module command VERSION   A #include <stdio.h>                  /* Standard IO definitions */ A #include <clidef.h>                 /* Cli routine definitions */ A #include <climsgdef.h>              /* Cli message definitions */ F #include <descrip.h>                /* Descriptor Definition Macros */G #include <dvidef.h>                 /* Device Information item codes */ > #include <iodef.h>                  /* I/O Definition codes */E #include <ssdef.h>                  /* System Service return codes */ E #include <string.h>                 /* strlen, strcmp, strcpy, etc */ K #include <tt2def.h>                 /* extended terminal characteristics */ H #include <ttdef.h>                  /* basic terminal characteristics */S #include <uaidef.h>                 /* User Authorization Information item codes */ 4 #include "defs.h"                   /* local defs */   F char PwdBuf[32];                    /* User entered password string */   D extern int  IgnoreId;               /* Ignore identifier checking */I extern int  NewTTChar[3];           /* Target terminal characteristics */ K extern int  OldTTChar[3];           /* Invoking terminal characteristics */  extern int  status;    G extern short ModeFlag;              /* subproc(FALSE)/detached(TRUE) */  extern short ModeLen;  extern short NameLen; J extern short NewTtdProt;            /* Protection of modified tt device */J extern short OldTtdProt;            /* Protection of original tt device */J extern short TtdChan;               /* Channel for originating terminal */K extern short UserLen;               /* size of username buffer (NewUser) */    L extern char CmdVerb[32];            /* foreign symbol invoking this image */: extern char NewUser[13];            /* Target user name */L extern char NewUserTrim[13];        /* string for new username w/o blanks */: extern char TtdName[32];            /* Original TT name */   C extern struct ITEM DviItem[2];      /* Itemlist for $GETDVI info */ C extern struct ITEM UaiItem[15];     /* Itemlist for $GETUIA info */    : extern struct IOSB DviIosb;         /* iosb for $GETDVI */: extern struct IOSB QioIosb;         /* iosb for $QIO(W) */= extern struct IOSB TtdIosb;         /* iosb for Ttd device */    % extern struct dsc$descriptor_s DscTt; ( extern struct dsc$descriptor_s DscUserT;    extern int  lib$get_input(); extern void EchoOff(); extern void EchoOn();     globalvalue PERSONA_CLD; globalvalue CTL$AG_CLIDATA;  globalvalue PRC_L_RECALLPTR; globalvalue PPD$L_PRC; globalvalue PRC_S_COMMANDS;          J /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  * Function: ParseCmdLine A  * Description: Parse the command line used to invoke this image. H  *              Determine foreign symbol used, target username parameterE  *              value, and the qualifiers and required values. If the D  *              qualifiers /HELP or /VERSION are entered, ignore theG  *              parameter and all other qualifiers, show requested data   *              and exit.   *K  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */  int ParseCmdLine() { D     int  CliStat;                   /* status value for cli calls */@     short CmdLen;                   /* Length of command line */B     char CliStr[30];                /* buffer to store cli info */J     char CmdLine[132];              /* buffer reflecting input cmd line */     char LineBuf[132];M     char ModeBuf[32];               /* buffer for cli mode qualifier value */      char *ptr;   G     $DESCRIPTOR(Dsc_Cli, CliStr);   /* cli param or qualifier string */ F     $DESCRIPTOR(Dsc_Cmd, CmdLine);  /* user supplied input cmd line */L     $DESCRIPTOR(Dsc_Lbuf, LineBuf); /* modified cmdline for cli$dcl_parse */L     $DESCRIPTOR(Dsc_Mode, ModeBuf); /* execute mode type string(det/subp) */I     $DESCRIPTOR(Dsc_Verb, CmdVerb); /* foreign verb invoking the image */    <         /* get the command line used to invoke this image */   O     status = GetCmdLine(&Dsc_Cmd, &CmdLen);  /* get invoking foreign cmd str */ *     if(status != SS$_NORMAL) exit(status);     CmdLine[CmdLen] = '\0';    3         /* extract foreign cmd verb from CmdLine */    #     sscanf(CmdLine, "%s", CmdVerb);      ptr = strchr(CmdVerb, '/');      if(ptr) *ptr = '\0';,     Dsc_Verb.dsc$w_length = strlen(CmdVerb);.     status = str$upcase(&Dsc_Verb, &Dsc_Verb);   G         /* get parameter and qualifier(s) from command line, prefix the L            CLD declared verb and use CLI$DCL_PARSE to build the cmd table */   6     status = lib$get_foreign(&Dsc_Cmd, 0, &CmdLen, 0);*     if(status != SS$_NORMAL) exit(status);     CmdLine[CmdLen] = '\0';       strcpy(LineBuf, "PERSONA ");     strcat(LineBuf, CmdLine); ,     Dsc_Lbuf.dsc$w_length = strlen(LineBuf);I     CliStat = cli$dcl_parse(&Dsc_Lbuf, PERSONA_CLD, lib$get_input, 0, 0); ,     if(CliStat != CLI$_NORMAL) exit(status);   >         /* if user typed /HELP then show help text and exit */        strcpy(CliStr,"HELP");9     Dsc_Cli.dsc$w_length = strlen(Dsc_Cli.dsc$a_pointer); $     CliStat = cli$present(&Dsc_Cli);+     if(CliStat == CLI$_PRESENT) ShowHelp();    @         /* if user typed /VERSION then show versinfo and exit */        strcpy(CliStr, "VERSION");*     Dsc_Cli.dsc$w_length = strlen(CliStr);$     CliStat = cli$present(&Dsc_Cli);+     if(CliStat == CLI$_PRESENT) ShowVers();    @         /* if user typed /IGNOREID then set the IgnoreId flag */        strcpy(CliStr, "IGNOREID"); *     Dsc_Cli.dsc$w_length = strlen(CliStr);$     CliStat = cli$present(&Dsc_Cli);0     if(CliStat == CLI$_PRESENT) IgnoreId = TRUE;   ?         /* if user typed /MODE then set/clear the ModeFlag flag A            dependent on the usage of the mode qualifier. If /MODE F            is specified without a value, or with the value SUBPROCESS,B            'ModeFlag' will be FALSE, regardless of the equivalence/            value of the PERSONA_MODE logical */         strcpy(CliStr, "MODE"); *     Dsc_Cli.dsc$w_length = strlen(CliStr);$     CliStat = cli$present(&Dsc_Cli);!     if(CliStat == CLI$_PRESENT) { ?         CliStat = cli$get_value(&Dsc_Cli, &Dsc_Mode, &ModeLen); #         if(CliStat == SS$_NORMAL) { ,             Dsc_Mode.dsc$w_length = ModeLen;$             ModeBuf[ModeLen] = '\0';N             if(strncmp(ModeBuf, "SUBPROCESS", ModeLen) == 0) ModeFlag = FALSE;K             if(strncmp(ModeBuf, "DETACHED", ModeLen) == 0) ModeFlag = TRUE; 	         }          else {8             if(CliStat == CLI$_ABSENT) ModeFlag = FALSE;             else exit(CliStat); 	         }      }    7         /* get the target username from command line */    -     strcpy(Dsc_Cli.dsc$a_pointer,"USERNAME"); 9     Dsc_Cli.dsc$w_length = strlen(Dsc_Cli.dsc$a_pointer); $     CliStat = cli$present(&Dsc_Cli);!     if(CliStat == CLI$_PRESENT) { ?         CliStat = cli$get_value(&Dsc_Cli, &DscUserT, &UserLen); 0         if(CliStat != SS$_NORMAL) exit(CliStat);(         DscUserT.dsc$w_length = UserLen;$         NewUserTrim[UserLen] = '\0';2         status = str$upcase(&DscUserT, &DscUserT);     } :     else {  /* if no username, display message and exit */?         printf("\n%%%s-E-NOUSERID,  Usage Syntax: %s Username",              CmdVerb,  CmdVerb); 1         printf("\t(type %s /HELP)\n\n", CmdVerb);          exit(SS$_NORMAL);      } *     sprintf(NewUser,"%-12s", NewUserTrim);        return(SS$_NORMAL);  }       J /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  * Function: PwdChk N  * Description: Prompt user for system manager password. Do not echo response,L  *              compare response string to existing password. If response isF  *              is identical return SS$_NORMAL, else return SS$_INVPWD  *K  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */  int PwdChk() { 
     char Alg;      char UsrNam[] = {"SYSTEM"};      short Salt;      int IoFunct = 0;      long ChkHash[2], CurHash[2];$     $DESCRIPTOR(Dsc_ChkPwd, PwdBuf);"     $DESCRIPTOR(Dsc_User, UsrNam);   0     printf("\nEnter System Manager Password: ");0     status = sys$assign(&DscTt, &TtdChan, 0, 0);*     if(status != SS$_NORMAL) exit(status);D     IoFunct = IO$_READLBLK | IO$M_PURGE | IO$M_CVTLOW | IO$M_NOECHO;:     status = sys$qiow(0, TtdChan, IoFunct, &QioIosb, 0, 0,;                       &PwdBuf, sizeof(PwdBuf), 0, 0, 0, 0); *     if(status != SS$_NORMAL) exit(status);:     if(QioIosb.status != SS$_NORMAL) exit(QioIosb.status);$     PwdBuf[QioIosb.byte_cnt] = '\0';!     status = sys$dassgn(TtdChan); *     if(status != SS$_NORMAL) exit(status);     printf("\n");    &     Dsc_ChkPwd.dsc$a_pointer = PwdBuf;-     Dsc_ChkPwd.dsc$w_length = strlen(PwdBuf);         UaiItem[0].buf_size = 1;(     UaiItem[0].item_code = UAI$_ENCRYPT;     UaiItem[0].buf_addr = &Alg;      UaiItem[0].buf_len = 0;      UaiItem[1].buf_size = 2;%     UaiItem[1].item_code = UAI$_SALT;       UaiItem[1].buf_addr = &Salt;     UaiItem[1].buf_len = 0;      UaiItem[2].buf_size = 8;$     UaiItem[2].item_code = UAI$_PWD;#     UaiItem[2].buf_addr = &CurHash;      UaiItem[2].buf_len = 0;      UaiItem[3].buf_size = 0;     UaiItem[3].item_code = 0;    <     status = sys$getuai(0, 0, &Dsc_User, &UaiItem, 0, 0, 0);   A         /* use 'sys$hash_password' to get hash value from user */    K     status = sys$hash_password(&Dsc_ChkPwd, Alg, Salt, &Dsc_User, ChkHash); @     if((CurHash[0] != ChkHash[0]) || (CurHash[1] != ChkHash[1]))         return(SS$_INVPWD);      else return (SS$_NORMAL);  }       H /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  *    Function: GetCmdLineI  * Description: Retrieve the last command entered from the command recall H  *              buffer in the users process space, the command which wasJ  *              used to invoke this image. The contents of this recall bufK  *              are saved in a user specified buffer. In the unlikely event H  *              that the command line is longer than callers buffer, setM  *              length to -1 and return SS$_BUFFEROVF. Else return SS$_NORMAL   *J  *              This routine is aware of buffer length changes implemented'  *              in VMS 7.3-2 and above.   *I  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */ A int GetCmdLine(struct dsc$descriptor_s *DscTarget, short *length)  { <     char    *Sptr = 0;      /* last recall buffer pointer */D     char    *Dptr = 0;      /* callers string destination pointer */        short   ExpBuf = 0; @     short   *Lptr = 0;      /* pointer to callers length word */        int     BufSize;     int     RecallAddr = 0;      int     ppd = 0;     int     prc = 0;A     int     *Iptr = 0;      /* integer pointer for indirection */    D         /* recall buffer larger for V7.3-2 and higher. Use this infoD            to determine whether recall buffer length is presented to$            us as a byte or a word */   =     BufSize = PRC_S_COMMANDS;       /* get size of rcl buf */      if(BufSize > 4100)D         ExpBuf = TRUE;              /* if < 4100, osvers <= 7.3-1 */   8     RecallAddr = CTL$AG_CLIDATA;    /* address of ppd */8     RecallAddr += PPD$L_PRC;        /* address of prc */A     prc = PRC_L_RECALLPTR;          /* current command pointer */ A     Iptr = RecallAddr;              /* pseudo pointer register */      RecallAddr = *Iptr; 0     RecallAddr += prc;              /* offset */B     Iptr = RecallAddr;              /* copy to pointer register */L     RecallAddr = *Iptr;             /* RecallAddr points to end of buffer */   A         /* here we use recall allocation to determine the size of B            the recall buffer length field, changed at vms 7.3.2 */   E     if(ExpBuf) RecallAddr -= 2;     /* length is 16 bits at 7.3-2+ */ ?     else RecallAddr--;              /* else length is 8 bits */      Sptr = RecallAddr;$     Dptr = DscTarget->dsc$a_pointer;   B         /* be sure cmd line not longer than callers buffer. If so,6            ignore cmd line and return SS$_BUFFEROVF */        if(ExpBuf) {         Lptr = Sptr;O         if(*Lptr < DscTarget->dsc$w_length-1) *length = *Lptr; /* 16 bit val */          else {             *length = -1; "             return(SS$_BUFFEROVF);	         }      } 2     else *length = *Sptr;       /*  8 bit value */   C         /* get buffer length and copy cmd line to callers buffer */         Sptr -= *length;!     strncpy(Dptr, Sptr, *length);      return(SS$_NORMAL);  }             J /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  * Function: ChangeTtDevD  * Description: Save originating terminal device characteristics andC  *              protections. Modify terminal device as required for 7  *              PERSONA operation. (see comments below)   *K  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */  int ChangeTtDev()  {      char *ptr1;      char *ptr2;    >         /* Assign a channel to the original terminal device */   0     status = sys$assign(&DscTt, &TtdChan, 0, 0);'     if(!(status & 1)) lib$stop(status);    9         /* Get device name of original terminal device */    *     DviItem[0].buf_size = sizeof(TtdName);'     DviItem[0].item_code = DVI$_DEVNAM; #     DviItem[0].buf_addr = &TtdName; "     DviItem[0].buf_len = &NameLen;     DviItem[1].buf_size = 0;     DviItem[1].item_code = 0;    E     status = sys$getdviw(0, TtdChan, 0, &DviItem, &DviIosb, 0, 0, 0); '     if(!(status & 1)) lib$stop(status);    ,         /* remove underscore from TtdName */        TtdName[NameLen] = 0;      ptr1 = ptr2 = &TtdName;      ptr2++; #     while(*ptr1) *ptr1++ = *ptr2++;      NameLen--;   C         /* get the device protections of original terminal and save D            for restore on exit. Then set orig term to full access */   7     status = GetObjProt(&TtdName, &OldTtdProt, DEVICE); '     if(!(status & 1)) lib$stop(status); 7     status = SetObjProt(&TtdName, &NewTtdProt, DEVICE); '     if(!(status & 1)) lib$stop(status);    3         /* get original terminal characteristics */    L     status = sys$qiow(0, TtdChan, IO$_SENSEMODE, &TtdIosb, 0, 0, &OldTTChar,5                       sizeof(OldTTChar), 0, 0, 0, 0); '     if(!(status & 1)) lib$stop(status);    E         /* copy old term characteristics to new term characteristics, E            then make changes to new characteristics buffer (there are ?            prettier ways to do this, but this method works!) */          NewTTChar[0] = OldTTChar[0];      NewTTChar[1] = OldTTChar[1];      NewTTChar[2] = OldTTChar[2];         NewTTChar[1] |= TT$M_NOECHO;     NewTTChar[1] &= ~TT$M_WRAP; "     NewTTChar[2] |= TT2$M_PASTHRU;   C         /* save new characteristics back to originating terminal */*  *;     status = sys$qio(0,                 /* efn, not used */*A                      TtdChan,           /* channel to terminal */%:                      IO$_SETMODE,       /* i/o function */9                      &TtdIosb,          /* action iosb */ C                      0,                 /* ast routine, not used */ E                      0,                 /* ast parameter, not used */ G                      &NewTTChar,        /* P1 - new tty param buffer */|O                      sizeof(NewTTChar), /* P2 - NewTTChar size in bytes (12) */ ;                      0,                 /* P3 - not used */ ;                      0,                 /* P4 - not used */ ;                      0,                 /* P5 - not used */*;                      0);                /* P6 - not used */|'     if(!(status & 1)) lib$stop(status);_     return(SS$_NORMAL);  }       L /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  * Function: ShowVerssH  * Description: User entered the /VERSION qualifier to display the imageH  *              version, C compiler type, and required image privileges.F  *              This software application has NOT been built with VaxC  *M  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */m
 ShowVers() { 3     printf("\n\n\t\t%s by Lyle W West\n", CmdVerb);n0     printf("\t\tVersion: %s (DecC)\n", VERSION);.     printf("\t\tImage Build: %s\n", __DATE__);B     printf("\t\tRequired Privs: CMKRNL, DETACH, SYSPRV, WORLD\n");E     printf("\t\t                (or SETPRV as Authorized Priv)\n\n");u     exit(1); }       L /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  * Function: ShowHelpiA  * Description: User entered the /HELP qualifier to get a list of/A  *              parameters and qualifiers available to this imaged  *M  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */s
 ShowHelp() { ;     printf(" \n\n%s Command line arguments:\n\n", CmdVerb);h      printf("   Parameters\n\n");J     printf("    USERNAME    Required. The USERNAME is a valid user in\n");I     printf("\t\tthe User Authorization File. The user account cannot\n"); N     printf("\t\tbe disabled. If invalid or disabled, %s exits.\n\n", CmdVerb);      printf("   Qualifiers\n\n");S     printf("    /MODE       Specifies the mode of the created persona process.\n"); G     printf("\t\tThere are two options, DETACHED or SUBPROCESS. The\n"); 8     printf("\t\tdefault is to create a subprocess\n\n");O     printf("    /IGNOREID   If present, %s ignores identifier requirements.\n",                  CmdVerb);lL     printf("\t\tHowever, user is required to enter the system manager's\n");+     printf("\t\tpassword to continue\n\n");xT     printf("    /HELP       If present, %s displays list of qualifiers\n", CmdVerb);?     printf("\t\tavailable for %s (this display)\n\n", CmdVerb); M     printf("    /VERSION    If present %s displays version, build", CmdVerb); 1     printf(" date,\n\t\tand required privs\n\n");o     exit(1); }         s   