 /* !++  ! # ! MODULE:   	    ADDRESS_CONVERSION  ! ( ! FACILITY: 	    NEWSRDR (sample source) ! @ ! ABSTRACT: 	    Example of site-installable address conversion. !  ! MODULE DESCRIPTION:  ! C !   This module contains routines for use by NEWSRDR for converting ? !   RFC822-type addresses into a format acceptable to the local  !   network mail handler.  ! B !   This module simply takes the address passed in, encloses it in= !   quotation marks, and tacks SMTP% on the front.  A routine ? !   called "reverse_domain" is also included, which can be used A !   by sites whose mail handlers use backwards ordering of domain 
 !   parts. ! J !   To use this module: MODIFY IT AS NEEDED FOR YOUR SITE, then compile it" !   and link it with the commands: !  !       $ cc address_conversion ; !   	$ link/share/notrace address_conversion,sys$input:/opt   !   	    sys$share:vaxcrtl/share' !   	    universal=init,convert,cleanup  !   	    <ctrl/Z>  ! F !   Then copy it to SYS$SHARE and make it available with the commands: ! F !   	$ copy address_conversion.exe sys$common:[syslib]/protection=w:reD !   	$ install create sys$share:address_conversion/share/open/headerQ !   	$ define/system/exec newsrdr_address_conversion sys$share:address_conversion  ! 8 !   (You need a suitably privileged account to do this.) !  ! AUTHOR:   	    M. Madison 1 !   	    	    COPYRIGHT  1992, MADGOAT SOFTWARE.  ! I !   THIS SOFTWARE IS PROVIDED "AS IS".  NEITHER THE AUTHOR NOR RENSSELAER I !   MAKE ANY GUARANTEES REGARDING THE SUITABILITY, RELIABILITY, SECURITY, I !   USEFULNESS, OR PERFORMANCE OF THIS SOFTWARE.  >>USE AT YOUR OWN RISK.  !  ! CREATION DATE:    12-FEB-1991  !  ! MODIFICATION HISTORY:  ! 0 !   12-FEB-1991	V1.0	Madison	    Initial coding. !--  */   #include descrip #include string  #include stdio #include ssdef #include str$routines  #include lib$routines    struct context {$     struct dsc$descriptor localnode;     };        /* !++  !  ! ROUTINE NAME:	    INIT !  ! FUNCTIONAL DESCRIPTION:  ! B !   Allocates and initializes context block for subsequent address !   conversions. ! A !   Note that we don't actually use a context block here, so this  !   just returns normal status.  ! B ! RETURNS:  	cond_value, longword (unsigned), write only, by value !  ! PROTOTYPE: !  !   INIT  ctxptr ! > ! ctxptr:   pointer, longword (unsigned), modify, by reference !  ! IMPLICIT INPUTS:  None.  !  ! IMPLICIT OUTPUTS: None.  !  ! COMPLETION CODES:  ! 2 !   SS$_NORMAL:	    	normal successful completion. !  ! SIDE EFFECTS:  ! 	 !   None.  !--  */ unsigned int init(struct context **ctx) {       return SS$_NORMAL;
 }  /* init */    /* !++  !  ! ROUTINE NAME:	    CONVERT  !  ! FUNCTIONAL DESCRIPTION:  ! E !   Converts RFC822 address into something VMS Mail (and the "foreign 8 !   protocol" handler for network mail) will understand. ! E !   NB: You MUST use STR$ routines to copy result to OUTSTR parameter & !       to ensure proper operation!!!! ! H !       You _may_ safely assume that INSTR is compatible with a DTYPE_T,7 !   	CLASS_S (standard fixed-length) string descriptor.  ! B ! RETURNS:  	cond_value, longword (unsigned), write only, by value !  ! PROTOTYPE: ! " !   CONVERT  ctxptr, instr, outstr ! > ! ctxptr:   pointer, longword (unsigned), modify, by referenceK ! instr:    char_string, character string, read only, by descriptor (fixed) D ! outstr:   char_string, character string, write only, by descriptor !  ! IMPLICIT INPUTS:  None.  !  ! IMPLICIT OUTPUTS: None.  !  ! COMPLETION CODES:  ! 2 !   SS$_NORMAL:	    	normal successful completion. !  ! SIDE EFFECTS:  ! 	 !   None.  !--  */ unsigned int; convert(struct context **ctx, struct dsc$descriptor *instr, )     	    struct dsc$descriptor *outstr) {    /* !++ ( !  Use the following with reverse_domain ! I !  void reverse_domain(struct dsc$descriptor *, struct dsc$descriptor *);  !  struct dsc$descriptor tmp;  !  int status; !--  */  H     $DESCRIPTOR(prefix, "SMTP%\"");  /* alter as needed for your site */     $DESCRIPTOR(suffix, "\"");   /* !++ N !   The following is what NEWSRDR normally does with the NEWSRDR_MAIL_PROTOCOL= !   logical name, and is provided here only for illustration.  !--  --*/7     return str$concat(outstr, &prefix, instr, &suffix);    /* !++ 0 !   Use the following when using reverse_domain: ! $ !   tmp.dsc$b_dtype = DSC$K_DTYPE_T;$ !   tmp.dsc$b_class = DSC$K_CLASS_D; !   tmp.dsc$w_length = 0;  !   tmp.dsc$a_pointer = NULL;   !   reverse_domain(instr, &tmp);8 !   status = str$concat(outstr, &prefix, &tmp, &suffix); !   str$free1_dx(&tmp);  !   return status; !  !--  */   }  /* convert */   /* !++  !  ! ROUTINE NAME:	    CLEANUP  !  ! FUNCTIONAL DESCRIPTION:  ! 8 !   Deallocates context block allocated by init routine. ! I !   Note that we don't actually use a context block, so this just returns  !   normal status. ! B ! RETURNS:  	cond_value, longword (unsigned), write only, by value !  ! PROTOTYPE: !  !   CLEANUP  ctxptr  ! > ! ctxptr:   pointer, longword (unsigned), modify, by reference !  ! IMPLICIT INPUTS:  None.  !  ! IMPLICIT OUTPUTS: None.  !  ! COMPLETION CODES:  ! 2 !   SS$_NORMAL:	    	normal successful completion. !  ! SIDE EFFECTS:  ! 	 !   None.  !--  */ unsigned int cleanup(struct context **ctx) {        return SS$_NORMAL; }  /* cleanup */   /* !++  ! " ! ROUTINE NAME:	    REVERSE_DOMAIN !  ! FUNCTIONAL DESCRIPTION:  ! ( !   Reverses the parts of a domain name. ! ; !   Examples:  user@host.domain.edu -> user@edu.domain.host ? !              user@host.domain.ac.uk -> user@uk.ac.domain.host  ! B ! RETURNS:  	cond_value, longword (unsigned), write only, by value !  ! PROTOTYPE: !  !   CLEANUP  in, out ! = ! in:	char_string, character string, read only, by descriptor ? ! out:	char_string, character string, write only, by descriptor  !  ! IMPLICIT INPUTS:  None.  !  ! IMPLICIT OUTPUTS: None.  !  ! COMPLETION CODES:  ! 2 !   SS$_NORMAL:	    	normal successful completion. !  ! SIDE EFFECTS:  ! 	 !   None.  !--  */ voidG reverse_domain(struct dsc$descriptor *in, struct dsc$descriptor *out) {        char *cp, *placeholder; $     struct dsc$descriptor tmp, tmp2;     $DESCRIPTOR(dot, ".");  $     tmp.dsc$b_dtype = DSC$K_DTYPE_T;$     tmp.dsc$b_class = DSC$K_CLASS_D;     tmp.dsc$w_length = 0;      tmp.dsc$a_pointer = NULL;   %     tmp2.dsc$b_dtype = DSC$K_DTYPE_T; %     tmp2.dsc$b_class = DSC$K_CLASS_S;   7     placeholder = in->dsc$a_pointer + in->dsc$w_length; <     for (cp = placeholder-1; cp > in->dsc$a_pointer; cp--) {     	switch (*cp) {        	    case '.' : /     	    	tmp2.dsc$w_length = placeholder-cp-1; &     	    	if (tmp2.dsc$w_length > 0) {(     	    	    tmp2.dsc$a_pointer = cp+1;&     	    	    str$append(&tmp, &tmp2);%     	    	    str$append(&tmp, &dot);      	    	    }      	    	placeholder = cp;      	    	break;       	    case '@' : /     	    	tmp2.dsc$w_length = placeholder-cp-1; &     	    	if (tmp2.dsc$w_length > 0) {(     	    	    tmp2.dsc$a_pointer = cp+1;&     	    	    str$append(&tmp, &tmp2);     	    	    } 7     	    	tmp2.dsc$w_length = cp-(in->dsc$a_pointer)+1; 1     	    	tmp2.dsc$a_pointer = in->dsc$a_pointer; '     	    	str$concat(out, &tmp2, &tmp);      	    	str$free1_dx(&tmp);      	    	return; 
     	    }     	}  %     /* ?? this shouldn't happen ?? */        str$free1_dx(&tmp);      str$copy_dx(out,in);     }  /* reverse_domain */ 