 /* **++ **  FACILITY:	NEWSRDR  ** **  ABSTRACT:	Parsing routines.  ** **  MODULE DESCRIPTION:  **0 **  	Various routines that parse various things. ** **  AUTHOR: 	    M. Madison 7 **  	    	    COPYRIGHT  1993, 1998 MADGOAT SOFTWARE.  " **  	    	    ALL RIGHTS RESERVED. ** **  CREATION DATE:  06-SEP-1992  ** **  MODIFICATION HISTORY:  **1 **  	06-SEP-1992 V1.0    Madison 	Initial coding. E **  	12-SEP-1992 V1.0-1  Madison 	Add support for '.' in parse_range. D **  	08-OCT-1992 V1.0-2  Madison 	Check for tab a.w.a. space in PLR.D **  	12-APR-1993 V1.1    Madison 	Line count added to parse_headers.6 **  	19-MAY-1993 V1.1-1  Madison 	Fix Parse_Range bug.D **  	23-JUN-1993 V1.1-2  Madison 	Allow no y/n flag on LIST replies.I **  	29-JUN-1993 V1.2    Madison 	Don't signal SS$_ABORT on parse errors. I **  	09-OCT-1993 V1.3    Madison 	Support for FIRST, LAST in Parse_Range. > **  	13-APR-1994 V1.3-1  Madison 	Set length field in headers.? **  	18-OCT-1998 V1.3-2  Madison 	Fix parsing of OTHER headers.  **-- */ #include "newsrdr.h" #include "globals.h" #include "tpadef.h"    #define TAB '\011'  #     extern unsigned int parse822();        struct PGRBLK {      	struct tpadef tpa0;     	int *acnt;      	int *first;     	int *last;      };&     extern int pgr_state(), pgr_key();       struct PRBLK {     	struct tpadef tpa0;     	int *first;     	int *last;      	int current;      	struct GRP *grp;      };6     extern int parse_range_state(), parse_range_key();       struct PXBLK {     	struct tpadef tpa0;     	struct QUE *hdrq;     	char *grpp;     	char *grp;      	char *nump;     	char *num;      };   /* **  Forward declarations */  8     unsigned int Parse_List_Reply(char *, struct GRP *);@     unsigned int parse_group_reply(char *, int *, int *, int *);,     unsigned int pgr_store(struct PGRBLK *);F     unsigned int Parse_Range(char *, int *, int *, int, struct GRP *);3     unsigned int parse_range_store(struct PRBLK *); 9     unsigned int Parse_ToList(char *, struct QUE *, int); B     unsigned int Parse_Headers(struct QUE *, struct QUE *, int *);2     unsigned int Parse_Xref(char *, struct QUE *);*     unsigned int px_store(struct PXBLK *);1     unsigned int csl_parse(char *, struct QUE *); $     extern int px_state(), px_key();     /* **++ **  ROUTINE:	Parse_List_Reply  ** **  FUNCTIONAL DESCRIPTION:  **B **  	Parses group information from a LIST command reply, and fillsF **  in the appropriate parts of a GRP structure from that information. **B **  RETURNS:	cond_value, longword (unsigned), write only, by value ** **  PROTOTYPE: **1 **  	Parse_List_Reply(char *str, struct GRP *grp)  **1 **  str:    ASCIZ_string, read only, by reference / **  grp:    GRP structure, modify, by reference  ** **  IMPLICIT INPUTS:	None. ** **  IMPLICIT OUTPUTS:	None.  ** **  COMPLETION CODES: / **  	SS$_NORMAL: 	Normal successful completion.  ** **  SIDE EFFECTS:   	None. ** **-- */; unsigned int Parse_List_Reply(char *str, struct GRP *grp) {        char *anchor, *cp, *cp2;     int remlen, len, copylen;        anchor = str;      remlen = strlen(str);        cp = strchr(anchor, ' '); &     if (!cp) cp = strchr(anchor, TAB);'     if (!cp) return NEWS__LISTREPLYERR;      len = cp - anchor;J     copylen = (len > sizeof(grp->grpnam)-1 ? sizeof(grp->grpnam)-1 : len);*     strncpy(grp->grpnam, anchor, copylen);"     *(grp->grpnam+copylen) = '\0';       remlen -= len + 1;     anchor += len + 1;       cp = strchr(anchor, ' '); &     if (!cp) cp = strchr(anchor, TAB);'     if (!cp) return NEWS__LISTREPLYERR;      len = cp - anchor;+     for (cp2 = anchor; *cp2 == '0'; cp2++);      if (!*cp2) {     	grp->lastavl = 0;     } else {-     	lib$cvt_dtb(cp-cp2, cp2, &grp->lastavl);      }        remlen -= len + 1;     anchor += len + 1;       cp = strchr(anchor, ' '); &     if (!cp) cp = strchr(anchor, TAB);'     if (!cp) return NEWS__LISTREPLYERR;      len = cp - anchor;2     lib$cvt_dtb(cp-anchor, anchor, &grp->frstavl);       remlen -= len + 1;     anchor += len + 1;       if (remlen < 1) {      	grp->directpost = 1;      } else {F     	if (*anchor == '=' || *anchor == 'X' || *anchor == 'x') return 0;8     	grp->directpost = *anchor != 'Y' && *anchor != 'y';     }        return SS$_NORMAL;   } /* Parse_List_Reply */   /* **++ **  ROUTINE:	parse_group_reply ** **  FUNCTIONAL DESCRIPTION:  **< **  	Uses LIB$T{ABLE_}PARSE to parse the response of a GROUP **  command. **B **  RETURNS:	cond_value, longword (unsigned), write only, by value ** **  PROTOTYPE: **C **  	parse_group_reply(char *str, int *acnt, int *first, int *last)  **1 **  str:    ASCIZ_string, read only, by reference - **  acnt:   integer, write only, by reference - **  first:  integer, write only, by reference - **  last:   integer, write only, by reference  ** **  IMPLICIT INPUTS:	None. ** **  IMPLICIT OUTPUTS:	None.  ** **  COMPLETION CODES: / **  	SS$_NORMAL: 	Normal successful completion.  ** **  SIDE EFFECTS:   	None. ** **-- */M unsigned int parse_group_reply(char *str, int *acnt, int *first, int *last) {        struct PGRBLK tpablk;   '     memset(&tpablk, 0, sizeof(tpablk)); /     tpablk.tpa0.tpa$l_count = TPA$K_COUNT0 + 3; .     tpablk.tpa0.tpa$l_stringcnt = strlen(str);&     tpablk.tpa0.tpa$l_stringptr = str;     tpablk.acnt = acnt;      tpablk.first = first;      tpablk.last = last;   F     return table_parse(&tpablk, (void *) pgr_state, (void *) pgr_key);   } /* parse_group_reply */    /* **++ **  ROUTINE:	pgr_store ** **  FUNCTIONAL DESCRIPTION:  **E **  	LIB$T{ABLE_}PARSE action routine for use with parse_group_reply.  **B **  RETURNS:	cond_value, longword (unsigned), write only, by value ** **  PROTOTYPE: ** **  	pgr_store(...)  **B **  	For TABLE_PARSE, the elements of the PGRBLK structure are the **  	arguments.  **@ **  	For LIB$TABLE_PARSE, the address of the PGRBLK structure is! **  	passed as the only argument.  ** **  IMPLICIT INPUTS:	None. ** **  IMPLICIT OUTPUTS:	None.  ** **  COMPLETION CODES: " **  	SS$_NORMAL: 	Always returned. ** **  SIDE EFFECTS:   	None. ** **-- */, unsigned int pgr_store(struct PGRBLK *tpa) {  $     switch (tpa->tpa0.tpa$l_param) {       case 1: )     	*tpa->acnt = tpa->tpa0.tpa$l_number;      	break;      case 2: *     	*tpa->first = tpa->tpa0.tpa$l_number;     	break;      case 3: )     	*tpa->last = tpa->tpa0.tpa$l_number;      	break;      }        return SS$_NORMAL;   } /* pgr_store */    /* **++ **  ROUTINE:	Parse_Range ** **  FUNCTIONAL DESCRIPTION:  **+ **  	Parses an article range specification.  **B **  RETURNS:	cond_value, longword (unsigned), write only, by value ** **  PROTOTYPE: **? **  	Parse_Range(char *str, int *first, int *last, int current)  **2 **  str:    	ASCIZ_string, read only, by reference. **  first:  	integer, write only, by reference. **  last:   	integer, write only, by reference) **  current:	integer, read only, by value  ** **  IMPLICIT INPUTS:	None. ** **  IMPLICIT OUTPUTS:	None.  ** **  COMPLETION CODES: / **  	SS$_NORMAL: 	Normal successful completion.  ** **  SIDE EFFECTS:   	None. ** **-- */Z unsigned int Parse_Range(char *str, int *first, int *last, int current, struct GRP *grp) {       struct PRBLK tpablk;  '     memset(&tpablk, 0, sizeof(tpablk)); -     tpablk.tpa0.tpa$l_count = TPA$K_COUNT0+4; .     tpablk.tpa0.tpa$l_stringcnt = strlen(str);&     tpablk.tpa0.tpa$l_stringptr = str;     tpablk.first = first;      tpablk.last = last;      tpablk.current = current;      tpablk.grp = grp;   V     return table_parse(&tpablk, (void *) parse_range_state, (void *) parse_range_key);   } /* Parse_Range */    /* **++ **  ROUTINE:	parse_range_store ** **  FUNCTIONAL DESCRIPTION:  **: **  	LIB$T{}PARSE action routine for use with Parse_Range. **B **  RETURNS:	cond_value, longword (unsigned), write only, by value ** **  PROTOTYPE: ** **  	parse_range_store(...)  **A **  	For TABLE_PARSE, the elements of the PRBLK structure are the  **  	arguments.  **? **  	For LIB$TABLE_PARSE, the address of the PRBLK structure is ! **  	passed as the only argument.  ** **  IMPLICIT INPUTS:	None. ** **  IMPLICIT OUTPUTS:	None.  ** **  COMPLETION CODES: " **  	SS$_NORMAL: 	Always returned. ** **  SIDE EFFECTS:   	None. ** **-- */3 unsigned int parse_range_store(struct PRBLK *tpa) {   $     switch (tpa->tpa0.tpa$l_param) {       case 1: 7     	*tpa->first = *tpa->last = tpa->tpa0.tpa$l_number;      	break;      case 2: )     	*tpa->last = tpa->tpa0.tpa$l_number;      	break;      case 3: 2     	if (tpa->current == 0) return LIB$_SYNTAXERR;-     	*tpa->first = *tpa->last = tpa->current;      	break;      case 4: 2     	if (tpa->current == 0) return LIB$_SYNTAXERR;     	*tpa->last = tpa->current;      	break;      case 5: .     	if (tpa->grp == 0) return LIB$_SYNTAXERR;2     	*tpa->first = *tpa->last = tpa->grp->frstavl;     	break;      case 6: .     	if (tpa->grp == 0) return LIB$_SYNTAXERR;2     	*tpa->first = *tpa->last = tpa->grp->lastavl;     	break;      case 7: .     	if (tpa->grp == 0) return LIB$_SYNTAXERR;$     	*tpa->last = tpa->grp->lastavl;     	break;      default:     	break;      }        return SS$_NORMAL;   } /* parse_range_store */    /* **++ **  ROUTINE:	Parse_ToList  ** **  FUNCTIONAL DESCRIPTION:  **= **  	Parses a list of addresses.  Actually, calls parse822 to ? **  do that.  Strips all the extraneous stuff off each address, ? **  inserts it in a queue.  If keep_name is set, the extraneous  **  stuff is kept. **B **  RETURNS:	cond_value, longword (unsigned), write only, by value ** **  PROTOTYPE: **= **  	Parse_ToList(char *str, struct QUE *hdrq, int keep_name)  **2 **  str:    	ASCIZ_string, read only, by reference0 **  hdrq:   	QUE structure, modify, by reference+ **  keep_name:	boolena, read only, by value  ** **  IMPLICIT INPUTS:	None. ** **  IMPLICIT OUTPUTS:	None.  ** **  COMPLETION CODES: / **  	SS$_NORMAL: 	Normal successful completion.  ** **  SIDE EFFECTS:   	None. ** **-- */G unsigned int Parse_ToList(char *str, struct QUE *hdrq, int keep_name) {        unsigned int ctx, status;       char *address, *fulladdress;       ctx = 0;K     while (OK((status = parse822(str, &ctx, &fulladdress, &address, 0)))) { G     	insert_header((keep_name ? fulladdress : address), hdrq->tail, 0);      }   ;     return (status == SS$_ENDOFFILE) ? SS$_NORMAL : status;    } /* Parse_ToList */   /* **++ **  ROUTINE:	Parse_Headers ** **  FUNCTIONAL DESCRIPTION:  **G **  	Parses a queue of headers that are in plain text form into a queue  **  of TLV representations.  **B **  RETURNS:	cond_value, longword (unsigned), write only, by value ** **  PROTOTYPE: **< **  	Parse_Headers(struct QUE *inq, struct QUE *outq, int *) **2 **  inq:    QUE structure, read only, by reference/ **  outq:   QUE structure, modify, by reference  ** **  IMPLICIT INPUTS:	None. ** **  IMPLICIT OUTPUTS:	None.  ** **  COMPLETION CODES: / **  	SS$_NORMAL: 	Normal successful completion.  ** **  SIDE EFFECTS:   	None. ** **-- */L unsigned int Parse_Headers(struct QUE *inq, struct QUE *outq, int *xlines) {       struct HDR *hdr, *hdr2;      int i, len, lines, j; 
     char *cp; ?     static char *Tag[] = {"From","Date","Newsgroups","Subject", ;     	"Message-ID","Path","Reply-To","Sender","Followup-To", 5     	"Expires","References","Control","Distribution", <     	"Organization","Keywords","Summary","Approved","Lines",
     	"Xref"}; O     static int Code[] = {NEWS_K_HDR_FROM,NEWS_K_HDR_DATE,NEWS_K_HDR_NEWSGROUPS, >     	NEWS_K_HDR_SUBJECT,NEWS_K_HDR_MESSAGE_ID,NEWS_K_HDR_PATH,B     	NEWS_K_HDR_REPLY_TO,NEWS_K_HDR_SENDER,NEWS_K_HDR_FOLLOWUP_TO,A     	NEWS_K_HDR_EXPIRES,NEWS_K_HDR_REFERENCES,NEWS_K_HDR_CONTROL, I     	NEWS_K_HDR_DISTRIBUTION,NEWS_K_HDR_ORGANIZATION,NEWS_K_HDR_KEYWORDS, =     	NEWS_K_HDR_SUMMARY,NEWS_K_HDR_APPROVED,NEWS_K_HDR_LINES,      	NEWS_K_HDR_XREF};       lines = 0;H     for (hdr = inq->head; hdr != (struct HDR *) inq; hdr = hdr->flink) {      	cp = strchr(hdr->str, ':');     	len = cp-hdr->str; 7     	for (i = 0; i < sizeof(Tag)/sizeof(char *); i++) { %     	    if (len == strlen(Tag[i]) && :     	    	    strneql_case_blind(hdr->str, Tag[i], len)) {#     	    	while (isspace(*(++cp)));      	    	j = strlen(cp); !     	    	hdr2 = mem_gethdr(j+1);      	    	hdr2->code = Code[i];      	    	hdr2->len = j;      	    	strcpy(hdr2->str, cp);)     	    	queue_insert(hdr2, outq->tail);      	    	lines++;     	    	break;
     	    }     	}     	/* "     	 *  If not match, it's OTHER.     	 */+     	if (i == sizeof(Tag)/sizeof(char *)) { '     	    hdr2 = mem_gethdr(hdr->len+1); '     	    hdr2->code = NEWS_K_HDR_OTHER;      	    hdr2->len = hdr->len;%     	    strcpy(hdr2->str, hdr->str); (     	    queue_insert(hdr2, outq->tail);     	    lines++;      	}     }         if (xlines) *xlines = lines;     return SS$_NORMAL;   } /* parse_headers */    /* **++ **  ROUTINE:	Parse_Xref  ** **  FUNCTIONAL DESCRIPTION:  **A **  	Uses LIB$T{}PARSE to parse an Xref: header, building a queue   **  of group/article references. **B **  RETURNS:	cond_value, longword (unsigned), write only, by value ** **  PROTOTYPE: **, **  	Parse_Xref(char *str, struct QUE *hdrq) **1 **  str:    ASCIZ_string, read only, by reference / **  hdrq:   QUE structure, modify, by reference  ** **  IMPLICIT INPUTS:	None. ** **  IMPLICIT OUTPUTS:	None.  ** **  COMPLETION CODES: / **  	SS$_NORMAL: 	Normal successful completion.  ** **  SIDE EFFECTS:   	None. ** **-- */6 unsigned int Parse_Xref(char *str, struct QUE *hdrq) {       struct PXBLK tpablk;     char grp[STRING_SIZE];     char num[STRING_SIZE];  '     memset(&tpablk, 0, sizeof(tpablk)); -     tpablk.tpa0.tpa$l_count = TPA$K_COUNT0+4; -     tpablk.tpa0.tpa$l_options = TPA$M_BLANKS; .     tpablk.tpa0.tpa$l_stringcnt = strlen(str);&     tpablk.tpa0.tpa$l_stringptr = str;     tpablk.hdrq = hdrq; #     tpablk.grp = tpablk.grpp = grp; #     tpablk.num = tpablk.nump = num;   D     return table_parse(&tpablk, (void *) px_state, (void *) px_key);   } /* Parse_Xref */   /* **++ **  ROUTINE:	px_store  ** **  FUNCTIONAL DESCRIPTION:  **0 **  	LIB$T{}PARSE action routine for Parse_Xref. **B **  RETURNS:	cond_value, longword (unsigned), write only, by value ** **  PROTOTYPE: ** **  	px_store(...) **A **  	For TABLE_PARSE, the elements of the PXBLK structure are the  **  	arguments.  **? **  	For LIB$TABLE_PARSE, the address of the PXBLK structure is ! **  	passed as the only argument.  ** **  IMPLICIT INPUTS:	None. ** **  IMPLICIT OUTPUTS:	None.  ** **  COMPLETION CODES: " **  	SS$_NORMAL: 	Always returned. ** **  SIDE EFFECTS:   	None. ** **-- */* unsigned int px_store(struct PXBLK *tpa) {       int copylen;     struct HDR *h;  $     switch (tpa->tpa0.tpa$l_param) {       case 1: K     	strncpy(tpa->grp, tpa->tpa0.tpa$l_tokenptr, tpa->tpa0.tpa$l_tokencnt); 5     	tpa->grpp = tpa->grp + tpa->tpa0.tpa$l_tokencnt;      	*tpa->grpp = '\0';      	break;        case 2: (     	copylen = tpa->tpa0.tpa$l_tokencnt;6     	if (copylen > STRING_SIZE-(tpa->grpp-tpa->grp)-1)7     	    	copylen = STRING_SIZE-(tpa->grpp-tpa->grp)-1;      	if (copylen > 0) { ?     	    strncpy(tpa->grpp, tpa->tpa0.tpa$l_tokenptr, copylen);      	    tpa->grpp += copylen;     	    *tpa->grpp = '\0';      	}     	break;        case 3:      	tpa->nump = tpa->num;     	break;        case 4: (     	copylen = tpa->tpa0.tpa$l_tokencnt;6     	if (copylen > STRING_SIZE-(tpa->nump-tpa->num)-1)7     	    	copylen = STRING_SIZE-(tpa->nump-tpa->num)-1;      	if (copylen > 0) { ?     	    strncpy(tpa->nump, tpa->tpa0.tpa$l_tokenptr, copylen);      	    tpa->nump += copylen;     	    *tpa->nump = '\0';      	}     	break;        case 5: :     	if (tpa->grpp != tpa->grp && tpa->nump != tpa->num) {     	    int num; 7     	    lib$cvt_dtb(strlen(tpa->num), tpa->num, &num); 7     	    insert_header(tpa->grp, tpa->hdrq->tail, num);      	}       default:     	break;      }        return SS$_NORMAL;   } /* px_store */   /* **++ **  ROUTINE:	csl_parse ** **  FUNCTIONAL DESCRIPTION:  **B **  	Parses a comma-separated list of strings, taking into accountH **  quoting and comment delimiters (exclamation points).  Builds a queue **  of the individual items. **B **  RETURNS:	cond_value, longword (unsigned), write only, by value ** **  PROTOTYPE: *** **  	csl_parse(char *str, struct QUE *que) **1 **  str:    ASCIZ_string, read only, by referenceN/ **  que:    QUE structure, modify, by referenceY ** **  IMPLICIT INPUTS:	None. ** **  IMPLICIT OUTPUTS:	None.1 ** **  COMPLETION CODES:	/ **  	SS$_NORMAL: 	Normal successful completion.- ** **  SIDE EFFECTS:   	None. ** **-- */4 unsigned int csl_parse(char *str, struct QUE *que) {  +     char tmp[STRING_SIZE], *icp, *ocp, *cp;.     struct HDR *hdr;     int inq;       icp = str;      while (isspace(*icp)) icp++;       inq = 0;     ocp = tmp;       while (*icp) {     	if (inq) {O"     	    if (*icp == '"') inq = 0;     	    *ocp++ = *icp++; 
     	} else {      	    if (*icp == '!') {-     	    	break;"     	    } else if (*icp == ',') {7     	    	while (ocp > tmp && isspace(*(ocp-1))) ocp--;e     	    	*ocp = '\0';:     	    	if (strneql_case_blind(tmp, news_cfg.mail_proto,2     	    	    	    strlen(news_cfg.mail_proto))) {5     	    	    cp = tmp + strlen(news_cfg.mail_proto);;2     	    	    if (*cp == '"' && *(ocp-1) == '"') {     	    	    	cp++;     	    	    	*(--ocp) = '\0';      	    	    }      	    	} else cp = tmp;#     	    	hdr = mem_gethdr(ocp-cp);      	    	strcpy(hdr->str, cp);g'     	    	queue_insert(hdr, que->tail);s     	    	ocp = tmp;     	    	icp++;&     	    	while (isspace(*icp)) icp++;     	    } else { #     	    	if (*icp == '"') inq = 1;      	    	*ocp++ = *icp++;
     	    }     	}     }w  1     while (ocp > tmp && isspace(*(ocp-1))) ocp--;e     if (ocp > tmp) {     	*ocp = '\0';i5     	if (strneql_case_blind(tmp, news_cfg.mail_proto, .     	    	    	strlen(news_cfg.mail_proto))) {0     	    cp = tmp + strlen(news_cfg.mail_proto);-     	    if (*cp == '"' && *(ocp-1) == '"') {o     	    	cp++;)     	    	*(--ocp) = '\0';
     	    }     	} else cp = tmp;      	hdr = mem_gethdr(ocp-cp);     	strcpy(hdr->str, cp);"     	queue_insert(hdr, que->tail);     }        return SS$_NORMAL;   } /* csl_parse */t