 /*?         LISTEN_PROCESS - message processing routines for LISTEN     COPYRIGHT NOTICE   5  This software is COPYRIGHT  1997,2005, Ian Miller.    3  Released under licence described in aaareadme.txt      DISCLAIMER   J  This software is provided "AS IS". The author makes no representations orN  warranties with respect to the software and specifically disclaim any impliedE  warranties of merchantability or fitness for any particular purpose.    History	 =======   C 14-Mar-1997 I.Miller  V1.0      Created (from bits of LISTEN_SYSID) 5 09-Apr-1997 I.Miller  V1.0-001  Use save_mop_message. ? 11-Apr-1997 I.Miller  V1.0-002  Don't add 0.0.0.0 IP addresses. F                                 Don't add IPX addresses with net == 0.B 14-Apr-1997 I.Miller  V1.0-003  Add process_ipx_802_3,process_rip.4                                 Add node attributes.5 30-Apr-1997 I.Miller  V1.0-004  Add process_name etc. H 06-May-1997 I.Miller  V1.0-005	Add process_igmp to find out who is using 				IP multicasting. */   #define VERSION "V1.0-005"
 #if __DECC% #pragma module LISTEN_PROCESS VERSION  #else  #module LISTEN_PROCESS VERSION   #endif   #include <stdio.h> #include <stdlib.h>  #include <starlet.h> #include <ctype.h>   #include "ethernet.h"  #include "messages.h"  #include "sysid.h" #include "listen_table.h"  #include "listen_subs.h"  G static void process_udp(int n,IP_HEADER *iphdr,UDP_HEADER *udp_header); F static void process_rip(int n,IP_HEADER *iphdr,UDP_HEADER *udp_header,1         unsigned char *data,unsigned short dlen); 0 static void process_igmp(int n,IP_HEADER *iphdr,1         unsigned char *data,unsigned short dlen); G static void process_name(int n,IP_HEADER *iphdr,UDP_HEADER *udp_header, 1         unsigned char *data,unsigned short dlen); H static void process_bootp(int n,IP_HEADER *iphdr,UDP_HEADER *udp_header,1         unsigned char *data,unsigned short dlen); P static void process_ipx_rip(int n,IPX_HEADER *ipxhdr,unsigned char *data,                unsigned short len);P static void process_ipx_sap(int n,IPX_HEADER *ipxhdr,unsigned char *data,                unsigned short len);@ static void process_icmp_router_adv(int n,ICMP_HEADER *icmphdr);3 static unsigned char *skip_name(unsigned char *cp); K static void uncompress_name(unsigned char *in_ptr, unsigned char *base_ptr, .         unsigned char *end_ptr,char *out_ptr);- static void decode_name(char *in, char *out); < static void process_netbuei_name(int n,unsigned char *name);     /*9         process MOP RC SYSID V4 messages (DECnet phase V)  */ voidO process_sysid_v4(int n,FRAME_HEADER *hdr,unsigned char *msg,unsigned short len)  { $         unsigned short dnet, now[4];         char name[256];            sys$gettim(&now);       "         /* validate message     */4         if ((hdr->hdr_802e.destination[0] & 1) == 1)	         {                   if (msg[0] == 7)                 { 2                         /* its a SYSID message		*/+                 	/* add MOP to protocols */ ?                         add_protocol_802e(n,hdr->hdr_802e.pid); 9                         save_mope_message(n,msg,len,now); `                         if (get_sysid_name(nodes[n].mope_sysid,nodes[n].mope_sysid_length,name))                         { L                                 add_name(n,LT_NAME_SYSID,name,strlen(name));                         }   6                 	if ((hdr->hdr_802e.source[0] == 0xAA):                         &&  (hdr->hdr_802e.source[1] == 0)7         	        &&  (hdr->hdr_802e.source[2] == 0x04)  ;                         &&  (hdr->hdr_802e.source[3] == 0))          	        {,                 		/* add DECnet address   */1         		        dnet = hdr->hdr_802e.source[4]  F                                         + hdr->hdr_802e.source[5]*256;9         		        add_address(n,LT_ADDRESS_DECNET,&dnet); @                                 strcpy(name,get_nodename(dnet));4                                 if (name[0] != '\0')!                                 { U                                         add_name(n,LT_NAME_DECNET,name,strlen(name)); !                                 }                  	}                 }                  else                 { I                         printf("MOP message type %d not SYSID\n",msg[0]);                  } 	         }          else	         { 4                 printf("not a multicast address\n");	         }  }    /*:         process MOP RC SYSID V3 messages (DECnet phase IV) */ voidO process_sysid_v3(int n,FRAME_HEADER *hdr,unsigned char *msg,unsigned short len)  { ,         unsigned short dnet, now[4], msglen;         char name[256];   /         /* get the length (ethernet padding) */          memcpy(&msglen,msg,2);  2         /* skip the length                      */         msg += 2;          len = msglen;            sys$gettim(&now);       "         /* validate message     */3         if ((hdr->hdr_eth.destination[0] & 1) == 1) 	         {                   if (msg[0] == 7)                 { 2                         /* its a SYSID message		*/+                 	/* add MOP to protocols */ 7                 	add_protocol_eth(n,MOP_PROTOCOL_TYPE); 8                         save_mop_message(n,msg,len,now);^                         if (get_sysid_name(nodes[n].mop_sysid,nodes[n].mop_sysid_length,name))                         { L                                 add_name(n,LT_NAME_SYSID,name,strlen(name));                         }   . 	        	if ((hdr->hdr_eth.source[0] == 0xAA)2 	                &&  (hdr->hdr_eth.source[1] == 0)/ 		        &&  (hdr->hdr_eth.source[2] == 0x04)  3 	                &&  (hdr->hdr_eth.source[3] == 0))  		        { % 	        		/* add DECnet address   */ ) 			        dnet = hdr->hdr_eth.source[4]  > 	                                + hdr->hdr_eth.source[5]*256;2 			        add_address(n,LT_ADDRESS_DECNET,&dnet);@                                 strcpy(name,get_nodename(dnet));4                                 if (name[0] != '\0')!                                 { U                                         add_name(n,LT_NAME_DECNET,name,strlen(name)); !                                 }  	        	}  		}  		else 		{ I                         printf("MOP message type %d not SYSID\n",msg[0]);                  } 	         }          else	         { 4                 printf("not a multicast address\n");	         }  }    /*         process ARP broadcasts */ voidJ process_arp(int n,FRAME_HEADER *hdr,unsigned char *msg,unsigned short len) {          ARP_MESSAGE *amsg;         char name[256];          int n2;   ' 	add_protocol_eth(n,ARP_PROTOCOL_TYPE);   "         amsg = (ARP_MESSAGE *)msg;         bswap(&amsg->ar_hrd);          bswap(&amsg->ar_pro);          bswap(&amsg->ar_op);  "         /* validate message     */)         if ((amsg->ar_hrd == ARP_HRD_ETH) (         &&  (amsg->ar_pro == ARP_PRO_IP))         &&  (amsg->ar_hln == ARP_HLN_ETH) (         &&  (amsg->ar_pln == ARP_PLN_IP)#         &&  (amsg->ar_spa[0] != 0)) 	         { O                 if ((amsg->ar_op == ARP_REPLY) || (amsg->ar_op == ARP_REQUEST))                  { B                         add_address(n,LT_ADDRESS_IP,amsg->ar_spa);;                         if (get_ip_name(amsg->ar_spa,name)) I                                 add_name(n,LT_NAME_IP,name,strlen(name)); 5                         if (amsg->ar_op == ARP_REPLY)                          { <                                 n2 = add_node(amsg->ar_tha);,                                 if (n2 >= 0)!                                 { E                                         add_address(n2,LT_ADDRESS_IP, >                                                 amsg->ar_tpa);K                                         if (get_ip_name(amsg->ar_tpa,name)) Z                                                 add_name(n2,LT_NAME_IP,name,strlen(name));!                                 }                          }                  } 	         }  }    /*         process IP broadcasts  */ voidI process_ip(int n,FRAME_HEADER *hdr,unsigned char *msg,unsigned short len)  {  	UDP_HEADER *udphdr; 	IP_HEADER *iphdr;         char name[256];  	unsigned char ihl;          ICMP_HEADER *icmphdr;          unsigned char *data;         unsigned short datalen;          char *p;  % 	/* add IP protocol for this node	*/	 & 	add_protocol_eth(n,IP_PROTOCOL_TYPE);   	/* look at IP header			*/ 	iphdr = (IP_HEADER *)msg;  ! 	/* add this nodes IP address		*/ "         if (iphdr->source[0] != 0);                 add_address(n,LT_ADDRESS_IP,iphdr->source);     	/* add IP name if available		*/,         if (get_ip_name(iphdr->source,name))9                 add_name(n,LT_NAME_IP,name,strlen(name));    	/* get header length	*/ 	ihl = iphdr->ihl * 4;	  	if (ihl < 20)% 		ihl = 20;	/* must be at least 20	*/          data = &msg[ihl];          datalen = len - ihl; 	switch (iphdr->protocol)  	{ 	case IP_ICMP: 		/* ICMP	*/.                 icmphdr = (ICMP_HEADER *)data; #if 0 *                 switch(icmphdr->icmp_type)                 { ,                 case ICMP_TYPE_ECHO_REQUEST:+                         p = "echo request";                          break;(                 case ICMP_TYPE_DUNREACH:6                         p = "destination unreachable";                         break;'                 case IMCP_TYPE_SQUENCH: ,                         p = "source quench";                         break;(                 case ICMP_TYPE_REDIRECT:'                         p = "redirect";                          break;*                 case ICMP_TYPE_ECHO_REPLY:)                         p = "echo reply";                          break;*                 case ICMP_TYPE_ROUTER_ADV:2                         p = "router advertisment";                         break;*                 case ICMP_TYPE_ROUTER_SOL:2                         p = "Router Solicitation";                         break;&                 case ICMP_TYPE_TOOOLD:,                         p = "time exceeded";                         break;(                 case ICMP_TYPE_PPROBLEM:0                         p = "parameter problem";                         break;)                 case ICMP_TYPE_TIMESTAMP: 0                         p = "timestamp request";                         break;-                 case ICMP_TYPE_TIMESTAMP_REP: .                         p = "timestamp reply";                         break;,                 case ICMP_TYPE_INFO_REQUEST:2                         p = "information request";                         break;*                 case ICMP_TYPE_INFO_REPLY:0                         p = "information reply";                         break;                 default:                          p = "?";                 } 8 		printf("ICMP message type = %d (%s), code = %d from ",A                         icmphdr->icmp_type,p,icmphdr->icmp_code); % 		display_addr(stdout,nodes[n].addr);  		printf("\n");  #endif?                 if (icmphdr->icmp_type == ICMP_TYPE_ROUTER_ADV)                  { 2                         /* router advertisment  */>                         add_attribute(n,LT_NODE_ATT_IPROUTER);;                         process_icmp_router_adv(n,icmphdr);                  }  		break; 	case IP_IGMP: 		/* IGMP	*/3                 process_igmp(n,iphdr,data,datalen);  		break;
 	case IP_TCP:  		/* TCP 	*/ #if 0  		printf("TCP message from ");% 		display_addr(stdout,nodes[n].addr);  		printf("\n");  #endif
 	case IP_UDP:  		/* UDP	*/  		udphdr = (UDP_HEADER *)data; 		process_udp(n,iphdr,udphdr); 		break; 	} }   D static void process_igmp(int n,IP_HEADER *iphdr,unsigned char *data,         unsigned short dlen) {          IGMP_HEADER *igmphdr;   &         igmphdr = (IGMP_HEADER *)data;  (         if (dlen >= sizeof(IGMP_HEADER))	         { 5                 if (igmphdr->version == IGMP_VERSION)                  { >                         if (igmphdr->type == IGMP_TYPE_REPORT)                         { J                                 /* node is reporting memership of group */L                                 add_address(n,LT_ADDRESS_IP,igmphdr->gaddr);                         } - 			else if (igmphdr->type == IGMP_TYPE_QUERY)  			{ 				printf("IGMP query from "); - 				display_ip_address(stdout,iphdr->source);  				printf(" to "); 2 				display_ip_address(stdout,iphdr->destination); 				printf("\n");  			} 			else  			{( 				printf("IGMP message type %d from ", 					igmphdr->type);- 				display_ip_address(stdout,iphdr->source);  				printf(" to "); 2 				display_ip_address(stdout,iphdr->destination); 				printf("\n");  			  			}                 }                  else                 { M                         printf("unknown IGMP version %d\n",igmphdr->version);                  } 	         }          else	         { ;                 printf("duff IGMP message size %d\n",dlen); 	         }  }    static void 3 process_icmp_router_adv(int n,ICMP_HEADER *icmphdr)  {          int i;         ROUTE_IP rip;   1         if (icmphdr->u.router_adv.addr_size != 2) :                 return; /* don't know what this is      */:         for (i=0; i < icmphdr->u.router_adv.num_addr; i++)	         { D                 memcpy(rip.addr,icmphdr->u.router_adv.entry[i].addr,*                         sizeof(rip.addr));G                 rip.metric = icmphdr->u.router_adv.entry[i].preference; :                 add_route(n,LT_ROUTE_IP,sizeof(rip),&rip);	         }  }    /* 	process a UDP message */ static void : process_udp(int n,IP_HEADER *iphdr,UDP_HEADER *udp_header) {  	unsigned char *data; # 	unsigned short dlen, dport, sport;    	/* get data length	*/8 	dlen = bswap2(udp_header->length) - sizeof(UDP_HEADER);   	/* skip header		*/ $ 	data = (unsigned char *)udp_header; 	data += sizeof(UDP_HEADER);   	/* get port numbers	*/ # 	dport = bswap2(udp_header->dport); # 	sport = bswap2(udp_header->sport);    #if 0          printf("UDP from ");$ 	display_addr(stdout,nodes[n].addr);3         printf("dport %d, sport %d\n",dport,sport);  #endif 	switch(dport) 	{ 	case UDP_PORT_BOOTP_SERVER:$ 		/* request to BOOTP/DHCP server	*/B                 /* implies this node is a BOOTP/DHCP client     */4                 add_attribute(n,LT_NODE_ATT_BOOTPC);<                 process_bootp(n,iphdr,udp_header,data,dlen); 		break; 	case UDP_PORT_BOOTP_CLIENT:B                 /* reply from BOOTP/DHCP server to client       */B                 /* implies this node is a BOOTP/DHCP server     */4                 add_attribute(n,LT_NODE_ATT_BOOTPS);<                 process_bootp(n,iphdr,udp_header,data,dlen);                 break; 	case UDP_PORT_NETBIOS_NAME: 		/* NETBIOS Name Service */;                 process_name(n,iphdr,udp_header,data,dlen);  		break; 	case UDP_PORT_NETBIOS_DGRAM:   		/* NETBIOS Datagram Service	*/ 		break; 	case UDP_PORT_NETBIOS:  		/* NETBIOS */  		break; 	case UDP_PORT_IPX:  		/* IPX				*/ 		printf("IPX over IP from ");% 		display_addr(stdout,nodes[n].addr);  		printf("\n");  		break; 	case UDP_PORT_NETWAREIP:  		/* netware-IP			*/ 		break; 	case UDP_PORT_ROUTE:  		/* RIP				*/6                 add_attribute(n,LT_NODE_ATT_IPROUTER);:                 process_rip(n,iphdr,udp_header,data,dlen); 		break;	 	default:                   if (sport == 53)C                         process_name(n,iphdr,udp_header,data,dlen);  #if 0 4 		printf("UDP dport %d sport %d from ",dport,sport);% 		display_addr(stdout,nodes[n].addr);                  printf(" ");9                 display_ip_address(stdout,iphdr->source);                  printf(" to "); >                 display_ip_address(stdout,iphdr->destination); 		printf("\n");  #endif 	}   }    /*         process RIP messages */ static void N process_rip(int n,IP_HEADER *iphdr,UDP_HEADER *udp_header,unsigned char *data,         unsigned short dlen) {          RIP_HEADER *rip_header;          RIP_ENTRY *rip_entry; '         RIP_AUTH_ENTRY *rip_auth_entry;          ROUTE_IP rip;          ROUTE_IP2 rip2;   "         /* get RIP header       */(         rip_header = (RIP_HEADER *)data;#         data += sizeof(RIP_HEADER); #         dlen -= sizeof(RIP_HEADER);   *         /* check RIP data length        */&         if ((rip_header->command == 2)(         &&  (dlen >= sizeof(RIP_ENTRY)))	         { *                 /* check RIP version    *//                 if ((rip_header->version == 1)  /                 ||  (rip_header->version == 2))                  { 2                         /* scan RIP entries     */(                         while (dlen > 0)                         { >                                 rip_entry = (RIP_ENTRY *)data;=                                 if (rip_entry->afi == 0x0200) !                                 { B                                         /* IP address entry     */E                                         if ((rip_entry->addr[0] == 0) E                                         &&  (rip_entry->addr[1] == 0) E                                         &&  (rip_entry->addr[2] == 0) F                                         &&  (rip_entry->addr[3] == 0)))                                         { J                                                 /* default route        */@                                                 add_attribute(n,O                                                         LT_NODE_ATT_IPDEFAULT); )                                         } E                                         if (rip_header->version == 1) )                                         { @                                                 memcpy(rip.addr,H                                                         rip_entry->addr,J                                                         sizeof(rip.addr));W                                                 rip.metric = bswap4(rip_entry->metric); H                                                 add_route(n,LT_ROUTE_IP,J                                                         sizeof(rip),&rip);)                                         } ,                                         else)                                         { A                                                 memcpy(rip2.addr, H                                                         rip_entry->addr,K                                                         sizeof(rip2.addr)); A                                                 memcpy(rip2.mask, H                                                         rip_entry->mask,K                                                         sizeof(rip2.addr)); X                                                 rip2.metric = bswap4(rip_entry->metric);I                                                 add_route(n,LT_ROUTE_IP2, L                                                         sizeof(rip2),&rip2);)                                         } !                                 } B                                 else if (rip_entry->afi == 0xffff)!                                 { P                                         rip_auth_entry = (RIP_AUTH_ENTRY *)data;C                                         printf("RIP auth entry\n"); !                                 } :                                 data += sizeof(RIP_ENTRY);:                                 dlen -= sizeof(RIP_ENTRY);                         }                  } 	         }  }    static void ; process_name(int n,IP_HEADER *iphdr,UDP_HEADER *udp_header, 0         unsigned char *data,unsigned short dlen) {          NAME_HEADER *nhdr;K         unsigned short qdcount,ancount,nscount,arcount, type, class, rdlen; $         unsigned char *np, *end_ptr;#         char name[256], name2[256];          NB_FLAGS *nbflags;         NB_ADDRESS *nbaddr;          int data_len,nl;         int n2;          #         nhdr = (NAME_HEADER *)data;          end_ptr = data + dlen;$         data += sizeof(NAME_HEADER);.         data_len = dlen - sizeof(NAME_HEADER);  (         qdcount = bswap2(nhdr->qdcount);(         ancount = bswap2(nhdr->ancount);(         nscount = bswap2(nhdr->nscount);(         arcount = bswap2(nhdr->arcount);   #if 0 * 	display_ip_address(stdout,iphdr->source);;         printf(" - name message - opode %d ",nhdr->opcode);          switch(nhdr->opcode)	         {          case NAME_OP_QUERY:                   printf("query");                 break;         case NAME_OP_IQUERY:(                 printf("inverse query");                 break;         case NAME_OP_STATUS:2                 printf("nameserver status query");                 break;"         case NAME_OP_NS_NOTIFY_OP:,                 printf("nameserver notify");                 break;"         case NAME_OP_REGISTRATION:/                 printf("NetBIOS registration");                  break;         case NAME_OP_RELEASE: *                 printf("NetBIOS release");                 break;         case NAME_OP_WACK:/                 printf("NetBIOS Wait for ACK");                  break;          case NAME_OP_REFRESH:   *                 printf("NetBIOS refresh");	         } 6         printf(" %s\n",nhdr->qr?"response":"request");           if (qdcount > 0)*                 printf("QUESTION data\n"); #endif1         while ((qdcount-- > 0) && (data_len > 0)) 	         {                  np = data;'                 data = skip_name(data); ,                 data_len -= data - np;      %                 memcpy(&type,data,2);                  bswap(&type);                  data += 2;                 data_len -= 2;&                 memcpy(&class,data,2);                 bswap(&class);                 data += 2;                 data_len -= 2; #if 0 7                 printf("class=%d,type=%d,",class,type); G                 uncompress_name(np,(unsigned char *)nhdr,end_ptr,name); )                 if (type == NAME_TYPE_NB)                  { C                         /* decode bizarrely encoded NetBIOS name */ 0                         decode_name(name,name2);2                         printf("name=%s\n",name2);                 }                  else                 { 1                         printf("name=%s\n",name);                  }  #endif	         }  #if 0          if (ancount > 0)'                 printf("ANSWER RRs\n");  #endif1         while ((ancount-- > 0) && (data_len > 0)) 	         {                  np = data;'                 data = skip_name(data); &                 data_len -= data - np;%                 memcpy(&type,data,2);                  bswap(&type);                  data += 2;                 data_len -= 2;&                 memcpy(&class,data,2);                 bswap(&class);                 data += 2;                 data_len -= 2; #if 0 7                 printf("class=%d,type=%d,",class,type); G                 uncompress_name(np,(unsigned char *)nhdr,end_ptr,name); )                 if (type == NAME_TYPE_NB)                  { C                         /* decode bizarrely encoded NetBIOS name */ 0                         decode_name(name,name2);2                         printf("name=%s\n",name2);                 }                  else                 { 1                         printf("name=%s\n",name);                  }  #endif; 		if ((type != NAME_TYPE_NB) && (type != NAME_TYPE_NBSTAT))  		{ 8                         /* source node is a nameserver*/@                         add_attribute(n,LT_NODE_ATT_NAMESERVER); 		}   2                 data += 4;      /* skip TTL     */&                 memcpy(&rdlen,data,2);                 bswap(&rdlen);-                 if ((type == NAME_TYPE_CNAME) *                 ||  (type == NAME_TYPE_NS),                 ||  (type == NAME_TYPE_PTR))                 {  #if 0 O                         uncompress_name(&data[2],(unsigned char *)nhdr,end_ptr, '                                 name2); 8                         printf("RDATA name %s\n",name2); #endif                 } -                 else if (type == NAME_TYPE_A)                  {  #if 0 4                         printf("RDATA IP address ");<                         display_ip_address(stdout,&data[2]);+                         fputc('\n',stdout);  #endifJ                         n2 = find_node_by_address(&data[2],LT_ADDRESS_IP);$                         if (n2 >= 0)                         { I                                 uncompress_name(np,(unsigned char *)nhdr, 6                                         end_ptr,name);1                                 lower_case(name); L                                 add_name(n2,LT_NAME_IP,name,strlen(name)-1);                         }                  }                  data += rdlen;"                 data_len -= rdlen;	         }  #if 0          if (nscount > 0)*                 printf("AUTHORITY RRs\n"); #endif1         while ((nscount-- > 0) && (data_len > 0)) 	         {                  np = data;'                 data = skip_name(data); &                 data_len -= data - np;%                 memcpy(&type,data,2);                  bswap(&type);                  data += 2;                 data_len -= 2;&                 memcpy(&class,data,2);                 bswap(&class);                 data += 2;                 data_len -= 2; #if 0 G                 uncompress_name(np,(unsigned char *)nhdr,end_ptr,name); 7                 printf("class=%d,type=%d,",class,type); )                 if (type == NAME_TYPE_NB)                  { C                         /* decode bizarrely encoded NetBIOS name */ 0                         decode_name(name,name2);2                         printf("name=%s\n",name2);                 }                  else                 { 1                         printf("name=%s\n",name);                  }  #endif2                 data += 4;      /* skip TTL     */&                 memcpy(&rdlen,data,2);                 bswap(&rdlen);                 data += rdlen;"                 data_len -= rdlen;	         }  #if 0          if (arcount > 0)+                 printf("ADDITIONAL RRs\n");  #endif1         while ((arcount-- > 0) && (data_len > 0)) 	         {                  np = data;'                 data = skip_name(data); &                 data_len -= data - np;%                 memcpy(&type,data,2);                  bswap(&type);                  data += 2;                 data_len -= 2;&                 memcpy(&class,data,2);                 bswap(&class);                 data += 2;                 data_len -= 2;G                 uncompress_name(np,(unsigned char *)nhdr,end_ptr,name);  #if 0 7                 printf("class=%d,type=%d,",class,type);  #endif)                 if (type == NAME_TYPE_NB)                  { C                         /* decode bizarrely encoded NetBIOS name */ 0                         decode_name(name,name2); #if 0 I                         printf("name=%s,flags qr=%d,rd=%d,aa=%d,ad=%d\n", &                                 name2,E                                 nhdr->qr,nhdr->rd,nhdr->aa,nhdr->ad);  #endif                 }  #if 0                  else                 { 1                         printf("name=%s\n",name);                  }  #endif2                 data += 4;      /* skip TTL     */*                 /* get RD length        */&                 memcpy(&rdlen,data,2);                 data += 2;                 data_len -= 2;                 bswap(&rdlen);D                 if ((rdlen == (sizeof(NB_FLAGS)+sizeof(NB_ADDRESS)))+                 &&  (type == NAME_TYPE_NB))                  { 3                         nbflags = (NB_FLAGS *)data; 9                         bswap((unsigned short *)nbflags);  #if 0 N                         printf("nbflags - group %d, ont %d,reserved=0x%02x\n",O                                 nbflags->group,nbflags->ont,nbflags->reserved);  #endif1                         data += sizeof(NB_FLAGS); 5                         data_len -= sizeof(NB_FLAGS); 4                         nbaddr = (NB_ADDRESS *)data; #if 0 *                         printf("nbaddr ");K                         display_ip_address(stdout,(unsigned char *)nbaddr); %                         printf("\n");  #endif3                         data += sizeof(NB_ADDRESS); 7                         data_len -= sizeof(NB_ADDRESS); - 			if ((nhdr->opcode == NAME_OP_REGISTRATION) :                         &&  (!nhdr->qr) /* not response */ 			&&  (!nhdr->rd))  			{* 				/*  NAME OVERWRITE REQUEST & DEMAND */E                         	if ((name2[0] == 0x01) && (name2[1] == 0x02) H                         	&&  (name2[15] == 0x01) && (name2[14] == 0x02))!                                 { J                                         /*magic name ^a^b__MBROWSE__^B^A*/P                                         add_attribute(n,LT_NODE_ATT_MSTBROWSER);!                                 } $                                 else!                                 { ;                                         nl = strlen(name2); 4                                         if (nl < 17)8                                                 nl = 17;%                         		add_name(n, `                                                 nbflags->group?LT_NAME_NETBIOSG:LT_NAME_NETBIOS,:                                                 name2,nl);!                                 }  			}) 			if (((nhdr->opcode == NAME_OP_RELEASE) * 			||   (nhdr->opcode == NAME_OP_REFRESH))(                         &&  (!nhdr->qr)) 			{B                                 /* NAME RELEASE or REFRESH      */- 				/* implies that the node owns the name */ E                         	if ((name2[0] == 0x01) && (name2[1] == 0x02) H                         	&&  (name2[15] == 0x01) && (name2[14] == 0x02))!                                 { J                                         /*magic name ^a^b__MBROWSE__^B^A*/P                                         add_attribute(n,LT_NODE_ATT_MSTBROWSER);!                                 } $                                 else!                                 { ;                                         nl = strlen(name2); 4                                         if (nl < 17)8                                                 nl = 17;%                         		add_name(n, `                                                 nbflags->group?LT_NAME_NETBIOSG:LT_NAME_NETBIOS,:                                                 name2,nl);!                                 }  			}                 }                  else                 { &                         data += rdlen;*                         data_len -= rdlen;                 } 	         }  }    /* skip over a domain name */  static unsigned char * skip_name(unsigned char *cp) {  	unsigned char i;   8 	if (((i = *cp++) & NAME_INDIR_FLAG) == NAME_INDIR_FLAG) 		return (cp + 1); 	while (i)  	         { 
 		cp += i; 		i = *cp++; 	}
 	return (cp);  }    /* uncompress a domain name */ static void ? uncompress_name(unsigned char *in_ptr, unsigned char *base_ptr, -         unsigned char *end_ptr,char *out_ptr)  {  	unsigned int i;   	if ((i = *in_ptr++) != 0)	         {   		while (i && in_ptr < end_ptr)                  { 1 			if ((i & NAME_INDIR_FLAG) == NAME_INDIR_FLAG)                           { 8 				in_ptr = base_ptr + (((i << 8) | *in_ptr) & 0x3fff); 				i = *in_ptr++;
 				continue;  			} 			do                          {  				*out_ptr++ = *in_ptr++;  			} while (--i);  			*out_ptr++ = '.'; 			i = *in_ptr++;  		} 	         }  	else  		*out_ptr++ = '.';          *out_ptr = '\0'; }   L /* decode a NetBIOS name (encoded by bizarre method described in RFC1001) */ static void   decode_name(char *in, char *out) {          unsigned char code;  	char *p, *outptr = out;  P         /*  scan the string stopping at the dot (end of name) or end of string*/-         while ((*in != '.') && (*in != '\0')) 	         { J                 code = ((*in++ - 'A') << 4);    /* decode hi nibble     */J                 code += *in++ - 'A';            /* decode lo nibble     */F                 *out++ = code;          	/* copy to output buffer   */	         } L         strcpy(out,in); /* copy remainder of string (scope identifier)    */ }   H static void process_bootp(int n,IP_HEADER *iphdr,UDP_HEADER *udp_header,0         unsigned char *data,unsigned short dlen) {          BOOTP_HEADER *bhdr;          short olen;  	int pad, oindex;  	unsigned char optlen, option; 	unsigned char opt_overload;	     $         bhdr = (BOOTP_HEADER *)data;  "         /* validate message     */@         if (dlen < (sizeof(BOOTP_HEADER)-sizeof(bhdr->options)))	         { B                 printf("%%LISTEN-W-DUFFBPL, BOOTP message from ");% 		display_addr(stdout,nodes[n].addr); 7                 printf(" too short - len = %d\n",dlen);7                 return;R	         }eA         if ((bhdr->op != BOOTREQUEST) && (bhdr->op != BOOTREPLY))t	         {vC                 printf("%%LISTEN-W-DUFFBPOP, BOOTP message from ");h% 		display_addr(stdout,nodes[n].addr);l8                 printf(" has unknown op %d\n",bhdr->op);                 return;r	         } '         if (bhdr->htype != ARP_HRD_ETH)l	         { C                 printf("%%LISTEN-W-DUFFBPOP, BOOTP message from ");1% 		display_addr(stdout,nodes[n].addr);.N                 printf(" has unknown hardware address type %d\n",bhdr->htype);                 return;e	         }=&         if (bhdr->hlen != ARP_HLN_ETH)	         {pC                 printf("%%LISTEN-W-DUFFBPOP, BOOTP message from ");u% 		display_addr(stdout,nodes[n].addr);dM                 printf(" has unknown hardware address llen %d\n",bhdr->hlen);u                 return;l	         } *         /* calculate options length     */C         olen = dlen - (sizeof(BOOTP_HEADER)-sizeof(bhdr->options));O  *         /* display message              */ #if 0eK         printf("BOOTP %s from ",(bhdr->op==BOOTREQUEST)?"request":"reply");h$ 	display_addr(stdout,nodes[n].addr);C         printf(" xid = 0x%04x, secs = %u, broadcast = %d, ciaddr=",t<                 bhdr->xid,bhdr->secs,bhdr->flags.broadcast);) 	display_ip_address(stdout,bhdr->ciaddr);A+         printf(",options len = %d\n",olen);n #endif3 	pad = FALSE;		/* assume no even boundry padding	*/_4 	opt_overload = 0;	/* assume no options overload		*/ 	if ((bhdr->options[0] == 99)t 	&&  (bhdr->options[1] == 130) 	&&  (bhdr->options[2] == 83)d 	&&  (bhdr->options[3] == 99)) 	{* 		/* the options area is in DHCP format	*/
 		oindex = 4;A 		olen -= 4; 		while (olen > 0) 		{ $ 			option = bhdr->options[oindex++];
 			olen--; 			if (option == 0)_ 			{M                                 /* all options should start on even boundry*/;* 				pad = TRUE;	/* even boundry padding	*/ 				optlen = 0;e 			} 			else  			if (option == 0xff) 			{:                                 /* end of options flag  */ 				optlen = 0;cJ                                 olen = 0;       /* terminate loop       */ 			} 			elsei 			{% 				optlen = bhdr->options[oindex++];i 				olen--;d 			} #if 0t$ 			printf("option len %d, type %d ", 				optlen,option);t #endif&                         switch(option)                         { B                         case 12:        /* host name            */ #if 0_9                                 printf("host name %*.*s",tN                                         optlen,optlen,&bhdr->options[oindex]); #endif8                                 add_name(n,LT_NAME_DHCP,O                                         (char *)&bhdr->options[oindex],optlen); &                                 break;B                         case 50:        /* requested IP address */ #if 0 @                                 printf("requested IP address ");:                                 display_ip_address(stdout,@                                         &bhdr->options[oindex]); #endif&                                 break;& 			case 52:	/* option overload flag	*/) 				opt_overload = bhdr->options[oindex];E
 				break;B                         case 53:        /* DHCP message type    */ #if 0r=                                 switch(bhdr->options[oindex])_!                                 { '                                 case 1: ?                                         printf("DHCPDISCOVER"); .                                         break;'                                 case 2:h<                                         printf("DHCPOFFER");.                                         break;'                                 case 3:e>                                         printf("DHCPREQUEST");.                                         break;'                                 case 4: >                                         printf("DHCPDECLINE");.                                         break;'                                 case 5: :                                         printf("DHCPACK");.                                         break;'                                 case 6: :                                         printf("DHCPNAK");.                                         break;'                                 case 7:D>                                         printf("DHCPRELEASE");.                                         break;'                                 case 8:e=                                         printf("DHCPINFORM");t.                                         break;(                                 default:;                                         printf("DHCP %d ?", G                                                 bhdr->options[oindex]);g.                                         break;!                                 }  #endif
 				break;! 			case 60:	/* vendor class id	*/  #if 0 2 				printf("VENDOR CLASS ID = %d, %d %d %d %d %d", 					bhdr->options[oindex],  					bhdr->options[oindex+1],( 					bhdr->options[oindex+2],  					bhdr->options[oindex+3],e 					bhdr->options[oindex+4],  					bhdr->options[oindex+5]); #endif
 				break; 			case 61:	/* client id	*/  #if 0 1 				printf("CLIENT ID type = %d, %d %d %d %d %d",  					bhdr->options[oindex],, 					bhdr->options[oindex+1],  					bhdr->options[oindex+2],r 					bhdr->options[oindex+3],  					bhdr->options[oindex+4],h 					bhdr->options[oindex+5]); #endif&                                 break;                         }c #if 0 %                         printf("\n");E #endif 			oindex += optlen; 			olen -= optlen;- 			/* handle even byte boundry padding     */+5 			if (pad && (oindex & 1))	/* if pad and odd addr */L 			{
 				oindex++;t 				olen--;  			} 		}  	}/ 	/* remember the server name if there is one	*/ 8 	if ((bhdr->op == BOOTREPLY)	/* if message is a reply	*/J 	&&  ((opt_overload != 2) && (opt_overload != 3)) /* no options in sname*/5 	&&  (bhdr->sname[0] != '\0'))	/* name is not null	*/  	{; 		add_name(n,LT_NAME_DHCP,bhdr->sname,strlen(bhdr->sname));  	} }r f /*'         process DECnet phase IV routing  */ voidP process_decnet_iv(int n,FRAME_HEADER *hdr,unsigned char *msg,unsigned short len) {s         unsigned char *p; 2         unsigned short dnet, now[4], msglen, hlen;         int i,dlen;R         DECNETIV_FLAGS *flags;         char name[256];          DECNETIV_EHELLO *ehmsg;          DECNETIV_RHELLO *rhmsg; $         DECNETIV_RLEVEL1_HDR *l1hdr;$         DECNETIV_RLEVEL1_SEG *l1seg;,         DECNETIV_RLEVEL1_RTGINFO *l1rtginfo;$         DECNETIV_RLEVEL2_HDR *l2hdr;$         DECNETIV_RLEVEL2_SEG *l2seg;,         DECNETIV_RLEVEL2_RTGINFO *l2rtginfo;         DECNETIV_ID router_id;(         ROUTE_DECNET routes[MAX_ROUTES];         int nroutes;  3         add_protocol_eth(n,DECNETIV_PROTOCOL_TYPE);   ,         if ((hdr->hdr_eth.source[0] == 0xAA))         &&  (hdr->hdr_eth.source[1] == 0))-         &&  (hdr->hdr_eth.source[2] == 0x04)  *         &&  (hdr->hdr_eth.source[3] == 0))	         {S*                 /* add DECnet address   */.                 dnet = hdr->hdr_eth.source[4] 5                         + hdr->hdr_eth.source[5]*256;(?                 add_address(n,LT_ADDRESS_DECNET,(char *)&dnet); 0                 strcpy(name,get_nodename(dnet));$                 if (name[0] != '\0')                 { E                         add_name(n,LT_NAME_DECNET,name,strlen(name));                  } 	         }   /         /* get the length (ethernet padding) */          memcpy(&msglen,msg,2);  2         /* skip the length                      */         msg += 2;>         len = msglen;   9         /* work out what sort of message this is       */P&         flags = (DECNETIV_FLAGS *)msg;         <         if (flags->ctrl == 1)	/* if its a control message	*/	         { $                 switch (flags->type)                 {p:                 case 0: /* initialisation message       */                         break;:                 case 1: /* verification message         */                         break;:                 case 2: /* hello and test               */                         break;:                 case 3: /*  level 1 routing message     */>                         add_attribute(n,LT_NODE_ATT_DECNETL1);<                         l1hdr = (DECNETIV_RLEVEL1_HDR *)msg;O                         memcpy(&router_id,&l1hdr->srcnode,sizeof(DECNETIV_ID));c<                         hlen = sizeof(DECNETIV_RLEVEL1_HDR);'                         p = &msg[hlen]; -                         dlen = msglen - hlen;/$                         nroutes = 0;(                         while (dlen > 2)                         { B                                 l1seg = (DECNETIV_RLEVEL1_SEG *)p;B                                 p += sizeof(DECNETIV_RLEVEL1_SEG);@                                 for (i=0; i < l1seg->count; i++)!                                 { R                                         l1rtginfo = (DECNETIV_RLEVEL1_RTGINFO *)p;N                                         p += sizeof(DECNETIV_RLEVEL1_RTGINFO);L                                         if (l1rtginfo->hops < DECNETIV_INFH))                                         {S #if 0 Q                                                 printf("%d.%d cost %d hops %d\n", G                                                         router_id.area,cJ                                                         l1seg->start_id+i,H                                                         l1rtginfo->cost,I                                                         l1rtginfo->hops);  #endifs                                                 if ((l1rtginfo->hops > 1)        /* only remember off lan nodes  */ ! 						&&  (nroutes < MAX_ROUTES)) 1                                                 {_K                                                         routes[nroutes].id  Q                                                                 = l1seg->start_id V                                                                 + router_id.area*1024;L                                                         routes[nroutes].costR                                                                 = l1rtginfo->cost;L                                                         routes[nroutes].hopsR                                                                 = l1rtginfo->hops;B                                                         nroutes++;1                                                 } )                                         } !                                 } D                                 dlen -= sizeof(DECNETIV_RLEVEL1_SEG)X                                         + l1seg->count*sizeof(DECNETIV_RLEVEL1_RTGINFO);                         }]3                         for (i=0; i < nroutes; i++)f                         {PA                                 add_route(n,LT_ROUTE_DECNET_NODE,rI                                         sizeof(ROUTE_DECNET),&routes[i]);_                         }                          break;:                 case 4: /* level 2 routing message      */>                         add_attribute(n,LT_NODE_ATT_DECNETL2);<                         l2hdr = (DECNETIV_RLEVEL2_HDR *)msg;O                         memcpy(&router_id,&l2hdr->srcnode,sizeof(DECNETIV_ID));e<                         hlen = sizeof(DECNETIV_RLEVEL2_HDR);'                         p = &msg[hlen];r-                         dlen = msglen - hlen;n$                         nroutes = 0;(                         while (dlen > 2)                         { B                                 l2seg = (DECNETIV_RLEVEL2_SEG *)p;B                                 p += sizeof(DECNETIV_RLEVEL2_SEG);@                                 for (i=0; i < l2seg->count; i++)!                                 { R                                         l2rtginfo = (DECNETIV_RLEVEL2_RTGINFO *)p;N                                         p += sizeof(DECNETIV_RLEVEL2_RTGINFO);M                                         if ((l2rtginfo->hops < DECNETIV_INFH)Y  					&&  (nroutes < MAX_ROUTES)))                                         {d #if 0dS                                                 printf("area %d cost %d hops %d\n",;L                                                         l2seg->start_area+i,H                                                         l2rtginfo->cost,I                                                         l2rtginfo->hops);; #endifC                                                 routes[nroutes].id  U                                                         = (l2seg->start_area+i)*1024;eD                                                 routes[nroutes].costJ                                                         = l2rtginfo->cost;D                                                 routes[nroutes].hopsJ                                                         = l2rtginfo->hops;:                                                 nroutes++;)                                         } !                                 }+D                                 dlen -= sizeof(DECNETIV_RLEVEL2_SEG)X                                         + l2seg->count*sizeof(DECNETIV_RLEVEL2_RTGINFO);                         }i3                         for (i=0; i < nroutes; i++)I                         { A                                 add_route(n,LT_ROUTE_DECNET_AREA,_I                                         sizeof(ROUTE_DECNET),&routes[i]);a                         }p                         break;:                 case 5: /* ethernet router hello        */7                         rhmsg = (DECNETIV_RHELLO *)msg;p2                         if (rhmsg->info.type == 2)F                                 add_attribute(n,LT_NODE_ATT_DECNETL1);8                         else if (rhmsg->info.type == 1) F                                 add_attribute(n,LT_NODE_ATT_DECNETL2);                         break;:                 case 6: /* ethernet endnode hello       */7                         ehmsg = (DECNETIV_EHELLO *)msg;                          break;                 } 	         }t }, N /*"         process NetBEUI broadcasts */ void pN process_netbuei(int n,FRAME_HEADER *hdr,unsigned char *msg,unsigned short len) {          SMB_HEADER *smbhdr;e  (         add_protocol_802(n,NETBUEI_SAP);  B         /* the format of these was obtained by inspection       */B         /* They start with  0x2c,00,ff,ef                       */B         /* then at offset 12 is a 15 byte ascii string which    */B         /* is followed by a 1 byte type                         */B         /* Att offset 28 is a 15 byte ascii string which is     */B         /* followed by a 1 byte type.                           */   #if 0 %         printf("NETBEUI announce\n");O) 	printf("First name %15.15s type 0x%x\n",r%                 &msg[12],msg[12+15]);e1         printf("Second name %15.15s type 0x%x\n",_%                 &msg[28],msg[28+15]);          if ((msg[44] == 0xff)          &&  (msg[45] == 'S')         &&  (msg[46] == 'M')         &&  (msg[47] == 'B'))r	         {,0                 smbhdr = (SMB_HEADER *)&msg[44];?                 printf("SMB command 0x%02x\n",smbhdr->Command);s	         }h #endif  1         if ((msg[0] == 0x2c) && (msg[1] == 0x00) o1         &&  (msg[2] == 0xff) && (msg[3] == 0xef))o	         {)1                 process_netbuei_name(n,&msg[12]);i1                 process_netbuei_name(n,&msg[28]); 	         }f #if 1) 	else  	{  		printf("other message from ");% 		display_addr(stdout,nodes[n].addr); , 		printf("msg[0-3] 0x%02x %02x %02x %02x\n",  			msg[0],msg[1],msg[2],msg[3]); 	} #endif }H E static voidH/ process_netbuei_name(int n,unsigned char *name)n {n         unsigned char type;I   	/* type bytes						*/P         /* 0x00    base computernames and workgroups, also in "*" queries     */P         /* 0x01    master browser, in magic \0x1\0x2__MSBROWSE__\0x2\0x1 name */P         /* 0x03    messaging/alerter service; name of logged-in user          */P         /* 0x20    resource-sharing "server service" name                     */P         /*         Master browsers use this type when annoucing names in the  */P         /*         domain (workgroup) that they know about.                   */P         /* 0x1B    domain master-browser name                                 */P         /* 0x1C    domain controller name                                     */P         /*         A master browser uses this type when annoucing the         */P         /*         domain name.                                               */P         /* 0x1D    A master browser uses this type when annoucing the         */P         /*         workgroup name.                                            */P         /* 0x1E    workgroup master browser election announcement [?]         */P         /*         Used on workgroup name                                     */,         if (isalpha(*name) && (*name < 127))	         {y                  type = name[15];                 switch(type)                 {                  case 0x01:@                         add_attribute(n,LT_NODE_ATT_MSTBROWSER);                         break;                 case 0x1c:                 case 0x1d::                         /* master browser announcement  */G                         add_name(n,LT_NAME_WORKGROUP,(char *)name,16);  @                         add_attribute(n,LT_NODE_ATT_MSTBROWSER);                         break;                 case 0x1e:2                         /* browser announcement */G                         add_name(n,LT_NAME_WORKGROUP,(char *)name,16); p                         break;                 default:E                         add_name(n,LT_NAME_NETBUEI,(char *)name,16);                   }d	         }T }U I /*+         process IPX (802 format) broadcasts  */ void iJ process_ipx(int n,FRAME_HEADER *hdr,unsigned char *msg,unsigned short len) {          IPX_HEADER  *ipxhdr;         unsigned short dlen;  $         add_protocol_802(n,IPX_SAP);#         ipxhdr = (IPX_HEADER *)msg; (         if (ipxhdr->ipx_source.net != 0)J                 add_address(n,LT_ADDRESS_IPX,(char *)&ipxhdr->ipx_source);  :         /* skip message header and get data length      */"         msg += sizeof(IPX_HEADER);@         dlen = bswap2(ipxhdr->ipx_pktsize) - sizeof(IPX_HEADER);          switch(ipxhdr->ipx_type)	         {          case IPX_TYPE_UNKNOWN:         default:-                 switch(ipxhdr->ipx_dest.sock)2                 {pJ                 case IPX_SOCK_NCP:      /* NetWare Core Protocol        */                         break;J                 case IPX_SOCK_SAP:      /* Service Advertising Packet   */;                         process_ipx_sap(n,ipxhdr,msg,dlen);                          break;J                 case IPX_SOCK_RIP:      /* Routing Information Packet   */;                         process_ipx_rip(n,ipxhdr,msg,dlen);I                         break;J                 case IPX_SOCK_NETBIOS:  /* Novell NetBIOS process       */                         break;                 case 0x5204:I                         /* these appear to be some sort of advertisment*/;A                         if ((msg[0] == 0x00) && (msg[1] == 0x02)  -                         &&  (msg[2] == 0x03))p                         { B                                 /* these appear to be printers  */L                                 add_name(n,LT_NAME_NOVELLP,(char *)&msg[20],C                                         strlen((char *)&msg[20])); m #if 0 :                                 printf("Novell printer ");;                                 display_ipx_address(stdout, N                                         (unsigned char *)&ipxhdr->ipx_source);>                                 printf(" name %s\n",&msg[23]); #endif                         }                          elseA                         if ((msg[0] == 0x00) && (msg[1] == 0x02) n-                         &&  (msg[2] == 0x02))t                         {d #if 0tC                                 /* these appear from fileservers */dH                                 printf("ipx type 0x%x, sock 0x%x from ",P                                         ipxhdr->ipx_type,ipxhdr->ipx_dest.sock);;                                 display_ipx_address(stdout, N                                         (unsigned char *)&ipxhdr->ipx_source);-                                 printf("\n"); M                                 printf("name %32.32s len %d\n",&msg[4],dlen);; #endif                         }a                         elseA                         if ((msg[0] == 0x00) && (msg[1] == 0x02) ;-                         &&  (msg[2] == 0x08))                          {; #if 0 C                                 /* these appear from fileservers */"H                                 printf("ipx type 0x%x, sock 0x%x from ",P                                         ipxhdr->ipx_type,ipxhdr->ipx_dest.sock);;                                 display_ipx_address(stdout, N                                         (unsigned char *)&ipxhdr->ipx_source);-                                 printf("\n"); H                                 printf("name %s len %d\n",&msg[7],dlen); #endif                         }                          else                         {s #if 0pH                                 printf("ipx type 0x%x, sock 0x%x from ",P                                         ipxhdr->ipx_type,ipxhdr->ipx_dest.sock);;                                 display_ipx_address(stdout, N                                         (unsigned char *)&ipxhdr->ipx_source);9                                 printf(" len %d\n",dlen);(-                                 printf("\n"); @                                 printf("msg[0] = %d,%d,%d,%d\n",E                                         msg[0],msg[1],msg[2],msg[3]);  #endif                         }                          break; #if 0                  default:@                         printf("ipx type 0x%x, sock 0x%x from ",H                                 ipxhdr->ipx_type,ipxhdr->ipx_dest.sock);3                         display_ipx_address(stdout, F                                 (unsigned char *)&ipxhdr->ipx_source);%                         printf("\n");  #endif                 }-                 break;?         case IPX_TYPE_RIP:   /* Routing Information Packet   */ 3                 process_ipx_rip(n,ipxhdr,msg,dlen);                  break;?         case IPX_TYPE_SAP:   /* Service Advertising Packet   */ 3                 process_ipx_sap(n,ipxhdr,msg,dlen);                  break;?         case IPX_TYPE_SPX:   /* Sequenced Packed eXchange    */n                 break;?         case IPX_TYPE_NCP:   /* NetWare Core Protocol        */                  break;?         case IPX_TYPE_PPROP: /* propagated packet (NetBIOS)  */  		if (ipxhdr->ipx_tctrl != 0)2 		{ ' 	                printf("PPROP from ");nR 	                display_ipx_address(stdout,(unsigned char *)&ipxhdr->ipx_source);@ 	                printf(" with tctrl = %d\n",ipxhdr->ipx_tctrl); 		}(                 break;	         }N }_ EP static void process_ipx_rip(int n,IPX_HEADER *ipxhdr,unsigned char *data,                unsigned short len)t {,         IPX_RIP_MESSAGE *irmsg;          int i,netcount;;'         unsigned short operation, rlen;          (         irmsg = (IPX_RIP_MESSAGE *)data;-         operation = bswap2(irmsg->operation);E #if 0 ;         printf("IPX RIP operation %d (%s) from ",operation,t[ 		(operation==IPX_RIP_OP_REQUEST)?"REQ":((operation==IPX_RIP_OP_RESPONSE)?"RESP/ANN":"?"));dI         display_ipx_address(stdout,(unsigned char *)&ipxhdr->ipx_source);e         printf("\n");  #endif-         if (operation != IPX_RIP_OP_RESPONSE) :                 return; /* nothing more to do with this */         *         /* sanity check message len     */(         if (len < sizeof(IPX_RIP_ENTRY))	         {iN                 printf("%%LISTEN-E-INVIPXRIP, invalid IPX RIP message len\n");                 return; 	         }=J         netcount = (len - sizeof(irmsg->operation))/sizeof(IPX_RIP_ENTRY);@         if ((netcount < 1) || (netcount > IPX_RIP_MAX_NETWORKS))	         {eN                 printf("%%LISTEN-E-INVIPXRIP, invalid IPX RIP message len\n");                 return; 	         }   /         add_attribute(n,LT_NODE_ATT_IPXROUTER);   "         /* process RIP entries  */         rlen = 0; $         for (i=0; i < netcount; i++)	         { 0                 bswap(&irmsg->networks[i].hops);1                 bswap(&irmsg->networks[i].ticks); 3                 if ((irmsg->networks[i].hops != 0) f4                 &&  (irmsg->networks[i].ticks != 0))                 {  #if 0 C                         printf("  network 0x%x hops %d ticks %d\n", C                                 bswap4(irmsg->networks[i].network), 8                                 irmsg->networks[i].hops,:                                 irmsg->networks[i].ticks); #endif6                         rlen += sizeof(IPX_RIP_ENTRY);                 }                  else                         break;	         }n         if (rlen > 0)n?                 add_route(n,LT_ROUTE_IPX,rlen,irmsg->networks);  }    static fB void process_ipx_sap(int n,IPX_HEADER *ipxhdr,unsigned char *data,         unsigned short len)  {B          IPX_SAP_MESSAGE *sapmsg;&         unsigned short operation,type;"         int nservices, i, namelen;         SERVICE_SAP serv;   )         sapmsg = (IPX_SAP_MESSAGE *)data; N         if (len < (sizeof(sapmsg->operation)+sizeof(sapmsg->entries[0].type)))	         {aP                 printf("%%LISTEN-E-DUFSAP, duff sap message - length %d\n",len);	         }a  6         operation = bswap2(sapmsg->operation);        .         if ((operation == IPX_SAP_OP_REQUEST) 1         || (operation == IPX_SAP_OP_GNS_REQUEST))N	         {  #if 0f4                 printf("SAP service request from ");Q                 display_ipx_address(stdout,(unsigned char *)&ipxhdr->ipx_source); 4                 printf(" for service type 0x%02x\n",9                         bswap2(sapmsg->entries[0].type));  #endif                 return; 	         }l/         if ((operation != IPX_SAP_OP_RESPONSE)  3         &&  (operation != IPX_SAP_OP_GNS_RESPONSE))+	         {  #if 0 4                 printf("SAP service request from ");Q                 display_ipx_address(stdout,(unsigned char *)&ipxhdr->ipx_source);=<                 printf(" for operation 0x%02x\n",operation); #endif                 return; 	         } 2         /* determine number of service entries  */L         nservices = (len - sizeof(sapmsg->operation))/sizeof(IPX_SAP_ENTRY); #if 0r-         printf("SAP service response from "); I         display_ipx_address(stdout,(unsigned char *)&ipxhdr->ipx_source);hE         printf(" for %d service%c\n",nservices,nservices==1?' ':'s');  #endifI         if ((nservices < 1) || (nservices > IPX_SAP_MAX_SERVICE_ENTRIES))\	         { U                 printf("%%LISTEN-E-DUFSAPN, duff number of services %d\n",nservices);                  return ;	         } '         for (i = 0; i < nservices; i++) 	         { 7                 type = bswap2(sapmsg->entries[i].type); : 		if ((type == 0) || (sapmsg->entries[i].name[0] == '\0')) 			break;	/* duff enttry	*/ D 		sapmsg->entries[i].name[sizeof(sapmsg->entries[i].name)-1] = '\0'; #if 0 =                 printf("service type 0x%04x name %s server ", 6                         type,sapmsg->entries[i].name);Y                 display_ipx_address(stdout,(unsigned char *)&sapmsg->entries[i].network); O                 printf(" socket = 0x%02x\n",bswap2(sapmsg->entries[i].socket));  #endif:                 namelen = strlen(sapmsg->entries[i].name);:                 serv.network = sapmsg->entries[i].network;!                 serv.type = type; L                 memcpy(serv.addr,sapmsg->entries[i].addr,sizeof(serv.addr));@                 serv.socket = bswap2(sapmsg->entries[i].socket);E                 add_service(n,LT_SERVICE_SAP,sapmsg->entries[i].name, 4                         namelen,&serv,sizeof(serv));	         }h }> o /*=         process LAVC (VMS cluster over ethernet) annoucementsr */ void sK process_lavc(int n,FRAME_HEADER *hdr,unsigned char *msg,unsigned short len)  { '         unsigned short msglen,dnet,gno;          char name[256];2 	LAVC_ANNOUNCEMENT *lmsg;   /         add_protocol_eth(n,LAVC_PROTOCOL_TYPE);   ,         if ((hdr->hdr_eth.source[0] == 0xAA))         &&  (hdr->hdr_eth.source[1] == 0)_-         &&  (hdr->hdr_eth.source[2] == 0x04)  *         &&  (hdr->hdr_eth.source[3] == 0))	         { *                 /* add DECnet address   */.                 dnet = hdr->hdr_eth.source[4] 5                         + hdr->hdr_eth.source[5]*256;l?                 add_address(n,LT_ADDRESS_DECNET,(char *)&dnet);l0                 strcpy(name,get_nodename(dnet));$                 if (name[0] != '\0')                 { E                         add_name(n,LT_NAME_DECNET,name,strlen(name));T                 }O	         } /         /* get the length (ethernet padding) */;         memcpy(&msglen,msg,2);  2         /* skip the length                      */         msg += 2;c         len = msglen;)  ! 	lmsg = (LAVC_ANNOUNCEMENT *)msg;>:         add_address(n,LT_ADDRESS_LAVC,(char *)&lmsg->gno); }R E void  O process_802_misc(int n,FRAME_HEADER *hdr,unsigned char *msg,unsigned short len)( {e.         add_protocol_802(n,hdr->hdr_802.dsap); }    void &O process_eth_misc(int n,FRAME_HEADER *hdr,unsigned char *msg,unsigned short len)  { /         add_protocol_eth(n,hdr->hdr_eth.ptype);e }^ M /*C         process IPX messages where the IEEE 802.2 header is missingT */U void process_ipx_802_3(int n,FRAME_HEADER *hdr,unsigned char *msg,unsigned short len)  {e         FRAME_HEADER newhdr;+         unsigned char newmsg[NODE_BUFSIZE];   -         add_attribute(n,LT_NODE_ATT_IPX8023);   2         /* construct a proper IEEE 802.2 header */9         memcpy(newhdr.hdr_802.source,hdr->hdr_802.source,d! 		sizeof(newhdr.hdr_802.source)); C         memcpy(newhdr.hdr_802.destination,hdr->hdr_802.destination,O& 		sizeof(newhdr.hdr_802.destination));&         newhdr.hdr_802.dsap = IPX_SAP;&         newhdr.hdr_802.ssap = IPX_SAP;"         newhdr.hdr_802.ctl[0] = 3;"         newhdr.hdr_802.ctl[1] = 0;  &         newmsg[0] = hdr->hdr_802.dsap;&         newmsg[1] = hdr->hdr_802.ssap;(         newmsg[2] = hdr->hdr_802.ctl[0];(         newmsg[3] = hdr->hdr_802.ctl[1];.         memcpy(&newmsg[4],msg,NODE_BUFSIZE-4);  ,         process_ipx(n,&newhdr,newmsg,len+4); }A   void nQ process_802_bridge(int n,FRAME_HEADER *hdr,unsigned char *msg,unsigned short len)  { .         add_protocol_802(n,hdr->hdr_802.dsap);,         add_attribute(n,LT_NODE_ATT_BRIDGE); }  r* /* process LAT service annoucements     */ void oM process_lat(int n,FRAME_HEADER *hdr,unsigned char *msg,unsigned short msglen)l {i          LAT_SERVICE_HDR *lathdr;<         char *name, *desc, len, namelen, desclen, nservices;         unsigned char *msgptr;  /         add_protocol_eth(n,hdr->hdr_eth.ptype);;  (         lathdr = (LAT_SERVICE_HDR *)msg;  7         if (lathdr->msg_type.type == LAT_C_SERVICE_MSG)r	         {w7                 msgptr = msg + sizeof(LAT_SERVICE_HDR);	2                 msglen -= sizeof(LAT_SERVICE_HDR);                   if (msglen > 0)d!                 {                e:                         /* skip service group bitmask   */)                         len  = *msgptr++;c&                         msgptr += len;&                         msglen -= len;                 }e                 if (msglen > 0)l                 {(:                         /* node name                    */,                         namelen = *msgptr++;.                         name = (char *)msgptr;*                         msgptr += namelen;*                         msglen -= namelen;(                         if (namelen > 0)J                                 add_name(n,LT_NAME_LAT_NODE,name,namelen);                 }                  if (msglen > 0)p                 {n2                         /* node description     */,                         desclen = *msgptr++;.                         desc = (char *)msgptr;*                         msgptr += desclen;*                         msglen -= desclen;(                         if (desclen > 0)J                                 add_name(n,LT_NAME_LAT_DESC,desc,desclen);                 }W                 if (msglen > 0)                  {u2                         /* service annoucements */.                         nservices = *msgptr++;!                         msglen--;o?                         while ((nservices > 0) && (msglen > 0))                          {W:                                 /* skip service rating  */*                                 *msgptr++;)                                 msglen--; :                                 /* service name         */4                                 namelen = *msgptr++;)                                 msglen--;_6                                 name = (char *)msgptr;2                                 msgptr += namelen;2                                 msglen -= namelen;:                                 /* service description  */4                                 desclen = *msgptr++;)                                 msglen--; 6                                 desc = (char *)msgptr;2                                 msgptr += desclen;2                                 msglen -= desclen;0                                 if (namelen > 0)!                                 {mJ                                         add_service(n,LT_SERVICE_LAT,name,F                                                 namelen,desc,desclen);!                                 } ,                                 nservices--;                         }d                 };	         }i }d s" /* Local Area System Transport  */ void oK process_last(int n,FRAME_HEADER *hdr,unsigned char *msg,unsigned short len)p {i 	unsigned short msglen;;         LAST_HDR *lasthdr;  /         add_protocol_eth(n,LAST_PROTOCOL_TYPE);>  /         /* get the length (ethernet padding) */          memcpy(&msglen,msg,2);  2         /* skip the length                      */         msg += 2;          len = msglen;   "         lasthdr = (LAST_HDR *)msg;  2         /* validate message                     */  0         if (lasthdr->type == LAST_TYPE_SERV_ANN)	         {n:                 /* get the node name                    */H                 add_name(n,LT_NAME_LAST,lasthdr->name,lasthdr->namelen);9                 add_attribute(n,LT_NODE_ATT_LAST_SERVER); 	         } 5         else if (lasthdr->type == LAST_TYPE_SERV_REQ) 	         {}:                 /* get the node name                    */H                 add_name(n,LT_NAME_LAST,lasthdr->name,lasthdr->namelen);9                 add_attribute(n,LT_NODE_ATT_LAST_CLIENT); 	         }  	else  	{1 		printf("LAST type 0x%04x from ",lasthdr->type); + 		display_addr(stdout,hdr->hdr_eth.source);  		printf("\n");n 	} }t