 /*         LIST_SUBS.C            Misc routines.    COPYRIGHT NOTICE   5  This software is COPYRIGHT  1997,2005, Ian Miller.    3  Released under licence described in aaareadme.txt      DISCLAIMER   J  This software is provided "AS IS". The author makes no representations orN  warranties with respect to the software and specifically disclaim any impliedE  warranties of merchantability or fitness for any particular purpose.    History	 =======   ( 04-FEB-1997 I.Miller  V1.0      Created 6 11-Apr-1997 I.Miller  V1.0-001  Add display_lavc_groupB 04-Jul-2005 I.Miller  V1.0-002	Tidy code a little for new compiler */   #define VERSION "V1.0-002"
 #if __DECC" #pragma module LISTEN_SUBS VERSION #else  #module LISTEN_SUBS VERSION  #endif   #include <stdio.h> #include <stdlib.h>  #include <string.h>  #include <ctype.h> #include "messages.h"  #include "listen_table.h"  #include "listen_subs.h"  G /* if IP_NAMES is defined non-zero then get_ip_name calls gethostbyaddr F 	to get the name correspoding to a IP address. This means this program' 	must be linked with the TCP/IP library 9 		TCP/IP Services for OpenVMS VAX	SYS$LIBRARY:UCX$IPC.OLB = 		TCP/IP Services for OpenVMS Alpha SYS$SHARE:UCX$IPC_SHR.EXE 3 	Define this to be 0 if you have no TCP/IP library.  */ #ifndef IP_NAMES #define IP_NAMES 0 #endif #if IP_NAMES #include <netdb.h> #endif    N /* if USE_NETACP is defined non-zero then get_nodename will attempt to use theG 	famous undocumented NETACP QIO interface to translate DECnet addresses 
 	to names. */ #define USE_NETACP 1   #if USE_NETACP" #define NFB_MAX_FIELD_ID_ENTRIES 5 #include "nfbdef.h"  #include <starlet.h> #include <descrip.h> #include <iodef.h> #endif  3 #define LINELEN 80	/* max rec len in output file	*/    void- display_addr(FILE *fpOut,unsigned char *addr)  { 6         fprintf(fpOut,"%02X-%02X-%02X-%02X-%02X-%02X",A                 addr[0],addr[1],addr[2],addr[3],addr[4],addr[5]);  }    /*  D         get_nodename - given DECnet address ask NETACP for nodename.  F         Uses famous undocumented NETACP QIO interface (DECnet IV only) */ char *  get_nodename(unsigned short add) {  #if USE_NETACP   static struct nfbdef nfb  K                 = {	NFB$C_FC_SHOW, NFB$M_NOCTX, NFB$C_DB_NDI, NFB$C_OP_EQL, * 			NFB$C_NDI_ADD, NFB$C_WILDCARD, 0, 0, 0,$ 			NFB$C_NDI_NNA, NFB$C_ENDOFLIST };K   static struct dsc$descriptor nfbdesc = {sizeof(nfb), 0, 0, (char *)&nfb};    static struct { E     long int p4_count; /* is that what this is? I don't know (why) */ 
     long add;    } key = {0,0};K   static struct dsc$descriptor keydesc = {sizeof(key), 0, 0, (char *)&key};    static struct    {      short len;     char name[6]; 
   } nodename; U   static struct dsc$descriptor bufdesc = {sizeof(nodename), 0, 0, (char *)&nodename}; $   int status, iosb[2], i, j, retlen;!   static $DESCRIPTOR(Net,"Net:"); $   static unsigned short netchan = 0;   static char result[7];      result[0] = '\0';      key.add = add;     if (netchan == 0)    { /     status = sys$assign (&Net, &netchan, 0, 0);    }	     if (netchan != 0)    { ;       status = sys$qiow (0,netchan,IO$_ACPCONTROL,iosb,0,0, 0 	       &nfbdesc,&keydesc,&retlen,&bufdesc,0,0);   	        if (status & 1)        { + 	memcpy(result,nodename.name,nodename.len); $         result[nodename.len] = '\0';       }    }      return result; #else    return ""; #endif }    voidC display_lwords(FILE *fpOut,unsigned char *data, unsigned short len)  {  	unsigned char *p;  1 	for (p = &data[len-4]; len > 0; len -= 4,p -= 4)  	{# 		fprintf(fpOut,"%02x%02x%02x%02x",  			p[3],p[2],p[1],p[0]); 		fputc(' ',fpOut);  	} }    voidB display_bytes(FILE *fpOut,unsigned char *data, unsigned short len) {  	int i;   
 	if (len > 0)  	{ 		for (i = 0; i < len; i++)  		{ - 			if ((isprint(data[i])) && (data[i] < 127)) " 				fprintf(fpOut,"%c  ",data[i]); 			else  				fprintf(fpOut,".  "); , 			if ((i != 0) && ((i % (LINELEN/3)) == 0)) 				fputc('\n',fpOut); 		}  		fputc('\n',fpOut); 		for (i=0; i < len; i++)  		{ " 			fprintf(fpOut,"%02x ",data[i]);, 			if ((i != 0) && ((i % (LINELEN/3)) == 0)) 				fputc('\n',fpOut); 		}  		fputc('\n',fpOut); 	} }    char *
 curtime(void)  {  	static char timestr[30]; " 	$DESCRIPTOR(timestr_dsc,timestr); 	unsigned short tlen;  	unsigned long ccode;  	 , 	ccode = sys$asctim(&tlen,&timestr_dsc,0,1); 	if (ccode & 1)  		timestr[tlen] = '\0';  	else  		timestr[0] = '\0';   	return timestr; }    void6 display_dnet_address(FILE *fpOut,unsigned short *dnet) { . 	fprintf(fpOut,"%d.%d",*dnet/1024,*dnet%1024); }    void1 display_ip_address(FILE *fpOut,unsigned char *ip)  { 6 	fprintf(fpOut,"%d.%d.%d.%d",ip[0],ip[1],ip[2],ip[3]); }    void3 display_ipx_address(FILE *fpOut,unsigned char *ptr)  {          IPX_ADDRESS *addr;         "         addr = (IPX_ADDRESS *)ptr;  ;         fprintf(fpOut,"%08x:%02x-%02x-%02x-%02x-%02x-%02x", >                 bswap4(addr->net),addr->node[0],addr->node[1],:                 addr->node[2],addr->node[3],addr->node[4],                 addr->node[5]);  }    void  , display_man(FILE *fpOut,unsigned char *addr) {          static const struct 	         { "                 unsigned long oui;J                 char *name1;    /* short name. not more than 8 chars    */J                 char *name2;    /* longer name                          */	         }          mtable[] =  ,     {{ 0x00000C, "Cisco", "Cisco Systems" },5     { 0x00000D, "Fibronics", "Fibronics Ltd,Israel"},      { 0x00000E, "Fujitsu", 0 },      { 0x00000F, "NeXT", 0 },1     { 0x000010, "Hughes", "Hughes LAN Systems" }, !     { 0x000011, "Tektronix", 0 }, !     { 0x000015, "Datapoint", 0 }, !     { 0x000018, "Multigate", 0 }, 3     { 0x00001A, "AMD", "Advanced Micro Devices?" },      { 0x00001B, "Novell", 0 },!     { 0x00001D, "Cabletron", 0 }, 2     { 0x000020, "D.I. AB", "Data Industrier AB" },     { 0x000021, "SC&C", 0 },0     { 0x000022, "Visual", "Visual Technology" },;     { 0x000023, "ABB","ABB Industrial Systems AB,Sweeden"},      { 0x000029, "IMC", 0 },      { 0x00002A, "TRW", 0 }, ;     { 0x000031, "QPSX", "QPSX Communications Pty Ltd,AU" }, 4     { 0x000037, "OxMetrics", "Oxford Metrics Ltd" },-     { 0x00003C, "Auspex", "Auspex Systems" },      { 0x00003D, "AT&T", 0 },-     { 0x00003F, "Syntrex", "Syntrex, Inc." },       { 0x000044, "Castelle", 0 },7     { 0x000046, "Olivetti", "Olivetti North America" }, 6     { 0x000049, "Apricot", "Apricot Computers, Ltd" },4     { 0x00004B, "APT", "APT Appletalk WAN router" },      { 0x00004C, "NEC Corp", 0 },7     { 0x00004F, "Logicraft", "Logicraft PC Emulator" }, ,     { 0x000050, "Radisys", "Radisys Corp" },7     { 0x000051, "Hob", "Hob Electronic GMBH & Co KG" }, 0     { 0x000052, "ODS", "Optical Data Systems" },     { 0x000055, "AT&T", 0 },;     { 0x000058, "Racore", "Racore Computer Products Inc" }, 7     { 0x00005A, "S&K", "Schneider & Koch/Syskonnect" },      { 0x00005D, "RGE", 0 }, :     { 0x00005E, "USC", "USC Information Sciences Inst." },<     { 0x00005F, "Sumitomo", "Sumitomo Electric Ind., Ltd" },6     { 0x000061, "Gateway", "Gateway Communications" },!     { 0x000062, "Honeywell", 0 }, ?     { 0x000064, "Yokogawa", "Yokogawa Digital Computer Corp" }, 3     { 0x000065, "NetGen", "Network General Corp" }, 2     { 0x000068, "Rosemont", "Rosemont Controls" },8     { 0x000069, "DTQNA", "Concord Comm Inc (for DEC)" },+     { 0x00006B, "MIPS", "MIPS (now SGI)" }, <     { 0x00006D, "CrayCommLtd", "Cray Communications, Ltd" },.     { 0x00006E, "Artisoft", "Artisoft, Inc" },0     { 0x00006F, "Madge", "Madge Networks Ltd" },/     { 0x000074, "Ricoh", "Ricoh Company Ltd" }, .     { 0x000077, "M/I?", "MIPS?/Interphase?" },-     { 0x000079, "Networth", "Networth Inc" },      { 0x00007A, "Ardent", 0 },1     { 0x00007B, "ResMach", "Research Machines" }, ?     { 0x00007D, "CrayRes", "Cray Research Superservers, Inc" }, 1     { 0x00007F, "Linotype", "Linotype-Hell AG" }, :     { 0x000080, "CrayCommAS", "Cray Communications A/S" },      { 0x000081, "Synoptic", 0 },9     { 0x000084, "Aquila?", "Aquila?, ADI Systems Inc?" },       { 0x000086, "Gateway?", 0 },     { 0x000089, "Cayman", 0 },!     { 0x00008E, "Solbourne", 0 },      { 0x000093, "Proteon", 0 }, 2     { 0x000094, "Asante", "Asante Technologies" },      { 0x00009F, "Amerstar", 0 },     { 0x0000A0, "Sanyo", 0 }, !     { 0x0000A2, "Wellfleet", 0 }, A     { 0x0000A3, "NetAppTech", "Network Application Technology" }, 1     { 0x0000A4, "Acorn", "Acorn Computers Ltd" }, /     { 0x0000A6, "NetGenl", "Network General" }, 5     { 0x0000A7, "NCD", "Network Computing Devices" }, 7     { 0x0000A9, "NetSysCorp", "Network Systems Corp" }, "     { 0x0000AA, "Xerox Corp", 0 },     { 0x0000AB, "LMS", 0 }, 4     { 0x0000AC, "H-P", "Hewlett-Packard (Apollo)" },/     { 0x0000B0, "RAD", "RAD Network Devices" },      { 0x0000B3, "CIMLinc", 0 },      { 0x0000B5, "Vista", 0 }, /     { 0x0000B7, "Dove", "Dove Computer Corp" },      { 0x0000BB, "TriData", 0 }, 5     { 0x0000BC, "AlnBrdly", "Allen-Bradley Co Inc" }, 6     { 0x0000C0, "SMC", "Standard Microsystems Corp" },     { 0x0000C3, "Harris", 0 },>     { 0x0000C6, "HPINO","HP Intelligent Networks Operation" },     { 0x0000C8, "Altos", 0 },      { 0x0000C9, "Emulex", 0 },     { 0x0000D1, "Adaptec", 0 },      { 0x0000D3, "Wang", 0 },3     { 0x0000D7, "Dartmouth", "Dartmouth College" }, 0     { 0x0000D8, "PS/2?", "3Com? Novell? PS/2" },     { 0x0000DD, "Gould", 0 },       { 0x0000DE, "Unigraph", 0 },     { 0x0000E2, "Acer", 0 },5     { 0x0000E8, "Accton", "Accton Technology Corp" },      { 0x0000EF, "Alantec", 0 },      { 0x0000F0, "Samsung", 0 }, 8     { 0x0000F2, "SpiderComm", "Spider Communications" },'     { 0x0000F3, "GANDALF?","GANDALF?"}, 2     { 0x0000F8, "DEC", "Digital Equipment Corp" },3     { 0x0000FD, "HighLev", "High Level Hardware" }, 5     { 0x000102, "BBN", "Bolt, Beranek, and Newman" },      { 0x00011B, "NPI", 0 }, 5     { 0x0001C8, "ThosConrad", "Thomas Conrad Corp" },      { 0x001700, "Kabel", 0 }, &     { 0x0020af, "3Com", "3Com Corp" },+     { 0x004010, "Sonic", "Sonic Systems" },      { 0x004027, "Sigma?", 0 },:     { 0x004095, 0, "R.P.T. Intergroups Int'L Ltd,Taiwan"},5     { 0x0040AF, "SpiderSys", "Spider Systems Ltd?" }, 3     { 0x0040C8, "Milan", "Milan Technology Corp" }, &     { 0x00608C, "3Com", "3Com Corp" },8     { 0x008000, "Multitech", "Multitech Systems, Inc" },!     { 0x008010, "Commodore", 0 }, 3     { 0x008015, "SeikoSys", "Seiko Systems, Inc" }, /     { 0x008016, "W&G", "Wandel & Goltermann" }, 7     { 0x008019, "Dayna", "Dayna Communications, Inc" }, 7     { 0x008029, "Microdyne", "Microdyne Corporation" }, .     { 0x00802D, "Xylogics", "Xylogics, Inc" },"     { 0x008034, "SMT-Goupil", 0 },      { 0x008051, "Fibermux", 0 },     { 0x008052, "TE", 0 },      { 0x00807d, "Equinox?", 0 },     { 0x008087, "Okidata", 0 }, ?     { 0x00808C, "FrontSoft", "Frontier Software Development" }, 0     { 0x0080A1, "Microtest", "Microtest, Inc" },!     { 0x0080A3, "Lantronix", 0 }, "     { 0x0080A9, "Clearpoint", 0 },     { 0x0080B2, "NET", 0 }, 2     { 0x0080C2, "IEEE802", "IEEE 802 Committee" },     { 0x0080C7, "Xircom", 0 },     { 0x0080C8, "D-Link", 0 },     { 0x0080D3, "Shiva", 0 },       { 0x0080D6, "NuvoLink", 0 },&     { 0x00A024, "3Com", "3Com Corp" },&     { 0x00A025, "3Com", "3Com Corp" },0     { 0x00A040, "Apple", "Apple Computer Inc" },(     { 0x00A0C9, "Intel", "Intel Corp."},(     { 0x00AA00, "Intel", "Intel Corp."},;     { 0x00C002, "Sercomm", "Sercomm Corp.,Taiwan"},         :     { 0x00C025, "Dataprod", "Dataproducts Corp.,CA,USA" },6     { 0x00C06C, "SVEC","SVEC Computer Corp.,Taiwan" },*     { 0x00DD00, "U/B", "Ungermann-Bass" },*     { 0x00DD01, "U/B", "Ungermann-Bass" },*     { 0x00DD02, "U/B", "Ungermann-Bass" },*     { 0x00DD03, "U/B", "Ungermann-Bass" },*     { 0x00DD04, "U/B", "Ungermann-Bass" },*     { 0x00DD05, "U/B", "Ungermann-Bass" },*     { 0x00DD06, "U/B", "Ungermann-Bass" },*     { 0x00DD07, "U/B", "Ungermann-Bass" },*     { 0x00DD08, "U/B", "Ungermann-Bass" },*     { 0x00DD09, "U/B", "Ungermann-Bass" },*     { 0x00DD0A, "U/B", "Ungermann-Bass" },*     { 0x00DD0B, "U/B", "Ungermann-Bass" },*     { 0x00DD0C, "U/B", "Ungermann-Bass" },*     { 0x00DD0D, "U/B", "Ungermann-Bass" },*     { 0x00DD0E, "U/B", "Ungermann-Bass" },*     { 0x00DD0F, "U/B", "Ungermann-Bass" },5     { 0x020406, "BBN", "Bolt, Beranek, and Newman" }, +     { 0x020701, "RACAL", "RACAL-Datacom" },       { 0x026086, "Satelcom", 0 },&     { 0x02608C, "3Com", "3Com Corp" },     { 0x02CF1F, "CMC", 0 }, &     { 0x080002, "3Com", "3Com Corp" },<     { 0x080003, "ACC", "Advanced Computer Communications" },!     { 0x080005, "Symbolics", 0 }, 0     { 0x080007, "Apple", "Apple Computer Inc" },5     { 0x080008, "BBN", "Bolt, Beranek, and Newman" }, *     { 0x080009, "HP", "Hewlett Packard" },-     { 0x08000A, "Nestar", "Nestar Systems" }, *     { 0x08000B, "Unisys", "Unisys Corp" },7     { 0x08000D, "ICL", "Inetnational Computers, Ltd" },      { 0x08000E, "NCR", 0 },      { 0x080010, "AT&T", 0 },0     { 0x080011, "Tektronix", "Tektronix, Inc" },     { 0x080014, "Excelan", 0 }, =     { 0x080017, "NatlSemi", "National Semiconductor Corp." }, ,     { 0x08001A, "DataGen", "Data General" },,     { 0x08001B, "DataGen", "Data General" },1     { 0x08001E, "HP", "Hewlett Packard/Apollo" }, (     { 0x08001F, "Sharp", "Sharp Corp" },,     { 0x080020, "Sun", "Sun Microsystems" },     { 0x080022, "NBI", 0 }, 3     { 0x080023, "Matsushita", "Matsushita Denso" }, -     { 0x080025, "CDC", "Control Data Corp" }, (     { 0x080026, "Norsk", "Norsk Data" },9     { 0x080027, "PCSGmbh", "PCS Computer Systems GmbH" }, ,     { 0x080028, "TI", "Texas Instruments" },2     { 0x08002B, "DEC", "Digital Equipment Corp" },      { 0x08002E, "Metaphor", 0 },,     { 0x08002F, "Prime", "Prime Computer" },"     { 0x080036, "Intergraph", 0 },     { 0x080037, "Fujitsu", 0 },      { 0x080038, "Bull", 0 },4     { 0x080039, "SpiderSys", "Spider Systems Ltd" },      { 0x08003E, "Motorola", 0 },=     { 0x080041, "DCA", "Digital Communications Associates" }, 0     { 0x080045, "Xylogics?", "Xylogics, Inc?" },     { 0x080046, "Sony", 0 },     { 0x080047, "Sequent", 0 }, "     { 0x080049, "Univationn", 0 },     { 0x08004C, "Encore", 0 },     { 0x08004E, "BICC", 0 },!     { 0x080051, "Experdata", 0 }, 4     { 0x080056, "Stanford", "Stanford University" },-     { 0x080058, "DEC20?", "Digital DEC20?" }, @     { 0x08005A, "IBM", "International Business Machines Corp" },      { 0x080067, "Comdesign",0 },     { 0x080068, "Ridge", 0 }, 0     { 0x080069, "SGI", "Silicon Graphics Inc" },     { 0x08006A, "AT&T", 0 },     { 0x08006E, "Excelan", 0 }, "     { 0x080070, "Mitsubishi", 0 },3     { 0x080074, "Casio", "Casio Computer Co Ltd" }, 6     { 0x080075, "DDE", "Danish Data Elektronik A/S" },     { 0x080077, "Retix", 0 },       { 0x08007C, "Vitalink", 0 },     { 0x080080, "XIOS", 0 },7     { 0x080081, "Crosfield", "Crosfield Electronics" }, -     { 0x080083, "SeikoDen", "Seiko Denshi" }, "     { 0x080086, "Imagen/QMS", 0 },     { 0x080087, "Xyplex", 0 },      { 0x080089, "Kinetics", 0 },     { 0x08008B, "Pyramid", 0 },       { 0x08008D, "XyVision", 0 },     { 0x08008E, "Jupiter", 0 },      { 0x080090, "Retix", 0 }, @     { 0x10005A, "IBM", "International Business Machines Corp" },4     { 0x484453, "HDS?", "Human Designed Systems?" },     { 0x800007, "Apple?", 0 },2     { 0xAA0000, "DEC", "Digital Equipment Corp" },2     { 0xAA0001, "DEC", "Digital Equipment Corp" },2     { 0xAA0002, "DEC", "Digital Equipment Corp" },2     { 0xAA0003, "DEC", "Digital Equipment Corp" },%     { 0xAA0004, "DECnet", "DECnet" }, 8     { 0xCE0000, "Loopback", "Global loopback address" },:     { 0xFEFFFF, "Broadcast", "Global broadcast address"  } };         int i;         unsigned char x[4];            x[0] = addr[2];          x[1] = addr[1];          x[2] = addr[0];          x[3] = 0;   >         for (i=0; i < (sizeof(mtable)/sizeof(mtable[0])); i++)	         { 4                 if (memcmp(&mtable[i].oui,x,3) == 0)                 { 1                         if (mtable[i].name2 != 0) F                                 fprintf(fpOut,"  %s",mtable[i].name2);                         elseF                                 fprintf(fpOut,"  %s",mtable[i].name1);                         break;                 } 	         }  }    int + get_ip_name(unsigned char *addr,char *name)  {          int result = FALSE;  #if IP_NAMES struct hostent *hp;   -         hp = gethostbyaddr((char *)addr,4,2);          if (hp != NULL) 	         { (                 strcpy(name,hp->h_name);                 result = TRUE;	         }  #endif         return result; }   ) /* bswap - reverse the bytes in a word	*/  void bswap(unsigned short *w) {          unsigned char *p,b;            p = (unsigned char *)w;            b = p[0];          p[0] = p[1];         p[1] = b;  }   7 /* return the value of a word with the bytes swapped	*/ ' unsigned short bswap2(unsigned short x)  {          bswap(&x);         return x;  }   @ /* return the value of a long with the bytes in reverse order	*/ unsigned long  bswap4(unsigned long a)  {  	unsigned char *p, *q; 	unsigned long b;    	p = (unsigned char *)&a;  	q = (unsigned char *)&b; 
 	q[0] = p[3]; 
 	q[1] = p[2]; 
 	q[2] = p[1]; 
 	q[3] = p[0];   
 	return b; }    void  2 display_lavc_group(FILE *fpOut,unsigned char *gno) { !         fprintf(fpOut,"%d",*gno);  }    void  = display_ipx_route(FILE *fpOut,void *rdata,unsigned short len)  {          ROUTE_IPX *entry;    	entry = (ROUTE_IPX *)rdata;(         while (len >= sizeof(ROUTE_IPX))	         { E                 fprintf(fpOut,"  IPX: network %08x hops %d ticks %d", I                         bswap4(entry->network),entry->hops,entry->ticks);                  entry++;)                 len -= sizeof(ROUTE_IPX);          }          }    void  B display_lat_service(FILE *fpOut,void *data,unsigned char data_len) {          if (data_len != 0)	         { J                 fprintf(fpOut," - %*.*s",data_len,data_len,(char *)data); 	         }  }    void  C display_last_service(FILE *fpOut,void *data,unsigned char data_len)  {  }    void  B display_sap_service(FILE *fpOut,void *data,unsigned char data_len) {          SERVICE_SAP *serv;         IPX_ADDRESS ia;  	struct  	{ 		unsigned short type;
 		char *name;  	} sap_type_names [] = 	{{0x0004,"File Server"}, ! 	 {0x004b,"Btrieve VAP/NLM 5.0"},  	 {0x0050,"Btrieve VAP 4.11"},-  	 {0x0278,"Directory Server (Netware 4.x)"},      	 {0x0361,"NETINELO?"},  	}; L #define MAX_SAP_TYPE_NAME (sizeof(sap_type_names)/sizeof(sap_type_names[0])) 	int i;   #         serv = (SERVICE_SAP *)data;   ,         if (data_len == sizeof(SERVICE_SAP))	         { :                 fprintf(fpOut," type 0x%04x ",serv->type);& 		for (i=0; i < MAX_SAP_TYPE_NAME;i++) 		{ , 			if (serv->type == sap_type_names[i].type)2 				fprintf(fpOut,"(%s) ",sap_type_names[i].name); 		} '                 ia.net = serv->network; ;                 memcpy(ia.node,serv->addr,sizeof(ia.node)); '                 ia.sock = serv->socket; @                 display_ipx_address(fpOut,(unsigned char *)&ia);	         }          else	         { D                 fprintf(fpOut," - invalid data length %d",data_len);	         }  }    void  < display_ip_route(FILE *fpOut,void *rdata,unsigned short len) {          ROUTE_IP * rip;          int i, n;   $         if (len >= sizeof(ROUTE_IP))	         { (                 rip = (ROUTE_IP *)rdata;+                 n = len / sizeof(ROUTE_IP); %                 for (i=0; i < n; i++)                  { "                         if (i > 0)2                                 fputc('\n',fpOut);0                         fprintf(fpOut,"  IP: ");<                         display_ip_address(fpOut,rip->addr);@                         fprintf(fpOut," metric %d",rip->metric);                 } 	         }          else	         { A                 fprintf(fpOut," - invalid data length %d\n",len); 	         }  }    void  = display_ip2_route(FILE *fpOut,void *rdata,unsigned short len)  {          ROUTE_IP2 * rip;         int i, n;   %         if (len >= sizeof(ROUTE_IP2)) 	         { )                 rip = (ROUTE_IP2 *)rdata; ,                 n = len / sizeof(ROUTE_IP2);%                 for (i=0; i < n; i++)                  { "                         if (i > 0)2                                 fputc('\n',fpOut);0                         fprintf(fpOut,"  IP: ");<                         display_ip_address(fpOut,rip->addr);0                         fprintf(fpOut," mask ");<                         display_ip_address(fpOut,rip->mask);@                         fprintf(fpOut," metric %d",rip->metric);                 } 	         }          else	         { ?                 fprintf(fpOut," - invalid data length %d",len); 	         }  }    void  I display_decnet_route(FILE *fpOut,int area,void *rdata,unsigned short len)  {          ROUTE_DECNET *entry;   	entry = (ROUTE_DECNET *)rdata; +         while (len >= sizeof(ROUTE_DECNET)) 	         {                  if (area)                  { K                         fprintf(fpOut,"  DECnet Area: %2d cost %d hops %d", H                                 entry->id/1024,entry->cost,entry->hops);                 }                  else                 { 9                         fprintf(fpOut,"  DECnet Node: "); ?                         display_dnet_address(fpOut,&entry->id); 9                         fprintf(fpOut," cost %d hops %d", 9                                 entry->cost,entry->hops);                  }                  entry++;,                 len -= sizeof(ROUTE_DECNET);         }          }    char *2 display_datetime(FILE *fpOut,unsigned short *time) {  	static char timestr[80]; " 	$DESCRIPTOR(timestr_dsc,timestr); 	unsigned short tlen;  	unsigned long ccode;  	 / 	ccode = sys$asctim(&tlen,&timestr_dsc,time,0);  	if (ccode & 1) 	         {  		timestr[tlen] = '\0'; 	         }  	else 	         { J                 sprintf(timestr,"Invalid timestamp 0x%04x,%04x,%04x,%04x",9                         time[0],time[1],time[2],time[3]); 	         }          if (fpOut != NULL)%                 fputs(timestr,fpOut);            return timestr;  }    void   lower_case(char *name) {          while (*name != '\0') 	         { '                 *name = tolower(*name);                  name++;          }          }    char *# get_eth_pname(unsigned short ptype)  {          static struct 	         { %                 unsigned short ptype;                  char *pname;         } pnames[] =	         { '                 {0x6000," (DEC Exp.)"}, %                 {0x6001," (MOP-LD)"}, %                 {0x6002," (MOP-RC)"}, (                 {0x6003," (DECnet IV)"},"                 {0x6004," (LAT)"},'                 {0x6005," (DEC Diag)"}, (                 {0x6006," (DEC Cust.)"},#                 {0x6007," (LAVC)"}, *                 {0x6008," (DEC Unass.1)"},*                 {0x6009," (DEC Unass.1)"},!                 {0x0800," (IP)"}, $                 {0x0805," (X25L3)"},"                 {0x0806," (ARP)"},%                 {0x0889," (xyplex)"}, ,                 {0x8038," (DEC LANBridge)"},)                 {0x803f," (DEC LANmon)"}, '                 {0x8005," (HP probe)"}, #                 {0x8035," (RARP)"}, )                 {0x803C," (DNA naming)"}, )                 {0x8040," (NetBios EM)"}, #                 {0x8041," (LAST)"}, "                 {0x8137," (IPX)"},%                 {0x8138," (Novell)"}, #                 {0x814C," (SNMP)"}, "                 {0x0600," (xns)"},+                 {0x0606," (Xerox Merdic)"}, '                 {0x9000," (Loopback)"}, )                 {0x9001," (Bridge MGT)"}, 0                 {0x9002," (Bridge TCP/IP Sys)"},/                 {0x9003," (Bridge Loop Det.)"}, 
         };         int i;         char *pname = "";   <         for (i=0; i < sizeof(pnames)/sizeof(pnames[0]); i++)	         { -                 if (ptype == pnames[i].ptype)                  { 0                         pname = pnames[i].pname;                         break;                 } 	         }                   return pname;  }    char *  get_802_pname(unsigned char sap) {          static struct 	         { "                 unsigned char sap;                 char *pname;         } pnames[] =	         { %                 {0x00, " (802null)"}, /                 {0x02, " (LLC subl mgmnt fn)"}, /                 {0x03, " (LLC subl mgmnt fg)"}, +                 {0x06, " (IP (obsolete))"}, .                 {0x0e, " (PROWAY net mgmnt)"},"                 {0x33, " (LAST)"},'                 {0x42, " (Spng tree)"}, .                 {0x4e, " (RS-511 M Msg Svc)"},-                 {0x7e, " (ISO 8208 (X.25))"}, ,                 {0x8e, " (PROWAY act stn)"},&                 {0xAA, " (SNAP-SAP)"},'                 {0xfe, " (ISO trprt)"}, !                 {0xe0, " (IPX)"}, %                 {0xF0, " (NetBUEI)"}, &                 {0xff  , " (SAP-FF)"},
         };         int i;         char *pname = "";   <         for (i=0; i < sizeof(pnames)/sizeof(pnames[0]); i++)	         { )                 if (sap == pnames[i].sap)                  { 0                         pname = pnames[i].pname;                         break;                 } 	         }                   return pname;  }    char *" get_802e_pname(unsigned char *pid) {          static struct 	         { %                 unsigned char pid[5];                  char *pname;         } pnames[] =	         { 5                 {0x08,0x00,0x07,0x80,0x9b," (atk2)"}, 6                 {0x82,0x00,0x00,0x00,0x00," (es-is)"},=                 {0x08,0x00,0x2b,0x80,0x3e," (DNA time svc)"}, 7                 {0x08,0x00,0x2b,0x60,0x01," (MOP-LD)"}, 7                 {0x08,0x00,0x2b,0x60,0x02," (MOP-RC)"}, 9                 {0x08,0x00,0x2B,0x90,0x00," (MOP-LOOP)"}, 5                 {0x08,0x00,0x2B,0x80,0x41," (LAST)"}, ;                 {0x08,0x00,0x2b,0x80,0x3C," (DNA naming)"}, 8                 {0x08,0x00,0x2b,0x80,0x48," (DECamds)"},:                 {0x08,0x00,0x2B,0x60,0x07," (LAVC-802E)"},
         };         int i;         char *pname = "";   <         for (i=0; i < sizeof(pnames)/sizeof(pnames[0]); i++)	         { 5                 if (memcmp(pid,pnames[i].pid,5) == 0)                  { 0                         pname = pnames[i].pname;                         break;                 } 	         }                   return pname;  }   2 /* strtrim - replace trailing spaces with NULLs */ void strtrim(char *str) {          char *p;           p = str + strlen(str);         while (p > str) 	         {                  if (*p <= ' ')"                         *p = '\0';                 p--;	         }  } 