#include	<stdio.h>			/* standard I/O definitions */
#include	<descrip.h>			/* descriptor definitions */
#include	<ssdef.h>			/* system service definitions */
#include	<varargs.h>			/* variable arguments */
#include	<fab.h>				/* Define RMS FAB fields */

/*
 *	Accept a connection from a remote node
 *
 *	mai$ax_protocol		Protocol field from /PROTOCOL=protocol
 *
 * This routine is called when MAIL starts with the /PROTOCOL=protocol
 * qualifier and the process has DETACH and SYSPRV. MAIL will then pretend
 * that we are a network server and will behave accordingly. The 
 * "mai$ax_protocol" field passed to this routine is the value of the
 * /PROTOCOL qualifier. 
 *
 * Return: System service for success/failure
 *
 */

PROTO_IN_CONNECT(
	long	*mai$al_context,		/* Context field for protocol */
	long	mai$l_operation,		/* LNK_C_IN_CONNECT */
	va_list	arglist)			/* remainder of arguments */
{
	struct	dsc$descriptor	*mai$ax_inptran ; /* Translation of SYS$NET */
	char	*mai$b_filrat ;			/* File RMS RAT field */
	char	*mai$b_filrfm ;			/* File RMS RFM field */
	short	mai$w_sysflags ;		/* Low 16 bits of MAIL$GL_SYSFLAGS */
	struct	dsc$descriptor	*mai$ax_protocol ;	/* Protocol to use */
	long	*mai$al_pflags ;		/* Protocol flags */
	char	*mai$b_filorg ;			/* File RMS ORG field */

	mai$ax_inptran =
	  (struct dsc$descriptor *) va_arg(arglist, struct dsc$descriptor *) ;
	mai$b_filrat = (char *) va_arg(arglist, char *) ;
	mai$b_filrfm = (char *) va_arg(arglist, char *) ;
	mai$w_sysflags = (short) va_arg(arglist, short) ;
	mai$ax_protocol = 
	  (struct dsc$descriptor *) va_arg(arglist, struct dsc$descriptor *) ;
	mai$al_pflags = (long *) va_arg(arglist, long *) ;
	mai$b_filorg = (char *) va_arg(arglist, char *) ;

	printf( "* Operation type = %d (LNK_C_IN_CONNECT)\n", mai$l_operation );
	printf( "  Context field  = 0x%08x\n", *mai$al_context );
	printf( "  SYS$NET        = %.*s\n", mai$ax_inptran->dsc$w_length, mai$ax_inptran->dsc$a_pointer );
	printf( "  MAIL flags     = 0x%04x\n", mai$w_sysflags );
	printf( "  Mail protocol  = %.*s\n", mai$ax_protocol->dsc$w_length, mai$ax_protocol->dsc$a_pointer );

	*mai$b_filrfm = FAB$C_VAR;		/* Assume variable length... */
	*mai$b_filrat = FAB$M_CR;		/* ...CR files */
	*mai$b_filorg = FAB$C_SEQ;		/* ...SEQuential files */

	*mai$al_pflags = 0;			/* Set to 1 for permanent server */

	return(SS$_NORMAL) ;			/* Return success to caller */
}
