#include	<stdio.h>			/* standard I/O definitions */
#include	<descrip.h>			/* descriptor definitions */
#include	<ssdef.h>			/* system service definitions */
#include	<varargs.h>			/* variable arguments */

/*
 *	Send the attributes id TLD to the remote node.
 *
 *	mai$ax_node		Node name from address (to the right of the
 *				'%') if a '::' was found, else a blank string
 *	mai$l_system_flags	System flags to send to remote node - <0>
 *				means a foreign file.
 *	mai$ax_attribs		Attributes (a TLD) to send to remote node.
 *	mai$a_error		Passed address of a routine to be used to read
 *				back error texts from the remote node and to
 *				format them correctly for MAIL.
 *				Call this routine with:
 *					4(AP)	Context block address
 *					8(AP)	Address of routine to call to
 *						read next record
 *
 * Return: System status code for success/failure
 *
 */


void Dump_TLD(struct dsc$descriptor *t) ;

typedef struct TLD {
	unsigned	w_type	: 16;		/* Type of record */
	unsigned	w_length: 16;		/* Length of record */
/*	w_length bytes of data		*/
} TLD, *TLD_PTR;

PROTO_OUT_ATTRIBS(
	long	*mai$al_context,		/* Context field for protocol */
	long	mai$l_operation,		/* LNK_C_OUT_ATTRIBS */
	va_list	arglist)			/* remainder of arguments */
{
	long	mai$l_system_flags ;		/* System flags */
	struct	dsc$descriptor	*mai$ax_attribs ;	/* Attributes to send */
	TLD_PTR	a_tld =
		(TLD_PTR) mai$ax_attribs->dsc$a_pointer;/* Address of first TLD	*/
	long	length = mai$ax_attribs->dsc$w_length;	/* Length of TLD */

	mai$l_system_flags = (long) va_arg(arglist, long) ;
	mai$ax_attribs =
	  (struct dsc$descriptor *) va_arg(arglist, struct dsc$descriptor *) ;

	printf( "* Operation type = %d (LNK_C_OUT_ATTRIBS)\n", mai$l_operation );
	printf( "  Context field  = 0x%08x\n", *mai$al_context );
	printf( "  System flags   = 0x%08x\n", mai$l_system_flags );

	Dump_TLD( mai$ax_attribs );		/* Dump the attribute tables */

	return(SS$_NORMAL) ;			/* Return success to caller */
}
