	Subroutine Prsfil(File,Flen)
*
*	This routine is called once to retrieve each file name
*	we work with.
*	On the first call, it does all the command parsing, filling
*	up an array with names. Repeated calls to Lib$Find_File
*	are then used to parse the names, one of which is returned
*	on each call.
*	  We have to do all the parsing at once so we can pick up local
*	  qualifiers for the names.
**** V3.0 - edited 7 July 1991 by Kevin
****		Use LIB$GET_INPUT for user input
*
	Implicit None
	Character*(*) File
	Integer Flen
	Integer Status,Cli$Get_Value,Cli$Present,Status1,Stv
	External Cli$_Absent,Cli$_Present,Cli$_LocPres
	Include 'FILCOM.INC'
	Include 'QUALCOM.INC'
	Character*255 Temp,DefMai
	Integer Tlen,LDefmai
	Integer I
	Logical First
	Save First
	Data First /.True./

	External Rms$_NMF
	Integer Lib$Find_File,Context
	Logical Confirmed,PrsfilCheck
	External MLSEARCH_TOOMNYFIL,MLSEARCH_OPENIN,MLSEARCH_TOOMNYEXC
	External MLSEARCH_TOOMNYFOL

	If(First) Then
	 Nfiles = 0
	 NFolders = 0
	 Status1 = 1
	 Cfile = 1
	 First = .False.
	 Context = 0
*
*	Initialize folder tables and exclusion tables
*
	 Do I = 1,Maxfiles
	   Excluded(I) = ' '
	   Lexcl(I) = 0
	   Folders(I) = ' '
	   Folderlen(I) = 0
	 Enddo
*
*	Get folder names
*
	 Status = Cli$Present('SOURCE')
	 If(Status.eq.%Loc(Cli$_Present)) Then
	   Do While(Cli$Get_Value('SOURCE',Temp,Tlen))
		If(Nfolders .lt. Maxfiles) Then
		  Nfolders = NFolders + 1
		  Folders(NFolders) = Temp(1:Tlen)
		  Folderlen(NFolders) = Tlen
		Else
	          Call Lib$Signal(MLSEARCH_TOOMNYFOL,%val(1),
     $                                      %Val(Maxfiles))
		Endif
	  Enddo
	Endif
*
*	Look for /EXCLUDE
*
	 Call Prsexcl(Excluded,Lexcl,Nexcl,Maxfiles)

	 If(Cli$Present('FILES')) Then
	   Do While(Cli$Get_Value('FILES',Temp,Tlen))
	     If(Nfiles .lt. Maxfiles) Then
	       Nfiles = Nfiles + 1
	       Filnams(Nfiles) = Temp(1:Tlen)
	       Fnamlen(Nfiles) = Tlen
	     Else
	       Call Lib$Signal(MLSEARCH_TOOMNYFIL,%val(1),%Val(Maxfiles))
	     Endif
	   Enddo
	 Endif
	 Call GetMailDir(Defmai,LDefmai)
*
* Now we have all the names, start parsing the first one.
* If there were no names, return the default empty string now.
*
	  If(Nfiles .eq. 0) Then
		Flen = 1
		File = ' '
		Return
	  Endif
	Endif			!Check for first entry.

*
*	Enter here to get all filenames after first call
*	Get next matching name
*
10	If(Nfiles .eq. 0) Then
		Flen = -1
		Return
	Endif

	Tlen = Fnamlen(Cfile)
	Status = Lib$Find_File(Filnams(Cfile)(1:Tlen),
     $                         Current_File,Context,
     $                         Defmai(1:Ldefmai)//'MAIL.MAI',,Stv,2)
	If(Status) Then
		Call Str$Trim(File,Current_File,Cfilnaml)
		Flen = Cfilnaml
*
*	Exclude MAIL$nnnnn.MAI files
*
		If(PrsfilCheck(Current_File(1:Flen))) Goto 10
*
*	If /CONFIRM, check to see if they want this file.
*
		If(Confirm) Then
		   If(.Not. Confirmed(File(1:Flen),.True.)) Goto 20
		Endif
		Return
*
*	If file not found, see if we have any more file specs
*
	Else If(Status .eq. %Loc(Rms$_NMF)) Then
		Goto 20
	Else
*
*	If here, there is some problem parsing the filespec
*	Signal a warning, and move to the next
*
		Call Lib$Signal(MLSEARCH_OPENIN,%Val(1),
     $                             Filnams(Cfile)(1:Tlen),
     $                             %Val(Status),%Val(Stv))
		Goto 20
	Endif
*
*	Here to step the file counter.
*
20	Cfile = Cfile + 1
	If(Cfile .gt. Nfiles) Then
*
*	No, so say there is nothing left.
*
		Flen = -1
		File = ' '
		Return
	Endif
	Goto 10

	End

	Subroutine PrsExcl(Excluded,Lexcl,Nexcl,Maxfiles)
*
*	Check for /EXCLUDE folders
*
	Implicit None
	Integer Maxfiles,Nexcl
	Integer Lexcl(Maxfiles)
	Character*(*) Excluded(Maxfiles)

	Integer Cli$Present,Cli$Get_Value
	External Cli$_Absent,Cli$_Present
	External MLSEARCH_TOOMNYEXC
	Character*160 Temp
	Integer Tlen
*
*	Get folders to be excluded
*
	Nexcl = 0
	If(Cli$Present('EXCLUDED')) Then
	  Do While(CLI$Get_Value('EXCLUDED',Temp,Tlen))
		If(Nexcl .lt. Maxfiles) Then
		  Nexcl = Nexcl + 1
		  Excluded(Nexcl) = Temp(1:Tlen)
		  Lexcl(Nexcl) = Tlen
		Else
	          Call Lib$Signal(MLSEARCH_TOOMNYEXC,%val(1),
     $                                      %Val(Maxfiles))
		Endif
	  Enddo
	Endif

	Return
	End

	Logical Function Confirmed(Name,Type)
*
*	Called to ask a user to confirm a search for a module or a file.
*	Type is TRUE for files. Accept YES,NO,TRUE,FALSE or 0 or 1.
*
*	Also accepts ALL, and asks no more questions, or control-z or quit
*	to stop.
*
*	Default is no.
*
	Implicit None
	Character*(*) Name
	Logical Type
*---
	Character*80 Ans
	Integer Alen
*---
	Include 'QUALCOM.INC'
	Logical Abbrev
	External MLSEARCH_INVLANS

10	If(Type) Then
	    Call Lib$Get_input(Ans,'Search file '//Name//' ? [N]: ',Alen)
	Else
	    Call Lib$Get_input(Ans,'Search folder '//Name//' ? [N]: ',Alen)
	Endif

	If(Alen .le. 0) Then
		Confirmed = .False.
		Return
	Endif

	Confirmed = .False.
	Call Str$Upcase(Ans,Ans(1:Alen))
	If(Abbrev(Ans(1:Alen),'TRUE') .or. 
     $     Abbrev(Ans(1:Alen),'YES') .or.
     $     Abbrev(Ans(1:Alen),'1')) Then
		Confirmed = .True.
		Return
	Else If(Abbrev(Ans(1:Alen),'FALSE') .or.
     $          Abbrev(Ans(1:Alen),'NO') .or.
     $          Abbrev(Ans(1:Alen),'0')) Then
		Confirmed = .False.
		Return
	Else If(Abbrev(Ans(1:Alen),'QUIT')) Then
		Goto 99
	Else If(Abbrev(Ans(1:Alen),'ALL')) Then
		Confirm_Folder = .False.
		If(Type) Confirm = .False.
		Confirmed = .True.
		Return
	Else
		Call Lib$Signal(MLSEARCH_INVLANS,%Val(1),Ans(1:Alen))
		Goto 10
	Endif

99	Call Exit(1)
	End

	Logical Function PrsFilCheck(File)
*
*	Checks filename to ensure that it is not a MAIL$... file
*	FILE will be a fully qualified name.
*
	Implicit None
	Character*(*) File
	Integer Sys$Parse
	Include '($FABDEF)'
	Include '($NAMDEF)'
	Record /FABDEF/ Fab
	Record /NAMDEF/ Nam
	Character*255 Name
	Integer P

	Fab.Fab$B_Bid = Fab$C_Bid
	Fab.Fab$B_Bln = Fab$C_Bln
	Fab.Fab$L_Fna = %loc(File)
	Fab.Fab$B_Fns = Len(File)
	Fab.Fab$L_Nam = %loc(Nam)

	Nam.Nam$B_Bln = Nam$C_Bln
	Nam.Nam$B_Bid = Nam$C_Bid
	Nam.Nam$L_Esa = %Loc(Name)
	Nam.Nam$B_Ess = Len(Name)
	Nam.Nam$B_Nop = Nam$M_Synchk
	If (Sys$Parse(Fab)) Then
		P = Nam.Nam$L_Name - %Loc(Name) + 1
		If(Name(P:P+4) .eq. 'MAIL$' .and. Nam.Nam$B_Name .gt. 9
     $          .and. Index('0123456789ABCDEF',Name(P+5:P+5)).ne.0) Then
			PrsfilCheck = .True.
		Else
			PrsfilCheck = .False.
		Endif
	Else
		PrsfilCheck = .False.
	Endif
	return
	End

	Subroutine GetMailDir(Maildir,LMaildir)
	Implicit None
	Character*(*) Maildir
	Integer Lmaildir
*----- Local vars
	Include '($MAILDEF)'
	Integer UCtx
	Integer Mail$User_Begin,Mail$User_End,Mail$User_Get_info
	Structure /Itmlst/
	   Integer*2 Blen
	   Integer*2 Code
	   Integer Bufadr
	   Integer RetlenAdr
	End Structure
	Record/Itmlst/ Nullitm,Initm(2),Outitm(2)
	Integer Status

	Nullitm.code = 0
	Nullitm.Blen = 0
	Nullitm.Bufadr = 0
	Nullitm.Retlenadr = 0

	Call Srv(Mail$User_Begin(Uctx,Nullitm,Nullitm))

	Initm(1) = Nullitm

	Outitm(1).Bufadr = %Loc(Maildir)
	Outitm(1).Blen = Len(Maildir)
	Outitm(1).Retlenadr = %Loc(LMaildir)
	Outitm(1).Code  = Mail$_User_Full_Directory

	Outitm(2) = Nullitm

	Status = Mail$User_Get_info(Uctx,Initm,Outitm)
	Call Srv(Mail$User_End(Uctx,Nullitm,Nullitm))
	If(.Not. Status) Then
		Maildir = 'SYS$LOGIN:'
		Lmaildir = 10
	Endif

	Return
	End

	Subroutine GetMailEdit(MailEdit,LMailEdit)
*
*	This routine looks for and returns the user's default mail editor.
*	It will always return SOMETHING, in the following order:
*	    Is MAIL$EDIT defined ? If so, return definition.
*	    Does user have an editor set in mail profile ?, If so, return it.
*	    Else return TPU.
*	CALLABLE_ prefixes are removed from logical name defs.
*
	Implicit None
	Character*(*) MailEdit
	Integer LmailEdit
*----- Local vars
	Include '($MAILDEF)'
	Include '($LNMDEF)'
	Integer UCtx
	Integer Mail$User_Begin,Mail$User_End,Mail$User_Get_info
	Integer Sys$Trnlnm
	Structure /Itmlst/
	   Integer*2 Blen
	   Integer*2 Code
	   Integer Bufadr
	   Integer RetlenAdr
	End Structure
	Record/Itmlst/ Nullitm,Initm(2),Outitm(2)
	Integer Status

	Nullitm.code = 0
	Nullitm.Blen = 0
	Nullitm.Bufadr = 0
	Nullitm.Retlenadr = 0

	Initm(1).Code = LNM$_String
	Initm(1).Blen = Len(Mailedit)-1
	Initm(1).Bufadr = %Loc(Mailedit)+1
	Initm(1).Retlenadr = %loc(Lmailedit)
	Initm(2) = Nullitm

	Status = sys$trnlnm (,'LNM$FILE_DEV','MAIL$EDIT',,Initm)
	If(Status) Then
	  If(Mailedit(2:10) .eq. 'CALLABLE_' .and. Lmailedit .gt. 10) Then
		Mailedit = Mailedit(11:)
		Lmailedit = Lmailedit - 9
	  Else
		Mailedit(1:1) = '@'
		Lmailedit = Lmailedit+1
	  Endif
	  Return
	Endif

	Call Srv(Mail$User_Begin(Uctx,Nullitm,Nullitm))

	Initm(1) = Nullitm

	Outitm(1).Bufadr = %Loc(MailEdit)
	Outitm(1).Blen = Len(Mailedit)
	Outitm(1).Retlenadr = %Loc(LMailEdit)
	Outitm(1).Code  = Mail$_User_Editor

	Outitm(2) = Nullitm

	Status = Mail$User_Get_info(Uctx,Initm,Outitm)
	Call Srv(Mail$User_End(Uctx,Nullitm,Nullitm))

	If(Lmailedit .eq. 0 .or. Mailedit .eq. ' ') Then
	    Mailedit = 'TPU'
	    Lmailedit = 3
	Endif

	Return
	End

	Logical Function Abbrev(A,B)
	Implicit None
	Character*(*) A,B

	Abbrev = Len(A) .le. Len(B) .and. A .eq. B(1:Len(A))
	Return
	End

	Logical Function Bad_Timing(File)
*
*	Returns TRUE if a file is to be excluded due to /BEFORE or /SINCE
*	qualifiers.
*
	Implicit None
	Character*(*) File
	Include 'QUALCOM.INC'
	Include '($FABDEF)'
	Include '($XABDATDEF)'
*-----
	Structure /Time/
		Integer T(2)
	End Structure
	Record /TIME/ Rtime,Ftime
	Integer Status
	Structure /XABTIM/
		Byte B_cod
		Byte B_BLN
		Integer*2 Fill1
		Integer L_Nxt
		Integer*2 W_RVN
		Integer*2 Fill2
		Record /Time/ Q_RDT
		Record /Time/ Q_CDT
		Record /Time/ Q_EDT
		Record /Time/ Q_BDT
	End Structure
	Record /XABTIM/ XAB
	Record /FABDEF/ FAB

	Integer Lib$Sub_Times,Sys$open,Sys$Close
	External Lib$_Negtim
*
*	Initialize the block headers
*
	XAB.B_Cod = XAB$C_DAT
	XAB.B_BLN = XAB$C_DATLEN
	fab.fab$b_BID = FAB$C_BID
	fab.fab$b_BLN = FAB$C_BLN
*
*	Plug in some data
*
	Fab.Fab$L_Fna = %Loc(File)
	Fab.Fab$B_Fns = Len(File)
	Fab.Fab$L_Xab = %Loc(XAB)

	Call Stchek(Sys$Open(FAB))
*
*	Now we have some dates in the FAB, so copy the appropriate
*	one to FTIME for comparison.
*
	Ftime = XAB.Q_CDT

	Call Stchek(Sys$Close(Fab))

	If(Before) Then
		Status = Lib$Sub_times(Btime,Ftime,Rtime)
		If(Status .eq. %loc(Lib$_Negtim)) Then
			Bad_Timing = .True.
			Return
		Endif
	Endif

	If(Since) Then
		Status = Lib$Sub_times(Stime,Ftime,Rtime)
		If(Status .ne. %loc(Lib$_Negtim)) Then
			Bad_Timing = .True.
			Return
		Endif
	Endif

	Bad_timing = .False.
	Return
	End
