, /* Variable function expansion for GNU Make.7 Copyright (C) 1988, 1989 Free Software Foundation, Inc.  This file is part of GNU Make.  @ GNU Make is free software; you can redistribute it and/or modifyD it under the terms of the GNU General Public License as published byC the Free Software Foundation; either version 1, or (at your option)  any later version.  ; GNU Make is distributed in the hope that it will be useful, > but WITHOUT ANY WARRANTY; without even the implied warranty of= MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the , GNU General Public License for more details.  A You should have received a copy of the GNU General Public License < along with GNU Make; see the file COPYING.  If not, write toI the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */    #include "make.h"  #include "variable.h"  #include "dep.h" #include "commands.h"  #include "job.h" #include <errno.h>   extern int errno;    static char *string_glob ();                                  L /* Store into VARIABLE_BUFFER at O the result of scanning TEXT and replacingK    each occurrence of SUBST with REPLACE. TEXT is null-terminated.  SLEN is H    the length of SUBST and RLEN is the length of REPLACE.  If BY_WORD isE    nonzero, substitutions are done only on matches which are complete L    whitespace-delimited words.  If SUFFIX_ONLY is nonzero, substitutions are;    done only at the ends of whitespace-delimited words.  */       char *H subst_expand (o, text, subst, replace, slen, rlen, by_word, suffix_only)
      char *o;       char *text;      char *subst, *replace;       unsigned int slen, rlen;       int by_word, suffix_only; {    register char *t = text;   register char *p;   ,   if (slen == 0 && !by_word && !suffix_only)     { A       /* The first occurrence of "" in any string is its end.  */ 4       o = variable_buffer_output (o, t, strlen (t));       if (rlen > 0) / 	o = variable_buffer_output (o, replace, rlen);        return o;      }   /   while ((p = sindex (t, 0, subst, slen)) != 0)      { O       /* Output everything before this occurrence of the string to replace.  */        if (p > t)* 	o = variable_buffer_output (o, t, p - t);  ;       /* If we're substituting only by fully matched words, C 	 or only at the ends of words, check that this case qualifies.  */        if ((by_word0 	   && ((p > t && p[-1] != ' ' && p[-1] != '\t')B 	       || (p[slen] != '\0' && p[slen] != ' ' && p[slen] != '\t')) 	   || (suffix_only D 	       && (p[slen] != '\0' && p[slen] != ' ' && p[slen] != '\t'))))6 	/* Struck out.  Output the rest of the string that is! 	   no longer to be replaced.  */ - 	o = variable_buffer_output (o, subst, slen);        else if (rlen > 0)& 	/* Output the replacement string.  *// 	o = variable_buffer_output (o, replace, rlen);   6       /* Advance T past the string to be replaced.  */       t = p + slen;      }   +   /* Output everything left on the end.  */    if (*t != '\0') 2     o = variable_buffer_output (o, t, strlen (t));     return o;  }     > /* Store into VARIABLE_BUFFER at O the result of scanning TEXT7    and replacing strings matching PATTERN with REPLACE. :    If PATTERN_PERCENT is not nil, PATTERN has already been?    run through find_percent, and PATTERN_PERCENT is the result. :    If REPLACE_PERCENT is not nil, REPLACE has already beenC    run through find_percent, and REPLACE_PERCENT is the result.  */    char *M patsubst_expand (o, text, pattern, replace, pattern_percent, replace_percent) 
      char *o;       char *text;&      register char *pattern, *replace;6      register char *pattern_percent, *replace_percent; { ?   register int pattern_prepercent_len, pattern_postpercent_len; ?   register int replace_prepercent_len, replace_postpercent_len;    register char *t;    unsigned int len;    int doneany = 0;  L   /* We call find_percent on REPLACE before checking PATTERN so that REPLACEK      will be collapsed before we call subst_expand if PATTERN has no %.  */    if (replace_percent == 0) -     replace_percent = find_percent (replace);    if (replace_percent != 0)      { ?       /* Record the length of REPLACE before and after the % so < 	 we don't have to compute these lengths more than once.  */9       replace_prepercent_len = replace_percent - replace; =       replace_postpercent_len = strlen (replace_percent + 1);      }    else-     /* We store the length of the replacement .        so we only need to compute it once.  */.     replace_prepercent_len = strlen (replace);     if (pattern_percent == 0) -     pattern_percent = find_percent (pattern);    if (pattern_percent == 0) H     /* With no % in the pattern, this is just a simple substitution.  */3     return subst_expand (o, text, pattern, replace, . 			 strlen (pattern), strlen (replace), 1, 0);  8   /* Record the length of PATTERN before and after the %7      so we don't have to compute it more than once.  */ 5   pattern_prepercent_len = pattern_percent - pattern; 9   pattern_postpercent_len = strlen (pattern_percent + 1);   +   while (t = find_next_token (&text, &len))      {        int fail = 0;   '       /* Is it big enough to match?  */ A       if (len < pattern_prepercent_len + pattern_postpercent_len) 
 	fail = 1;  #       /* Does the prefix match?  */ -       if (!fail && pattern_prepercent_len > 0  	  && (*t != *pattern > 	      || t[pattern_prepercent_len - 1] != pattern_percent[-1]D 	      || strncmp (t + 1, pattern + 1, pattern_prepercent_len - 1)))
 	fail = 1;  #       /* Does the suffix match?  */ .       if (!fail && pattern_postpercent_len > 0= 	  && (t[len - 1] != pattern_percent[pattern_postpercent_len] @ 	      || t[len - pattern_postpercent_len] != pattern_percent[1]5 	      || strncmp (&t[len - pattern_postpercent_len], 8 			  &pattern_percent[1], pattern_postpercent_len - 1)))
 	fail = 1;         if (fail) , 	/* It didn't match.  Output the string.  */( 	o = variable_buffer_output (o, t, len);
       else 	{. 	  /* It matched.  Output the replacement.  */  : 	  /* Output the part of the replacement before the %.  */C 	  o = variable_buffer_output (o, replace, replace_prepercent_len);    	  if (replace_percent != 0) 	    {4 	      /* Output the part of the matched string that$ 		 matched the % in the pattern.  */A 	      o = variable_buffer_output (o, t + pattern_prepercent_len, $ 					  len - (pattern_prepercent_len# 						 + pattern_postpercent_len)); = 	      /* Output the part of the replacement after the %.  */ : 	      o = variable_buffer_output (o, replace_percent + 1,  					  replace_postpercent_len); 	    } 	}  >       /* Output a space, but not if the replacement is "".  */,       if (fail || replace_prepercent_len > 0B 	  || (replace_percent != 0 && len + replace_postpercent_len > 0)) 	{* 	  o = variable_buffer_output (o, " ", 1); 	  doneany = 1;  	}     }    if (doneany)     /* Kill the last space.  */      --o;     return o;  }                           O /* Handle variable-expansion-time functions such as $(dir foo/bar) ==> foo/  */   . /* These enumeration constants distinguish the1    various expansion-time built-in functions.  */   
 enum function    {      function_subst,      function_addsuffix,      function_addprefix,      function_dir,      function_notdir,     function_suffix,     function_basename,     function_wildcard,     function_firstword,      function_word,     function_words,      function_findstring,     function_strip,      function_join,     function_patsubst,     function_filter,     function_filter_out,     function_foreach,      function_sort,     function_origin,     function_shell,      function_invalid   };  4 /* Greater than the length of any function name.  */ #define MAXFUNCTIONLEN 11   D /* The function names and lengths of names, for looking them up.  */  
 static struct    {      char *name;      unsigned int len;      enum function function;    } function_table[] =   { #     { "subst", 5, function_subst }, +     { "addsuffix", 9, function_addsuffix }, +     { "addprefix", 9, function_addprefix },      { "dir", 3, function_dir }, %     { "notdir", 6, function_notdir }, %     { "suffix", 6, function_suffix },M)     { "basename", 8, function_basename },e)     { "wildcard", 8, function_wildcard },U+     { "firstword", 9, function_firstword },r!     { "word", 4, function_word },d#     { "words", 5, function_words },c.     { "findstring", 10, function_findstring },#     { "strip", 5, function_strip }, !     { "join", 4, function_join }, )     { "patsubst", 8, function_patsubst },l%     { "filter", 6, function_filter }, .     { "filter-out", 10, function_filter_out },'     { "foreach", 7, function_foreach },.!     { "sort", 4, function_sort },n%     { "origin", 6, function_origin }, #     { "shell", 5, function_shell },b     { 0, 0, function_invalid }   };                                                2 /* Return 1 if PATTERN matches WORD, 0 if not.  */   int ( pattern_matches (pattern, percent, word)-      register char *pattern, *percent, *word;h {    unsigned int len;c     if (percent == 0)n     {r.       unsigned int len = strlen (pattern) + 1;(       char *new = (char *) alloca (len);        bcopy (pattern, new, len);       pattern = new;'       percent = find_percent (pattern);A       if (percent == 0)e 	return streq (pattern, word);     }d     len = strlen (percent + 1);I  /   if (strlen (word) < (percent - pattern) + lenl4       || strncmp (pattern, word, percent - pattern))
     return 0;S  =   return !strcmp (percent + 1, word + (strlen (word) - len));s }       5 int shell_function_pid = 0, shell_function_completed;(  B /* Perform the function specified by FUNCTION on the text at TEXT.=    END is points to the end of the argument text (exclusive).g@    The output is written into VARIABLE_BUFFER starting at O.  */  H /* Note this absorbs a semicolon and is safe to use in conditionals.  */ #define BADARGS(func)  \"   if (reading_filename != 0)					\>     fatal ("%s:%u: Insufficient arguments to function `%s'",	\3 	   reading_filename, *reading_lineno_ptr, func);	\_>   else fatal ("insufficient arguments to function `%s'", func)  
 static char *d( expand_function (o, function, text, end)
      char *o;v      enum function function;      char *text;      char *end;  {    char *p, *p2, *p3;   unsigned int i, len;   int doneany = 0;   int count;=   char endparen = *end, startparen = *end == ')' ? '(' : '{';f     switch (function)      {a     default:       abort ();d       break;       + #ifndef VMS /* not supported for vms yet */l     case function_shell:       {s 	extern int fork (); 	extern int pipe ();
 	char **argv;= 	char buf[100];! 	int pipedes[2];	 	int pid;     	/* Expand the command line.  */$ 	text = expand_argument (text, end);  $ 	/* Construct the argument list.  */9 	argv = construct_command_argv (text, (struct file *) 0);p 	if (argv == 0)t	 	  break;/   	/* For error messages.  */o 	if (reading_filename != 0)*C 	  sprintf (buf, "%s:%u: ", reading_filename, *reading_lineno_ptr);  	else  	  buf[0] = '\0';t   	if (pipe (pipedes) < 0) 	  {$ 	    perror_with_name (buf, "pipe"); 	    break;  	  }   	push_signals_blocked_p (1);   	pid = fork ();B
 	if (pid < 0)t" 	  perror_with_name (buf, "fork"); 	else if (pid == 0)h4 	  child_execute_job (0, pipedes[1], argv, environ); 	else  	  {> 	    /* We are the parent.  Set up and read from the pipe.  */+ 	    char *buffer = (char *) xmalloc (201);s 	    unsigned int maxlen = 200;n 	    int cc;  - 	    /* Record the PID for child_handler.  */t 	    shell_function_pid = pid;" 	    shell_function_completed = 0;  - 	    /* Close the write side of the pipe.  */  	    (void) close (pipedes[1]);*  1 	    /* Read from the pipe until it gets EOF.  */n 	    i = 0;e 	    do  	      { 		if (i == maxlen) 		  {e 		    maxlen += 512;6 		    buffer = (char *) xrealloc (buffer, maxlen + 1); 		  }e   		errno = 0;1 		cc = read (pipedes[0], &buffer[i], maxlen - i); 
 		if (cc > 0)  		  i += cc; 	      } #ifdef EINTR& 	    while (cc > 0 || errno == EINTR); #elsel 	    while (cc > 0); #endif  , 	    /* Close the read side of the pipe.  */ 	    (void) close (pipedes[0]);   > 	    /* Loop until child_handler sets shell_function_completed- 	       to the status of our child shell.  */d* 	    while (shell_function_completed == 0)  	      wait_for_children (1, 0);   	    shell_function_pid = 0;  D 	    /* The child_handler function will set shell_function_completed9 	       to 1 when the child dies normally, or to -1 if iteD 	       dies with status 127, which is most likely an exec fail.  */  ( 	    if (shell_function_completed == -1) 	      {3 		/* This most likely means that the execvp failed,i2 		   so we should just write out the error message3 		   that came in over the pipe from the child.  */p 		fputs (buffer, stderr);e 		fflush (stderr); 	      }	 	    elsea 	      {. 		/* The child finished normally.  Replace all0 		   newlines in its output with spaces, and put, 		   that in the variable output buffer.  */ 		if (i > 0) 		  {a  		    if (buffer[i - 1] == '\n') 		      buffer[--i] = '\0';o 		    p = buffer;l( 		    while ((p = index (p, '\n')) != 0) 		      *p++ = ' ';x0 		    o = variable_buffer_output (o, buffer, i); 		  }t 	      }   	    free (argv[0]); 	    free ((char *) argv); 	    free (buffer);r 	  }   	pop_signals_blocked_p ();  
 	free (text);t 	break;        }( #endif /* VMS */       case function_origin: !       /* Expand the argument.  */r)       text = expand_argument (text, end);          {nE 	register struct variable *v = lookup_variable (text, strlen (text));  	if (v == 0)2 	  o = variable_buffer_output (o, "undefined", 9); 	elset 	  switch (v->origin)- 	    {
 	    default:p 	    case o_invalid: 	      abort ();
 	      break;t 	    case o_default:4 	      o = variable_buffer_output (o, "default", 7);
 	      break;  	    case o_env:9 	      o = variable_buffer_output (o, "environment", 11); 
 	      break;  	    case o_file:u1 	      o = variable_buffer_output (o, "file", 4);o
 	      break;  	    case o_env_override:dB 	      o = variable_buffer_output (o, "environment override", 20);
 	      break;h 	    case o_command:: 	      o = variable_buffer_output (o, "command line", 12);
 	      break;p 	    case o_override: 5 	      o = variable_buffer_output (o, "override", 8);m
 	      break;  	    case o_automatic:6 	      o = variable_buffer_output (o, "automatic", 9);
 	      break;n 	    }       }r         free (text);       break;            case function_sort:p!       /* Expand the argument.  */ )       text = expand_argument (text, end);          {c9 	char **words = (char **) xmalloc (10 * sizeof (char *));  	unsigned int nwords = 10;! 	register unsigned int wordi = 0; 	 	char *t;l  3 	/* Chop TEXT into words and put them in WORDS.  */!
 	t = text;' 	while (p = find_next_token (&t, &len))= 	  { 	    if (wordi >= nwords - 1)  	      { 		nwords += 5;- 		words = (char **) xrealloc ((char *) words, # 					    nwords * sizeof (char *)); 	 	      }	 * 	    words[wordi++] = savestring (p, len); 	  }   	if (wordi > 0)  	  {' 	    /* Now sort the list of words.  */cC 	    qsort ((char *) words, wordi, sizeof (char *), alpha_compare);s  & 	    /* Now write the sorted list.  */  	    for (i = 0; i < wordi; ++i) 	      { 		len = strlen (words[i]);4 		if (i == wordi - 1 || strlen (words[i + 1]) != len) 		    || strcmp (words[i], words[i + 1]))c 		  { 4 		    o = variable_buffer_output (o, words[i], len);- 		    o = variable_buffer_output (o, " ", 1);i 		  }p 		free (words[i]); 	      }  	    /* Kill the last space.  */	 	    --o;u 	  }   	free ((char *) words);f       }          free (text);       break;            case function_foreach:       {l+ 	/* Get three comma-separated arguments but " 	   expand only the first two.  */ 	char *var, *list; 	register struct variable *v;n   	count = 0;n 	for (p = text; p < end; ++p)  	  { 	    if (*p == startparen) 	      ++count;  	    else if (*p == endparen)  	      --count;=& 	    else if (*p == ',' && count <= 0)
 	      break;d 	  } 	if (p == end) 	  BADARGS ("foreach");r! 	var = expand_argument (text, p);    	p2 = p + 1; 	count = 0;  	for (p = p2; p < end; ++p)_ 	  { 	    if (*p == startparen) 	      ++count;  	    else if (*p == endparen)a 	      --count; & 	    else if (*p == ',' && count <= 0)
 	      break;, 	  } 	if (p == end) 	  BADARGS ("foreach");n  	list = expand_argument (p2, p);   	++p;w  	text = savestring (p, end - p);   	push_new_variable_scope ();= 	v = define_variable (var, strlen (var), "", o_automatic, 0);  	p3 = list;u/ 	while ((p = find_next_token (&p3, &len)) != 0), 	  { 	    char *result; 	    char save = p[len]; 	    p[len] = '\0';  	    v->value = p;/ 	    result = allocated_variable_expand (text);} 	    p[len] = save;,  = 	    o = variable_buffer_output (o, result, strlen (result)); , 	    o = variable_buffer_output (o, " ", 1); 	    doneany = 1;  	    free (result);r 	  }
 	if (doneany)s 	  /* Kill the last space.  */ 	  --o;c   	pop_variable_scope ();)   	free (var);
 	free (list);*
 	free (text);h       }n       break;       case function_filter:      case function_filter_out:s       {t 	char **words; 	unsigned int nwords;a 	register unsigned int wordi;e 	 > 	/* Get two comma-separated arguments and expand each one.  */ 	count = 0;  	for (p = text; p < end; ++p)  	  { 	    if (*p == startparen) 	      ++count;e 	    else if (*p == endparen)o 	      --count;p& 	    else if (*p == ',' && count <= 0)
 	      break;t 	  } 	if (p == end)C 	  BADARGS (function == function_filter ? "filter" : "filter-out");)  	p2 = expand_argument (text, p); 	=% 	text = expand_argument (p + 1, end);r  B 	/* Chop TEXT up into words and then run each pattern through.  */
 	nwords = 10; 2 	words = (char **) xmalloc (10 * sizeof (char *)); 	wordi = 0;i 	p3 = text;B/ 	while ((p = find_next_token (&p3, &len)) != 0)a 	  { 	    if (wordi == nwords - 1)i 	      { 		nwords += 10;G- 		words = (char **) xrealloc ((char *) words, # 					    nwords * sizeof (char *));e 	      } 	    if (*p3 != '\0')d 	      ++p3; 	    p[len] = '\0';f 	    words[wordi++] = p; 	  }  : 	/* Run each pattern through the words, killing words.  */	 	p3 = p2;o/ 	while ((p = find_next_token (&p3, &len)) != 0)e 	  { 	    char *percent;  	    char save = p[len]; 	    p[len] = '\0';*    	    percent = find_percent (p);  	    for (i = 0; i < wordi; ++i) 	      if (words[i] != 0 &&r' 		  (percent == 0 ? streq (p, words[i])h. 		   : pattern_matches (p, percent, words[i]))) 		  == (function == function_filter_out))n 		words[i] = 0;v 	    p[len] = save;f 	  }  % 	/* Output the words that remain.  */  	for (i = 0; i < wordi; ++i) 	  if (words[i] != 0)! 	    {C 	      o = variable_buffer_output (o, words[i], strlen (words[i]));x. 	      o = variable_buffer_output (o, " ", 1); 	      doneany = 1;a 	    }
 	if (doneany)_ 	  /* Kill the last space.  */ 	  --o;g   	free ((char *) words);  	free (p2);s
 	free (text);        }f       break;            case function_patsubst:_E       /* Get three comma-separated arguments and expand each one.  */p       count = 0;"       for (p = text; p < end; ++p) 	{ 	  if (*p == startparen)
 	    ++count;l 	  else if (*p == endparen))
 	    --count;0$ 	  else if (*p == ',' && count <= 0) 	    break;i 	}       if (p == end)e 	BADARGS ("patsubst");  
       p2 = p;s       count = 0;       for (++p; p < end; ++p)r 	{ 	  if (*p == startparen)
 	    ++count;c 	  else if (*p == endparen)u
 	    --count;l$ 	  else if (*p == ',' && count <= 0) 	    break;f 	}       if (p == end)  	BADARGS ("patsubst");  (       text = expand_argument (text, p2);'       p3 = expand_argument (p2 + 1, p); (       p2 = expand_argument (p + 1, end);       D       o = patsubst_expand (o, p2, text, p3, (char *) 0, (char *) 0);              free (text);       free (p3);       free (p2);       break;       case function_join:nC       /* Get two comma-separated arguments and expand each one.  */m       count = 0;"       for (p = text; p < end; ++p) 	{ 	  if (*p == startparen)
 	    ++count;E 	  else if (*p == endparen)c
 	    --count; $ 	  else if (*p == ',' && count <= 0) 	    break;  	}       if (p == end)) 	BADARGS ("join");'       text = expand_argument (text, p);m  '       p = expand_argument (p + 1, end);s              {w; 	/* Write each word of the first argument directly followedn5 	   by the corresponding word of the second argument. : 	   If the two arguments have a different number of words,= 	   the excess words are just output separated by blanks.  */  	register char *tp, *pp; 	p2 = text;i 	p3 = p; 	doi 	  { 	    unsigned int tlen, plen;p  ' 	    tp = find_next_token (&p2, &tlen);l 	    if (tp != 0)e0 	      o = variable_buffer_output (o, tp, tlen); 	    m' 	    pp = find_next_token (&p3, &plen);r 	    if (pp != 0) 0 	      o = variable_buffer_output (o, pp, plen); 	      	    if (tp != 0 || pp != 0) 	      {) 		o = variable_buffer_output (o, " ", 1);  		doneany = 1; 	      } 	  } 	while (tp != 0 || pp != 0);
 	if (doneany)  	  /* Kill the last blank.  */ 	  --o;r       }=              free (text);       free (p);        break;            case function_strip:!       /* Expand the argument.  */ )       text = expand_argument (text, end);	         p2 = text;2       while ((p = find_next_token (&p2, &i)) != 0) 	{( 	  o = variable_buffer_output (o, p, i);* 	  o = variable_buffer_output (o, " ", 1); 	  doneany = 1;/ 	}       if (doneany) 	/* Kill the last space.  */ 	--o;               free (text);       break;            case function_wildcard:v)       text = expand_argument (text, end);(              p = string_glob (text);_4       o = variable_buffer_output (o, p, strlen (p));              free (text);       break;            case function_subst:E       /* Get three comma-separated arguments and expand each one.  */u       count = 0;"       for (p = text; p < end; ++p) 	{ 	  if (*p == startparen)
 	    ++count;r 	  else if (*p == endparen) 
 	    --count;i$ 	  else if (*p == ',' && count <= 0) 	    break;  	}       if (p == end)  	BADARGS ("subst");d  
       p2 = p;a       count = 0;       for (++p; p < end; ++p); 	{ 	  if (*p == startparen)
 	    ++count;  	  else if (*p == endparen)o
 	    --count;"$ 	  else if (*p == ',' && count <= 0) 	    break;  	}       if (p == end)t 	BADARGS ("subst");)  (       text = expand_argument (text, p2);'       p3 = expand_argument (p2 + 1, p);t(       p2 = expand_argument (p + 1, end);       K       o = subst_expand (o, p2, text, p3, strlen (text), strlen (p3), 0, 0);E              free (text);       free (p3);       free (p2);       break;            case function_firstword:!       /* Expand the argument.  */ )       text = expand_argument (text, end);r  )       /* Find the first word in TEXT.  */r       p2 = text;$       p = find_next_token (&p2, &i);       if (p != 0),& 	o = variable_buffer_output (o, p, i);              free (text);       break;            case function_word:rC       /* Get two comma-separated arguments and expand each one.  */r       count = 0;"       for (p = text; p < end; ++p) 	{ 	  if (*p == startparen)
 	    ++count;* 	  else if (*p == endparen)s
 	    --count; $ 	  else if (*p == ',' && count <= 0) 	    break;  	}       if (p == end)r 	BADARGS ("word");'       text = expand_argument (text, p);;  (       p3 = expand_argument (p + 1, end);  &       /* Check the first argument.  */(       for (p2 = text; *p2 != '\0'; ++p2) 	if (*p2 < '0' || *p2 > '9') 	  { 	    if (reading_filename != 0),E 	      fatal ("%s:%u: non-numeric first argument to `word' function", . 		     reading_filename, *reading_lineno_ptr);	 	    else ? 	      fatal ("non-numeric first argument to `word' function");t 	  }  %       i = (unsigned int) atoi (text);a       if (i == 0)  	{ 	  if (reading_filename != 0)/< 	    fatal ("%s:%u: the `word' function takes a one-origin \ index argument",, 		   reading_filename, *reading_lineno_ptr); 	  else E 	    fatal ("the `word' function takes a one-origin index argument");  	}         p2 = p3;4       while ((p = find_next_token (&p2, &len)) != 0) 	if (--i == 0)	 	  break;r       if (i == 0)(( 	o = variable_buffer_output (o, p, len);         free (text);       free (p3);       break;       case function_words:!       /* Expand the argument.  */ )       text = expand_argument (text, end);u         i = 0;       p2 = text;<       while (find_next_token (&p2, (unsigned int *) 0) != 0) 	++i;p         {w 	char buf[20]; 	sprintf (buf, "%d", i);3 	o = variable_buffer_output (o, buf, strlen (buf));s       }r         free (text);       break;       case function_findstring:(C       /* Get two comma-separated arguments and expand each one.  */;       count = 0;"       for (p = text; p < end; ++p) 	{ 	  if (*p == startparen)
 	    ++count;p 	  else if (*p == endparen)r
 	    --count;t$ 	  else if (*p == ',' && count <= 0) 	    break;l 	}       if (p == end)1 	BADARGS ("findstring");'       text = expand_argument (text, p);   '       p = expand_argument (p + 1, end);   I       /* Find the first occurrence of the first string in the second.  */        i = strlen (text);&       if (sindex (p, 0, text, i) != 0)) 	o = variable_buffer_output (o, text, i);u              free (p);g       free (text);       break;            case function_addsuffix:     case function_addprefix:C       /* Get two comma-separated arguments and expand each one.  */e       count = 0;"       for (p = text; p < end; ++p) 	{ 	  if (*p == startparen)
 	    ++count;c 	  else if (*p == endparen) 
 	    --count;n$ 	  else if (*p == ',' && count <= 0) 	    break;e 	}       if (p == end) F 	BADARGS (function == function_addsuffix ? "addsuffix" : "addprefix");'       text = expand_argument (text, p);r       i = strlen (text);  (       p2 = expand_argument (p + 1, end);              p3 = p2;4       while ((p = find_next_token (&p3, &len)) != 0) 	{& 	  if (function == function_addprefix)- 	    o = variable_buffer_output (o, text, i);G* 	  o = variable_buffer_output (o, p, len);& 	  if (function == function_addsuffix)- 	    o = variable_buffer_output (o, text, i);p* 	  o = variable_buffer_output (o, " ", 1); 	  doneany = 1;/ 	}       if (doneany) 	/* Kill last space.  */ 	--o;               free (p2);       free (text);       break;            case function_dir:     case function_basename:p!       /* Expand the argument.  */n)       text = expand_argument (text, end);          p3 = text;5       while ((p2 = find_next_token (&p3, &len)) != 0)h 	{ 	  p = p2 + len;
 #ifdef VMSB 	  while (p >= p2 && *p != (function == function_dir ? ']' : '.')) #elsevB 	  while (p >= p2 && *p != (function == function_dir ? '/' : '.')) #endif	 	    --p;< 	  if (p >= p2)i 	    {$ 	      if (function == function_dir) 		++p;2 	      o = variable_buffer_output (o, p2, p - p2); 	    }% 	  else if (function == function_dir)d
 #ifdef VMS4             o = variable_buffer_output (o, "[]", 2); #else-4             o = variable_buffer_output (o, "./", 2); #endif 	  elsef, 	    /* The entire name is the basename.  */- 	    o = variable_buffer_output (o, p2, len);m  * 	  o = variable_buffer_output (o, " ", 1); 	  doneany = 1;= 	}       if (doneany) 	/* Kill last space.  */ 	--o;+              free (text);       break;            case function_notdir:      case function_suffix:i!       /* Expand the argument.  */S)       text = expand_argument (text, end);n         p3 = text;5       while ((p2 = find_next_token (&p3, &len)) != 0)+ 	{ 	  p = p2 + len;
 #ifdef VMSE 	  while (p >= p2 && *p != (function == function_notdir ? ']' : '.'))f #else E 	  while (p >= p2 && *p != (function == function_notdir ? '/' : '.'))e #endif	 	    --p;  	  if (p >= p2)u 	    {' 	      if (function == function_notdir)  		++p;9 	      o = variable_buffer_output (o, p, len - (p - p2));a 	    }( 	  else if (function == function_notdir)- 	    o = variable_buffer_output (o, p2, len);;  . 	  if (function == function_notdir || p >= p2) 	    {. 	      o = variable_buffer_output (o, " ", 1); 	      doneany = 1;  	    } 	}       if (doneany) 	/* Kill last space.  */ 	--o;u         free (text);       break;     }c     return o;  }(                                                      G /* Check for a function invocation in *STRINGP.  *STRINGP points at the G    opening ( or { and is not null-terminated.  If a function invocationaI    is found, expand it into the buffer at *OP, updating *OP, incrementingwO    *STRINGP past the reference and returning nonzero.  If not, return zero.  */    int  handle_function (op, stringp)u      char **op;       char **stringp;   {r   register unsigned int code;    unsigned int maxlen;   char *beg = *stringp + 1;    char *endref;o  4   endref = lindex (beg, beg + MAXFUNCTIONLEN, '\0');7   maxlen = endref != 0 ? endref - beg : MAXFUNCTIONLEN;n  8   for (code = 0; function_table[code].name != 0; ++code)     {u,       if (maxlen < function_table[code].len)
 	continue;.       endref = beg + function_table[code].len;-       if ((*endref == ' ' || *endref == '\t')w/ 	  && !strncmp (function_table[code].name, beg, # 		       function_table[code].len))  	break;      } %   if (function_table[code].name != 0)      {;<       /* We have found a call to an expansion-time function.9 	 Find the end of the arguments, and do the function.  */   J       char openparen = beg[-1], closeparen = openparen == '(' ? ')' : '}';       int count = 0;       char *argbeg;r       register char *p;   >       /* Space after function name isn't part of the args.  */       p = next_token (endref);       argbeg = p;   =       /* Count nested use of whichever kind of parens we use,p2 	 so that nested calls and variable refs work.  */         for (; *p != '\0'; ++p)e 	{ 	  if (*p == openparen)(
 	    ++count; , 	  else if (*p == closeparen && --count < 0) 	    break;u 	}  8       /* We found the end; expand the function call.  */  L       *op = expand_function (*op, function_table[code].function, argbeg, p);       *stringp = p;        return 1;s     }p     return 0;  }                                                       - /* Glob-expand LINE.  The returned pointer iss4    only good until the next call to string_glob.  */  
 static char *+ string_glob (line)      char *line; {+   static char *result = 0;   static unsigned int length;e!   register struct nameseq *chain;    register unsigned int idx;  L   chain = multi_glob (parse_file_seq (&line, '\0', sizeof (struct nameseq)),! 		      sizeof (struct nameseq));      if (result == 0)     {        length = 100; &       result = (char *) xmalloc (100);     }t  
   idx = 0;   while (chain != 0)     {r(       register char *name = chain->name;'       unsigned int len = strlen (name);t  )       struct nameseq *next = chain->next;        free ((char *) chain);       chain = next;   C       /* multi_glob will pass names without globbing metacharacters @ 	 through as is, but we want only files that actually exist.  */       if (file_exists_p (name))  	{ 	  if (idx + len + 1 > length) 	    { 	      length += (len + 1) * 2;t3 	      result = (char *) xrealloc (result, length);r 	    }# 	  bcopy (name, &result[idx], len);e 	  idx += len; 	  result[idx++] = ' ';  	}         free (name);     }n  6   /* Kill the last space and terminate the string.  */   if (idx == 0)      result[0] = '\0';d   else     result[idx - 1] = '\0';e     return result; })