 /* MAKE version 1.1, April 1987" Copyright (C) 1987 by Jesse Perry.; MAKE is in the public domain and may be freely distributed, 8 used, and modified, provided this notice is not removed.   mkdate.cA This file contains the routines which deal with file modification + dates, including the date caching routines.  */   #include <fab.h> #include <xab.h> #include "make.h"    typedef struct cache_entry { 	struct cache_entry *ce_next;  	DATE ce_filedate;< 	char ce_filename[1];	/* will actually be longer than one */ } CACHE_ENTRY;   static CACHE_ENTRY *Cacheptr;  static int Cache_n_cmd;   F /* Determine the modify date of the named file and put the date in theD buffer pointed to by fdateptr.  Return 0 for success, -1 if the date cannot be obtained. */   get_file_date(fname, fdateptr) char *fname; DATE *fdateptr;  {  	int dstat;  	int fnmdsc[2];   ) 	/* See if file is in file-date cache. */   # 	if (Cache_n_cmd != Num_cmd_sent) {  		clear_cache(); 		Cache_n_cmd = Num_cmd_sent; 3 	} else if (get_cache_date(fname, fdateptr) == 0) { 
 		return (0);  	}  5 	/* Since file not cached, we have to find it out. */   , 	fnmdsc[0] = strlen(fnmdsc[1] = (int)fname); 	if (Created) { 7 		dstat = getfdate(fnmdsc, fdateptr, NULL, NULL, NULL); 	 	} else { 7 		dstat = getfdate(fnmdsc, NULL, fdateptr, NULL, NULL);  	}  = 	/* If the date was found, add the file-date to the cache. */    	if (ERRSTAT(dstat)) { 		return (-1);	 	} else { " 		add_cache_date(fname, fdateptr); 	} 	return (0); }   ) /* See if a file-date is in the cache. */    static get_cache_date(fname, fdateptr)  char *fname; DATE *fdateptr;  {  	register CACHE_ENTRY *cptr;  < 	for (cptr = Cacheptr; cptr != NULL; cptr = cptr->ce_next) {/ 		if (COMPARE(fname, cptr->ce_filename) == 0) {  			if (fdateptr != NULL) {2 				fdateptr->date_lo = cptr->ce_filedate.date_lo;2 				fdateptr->date_hi = cptr->ce_filedate.date_hi; 			} #ifdef CACHE_DEBUG0 printf("**** %s date found in cache.\n", fname); #endif 			return (0); 		}  	}
 	return (-1);  }   ' /* Add a new file-date to the cache. */    static add_cache_date(fname, fdateptr)  char *fname; DATE *fdateptr;  {  	register CACHE_ENTRY *cptr;  F 	cptr = (CACHE_ENTRY *)err_alloc(sizeof(CACHE_ENTRY) + strlen(fname));# 	strecpy(fname, cptr->ce_filename); / 	cptr->ce_filedate.date_lo = fdateptr->date_lo; / 	cptr->ce_filedate.date_hi = fdateptr->date_hi;    	cptr->ce_next = Cacheptr; 	Cacheptr = cptr;    #ifdef CACHE_DEBUG0 printf("**** %s date added to cache.\n", fname); #endif 	return (0); }   9 /* Empty the cache -- a command has been executed, so any 0 or all of the cached file-dates may be wrong. */   static
 clear_cache()  { & 	register CACHE_ENTRY *cptr, *nextptr;  6 	for (cptr = Cacheptr; cptr != NULL; cptr = nextptr) { 		nextptr = cptr->ce_next;
 		free(cptr);  	} 	Cacheptr = NULL;  #ifdef CACHE_DEBUG  printf("**** Cache cleared.\n"); #endif }   > /* Set the modification date of a file to the current time. */   touch_file(filename) char *filename;  {  	int fnmdsc[2], currtime[2];   	if (Verbose) { * 		printf("\r\nTouching %s\r\n", filename); 	}/ 	fnmdsc[0] = strlen(fnmdsc[1] = (int)filename); H 	currtime[0] = currtime[1] = 0;	/* setfdate will fill in current time */ 	if (Created) { / 		setfdate(fnmdsc, currtime, NULL, NULL, NULL); 	 	} else { / 		setfdate(fnmdsc, NULL, currtime, NULL, NULL);  	} }   G /* Return TRUE if the date pointed to by depdptr is later than the date  pointed to by targdptr. */   out_of_date(depdptr, targdptr) DATE *depdptr, *targdptr;  { 0 	return (depdptr->date_hi > targdptr->date_hi ||. 	    (depdptr->date_hi == targdptr->date_hi &&, 	    depdptr->date_lo > targdptr->date_lo)); }   - /* Print the ascii version of a file date. */    printdate(bindate) register DATE *bindate;  {  	STR_DESC date_desc; 	char datebuf[ASCII_DATE_LEN];  8 	if (bindate->date_lo == -1 && bindate->date_hi == -1) { 		printf("<DATE UNAVAILABLE>");  		return (-1); 	}  # 	date_desc.sd_len = ASCII_DATE_LEN;  	date_desc.sd_str = datebuf;  	datebuf[ASCII_DATE_LEN] = '\0';' 	sys$asctim(NULL, &date_desc, bindate);    	printf(datebuf);  	return (0); } 