 
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *
 *
 *
 *                %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%\
 *                %% \___________________________________%% \
 *                %% |                                   %%  \
 *                %% |              REMTREE              %%   \
 *                %% |          support.c  c2004         %%    \
 *                %% |            Lyle W. West           %%    |
 *                %% |                                   %%    |
 *                %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%    |
 *                \                                        \   |
 *                 \                                        \  |
 *                  \                                        \ |
 *                   \________________________________________\|
 *
 *
 *
 *  Copyright (C) 2004 Lyle W. West, All Rights Reserved.
 *  Permission is granted to copy and use this program so long as [1] this
 *  copyright notice is preserved, and [2] no financial gain is involved
 *  in copying the program.  This program may not be sold as "shareware"
 *  or "public domain" software without the express, written permission
 *  of the author.
 *
 *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
 
#include "version.h"
#pragma module SUPPORT VERSION
 
#include <clidef.h>
#include <climsgdef.h>
#include <descrip.h>
#include <iodef.h>
#include <lmfdef.h>
#include <ossdef.h>         /* defines for $get/$set_security calls */
#include <prvdef.h>
#include <psldef.h>
#include <rms.h>
#include <rmsdef.h>
#include <ssdef.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "defs.h"
 
globalvalue CTL$AG_CLIDATA;
globalvalue PRC_L_RECALLPTR;
globalvalue PPD$L_PRC;
globalvalue PRC_S_COMMANDS;
globalvalue REMTREE_CLD;
 
extern int NumDirs;
extern int NumFiles;
extern int NumSubDirs;
extern int TotalAlloc;
extern int TotalUsed;
extern int alloc_size;
extern int used_size;
 
extern short ConfirmFlg;           /* confirm deletion of each file in the tree */
extern short LogFlg;               /* log deletion of each file in the tree */
extern short RetainFlg;            /* retain target dir and files therein */
 
extern char CmdVerb[32];           /* foreign command invoking this image */
extern char TargetPath[132];       /* directory to recursively delete tree */
 
extern int DotSort();
extern int lib$get_input();
extern void ShowHelp();
extern void ShowMessage();
extern void ShowVers();
 
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *
 *    Function: CheckFilePath
 * Description: CheckFilePath parses the passed pathname for validity by
 *              requesting a wildcard parse/search operation on target.
 *              If the path is valid, we return RMS$_NORMAL, else return
 *              status value from SYS$PARSE or SYS$SEARCH. This routine
 *              is probably redundant.
 *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
int CheckFilePath(char *Path)
{
    int chkstat;
 
    char ps_rsa[132];               /* parse expanded filename */
    char ps_esa[132];               /* search resultant filename */
    char tempspec[132];
 
    struct FAB CheckFab;            /* FAB Structure for P1 */
    struct NAM CheckNam;            /* NAM Structure for P1 */
 
        /* initialize Fab & Nam structures */
 
    strcpy(tempspec, Path);
    strcat(tempspec, "*.DIR;");
 
    CheckFab = cc$rms_fab;
    CheckFab.fab$l_fna = tempspec;  /* name of file */
    CheckFab.fab$b_fns = strlen(tempspec);
    CheckFab.fab$l_nam = &CheckNam; /* FAB has an associated NAM */
    CheckNam = cc$rms_nam;          /* (currently not used) */
    CheckNam.nam$l_esa = &ps_esa;   /* expanded filespec */
    CheckNam.nam$b_ess = sizeof(ps_esa);
    CheckNam.nam$l_rsa = &ps_rsa;   /* resultant filespec */
    CheckNam.nam$b_rss = sizeof(ps_rsa);
 
        /* perform sys$parse and sys$search on CheckFab */
 
    chkstat = sys$parse(&CheckFab);
    if(chkstat != RMS$_NORMAL) return(chkstat);
    ps_esa[CheckNam.nam$b_esl] = '\0';
    chkstat = sys$search(&CheckFab);
    if(chkstat != RMS$_NORMAL) return(chkstat);
    ps_rsa[CheckNam.nam$b_rsl] = '\0';
    return(RMS$_NORMAL);
}
 
 
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *
 * Function: CheckPrv
 * Description: Verify user running this image has sufficient privs
 *              to access any file on system in read mode. Currently,
 *              BYPASS will permit all necessary access. If priv
 *              not available then exit with nopriv error code.
 *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
int CheckPrv()
{
    int enabflg = 1;
    int prmflg = 0;
    int PrvStat;
    int PrivMask1 = 0;
    int PrivMask2 = 0;
    int CurPriv[2] = 0;
 
    struct  {short len, code; int *bufadr, *retlen;} JpiItem[2];
 
    JpiItem[0].len = sizeof(CurPriv);
    JpiItem[0].code = JPI$_CURPRIV;
    JpiItem[0].bufadr = &CurPriv;
    JpiItem[0].retlen = 0;
    JpiItem[1].len = 0;
    JpiItem[1].code = 0;
 
    PrivMask2 |= PRV$M_BYPASS;
    PrivMask1 |= PRV$M_SETPRV;
    PrvStat = sys$getjpiw(0, 0, 0, &JpiItem, 0, 0, 0);
    if(PrvStat != SS$_NORMAL) exit(PrvStat);
    if((CurPriv[0] & PrivMask2) == PrivMask2) return(SS$_NORMAL);
    if(PrivMask1 & CurPriv[0]) {
        CurPriv[0] |= (PRV$M_SETPRV + PRV$M_BYPASS);
        PrvStat = sys$setprv(enabflg, &CurPriv, prmflg, 0);
        return(PrvStat);
    }
    return(SS$_NOPRIV);     /* if we get here, we failed */
}
 
 
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *
 *    Function: DeleteFiles
 * Description: deletes all files in the subdirectory specified in the
 *              input argument 'InputPath'. If the command line included
 *              the /CONFIRM qualifier, user is prompted with each filename.
 *              This routine is called for each subdirectory located in the
 *              file tree specified by the command line.
 *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
int DeleteFiles(char *InputPath)
{
    int CheckConfirm = TRUE;
    int DelStat;
    int DeleteOK = TRUE;     /* delete the file(s) or not */
    int FirstPass  = TRUE;
    int context = 0;
    int dircount = 0;
    int filecount = 0;
    int localalloc = 0;
    int localused = 0;
    int done = 0;
    int flag = 0;
 
    char FileName[60];
    char Path[132];
    char FileSpec[132];
    char Response[30];
    char answer[30];
    char *ptr;
 
    $DESCRIPTOR(Dsc_Dir, Path);
    $DESCRIPTOR(Dsc_File, FileName);
    $DESCRIPTOR(Dsc_Rslt, FileSpec);
    $DESCRIPTOR(Dsc_Ans, answer);
 
 
    strcpy(Path, InputPath);
    strcat(Path, "*.*;*");
    Dsc_Dir.dsc$w_length = strlen(Path);
 
    while(!done) {
        if(LogFlg && FirstPass) printf("\n Target: %s\n", InputPath);
        Dsc_Rslt.dsc$w_length = sizeof(FileSpec);
        DelStat = lib$find_file(&Dsc_Dir, &Dsc_Rslt, &context, 0, 0, 0, &flag);
        if(DelStat != RMS$_NORMAL) {
            if(DelStat == RMS$_NMF) {
                if(LogFlg) printf("%22s%2d files deleted, %d/%d blocks\n",
                    " ", filecount, localused, localalloc);
                return(SS$_NORMAL);
            }
            else return(DelStat);
        }
        ptr = strchr(FileSpec, ' ');
        if(ptr) *ptr = 0;
        Dsc_Rslt.dsc$w_length = strlen(FileSpec);
        ptr = strrchr(FileSpec, ']');
        if(ptr) {
            ptr++;
            strcpy(FileName, ptr);
        }
 
        /* delete files */
 
        if(ConfirmFlg) {
            if(CheckConfirm) {
                printf("  DELETE %s (Yes, No, All, Quit): ", FileName);
                gets(&answer);
                if(strlen(answer)) {
                    Dsc_Ans.dsc$w_length = strlen(answer);
                    DelStat = str$upcase(&Dsc_Ans, &Dsc_Ans);
                }
                switch( (int) answer[0]) {
                    case 'Y':
                        DeleteOK = TRUE;
                        break;
                    case 'Q':
                    case 'N':
                        DeleteOK = FALSE;
                        return(2099);   /* SYSTEM-I-CANCEL */
                        break;
                    case 'A':
                        CheckConfirm = FALSE;
                        DeleteOK = TRUE;
                        break;
                    default:
                        return(SS$_INVARG);
                        break;
                }
            }
        }
 
        /* if DeleteOK is set we will delete current file */
 
        if(DeleteOK) {
            DelStat = GetBlockValues(FileSpec);
            if(DelStat != SS$_NORMAL) exit(DelStat);
            DelStat = lib$delete_file(&Dsc_Rslt);
            switch(DelStat) {
                case SS$_NORMAL:
                    localalloc += alloc_size;
                    localused += used_size;
                    NumFiles++;     /* global file counter */
                    if(LogFlg) {
                        printf("%30s deleted, %d/%d blocks\n", FileName,
                            used_size, alloc_size);
                    }
                    filecount++;    /* local file counter */
                    break;
 
                case RMS$_PRV:
                    printf("%%%s-E-NOPRIV, cannot delete %s\n",
                        CmdVerb, FileName);
                    exit(SS$_NORMAL);
 
                default:
                    return(18);
            }
        }
        FirstPass = FALSE;
    }           /* end of while */
 
    if(LogFlg) printf("   Deleted %d files, %d/%d blocks\n",
        filecount, localused, localalloc);
    return(SS$_NORMAL);
}
 
 
 
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *
 * Function: DotSort
 * Description: This is the qsort compare routine. We generate this from
 *              a generic model. Here, file1 and file2 represent two
 *              objects being comared. This routine sorts the integer
 *              DotCount between two objects in descending order
 *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
int DotSort(SORT_LST *file1, SORT_LST *file2)
{
        /* descending order */
 
    if(file1->DotCount > file2->DotCount) return(-1);
    else {
        if(file2->DotCount > file1->DotCount) return(1);
        else return(0);
    }
 
#ifdef ARF
        /* ascending order */
 
    if(file1->DotCount > file2->DotCount) return(1);
    else {
        if(file2->DotCount > file1->DotCount) return(-1);
        else return(0);
    }
#endif
}
 
 
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *
 *    Function: GetBlockValues
 * Description: the filename about to be deleted is specified by the
 *              input argument 'FileSpec'. Initialize fab and xab
 *              structures then open and close specified file to fill
 *              in the structures. Extract number of blocks allocated
 *              and used to global buffers, then return.
 *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
int GetBlockValues(char *FileSpec)
{
    int BlockStat;
 
    struct FAB AllocFab;            /* file alloccation block */
    struct XABFHC XabFhc;           /* file header characteristic XAB */
 
    AllocFab = cc$rms_fab;          /* init FAB structure */
    XabFhc = cc$rms_xabfhc;         /* init XABFHC structure*/
 
    AllocFab.fab$l_fna = FileSpec;
    AllocFab.fab$b_fns = strlen(FileSpec);
    AllocFab.fab$b_fac = FAB$M_GET;
    AllocFab.fab$l_fop = FAB$V_NAM;
    AllocFab.fab$l_xab = (char *) &XabFhc;   /* chain the file header xab */
 
    BlockStat = SYS$OPEN(&AllocFab);
    if(BlockStat != RMS$_NORMAL) return(BlockStat); /* SYSTEM-E-BADPARAM */
    BlockStat = SYS$CLOSE(&AllocFab);
    if(BlockStat != RMS$_NORMAL) return(BlockStat); /* SYSTEM-E-BADPARAM */
 
    alloc_size = AllocFab.fab$l_alq;
    used_size = XabFhc.xab$l_ebk;
    TotalAlloc += alloc_size;
    TotalUsed += used_size;
 
    return(SS$_NORMAL);
}
 
 
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *
 *    Function: GetCliInfo
 * Description: check for parameters and qualifiers which were entered
 *              at the command line. If values are required, verify syntax
 *              and set respective variables.
 *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
void GetCliInfo()
{
    char Buffer[80];               /* temporary string buffer */
    char CliStr[80];               /* cli string buffer */
    char CmdLine[132];             /* buffer reflecting input cmd line */
    char LineBuf[132];
 
    int CliStat;                   /* return status from cli calls */
 
    short BufLen;
    short CliStrLen;               /* integer for cli value sizes */
    short CmdLen;
 
    $DESCRIPTOR(DscCli, CliStr);   /* cli param or qualifier string */
    $DESCRIPTOR(DscBuf, Buffer);   /* string returned by cli$get_value */
    $DESCRIPTOR(DscLbuf, LineBuf);
    $DESCRIPTOR(DscCmd, CmdLine);
 
        /* get parameter and qualifier(s) from command line, prefix the
           CLD declared verb and use CLI$DCL_PARSE to build the cmd table */
 
    CliStat = lib$get_foreign(&DscCmd, 0, &CmdLen, 0);
    if(CliStat != SS$_NORMAL) exit(CliStat);
    CmdLine[CmdLen] = '\0';
    strcpy(LineBuf, "REMTREE ");
    strcat(LineBuf, CmdLine);
    DscLbuf.dsc$w_length = strlen(LineBuf);
    CliStat = cli$dcl_parse(&DscLbuf, REMTREE_CLD, lib$get_input, 0, 0);
    if(CliStat != CLI$_NORMAL) exit(CliStat);
 
        /* check for presence of HELP or VERSION qualifiers */
 
    strcpy(CliStr, "VERSION");
    DscCli.dsc$w_length = strlen(CliStr);
    CliStat = cli$present(&DscCli);
    if(CliStat == CLI$_PRESENT) ShowVers();
 
    strcpy(CliStr, "HELP");
    DscCli.dsc$w_length = strlen(DscCli.dsc$a_pointer);
    CliStat = cli$present(&DscCli);
    if(CliStat == CLI$_PRESENT) ShowHelp();
 
        /* check for CONFIRM qualifier */
 
    strcpy(CliStr, "CONFIRM");
    DscCli.dsc$w_length = strlen(DscCli.dsc$a_pointer);
    CliStat = cli$present(&DscCli);
    if(CliStat == CLI$_PRESENT) ConfirmFlg = TRUE;
 
        /* check for LOG qualifier */
 
    strcpy(CliStr, "LOG");
    DscCli.dsc$w_length = strlen(DscCli.dsc$a_pointer);
    CliStat = cli$present(&DscCli);
    if(CliStat == CLI$_PRESENT) LogFlg = TRUE;
 
        /* check for RETAIN qualifier */
 
    strcpy(CliStr, "RETAIN");
    DscCli.dsc$w_length = strlen(DscCli.dsc$a_pointer);
    CliStat = cli$present(&DscCli);
    if(CliStat == CLI$_PRESENT) RetainFlg = TRUE;
 
        /* get filepath info for target dir */
 
    strcpy(CliStr, "PATH");
    DscCli.dsc$w_length = strlen(DscCli.dsc$a_pointer);
    CliStat = cli$present(&DscCli);
    if(CliStat == CLI$_PRESENT) {
        CliStat = cli$get_value(&DscCli, &DscBuf, &CliStrLen);
        if(CliStat == SS$_NORMAL) {
            Buffer[CliStrLen] = '\0';
            strcpy(TargetPath, Buffer);    /* input path to compare */
        }
    }
    else {          /* Filepath not specified on command line */
        exit(0x381F0);
    }    /* %CLI-W-ABSENT, entity or value absent from command string */
}
 
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *
 *    Function: GetCmdLine
 * Description: Retrieve the last command entered from the command recall
 *              buffer in the users process space, the command which was
 *              used to invoke this image. The contents of this recall buf
 *              are saved in a user specified buffer. In the unlikely event
 *              that the command line is longer than callers buffer, set
 *              length to -1 and return SS$_BUFFEROVF. Else return SS$_NORMAL
 *
 *              This routine is aware of buffer length changes implemented
 *              in VMS 7.3-2 and above.
 *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
int GetCmdLine(struct dsc$descriptor_s *DscTarget, short *length)
{
    char    *Sptr = 0;      /* last recall buffer pointer */
    char    *Dptr = 0;      /* callers string destination pointer */
 
    short   ExpBuf = 0;
    short   *Lptr = 0;      /* pointer to callers length word */
 
    int     BufSize;
    int     RecallAddr = 0;
    int     ppd = 0;
    int     prc = 0;
    int     *Iptr = 0;      /* integer pointer for indirection */
 
        /* recall buffer larger for V7.3-2 and higher. Use this info
           to determine whether recall buffer length is presented to
           us as a byte or a word */
 
    BufSize = PRC_S_COMMANDS;       /* get size of rcl buf */
    if(BufSize > 4100)
        ExpBuf = TRUE;              /* if < 4100, osvers <= 7.3-1 */
 
    RecallAddr = CTL$AG_CLIDATA;    /* address of ppd */
    RecallAddr += PPD$L_PRC;        /* address of prc */
    prc = PRC_L_RECALLPTR;          /* current command pointer */
    Iptr = RecallAddr;              /* pseudo pointer register */
    RecallAddr = *Iptr;
    RecallAddr += prc;              /* offset */
    Iptr = RecallAddr;              /* copy to pointer register */
    RecallAddr = *Iptr;             /* RecallAddr points to end of buffer */
 
        /* here we use recall allocation to determine the size of
           the recall buffer length field, changed at vms 7.3.2 */
 
    if(ExpBuf) RecallAddr -= 2;     /* length is 16 bits at 7.3-2+ */
    else RecallAddr--;              /* else length is 8 bits */
    Sptr = RecallAddr;
    Dptr = DscTarget->dsc$a_pointer;
 
        /* be sure cmd line not longer than callers buffer. If so,
           ignore cmd line and return SS$_BUFFEROVF */
 
    if(ExpBuf) {
        Lptr = Sptr;
        if(*Lptr < DscTarget->dsc$w_length-1) *length = *Lptr; /* 16 bit val */
        else {
            *length = -1;
            return(SS$_BUFFEROVF);
        }
    }
    else *length = *Sptr;       /*  8 bit value */
 
        /* get buffer length and copy cmd line to callers buffer */
 
    Sptr -= *length;
    strncpy(Dptr, Sptr, *length);
    return(SS$_NORMAL);
}
 
 
 
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *
 * Function: ShowHelp
 * Description: Display a brief combination of REMTREE.README and the cdu
 *              REMTREE.CLD file. It provides a command line glance at the
 *              optional implementations of REMTREE usage.
 *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
void ShowHelp()
{
    printf("\n  %s (%s)\n\n", CmdVerb, VERSION);
    printf("\tDeletes all subdirectories and respective files in a tree\n");
    printf("\tspecified by the command line parameter.\n\n");
    printf("      Parameter:\n\n");
    printf("\tPATH - the filepath to the file tree of subdirectories to be\n");
    printf("\t\tremoved. The filepath can be specified by use of logical\n");
    printf("\t\tnames. For example:\n\n");
    printf("\t\t\t$ %s /LOG AXPECO:[V731]\n\n", CmdVerb);
    printf("      Qualifiers\n\n");
    printf("\t/CONFIRM - %s will prompt the user to confirm deletion of the\n",
                CmdVerb);
    printf("\t\tspecified file. The user is presented with options clause of\n");
    printf("\t\t(Yes, No, All, Quit). Responding with 'Yes' deletes file.\n");
    printf("\t\tResponding with 'All' deletes all files in that dir without\n");
    printf("\t\tfurther confirmation. Entry of 'No' or 'Quit' exits program.\n\n");
    printf("\t/LOG - if present, %s will log to sys$output all directory\n",
                CmdVerb);
    printf("\t\tpaths, file deletions, and blocks freed.\n\n");
    printf("\t/RETAIN - if present, %s will not delete the base directory\n",
                CmdVerb);
    printf("\t\tand the files in that directory. If omitted, the files and\n");
    printf("\t\tthe base directory, as specified in PATH parameter, are\n");
    printf("\t\tremoved without prompting.\n\n");
    printf("\t/HELP - Displays this text\n\n");
    printf("\t/VERSION - Displays version, build date,\n");
    printf("\t\tand required privs for VMS Install utility.\n\n");
    exit(1);
}
 
 
 
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *
 * Function: ShowVers
 * Description: Displays current installed version, build date, and
 *              required privs for interactive usage and/or the VMS
 *              install utility (note bypass used for directories).
 *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
void ShowVers()
{
    printf("\n\t\t%s by Lyle W West\n", CmdVerb);
    printf("\t\tVersion: %s (%s)\n", VERSION, ARCH ? "Alpha" : "Vax");
    printf("\t\tImage Build: %s (%s)\n", __DATE__, "DecC");
#ifdef SECURE
    printf("\t\tRequired Privs: BYPASS [Secure]\n\n");
#else
    printf("\t\tRequired Privs: BYPASS\n\n");
#endif
    exit(1);
}
 
