   L /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  *  *<  *                %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%\=  *                %% \___________________________________%% \ >  *                %% |                                   %%  \?  *                %% |               CHFPRO              %%   \ @  *                %% |           chfpro.c  c2004         %%    \@  *                %% |            Lyle W. West           %%    |@  *                %% |                                   %%    |@  *                %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%    |@  *                \                                        \   |@  *                 \                                        \  |@  *                  \                                        \ |@  *                   \________________________________________\|  *  *  *9  *  Copyright (C) 2004 Lyle W. West, All Rights Reserved. J  *  Permission is granted to copy and use this program so long as [1] thisH  *  copyright notice is preserved, and [2] no financial gain is involvedH  *  in copying the program.  This program may not be sold as "shareware"G  *  or "public domain" software without the express, written permission   *  of the author.  *L  *  CHFPRO has been designed as a system management tool and is not intendedJ  *  to be accessed by general users. As described below, certain privs areI  *  required to succesfully execute CHFPRO. Additionally, if the image is J  *  located where global access is available, it is prudent for the sysmgr   *  to have trusted users enter:  *,  *      DEFINE /JOB /EXEC SECURE_LNM ENABLED  *J  *  prior to attempting execution. If usage of CHFPRO is attempted withoutL  *  the above logical defined in users job table, the image will immediatelyK  *  exit with a priv message. If you encounter this symtom, enter following H  *  command: '$ CHFPRO /VERSION' and if the word 'Secure' appears on theI  *  last line, the above logical is needed. Note that this information is O  *  not documented elsewhere. This is a poor mans substitute for an identifier. K  *  Note also, this must be defined as an executive mode logical. There may L  *  be some users with the ability to determine the need for this logical toM  *  be defined in the JOB table, but not be able to define it with EXEC priv.   *  *  To build with SECURE enter:   *8  *      $ @BUILD SECURE [DEBUG]     (see file BUILD.COM)  *K  *  Online help is available only after the foreign symbol is defined; from   *  DCL simply enter:   *  *      CHFPRO /HELP  *M  *  Previous versions of CHFDAT required user to set default to the directory N  *  to which changes were to be performed. This restriction no longer applies.  *@  *  This application must be relinked if the current VMS version+  *  is upgraded to version 7.3-2 or higher.   *M  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */     #define VERSION "V1.2-2" #pragma module CHFPRO VERSION     #include <stdio.h> #include <ctype.h> #include <descrip.h> #include <dvidef.h>  #include <jpidef.h>  #include <lib$routines.h>  #include <prvdef.h>  #include <ssdef.h> #include <starlet.h> #include <string.h>  #include <stdlib.h> E #include <rms.h>                    /* Include the RMS definitions */    D struct FAB PsFab;                   /* parse-search FAB Structure */D struct NAM PsNam;                   /* parse-search NAM Structure */   8 struct {short len, code; char *buf, *retlen;} DviItm[2];    int status;    G char CmdProtStr[32];                /* file prot str entered by user */ M char CmdVerb[32];                   /* foreign command inviking this image */ A char DevName[24];                   /* target disk device name */ M char InputFile[80];                 /* input file to change (from cmdline) */  char NewProtStr[32]; char OldProtStr[32]; char ProtStr[30]; P char TargetFspec[80];               /* target filespec, change prot operation */   C short NewProt;                      /* target file prots at exit */ D short OldProt;                      /* target file prots at entry */M short ProtFlg;                      /* TRUE if /protection qualifier valid */     extern int CheckPrv();   M #define DEV$M_SWL 0x2000000         /* is device is software write locked? */     #ifdef __ALPHA #define ARCH 1 #else  #define ARCH 0 #endif   L /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  main routineM  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */ 
 int main() { O     int devchar;                    /* device characteristics of target disk */ 
     int indx;    @     short CvLen;                    /* Length of command verb */     short UicLen = 0;         char CmdLine[80]; P     char TargetFname[40];           /* target filename, change prot operation */     char enable_lnm[32];     char tmpspec[64]; L     char PsEsa[NAM$C_MAXRSS];       /* extended filespec (from SYS$PARSE) */M     char PsRsa[NAM$C_MAXRSS];       /* resultant filespec (from SYS$SEARCH */      char LineBuf[132];     char *DviPtr;      char *ptr = 0;   !     $DESCRIPTOR(DscCmd, CmdLine); !     $DESCRIPTOR(DscDev, DevName); F     $DESCRIPTOR(DscVerb, CmdVerb);  /* foreign invoking symbol name */        DviItm[0].len    = 4; $     DviItm[0].code   = DVI$_DEVCHAR;>     DviItm[0].buf    = &devchar;    /* disk characteristics */     DviItm[0].retlen = 0;      DviItm[1].len    = 0;      DviItm[1].code   = 0;         PsFab = cc$rms_fab;      PsNam = cc$rms_nam;    D         /* initialize the security logical name, even if not used */   %     strcpy(enable_lnm, "SECURE_LNM");    <         /* get the command line used to invoke this image */   M     status = GetCmdLine(&DscCmd, &CvLen);  /* get invoking foreign cmd str */ *     if(status != SS$_NORMAL) exit(status);     CmdLine[CvLen] = 0;    3         /* extract foreign cmd verb from CmdLine */    $     sscanf(CmdLine, "%s", &CmdVerb);     ptr = strchr(CmdVerb, '/');      if(ptr) *ptr = '\0';+     DscVerb.dsc$w_length = strlen(CmdVerb); ,     status = str$upcase(&DscVerb, &DscVerb);   2         /* get the cli values from command line */        GetCliInfo();    M         /* check for presence of several security parameters for this user */    >     status = CheckPrv();            /* sysprv and/or bypass */*     if(status != SS$_NORMAL) exit(status);   D         /* call 'CheckLnm' to verify correct JOB table definition */   
 #ifdef SECURE K         /* Some notes about error messages from the next few lines of code: J             W-AUTHFAIL - indicates logical IS defined, but the equivalenceC                          string is defined incorrectly (lowercase?) I             F-AUTHFAIL - Indicates the logical name is not defined in the E                          user's LNM$JOB table or wrong access mode */    7     status = CheckLnm(&enable_lnm, sizeof(enable_lnm)); J     if(status == SS$_NORMAL) { /* this says logical defined to some str */M         if(strcmp(enable_lnm, "ENABLED") != 0) { /* must match this string */ M             exit(0x2760);     /* %SYSTEM-W-AUTHFAIL, authorization failure */ 	         }      } M     else exit(0x2764);        /* %SYSTEM-F-AUTHFAIL, authorization failure */  #endif      :         /* initialize parse/search Fab & Nam structures */         PsFab.fab$l_dna = InputFile;(     PsFab.fab$b_dns = strlen(InputFile);     PsFab.fab$l_nam = &PsNam;    L     PsNam.nam$l_esa = PsEsa;            /* sys$parse Expanded string area */=     PsNam.nam$b_ess = sizeof(PsEsa);    /* esa buffer size */ N     PsNam.nam$l_rsa = PsRsa;            /* sys$search Resultant string area */?     PsNam.nam$b_rss = sizeof(PsRsa);    /* PsRsa buffer size */    B         /*  This section first does the parse of the input string.F          *  It checks the value of the return status, and if not equalE          *  to RMS$_NORMAL, the program exits with the return status.           */    ;     if((status = sys$parse(&PsFab, 0, 0)) == RMS$_NORMAL) { &         PsEsa[PsNam.nam$b_esl] = '\0';(         printf("\nTarget: %s\n", PsEsa);   I         /* Before we go any deeper, the rest of the code is irrelevant if J          * we can't change anything because this is a readonly device. GetM          * the device name. Use $GETDVI to check, then exit if not writeable. A          * If DVI$M_SWL is clear, then we can make modifications.           */    -         memset(&DevName, 0, sizeof(DevName)); ;         strncpy(DevName, PsNam.nam$l_dev, PsNam.nam$b_dev); 1         DscDev.dsc$w_length = PsNam.nam$t_dvi[0]; A         status = sys$getdviw(0, 0, &DscDev, &DviItm, 0, 0, 0, 0); .         if(status != SS$_NORMAL) exit(status);@         if(devchar & DEV$M_SWL) exit(0x182ba);  /* %RMS-E-WLK */   A         /*  Here we actually search for the file. If it is found, F          *  the file owner is changed to 'NewOwner' value, rev date isG          *  retained, log data is displayed and we search again for the C          *  next file. If it is not found, the search stops and the =          *  program exits with the value of the return status 8          *  Other errors are shown inline when possible.          */    C         while((status = sys$search(&PsFab, 0, 0)) == RMS$_NORMAL) { *             PsRsa[PsNam.nam$b_rsl] = '\0';'             strcpy(TargetFspec, PsRsa); %             ptr = strchr(PsRsa, ']');              ptr++;%             strcpy(TargetFname, ptr);              if(ProtFlg) { (                 status = ProcFileProt();6                 if(status != SS$_NORMAL) exit(status);<                 printf("  %30s  %21s --> %s\n", TargetFname,0                         OldProtStr, NewProtStr);
             } 	         }      }         printf("\n"); C     if(status == RMS$_NMF) exit(SS$_NORMAL);     /* exit quietly */ :     exit(status);   /* Else exit with the return status */ }                N /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  * Function: CheckPrv C  * Description: Verify user running this image has sufficient privs B  *              to access any record in SYSUAF.DAT file. Curently,B  *              SYSPRV will permit all necessary changes. If privs?  *              not available then exit with nopriv error code.   *O  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */  int CheckPrv() {      int enabflg = 1;     int prmflg = 0;      int PrvStat;     int PrivMask = 0;      int ProcPriv[2] = 0;   @     struct  {short len, code; int *bufadr, *retlen;} JpiItem[2];   &     JpiItem[0].len = sizeof(ProcPriv);$     JpiItem[0].code = JPI$_PROCPRIV;"     JpiItem[0].bufadr = &ProcPriv;     JpiItem[0].retlen = 0;     JpiItem[1].len = 0;      JpiItem[1].code = 0;   6     PrvStat = sys$getjpiw(0, 0, 0, &JpiItem, 0, 0, 0);,     if(PrvStat != SS$_NORMAL) exit(PrvStat);  =         /* determine priv required and see if they are set */        PrivMask |= PRV$M_SYSPRV;    @     if((ProcPriv[0] & PrivMask) == PrivMask) return(SS$_NORMAL);       PrivMask |= PRV$M_SETPRV;      ProcPriv[0] |= PrivMask;8     PrvStat = sys$setprv(enabflg, &ProcPriv, prmflg, 0);F     if(PrvStat != SS$_NORMAL) exit(1666);   /* not all req privs... */     else return(SS$_NORMAL); }       H /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  * Function: ShowVers C  * Description: Displays current installed version, build date, and C  *              required privs for interactive usage and/or the VMS C  *              install utility (note bypass used for directories).   *K  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */  void ShowVers()  { 1     printf("\n\t\t%s by Lyle W West\n", CmdVerb); F     printf("\t\tVersion: %s (%s)\n", VERSION, ARCH ? "Alpha" : "Vax");;     printf("\t\tImage Build: %s (%s)\n", __DATE__, "DecC");    
 #ifdef SECURE 6     printf("\t\tRequired Privs: SYSPRV [Secure]\n\n"); #else -     printf("\t\tRequired Privs: SYSPRV\n\n");  #endif     exit(1); }                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                