L /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  *  *<  *                %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%\=  *                %% \___________________________________%% \ >  *                %% |                                   %%  \?  *                %% |               CHFPRO              %%   \ @  *                %% |          utility.c  c2004         %%    \@  *                %% |            Lyle W. West           %%    |@  *                %% |                                   %%    |@  *                %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%    |@  *                \                                        \   |@  *                 \                                        \  |@  *                  \                                        \ |@  *                   \________________________________________\|  *  *  *9  *  Copyright (C) 2004 Lyle W. West, All Rights Reserved. J  *  Permission is granted to copy and use this program so long as [1] thisH  *  copyright notice is preserved, and [2] no financial gain is involvedH  *  in copying the program.  This program may not be sold as "shareware"G  *  or "public domain" software without the express, written permission   *  of the author.  *@  *  This application must be relinked if the current VMS version+  *  is upgraded to version 7.3-2 or higher.   *M  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */     #define VERSION "V1.2-2" #pragma module UTILITY VERSION    #include <stdio.h> #include <atrdef.h>  #include <climsgdef.h> #include <ctype.h> #include <descrip.h> #include <fibdef.h>  #include <jpidef.h>  #include <lnmdef.h>  #include <psldef.h>  #include <ssdef.h> #include <stat.h>  #include <string.h>  #include <stdlib.h> A #include <rms.h>                /* Include the RMS definitions */  #include <xabprodef.h>    globalvalue CTL$AG_CLIDATA;  globalvalue PRC_L_RECALLPTR; globalvalue PPD$L_PRC; globalvalue PRC_S_COMMANDS;     #define STR$_TRU 2392576   D extern struct FAB PsFab;            /* parse-search FAB Structure */D extern struct NAM PsNam;            /* parse-search NAM Structure */    extern int status;   D extern short OldPriv;               /* target file privs at entry */C extern short NewPriv;               /* target file privs at exit */ M extern short ProtFlg;               /* TRUE if /protection qualifier valid */    G extern char CmdProtStr[32];         /* file prot str entered by user */ L extern char CmdVerb[32];            /* foreign symbol invoking this image */K extern char InputFile[64];          /* input file to change from cmdline */  extern char NewProtStr[32];  extern char OldProtStr[32];  extern char ProtStr[30]; extern char *ptr;    A extern char DevName[24];            /* target disk device name */ K extern char TargetFspec[64];         /* target of change owner operation */     extern int lib$get_input();  extern void ShowHelp();    5 #define IO$_ACCESS 50               /* access file */ 5 #define IO$_MODIFY 54               /* modify file */     #define SYSTEM 1 #define OWNER 2  #define GROUP 4  #define WORLD 8     globalvalue CHFPRO_CLD;     char Buffer[80];    union { 9     unsigned short int xab$w_pro;   /* protection mask */         struct {0         unsigned xab$v_sys : 4;     /* system */0         unsigned xab$v_own : 4;     /* owner  */0         unsigned xab$v_grp : 4;     /* group  */0         unsigned xab$v_wld : 4;     /* world  */     } xab$bits;  } xab;   : struct {                            /* I/O Status Block */     short cond_value;      short count;
     int info;  } iosb;    A struct {                            /* Attribute Control Block */      unsigned short w_size;     unsigned short w_type;     unsigned int   l_addr;	 } acb[2];       N /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  * Function: GetCliInfo F  * Description: check for parameters and qualifiers which were enteredJ  *              at the command line. If values are required, verify syntax-  *              and set respective variables.   *O  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */  void GetCliInfo()  { :     char CliStr[80];               /* cli string buffer */I     char CmdLine[132];             /* buffer reflecting input cmd line */      char LineBuf[132];   E     int CliStat;                   /* return status from cli calls */    H     short CliStrLen;              /* integer depicting cli value size */     short CmdLen;    F     $DESCRIPTOR(DscCli, CliStr);   /* cli param or qualifier string */I     $DESCRIPTOR(DscBuf, Buffer);   /* string returned by cli$get_value */ "     $DESCRIPTOR(DscLbuf, LineBuf);!     $DESCRIPTOR(DscCmd, CmdLine);       G         /* get parameter and qualifier(s) from command line, prefix the L            CLD declared verb and use CLI$DCL_PARSE to build the cmd table */   5     status = lib$get_foreign(&DscCmd, 0, &CmdLen, 0); *     if(status != SS$_NORMAL) exit(status);     CmdLine[CmdLen] = '\0';      strcpy(LineBuf, "CHFPRO ");      strcat(LineBuf, CmdLine); +     DscLbuf.dsc$w_length = strlen(LineBuf); G     CliStat = cli$dcl_parse(&DscLbuf, CHFPRO_CLD, lib$get_input, 0, 0); ,     if(CliStat != CLI$_NORMAL) exit(status);   C         /* check for presence of qualifiers which are not dependant (            on additional input values */        strcpy(CliStr, "VERSION");)     DscCli.dsc$w_length = strlen(CliStr); #     CliStat = cli$present(&DscCli); +     if(CliStat == CLI$_PRESENT) ShowVers();         strcpy(CliStr,"HELP");7     DscCli.dsc$w_length = strlen(DscCli.dsc$a_pointer); #     CliStat = cli$present(&DscCli); +     if(CliStat == CLI$_PRESENT) ShowHelp();    I         /* if we get here (we would not if either of the above qualifiers I            were entered, as they call sys$exit at the conclusion of their K            respective function calls) then check for and process input file 2            parameter if it is present and valid */        strcpy(CliStr,"FILENAME");7     DscCli.dsc$w_length = strlen(DscCli.dsc$a_pointer); #     CliStat = cli$present(&DscCli); !     if(CliStat == CLI$_PRESENT) { >         CliStat = cli$get_value(&DscCli, &DscBuf, &CliStrLen);#         if(CliStat == SS$_NORMAL) { %             Buffer[CliStrLen] = '\0'; D             strcpy(InputFile, Buffer);    /* input file to change */	         }      } @     else {          /* FILENAME not specified on command line */         exit(0x381F0);H     }    /* %CLI-W-ABSENT, entity or value absent from command string */         strcpy(CliStr,"PROTECTION");7     DscCli.dsc$w_length = strlen(DscCli.dsc$a_pointer); #     CliStat = cli$present(&DscCli); !     if(CliStat == CLI$_LOCPRES) { >         CliStat = cli$get_value(&DscCli, &DscBuf, &CliStrLen);<         if(CliStat == CLI$_COMMA || CliStat == SS$_NORMAL) {%             Buffer[CliStrLen] = '\0'; L             strcpy(CmdProtStr, Buffer);    /* requested protection values */*             while(CliStat == CLI$_COMMA) {F                 CliStat = cli$get_value(&DscCli, &DscBuf, &CliStrLen);8                 if(CliStat & 1) strcat(CmdProtStr, ",");)                 Buffer[CliStrLen] = '\0'; +                 strcat(CmdProtStr, Buffer); 
             }              ProtFlg = TRUE; 	         }      } 
     else {$         if(CliStat == CLI$_ABSENT) {5             printf("\nUsage: CHFPRO filename %s\n\n", 8                    "/prot=(s:rwed,o:rwed,g:re,w:\"\")");             exit(SS$_NORMAL); 	         }          else exit(CliStat);      }  }       J /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  * Function: GetAsciiProt A  * Description: Translates the file protection mask to ascii. The J  *              protection field is a 16-bit field. Each "nibble" containsJ  *              the protection mask for one of the 4 protection categories-  *              (SYSTEM, OWNER, GROUP, WORLD)   *K  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */   void GetAsciiProt(char *ProtStr) {      char *ProtMaskStr [5];      6     /* To evaluate each nibble in the protection mask:G        -- Shift left (1 << XAB$V_SYS) to evaluate the particular nibble K        -- Shift left again by the bit number (ie. << XAB$V_NOREAD) you wish            to check */    0     memset(ProtMaskStr, 0, sizeof(ProtMaskStr));B     if((( (1 << XAB$V_SYS) << XAB$V_NOREAD) & xab.xab$w_pro) == 0)%             strcat(ProtMaskStr, "R"); C     if((( (1 << XAB$V_SYS) << XAB$V_NOWRITE) & xab.xab$w_pro) == 0) %             strcat(ProtMaskStr, "W"); A     if((( (1 << XAB$V_SYS) << XAB$V_NOEXE) & xab.xab$w_pro) == 0) %             strcat(ProtMaskStr, "E"); A     if((( (1 << XAB$V_SYS) << XAB$V_NODEL) & xab.xab$w_pro) == 0) %             strcat(ProtMaskStr, "D");      strcat(ProtStr, "("); !     strcat(ProtStr, ProtMaskStr);      strcat(ProtStr, ",");    0     memset(ProtMaskStr, 0, sizeof(ProtMaskStr));B     if((( (1 << XAB$V_OWN) << XAB$V_NOREAD) & xab.xab$w_pro) == 0)%             strcat(ProtMaskStr, "R"); C     if((( (1 << XAB$V_OWN) << XAB$V_NOWRITE) & xab.xab$w_pro) == 0) %             strcat(ProtMaskStr, "W"); A     if((( (1 << XAB$V_OWN) << XAB$V_NOEXE) & xab.xab$w_pro) == 0) %             strcat(ProtMaskStr, "E"); A     if((( (1 << XAB$V_OWN) << XAB$V_NODEL) & xab.xab$w_pro) == 0) %             strcat(ProtMaskStr, "D"); !     strcat(ProtStr, ProtMaskStr);      strcat(ProtStr, ",");    0     memset(ProtMaskStr, 0, sizeof(ProtMaskStr));B     if((( (1 << XAB$V_GRP) << XAB$V_NOREAD) & xab.xab$w_pro) == 0)%             strcat(ProtMaskStr, "R"); C     if((( (1 << XAB$V_GRP) << XAB$V_NOWRITE) & xab.xab$w_pro) == 0) %             strcat(ProtMaskStr, "W"); A     if((( (1 << XAB$V_GRP) << XAB$V_NOEXE) & xab.xab$w_pro) == 0) %             strcat(ProtMaskStr, "E"); A     if((( (1 << XAB$V_GRP) << XAB$V_NODEL) & xab.xab$w_pro) == 0) %             strcat(ProtMaskStr, "D"); !     strcat(ProtStr, ProtMaskStr);      strcat(ProtStr, ",");    0     memset(ProtMaskStr, 0, sizeof(ProtMaskStr));B     if((( (1 << XAB$V_WLD) << XAB$V_NOREAD) & xab.xab$w_pro) == 0)%             strcat(ProtMaskStr, "R"); C     if((( (1 << XAB$V_WLD) << XAB$V_NOWRITE) & xab.xab$w_pro) == 0) %             strcat(ProtMaskStr, "W"); A     if((( (1 << XAB$V_WLD) << XAB$V_NOEXE) & xab.xab$w_pro) == 0) %             strcat(ProtMaskStr, "E"); A     if((( (1 << XAB$V_WLD) << XAB$V_NODEL) & xab.xab$w_pro) == 0) %             strcat(ProtMaskStr, "D"); !     strcat(ProtStr, ProtMaskStr);      strcat(ProtStr, ")");  }       H /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  * Function: ShowHelp H  * Description: Display a brief combination of CHFPRO.README and the cduI  *              CHFPRO.CLD file. It provides a command line glance at the 9  *              optional implementations of CHFPRO usage.   *K  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */  void ShowHelp()  { 0     printf("\n  %s (%s)\n\n", CmdVerb, VERSION);O     printf("\tAllows user to change protection of a file or group of files\n"); J     printf("\tin the current (default) directory without changing the\n");H     printf("\tcreation or revision (modify) date and time values.\n\n");$     printf("      Parameters:\n\n");M     printf("\tFILENAME - the name of file in current directory to change\n"); N     printf("\t\townership. This parameter can use wildcards, BUT, file(s)\n");L     printf("\t\tmust be in the current directory and not be open. Also,\n");D     printf("\t\tCHFPRO really dislikes multiple file versions\n\n");#     printf("      Qualifiers\n\n"); O     printf("\t/PROTECTION - Changes the protection of target file(s) using\n"); M     printf("\t\tnormal VMS protection syntax (S:RWED,O:RWED,G:RE,W:\"\")\n"); C     printf("\t\tOmitted protection fields are not modifiied.\n\n"); /     printf("\t/HELP - Displays this text\n\n"); H     printf("\t/VERSION - Displays version, build date, and required\n");7     printf("\t\t  privs for VMS Install utility.\n\n");      exit(1); }       J /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  * Function: ProcFileProt D  * Description: Create a temporary xab structure with all protectionG  *              fields set to no access. Then read requested protection G  *              fields from comdline one at a time and set desired prot C  *              for each in the appropriate xabtmp fields (binary).   *K  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */  int ProcFileProt() {      short   func_code;     short   channel;     int     ProtStat;    <     struct  fibdef  fib;        /* File Information Block */E     struct  stat    statbuf;    /* File Statistics (including FID) */ @     struct dsc$descriptor_s fibdesc = {sizeof(fib), 0, 0, &fib};   ;     $DESCRIPTOR(DscDev, DevName);      /* Default Device */       0         /*  assign an I/O channel to the disk */   *     DscDev.dsc$w_length = strlen(DevName);3     ProtStat = sys$assign(&DscDev, &channel, 0, 0);      if((ProtStat & 1) != 1) { +         printf("\nError on sys$assign,\n");          lib$stop(ProtStat);      }    A         /* initialize the length, write bit and FID fields of the *            File Information Block (FIB) */   "     memset(&fib, 0, FIB$C_LENGTH);(     fibdesc.dsc$w_length = FIB$C_LENGTH;        fib.fib$v_write = 1;%     fib.fib$l_acctl = FIB$M_NORECORD; +     fib.fib$w_fid_num = PsNam.nam$w_fid[0]; +     fib.fib$w_fid_seq = PsNam.nam$w_fid[1]; +     fib.fib$w_fid_rvn = PsNam.nam$w_fid[2];    6         /* set up the Attribute Control Block (ACB) */        acb[0].w_size = ATR$S_FPRO;      acb[0].w_type = ATR$C_FPRO; #     acb[0].l_addr = &xab.xab$w_pro;      acb[1].w_size = 0;     acb[1].w_type = 0;     acb[1].l_addr = 0;   5        /* get the file's UIC-based protection mask */         func_code = IO$_ACCESS; ;     ProtStat = sys$qiow(0, channel, func_code, &iosb, 0, 0, 3                        &fibdesc, 0, 0, 0, &acb, 0);      if((ProtStat & 1) != 1) { <         printf("\nError on SYS$QIOW in IO$_ACCESS mode.\n");         lib$stop(ProtStat);      }    $     if((iosb.cond_value & 1) != 1) {C         printf("\nError return on SYS$QIOW in IO$_ACCESS mode.\n"); "         lib$stop(iosb.cond_value);     }    /     memset(&OldProtStr, 0, sizeof(OldProtStr));      GetAsciiProt(&OldProtStr);        ProtStat = ChangeProt();   B       /* Use the IO$_MODIFY function to change info about the fileH          Note, used this way, the file is not opened, however this wouldI          normally cause the expiration and revision dates to be modified. ?          Using FIB$M_NORECORD prohibits this from happening. */    <     ProtStat = sys$qiow(0, channel, IO$_MODIFY, &iosb, 0, 0,4                         &fibdesc, 0, 0, 0, &acb, 0);     if((ProtStat & 1) != 1) { <         printf("\nError on sys$qiow in IO$_MODIFY mode.\n");         lib$stop(ProtStat);      } $     if((iosb.cond_value & 1) != 1) {>         printf("\nError return on SYS$QIOW in IO$_MODIFY.\n");"         lib$stop(iosb.cond_value);     }    /     memset(&NewProtStr, 0, sizeof(NewProtStr));      GetAsciiProt(&NewProtStr);   <         /* Release the I/O channel assigned to the device */   #     ProtStat = sys$dassgn(channel); /     if((ProtStat & 1) != 1) lib$stop(ProtStat);      return(ProtStat);  }          N /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  * Function: CheckLnm L  * Description: Function to translate a provided logical name to the definedK  *              equivalence string. Only the current JOB logical name table D  *              is searched for a match. If successful, the returnedK  *              equivalence string is copied to the memory location used to L  *              provide the input logical name (*lnmstr) so caller must makeG  *              certain the buffer containing the input logical name is F  *              large enough to contain the full equivalence string orG  *              this routine returns SS$_BUFFEROVF. In all other cases, F  *              the return status of SYS$TRNLNM is returned to caller.  *O  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */*& int CheckLnm(char *lnmstr, int buflen) { I     int nocase = LNM$M_CASE_BLIND;  /* resolve lnm without case issues */ K     int eqvattrb = 0;               /* returned attributes of eqv string */%     int lnmstat = 0;     short eqv_len = 0;     short tbl_len = 0;?     char acmode;                    /* always from user mode */ <     char LnmTable[40];              /* logical name table */=     char LnmDef[40];                /* logical name string */%I     char LnmEqv[80];                /* logical name equivalence string */%  %>     struct {short len, code; int *bufadr, *retlen;} lnmitm[4];   &     $DESCRIPTOR(dsc_tabnam, LnmTable);$     $DESCRIPTOR(dsc_lognam, LnmDef);$     $DESCRIPTOR(dsc_eqvnam, LnmEqv);   <     acmode = PSL$C_EXEC;            /* requires exec mode */'     memset(&LnmEqv, 0, sizeof(LnmEqv));_     strcpy(LnmDef, lnmstr);       strcpy(LnmTable, "LNM$JOB");  e/     dsc_tabnam.dsc$w_length = strlen(LnmTable); -     dsc_lognam.dsc$w_length = strlen(LnmDef); -     dsc_eqvnam.dsc$w_length = sizeof(LnmEqv);i  n%     lnmitm[0].len = sizeof(eqvattrb);i%     lnmitm[0].code = LNM$_ATTRIBUTES;"!     lnmitm[0].bufadr = &eqvattrb;i     lnmitm[0].retlen = 0;p%     lnmitm[1].len = sizeof(LnmTable);       lnmitm[1].code = LNM$_TABLE;!     lnmitm[1].bufadr = &LnmTable;u      lnmitm[1].retlen = &tbl_len;#     lnmitm[2].len = sizeof(LnmEqv);*!     lnmitm[2].code = LNM$_STRING;*     lnmitm[2].bufadr = &LnmEqv;       lnmitm[2].retlen = &eqv_len;     lnmitm[3].len = 0;     lnmitm[3].code = 0;h   N     lnmstat = sys$trnlnm(&nocase, &dsc_tabnam, &dsc_lognam, &acmode, &lnmitm);     if(lnmstat == SS$_NORMAL) {c         LnmEqv[eqv_len] = '\0';f!         LnmTable[tbl_len] = '\0';<4         if(eqv_len < buflen) strcpy(lnmstr, LnmEqv);#         else return(SS$_BUFFEROVF);c     }e8     if(eqvattrb & LNM$M_CONCEALED) return(SS$_IVLOGNAM);     else return(lnmstat);l }u  R  _  AJ /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  * Function: ChangeProtrC  * Description: Parse user provided protection changes from commandrB  *              line, one field at a time. The methodology used inE  *              this function will provide only the changes specifiedpE  *              from the command line entries. Fields which are to beiH  *              modified to no access only need double quotes to satisfyG  *              the DCL CLI (ie, W:"") as the cli strips off the doublet5  *              quotes, this routine never sees them.   *K  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */  int ChangeProt() {a   
     int done;      short ModBits = 0;     char *ptr1;a     char *ptr2;      char *ptr3;t  [     union {c=         unsigned short int xab$w_pro;   /* protection mask */i  d         struct {4             unsigned xab$v_sys : 4;     /* system */4             unsigned xab$v_own : 4;     /* owner  */4             unsigned xab$v_grp : 4;     /* group  */4             unsigned xab$v_wld : 4;     /* world  */         } xab$bits;d
     } xabtmp;   d4         /* initialize temporary protection fields */  n$     xabtmp.xab$bits.xab$v_sys = 0xF;$     xabtmp.xab$bits.xab$v_own = 0xF;$     xabtmp.xab$bits.xab$v_grp = 0xF;$     xabtmp.xab$bits.xab$v_wld = 0xF;   <         /* parse CmdProtStr for system prot modifications */  d     done = FALSE;      while(!done) {         ptr1 = ptr2 = ptr3 = 0;g(         ptr1 = strstr(CmdProtStr, "S:");         if(!ptr1) { ,             ptr1 = strstr(CmdProtStr, "SY");             if(!ptr1) {a                 done = TRUE;                 break;
             }              else {)                 ptr2 = strchr(ptr1, ':');e                  ptr1 = ptr2 + 1;
             } 	         }s         else ptr1 += 2;d  tC         ModBits |= SYSTEM;          /* we found 'S:' or 'SY...:' */*!         ptr3 = strchr(ptr1, ',');*/         if(ptr3) *ptr3 = '\0';  /* temporary */n!         ptr2 = strchr(ptr1, 'R');r<         if(ptr2) xabtmp.xab$bits.xab$v_sys &= ~XAB$M_NOREAD;!         ptr2 = strchr(ptr1, 'W'); =         if(ptr2) xabtmp.xab$bits.xab$v_sys &= ~XAB$M_NOWRITE;*!         ptr2 = strchr(ptr1, 'E');*;         if(ptr2) xabtmp.xab$bits.xab$v_sys &= ~XAB$M_NOEXE; !         ptr2 = strchr(ptr1, 'D');l;         if(ptr2) xabtmp.xab$bits.xab$v_sys &= ~XAB$M_NODEL;f         if(ptr3) {*             if(*ptr3 == '\0') *ptr3 = ',';	         }a         done = TRUE;     }n  a;         /* parse CmdProtStr for owner prot modifications */   i     done = FALSE;i     while(!done) {         ptr1 = ptr2 = ptr3 = 0;O(         ptr1 = strstr(CmdProtStr, "O:");         if(!ptr1) {D,             ptr1 = strstr(CmdProtStr, "OW");             if(!ptr1) {                  done = TRUE;                 break;
             }              else {)                 ptr2 = strchr(ptr1, ':');l                  ptr1 = ptr2 + 1;
             }d	         }L         else ptr1 += 2;a   B         ModBits |= OWNER;          /* we found 'O:' or 'OW...:' */!         ptr3 = strchr(ptr1, ',');s/         if(ptr3) *ptr3 = '\0';  /* temporary */B!         ptr2 = strchr(ptr1, 'R');f<         if(ptr2) xabtmp.xab$bits.xab$v_own &= ~XAB$M_NOREAD;!         ptr2 = strchr(ptr1, 'W'); =         if(ptr2) xabtmp.xab$bits.xab$v_own &= ~XAB$M_NOWRITE;A!         ptr2 = strchr(ptr1, 'E');e;         if(ptr2) xabtmp.xab$bits.xab$v_own &= ~XAB$M_NOEXE; !         ptr2 = strchr(ptr1, 'D'); ;         if(ptr2) xabtmp.xab$bits.xab$v_own &= ~XAB$M_NODEL;          if(ptr3) {*             if(*ptr3 == '\0') *ptr3 = ',';	         }L         done = TRUE;     }    ;         /* parse CmdProtStr for group prot modifications */l  s     done = FALSE;      while(!done) {         ptr1 = ptr2 = ptr3 = 0;L(         ptr1 = strstr(CmdProtStr, "G:");         if(!ptr1) {l,             ptr1 = strstr(CmdProtStr, "GR");             if(!ptr1) {h                 done = TRUE;                 break;
             }u             else {)                 ptr2 = strchr(ptr1, ':');                   ptr1 = ptr2 + 1;
             } 	         }t         else ptr1 += 2;i  cB         ModBits |= GROUP;          /* we found 'G:' or 'GR...:' */!         ptr3 = strchr(ptr1, ',');$/         if(ptr3) *ptr3 = '\0';  /* temporary */c!         ptr2 = strchr(ptr1, 'R'); <         if(ptr2) xabtmp.xab$bits.xab$v_grp &= ~XAB$M_NOREAD;!         ptr2 = strchr(ptr1, 'W');e=         if(ptr2) xabtmp.xab$bits.xab$v_grp &= ~XAB$M_NOWRITE; !         ptr2 = strchr(ptr1, 'E');p;         if(ptr2) xabtmp.xab$bits.xab$v_grp &= ~XAB$M_NOEXE;/!         ptr2 = strchr(ptr1, 'D');s;         if(ptr2) xabtmp.xab$bits.xab$v_grp &= ~XAB$M_NODEL;"         if(ptr3) {*             if(*ptr3 == '\0') *ptr3 = ',';	         }          done = TRUE;     }f  i;         /* parse CmdProtStr for world prot modifications */c  ,     done = FALSE;n     while(!done) {         ptr1 = ptr2 = ptr3 = 0;$(         ptr1 = strstr(CmdProtStr, "W:");         if(!ptr1) { ,             ptr1 = strstr(CmdProtStr, "WO");             if(!ptr1) {                  done = TRUE;                 break;
             }e             else {)                 ptr2 = strchr(ptr1, ':');t                  ptr1 = ptr2 + 1;
             } 	         }t         else ptr1 += 2;    B         ModBits |= WORLD;          /* we found 'W:' or 'WO...:' */!         ptr3 = strchr(ptr1, ',');l/         if(ptr3) *ptr3 = '\0';  /* temporary */ !         ptr2 = strchr(ptr1, 'R');a<         if(ptr2) xabtmp.xab$bits.xab$v_wld &= ~XAB$M_NOREAD;!         ptr2 = strchr(ptr1, 'W');A=         if(ptr2) xabtmp.xab$bits.xab$v_wld &= ~XAB$M_NOWRITE; !         ptr2 = strchr(ptr1, 'E');*;         if(ptr2) xabtmp.xab$bits.xab$v_wld &= ~XAB$M_NOEXE;G!         ptr2 = strchr(ptr1, 'D');l;         if(ptr2) xabtmp.xab$bits.xab$v_wld &= ~XAB$M_NODEL;          if(ptr3) {*             if(*ptr3 == '\0') *ptr3 = ',';	         }          done = TRUE;     }f  eL     if(ModBits & SYSTEM) xab.xab$bits.xab$v_sys = xabtmp.xab$bits.xab$v_sys;L     if(ModBits & OWNER)  xab.xab$bits.xab$v_own = xabtmp.xab$bits.xab$v_own;L     if(ModBits & GROUP)  xab.xab$bits.xab$v_grp = xabtmp.xab$bits.xab$v_grp;L     if(ModBits & WORLD)  xab.xab$bits.xab$v_wld = xabtmp.xab$bits.xab$v_wld;  B     return(SS$_NORMAL);a }c  r  bH /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  *    Function: GetCmdLineI  * Description: Retrieve the last command entered from the command recall$H  *              buffer in the users process space, the command which wasJ  *              used to invoke this image. The contents of this recall bufK  *              are saved in a user specified buffer. In the unlikely event H  *              that the command line is longer than callers buffer, setM  *              length to -1 and return SS$_BUFFEROVF. Else return SS$_NORMAL   *J  *              This routine is aware of buffer length changes implemented'  *              in VMS 7.3-2 and above.   *I  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */WA int GetCmdLine(struct dsc$descriptor_s *DscTarget, short *length)M {S<     char    *Sptr = 0;      /* last recall buffer pointer */D     char    *Dptr = 0;      /* callers string destination pointer */  <     short   ExpBuf = 0;X@     short   *Lptr = 0;      /* pointer to callers length word */        int     BufSize;     int     RecallAddr = 0;w     int     ppd = 0;     int     prc = 0;A     int     *Iptr = 0;      /* integer pointer for indirection */,   D         /* recall buffer larger for V7.3-2 and higher. Use this infoD            to determine whether recall buffer length is presented to$            us as a byte or a word */  A=     BufSize = PRC_S_COMMANDS;       /* get size of rcl buf */      if(BufSize > 4100)D         ExpBuf = TRUE;              /* if < 4100, osvers <= 7.3-1 */   8     RecallAddr = CTL$AG_CLIDATA;    /* address of ppd */8     RecallAddr += PPD$L_PRC;        /* address of prc */A     prc = PRC_L_RECALLPTR;          /* current command pointer */ A     Iptr = RecallAddr;              /* pseudo pointer register */t     RecallAddr = *Iptr;<0     RecallAddr += prc;              /* offset */B     Iptr = RecallAddr;              /* copy to pointer register */L     RecallAddr = *Iptr;             /* RecallAddr points to end of buffer */  )A         /* here we use recall allocation to determine the size of0B            the recall buffer length field, changed at vms 7.3.2 */  <E     if(ExpBuf) RecallAddr -= 2;     /* length is 16 bits at 7.3-2+ */ ?     else RecallAddr--;              /* else length is 8 bits */)     Sptr = RecallAddr;$     Dptr = DscTarget->dsc$a_pointer;  *B         /* be sure cmd line not longer than callers buffer. If so,6            ignore cmd line and return SS$_BUFFEROVF */        if(ExpBuf) {         Lptr = Sptr;O         if(*Lptr < DscTarget->dsc$w_length-1) *length = *Lptr; /* 16 bit val */H         else {             *length = -1;*"             return(SS$_BUFFEROVF);	         }*     }d2     else *length = *Sptr;       /*  8 bit value */  ,C         /* get buffer length and copy cmd line to callers buffer */o  r     Sptr -= *length;!     strncpy(Dptr, Sptr, *length);)     return(SS$_NORMAL);n }h  "H     printf("\tcreation or revision (modify) date and time values.\n\n");$     printf("      Parameters:\n\n");M     printf("\tFILENAME - the name of file in current directory to change\n"); N     printf("\t\townership. This parameter can use wildcards, BUT, file(s)\n");L     printf("\t\tmust be in the current directory and not be open. Also,\n");D     printf("\t\tCHFPRO really dislikes multiple file versions\n\n");#     printf("      Qualifiers\n\n"); O     printf("                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                