# Do not invoke MMS on this directly, use MAKE_MPEG_PLAY.COM.
#
.IFDEF EXE
.ELSE
EXE = .EXE
OBJ = .OBJ
OLB = .OLB
OPT = .OPT
.ENDIF

.IFDEF DEBUG
DEBUG_QUAL = /Noop/Debug
.ELSE
DEBUG_QUAL = 
.ENDIF

DEFINES = /define=(NO_LRAND48,NO_RANDOM,NO_GETTIMEOFDAY,SIG_ONE_PARAM,DEBUG,_DECC_V4_SOURCE)
.IFDEF __ALPHA__
CC = $(CC)/STANDARD=VAXC $(DEBUG_QUAL)$(DEFINES)
.ELSE
.IFDEF __DECC__
.IFDEF __VAXC__
CC = $(CC)/VAXC $(DEBUG_QUAL)$(DEFINES)
.ELSE
CC = $(CC)/DECC/STANDARD=VAXC $(DEBUG_QUAL)$(DEFINES)
.ENDIF
.ELSE
CC = $(CC) $(DEBUG_QUAL)$(DEFINES)
.ENDIF
.ENDIF

HDRS	      = util.h, video.h, decoders.h, fs2.h, dither.h, fs4.h, proto.h, ctrlbar.h

.IFDEF DEBUG
LD	      = Link/Debug
PROGRAM       = mpeg_play_debug$(exe)
LIBRARY       = mpeg_play_debug$(olb)
.ELSE
LD	      = Link
PROGRAM       = mpeg_play$(exe)
LIBRARY       = mpeg_play$(olb)
.ENDIF

OBJS          = util$(obj), video$(obj), parseblock$(obj), motionvector$(obj), -
		decoders$(obj), fs2$(obj), fs2fast$(obj), fs4$(obj), hybrid$(obj), -
		hybriderr$(obj), 2x2$(obj), floatdct$(obj), gdith$(obj), gray$(obj), -
		mono$(obj), main$(obj), jrevdct$(obj), 16bit$(obj), util32$(obj), -
		ordered$(obj), ordered2$(obj), mb_ordered$(obj), readfile$(obj), -
		ctrlbar$(obj), 1x1$(obj), 2x2fs2$(obj)

PRINT	      = print

SRCS	      = util.c, video.c, parseblock.c, motionvector.c, decoders.c, -
		main.c, gdith.c, fs2.c, fs2fast.c, fs4.c, hybrid.c, -
		hybriderr.c, 2x2.c, gray.c, mono.c, jrevdct.c, 16bit.c, -
		util32.c, ordered.c, ordered2.c, mb_ordered.c, readfile.c, -
		floatdct.c, ctrlbar.c, 1x1.c, 2x2fs2.c

.FIRST
		If F$Search("$(LIBRARY)") .EQS. "" Then Library/Create $(LIBRARY)

default :	$(PROGRAM)
		@ Write SYS$Output "MPEG_PLAY 2.3 executable is $(PROGRAM)"

$(LIBRARY) :	$(LIBRARY)($(OBJS)), $(HDRS)
		@ Write SYS$Output ""

$(PROGRAM) :	$(LIBRARY), MPEG_PLAY$(OPT)
		$(LD)/EXE=$(PROGRAM) $(LIBRARY)/INCLUDE=MAIN/LIBRARY,-
				mpeg_play$(opt)/options

.obj.olb
		$(LIBR) $(LIBRFLAGS) $(MMS$TARGET) $(MMS$SOURCE)

clean : 
		DELETE *$(OBJ);*
 
clobber :
		DELETE *$(OBJ);*,$(LIBRARY);*,$(PROGRAM);*

print :
		$(PRINT) $(HDRS),$(SRCS)
