#include <stdio.h>
#include <descrip.h>
#include <ssdef.h>
#include <climsgdef.h>
#include "strings.h"
#include "cmdline.h"

globalref int makecmdtable;

/************************************************************/

process_cmdline(char *targname[])
{
  int i;
  int targcnt;
  int status;
  varstr(256) tmpstr,cmdstr;
  vardesc tmpdsc,cmddsc;
  strdesc precmd;
  int handler();
  char *tlist,*ptr,*tmp,*defstr;

  VAXC$ESTABLISH(handler);

  DESCRIP(precmd,"MAKE ");
  VDESCRIP(tmpdsc,tmpstr);
  VDESCRIP(cmddsc,cmdstr);
  status = lib$get_foreign(&tmpdsc);
  str$concat(&cmddsc,&precmd,&tmpdsc);
  status = cli$dcl_parse(&cmddsc,&makecmdtable,0,0,0);
  for(i=0; i<MAXKEYS; i++)
    (*keylist[i].readkey)(keylist[i].name,keylist[i].var);
  while (read_key_list("DEFINE",&defstr)) {
    parse_symbol_line(defstr);
    free(defstr);
  }
  macrocnt = 0;
  while (read_key_list("MACRO",&defstr)) {
    if (strchr(defstr,'=') != NULL) {
      parse_symbol_line(defstr);
      free(defstr);
    }
    else if (macrocnt >= 32) error("Too many MACRO files specified");
    else macrofiles[macrocnt++] = defstr;
  }
  targcnt = 0;
  for(i=1; i<9; i++) {
    if(!p[i]) continue;		/* Skip empty boxes */
    if(*p[i] == '\0') continue;	/* Skip empty boxes */
    targname[targcnt] = strperm(p[i]);
    DOWNCASE(targname[targcnt],tmp);
    targcnt++;
    free(p[i]);
  }
  return(targcnt);
}

/************************************************************/

read_key_boolean(char *keyname,int *keyvar)
{
  strdesc entity;

  DESCRIP(entity,keyname);
  switch(cli$present(&entity)) {
  case CLI$_PRESENT:
  case CLI$_DEFAULTED:
  case CLI$_LOCPRES:
    *keyvar = TRUE;
    break;
  case CLI$_NEGATED:
  case CLI$_LOCNEG:
    *keyvar = FALSE;
    break;
  case CLI$_ABSENT:
    *keyvar = FALSE;
    break;
  default:
    error("Unknown CLI$Present() return status.");
    break;
  }
}

/************************************************************/

read_key_list(char *keyname,char **keyvar)
{
  strdesc entity;
  short keylen;
  strdesc keyval;
  char keybuf[255];

  DESCRIP(entity,keyname);
  keybuf[0] = '\0';
  DESCRIP(keyval,keybuf);
  keyval.dsc$w_length = 255;
  if (cli$get_value(&entity,&keyval,&keylen)&1) {
    if(!(*keyvar = malloc(keylen+1))) {
      sprintf(keybuf,"Unable to allocate memory for parameter %s, length %d.",
	      entity.dsc$a_pointer,keylen);
      error(keybuf);
    }
    strncpy(*keyvar,keyval.dsc$a_pointer,keylen);
    (*keyvar)[keylen] = '\0';
    return 1;
  }
  else return 0;
}

/************************************************************/

read_key_text(char *keyname,char **keyvar)
{
  strdesc entity;
  short keylen;
  strdesc keyval;
  char keybuf[255];

  DESCRIP(entity,keyname);
  keybuf[0] = '\0';
  DESCRIP(keyval,keybuf);
  keyval.dsc$w_length = 255;
  switch(cli$present(&entity)) {
    case CLI$_PRESENT:
    case CLI$_DEFAULTED:
    case CLI$_LOCPRES:
      cli$get_value(&entity,&keyval,&keylen);
      if(!(*keyvar = malloc(keylen+1))) {
        sprintf(keybuf,"Unable to allocate memory for parameter %s, length %d.",
  	      entity.dsc$a_pointer,keylen);
        error(keybuf);
      }
      strncpy(*keyvar,keyval.dsc$a_pointer,keylen);
      (*keyvar)[keylen] = '\0';
      break;
    case CLI$_ABSENT:
      *keyvar = NULL;
      break;
    default:
      error("Unknown CLI$Present() return status.");
      break;
  }
}

#ifndef CLI$_FACILITY
globalvalue CLI$_FACILITY;
#endif

/************************************************************/
handler(sigargs,mechargs)
     unsigned long sigargs[];
     unsigned long mechargs[];
{
  char buf1[80];
  char buf2[80];
  strdesc desc1;
  strdesc desc2;
  unsigned char otherargs[4];
  unsigned short str_len;

  DESCRIP(desc1,buf1);
  DESCRIP(desc2,buf2);
  desc1.dsc$w_length = 80;
  desc2.dsc$w_length = 80;

  if ((sigargs[1] >> 16 & 0XFFF) == CLI$_FACILITY) {
    exit(sigargs[1]);
  }
  else
    return(SS$_RESIGNAL);
}
