  L /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  *;  *               %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%\ <  *               %% \                                   %% \=  *               %%  \__________________________________%%  \ >  *               %%  |                                  %%   \?  *               %%  |              LnmTool             %%    | ?  *               %%  |         CallBacks.c  c2003       %%    | ?  *               %%  |            Lyle W. West          %%    | ?  *               %%  |                                  %%    | ?  *               %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%    | ?  *               \                                        \   | ?  *                \                                        \  | ?  *                 \                                        \ | ?  *                  \________________________________________\|   *  *  *:  *   Copyright (C) 2003 Lyle W. West, All Rights Reserved.  *K  *   Permission is granted to copy and use this program so long as [1] this I  *   copyright notice is preserved, and [2] no financial gain is involved I  *   in copying the program.  This program may not be sold as "shareware" H  *   or "public domain" software without the express, written permission  *   of the author.   *M  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */    #include "version.h"  #pragma module callbacks VERSION   #include <stdio.h> #include <ctype.h> #include <descrip.h> #include <lnmdef.h>  #include <ssdef.h> #include <string.h>  #include <types.h> #include <X11/cursorfont.h>  #include <X11/Intrinsic.h> #include <X11/StringDefs.h>  #include <X11/Xlib.h>  #include <X11/Xos.h> #include <X11/Xutil.h> #include <Xm/Xm.h> #include <Xm/BulletinB.h>  #include <Xm/CascadeB.h> #include <Xm/Frame.h>  #include <Xm/Label.h>  #include <Xm/LabelG.h> #include <Xm/List.h> #include <Xm/MainW.h>  #include <Xm/PushB.h>  #include <Xm/PushBG.h> #include <Xm/RowColumn.h>  #include <Xm/SelectioB.h>  #include <Xm/Text.h> #include <Xm/TextF.h>  #include "defs.h"  #include "externs.h"   int ModifySelPos;    extern void OptsTableSelCB (); extern void RemoteTableDlg ();  N /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  *    Function: AddTableTextCBC  * Description: Some event has occurred with the text widget in the E  *              Modify popup dialog. Determine the event and take the D  *              appropriate action. A verify callback will uppercaseD  *              entereded test, A text changed event will enable theB  *              Add Table pushbutton, and CR_Activeate generates a%  *              popup warning dialog.   *#  *      Inputs: Reason for callback   *     Returns: None  *O  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */ I void AddTableTextCB(Widget w, XtPointer client_data, XtPointer call_data)  {      char errmsgbuf[80];      char *ptr;     int reason = 0;      short RemoveStat;      XmTextPosition curlength; O     XmTextVerifyCallbackStruct *cbs = (XmTextVerifyCallbackStruct *) call_data;        reason = cbs->reason;      switch ((int)client_data) {          case VERIFY:!             ptr = cbs->text->ptr;               if(*ptr == 0) break;!             *ptr = toupper(*ptr); -             XtSetSensitive(RemoveBtn, False);              break;           case CHANGED: ?             if(!cbs->text) {   /* user entered ^J or F13 ??? */ 1                 XtSetSensitive(RemoveBtn, False); -                 XtSetSensitive(AddBtn, True);              } :             curlength = XmTextGetLastPosition(TableTextW);7             if(curlength) TableTextWStrlen = curlength; &             else TableTextWStrlen = 0;M             if(!ModifySelPos) {     /* txt not added due to item selection */ &                 if(TableTextWStrlen) {1                     XtSetSensitive(AddBtn, True); 5                     XtSetSensitive(RemoveBtn, False);                  } 
             }              else {0                 XtSetSensitive(RemoveBtn, True);
             }              break;           case ACTIVATE:?             sprintf(errmsgbuf, "Use the 'Add' pushbutton \n%s", -                     "to add new name table"); 5             DispErrPopup("Add Table", &errmsgbuf, 0);              break;           case MOTION:             break;     }  }       N /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  *    Function: RadioPopupCBH  * Description: Manage radio buttons; user has selected one of the radioG  *              buttons in the Format popup. Determine which button was I  *              selected and set that value in 'DisplayRootMode' The item F  *              labeled NEEDMANAGE is called from the Options menu bar!  *              selection Format.   *  *      Inputs: None  *     Returns: None  *O  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */ G void RadioPopupCB(Widget w, XtPointer client_data, XtPointer call_data)  {      switch ((int)client_data) {          case COLSMODE_1:)             DisplayRootMode = COLSMODE_1;              break;           case COLSMODE_2:)             DisplayRootMode = COLSMODE_2;              break;           case COLSMODE_4:)             DisplayRootMode = COLSMODE_4;              break;           case NEEDMANAGE:-             XtManageChild(DispRootModePopup);              break;     }      XmUpdateDisplay(w);  }       N /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  *    Function: LnmSelCBD  * Description: User selected an logical name from the Logicals listE  *              widget. Determine which item was selected and display F  *              the equivalence string(s) and attributes. If the tableD  *              name selected is already selected, just exit without  *              further action.   *5  *      Inputs: Parent widget, client data, call data   *     Returns: None  *O  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */ C void LnmSelCB(Widget w, XtPointer client_data, XtPointer call_data)  {      int newpos = 0; E     int CurIndex = 0;       /* index value of target attrib/acmode */      int logstat;     Cursor watch = 0; B     XmListCallbackStruct *cb = (XmListCallbackStruct *) call_data;     XmString SelLnm;     LNM_LST *LnmPtr;  C         /* Until a concealed lnm selected, button non_functional */   *     XtSetSensitive(TypeOptions[1], FALSE);        newpos  = cb->item_position;J     if(LognameSelPos == newpos) { /* if already selected, ignore,return */         DoBell(0);         return;      } 3     else {      /* User selected unselected item */          LognameSelPos = newpos;          newpos--;          LnmPtr = AscLnmList;         LnmPtr += newpos; 3         strcpy(TargetLogicalName, LnmPtr->LogName); @         watch = XCreateFontCursor(XtDisplay(LnmForm), XC_watch);D         XDefineCursor(XtDisplay(LnmForm), XtWindow(LnmForm), watch);C         XmUpdateDisplay(LnmForm);    /* startup the Watch cursor */ $         logstat = DisplayLnmEquiv();1         logstat = DisplayLnmAttributes(CurIndex); ?         XUndefineCursor(XtDisplay(LnmForm), XtWindow(LnmForm));      }      XmUpdateDisplay(LnmListW); }       N /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  *    Function: OptionMenuCBH  * Description: User selected one of the Command buttons from the OptionJ  *              Menu. Which button was selected is determined by the value=  *              in the Client_data passed into this callback.   *5  *      Inputs: Parent widget, client data, call data   *     Returns: None  *O  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */ G void OptionMenuCB(Widget w, XtPointer client_data, XtPointer call_data)  {      int    indx;     int    retstat;      char   titlestr[50];     char   labelstr[30];     Widget SelFile;      OPTS_LST *OptsPtr;          switch ((int)client_data) {            case OPTM_STATS_BTN:             StatisticsPopup();             break;           case OPTM_ROOT_BTN:              RootFilesPopup();              break;           case OPTM_EXPND_BTN:             ExpandLnmPopup();              break;           case OPTM_MODIFY_BTN:   F             /* Move Optional Tables list into compound string array */  %             UpdateOptsList(MAINLIST); '             OptsPtr = AscOptsTableList;   1             XmListDeleteAllItems(OptTablesListW); <             for(indx = 0; indx < NumAvailableOpts; indx++) {(                 CsToptsListItems[indx] =O                     (XmString) XmStringCreateLtoR(OptsPtr->TableName, charset);                  OptsPtr++;
             }   -             /* update Optional Tables List */                n = 0;?             XtSetArg(args[n], XmNitems, CsToptsListItems); n++; C             XtSetArg(args[n], XmNitemCount, NumAvailableOpts); n++; 1             XtSetValues(OptTablesListW, args, n);   N             CopyTableList(CURRENT_TO_MODIFY); /* remove uncommitted changes */-             XtSetSensitive(CommitBtn, False); %             XtManageChild(ModifyDlg);              break;       }  }     N /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  *    Function: OptsTableSelCBI  * Description: User selected a table item from the Optional tables list. F  *              Move selected logical name table into the Modify tableI  *              list of tables. If the item selected is alreay highlited, (  *              remove hilite attribute.  *5  *      Inputs: Parent widget, client data, call data   *     Returns: None  *O  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */ I void OptsTableSelCB(Widget w, XtPointer client_data, XtPointer call_data)  {      int newpos = 0;      int otstat;      OPTS_LST *OptsPtr;B     XmListCallbackStruct *cb = (XmListCallbackStruct *) call_data;       newpos = cb->item_position; !     if(OptsTblSelPos == newpos) { 2         XmListDeselectPos(OptTablesListW, newpos);&         XtSetSensitive(AddBtn, False);         OptsTblSelPos = 0;7         memset(&ModifyAddStr, 0, sizeof(ModifyAddStr));          return;      } 
     else {         OptsTblSelPos = newpos; #         OptsPtr = AscOptsTableList;          OptsPtr += newpos - 1;1         strcpy(ModifyAddStr, OptsPtr->TableName); )         XtSetSensitive(AddBtn, True);          }  }     N /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  *    Function: PopupDoneCB() C  * Description: User selected the 'cancel/close' pushbutton on some G  *              popup dialog window. Determine which popup dialog, then $  *              unmanage that popup.  *&  *      Inputs: Normal callback inputs  *     Returns: None  *O  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */ F void PopupDoneCB(Widget w, XtPointer client_data, XtPointer call_data) {      int stat = 0;        switch ((int)client_data) {   3         case CANCEL_BTN:        /* Modify dialog */ =             XmListDeselectPos(OptTablesListW, OptsTblSelPos); *             XtSetSensitive(AddBtn, False);             OptsTblSelPos = 0;;             memset(&ModifyAddStr, 0, sizeof(ModifyAddStr)); '             XtUnmanageChild(ModifyDlg);              break;  4         case DISP_POPUP:        /* Display dialog */(             XtUnmanageChild(DisplayDlg);             break;  4         case ERR_POPUP:         /* ErrWarn dialog */(             XtUnmanageChild(ErrWarnDlg);             break;    9         case RADIO_POPUP:       /* DispRootMode dialog */ /             XtUnmanageChild(DispRootModePopup);              break;  1         case SAVE_POPUP:        /* Save dialog */ %             XtUnmanageChild(SaveDlg);              break;     }  }     N /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  *    Function: PushButtonCBC  * Description: User selected one of the buttons from Modify dialog L  *              popup. Determine which button and perform appropriate action  *&  *      Inputs: Normal callback inputs  *     Returns: None  *O  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */ G void PushButtonCB(Widget w, XtPointer client_data, XtPointer call_data)  {      int TableListModified = 0;
     int indx;      int selpos = 0;      int status;      int tblcnt;      char errmsgbuf[132];     String filename;     String tmpstr;     Widget SaveText;     OPTS_LST *OptsPtr;     TABLE_LST *TablePtr;  &     XmSelectionBoxCallbackStruct *cb =2         (XmSelectionBoxCallbackStruct *)call_data;       tblcnt = NumModify;      selpos = ModifySelPos;       switch ((int)client_data) {            case ADD_BTN: K             if(!strlen(ModifyAddStr)) {     /* tablename came from textw */ 5                 tmpstr = XmTextGetString(TableTextW);                   if(VerifyMode) {8                     status = VerifyAddTableName(tmpstr);.                     if(status != SS$_NORMAL) {T                         sprintf(errmsgbuf, "'%s' is an invalid\nlogical name table",(                                 tmpstr);B                         DispErrPopup("Add Table:", &errmsgbuf, 0);6                         XtSetSensitive(AddBtn, False);                         return;                      }                  } 2                 else strcpy(ModifyAddStr, tmpstr);
             } (             if((tblcnt + 1) == MAXTBL) {G                 sprintf(errmsgbuf, "Exceeded maximum table limit,\n%s", 6                                    "table not added");:                 DispErrPopup("Add Table:", &errmsgbuf, 0);?                 memset(&ModifyAddStr, 0, sizeof(ModifyAddStr));                  return; 
             }              ModifyAddTable(); %             TableListModified = TRUE; =             XmListDeselectPos(OptTablesListW, OptsTblSelPos);                n = 0;2             XtSetArg(args[n], XmNvalue, "0"); n++;M             XtSetValues(TableTextW, args, n);    /* clear table name textw */ ;             memset(&ModifyAddStr, 0, sizeof(ModifyAddStr)); *             XtSetSensitive(AddBtn, False);,             XtSetSensitive(CommitBtn, True);             break;           case COMMIT_BTN:-             CopyTableList(MODIFY_TO_CURRENT); -             XtSetSensitive(CommitBtn, False); '             XtUnmanageChild(ModifyDlg);              break;           case REMOVE_BTN:             ModifySelPos = 0;              selpos--; &             ModifyRemoveTable(selpos);'             XmUpdateDisplay(ModifyDlg); %             TableListModified = TRUE; -             XtSetSensitive(RemoveBtn, False); ,             XtSetSensitive(CommitBtn, True);             break;           case SAVE_BTN:F             SaveText = XmSelectionBoxGetChild(SaveDlg, XmDIALOG_TEXT);1             filename = XmTextGetString(SaveText); 1             if(LoggingEnabled) fprintf(lnmlog_fp, 7                 "SaveCB: Writing file %s\n", filename); 
 #ifdef LNMDBG :             printf("SaveCB: Writing file %s\n", filename); #endif.             lnmlst_fp = fopen(filename, "w+");             if(!lnmlst_fp) {#                 if(LoggingEnabled)  P                     fprintf(lnmlog_fp,"Save Tables: Cannot open %s for write\n",&                             filename);
 #ifdef LNMDBG L                 printf("Save Tables: Cannot open %s for write\n", filename); #endif<                 sprintf(errmsgbuf, "\nCannot open %s  \n%s",P                      filename, "\tfor write. Please check syntax and spelling");<                 DispErrPopup("Save Tables:", &errmsgbuf, 0);                 break;
             } $             TablePtr = AscTableList;M             fprintf(lnmlst_fp, "# LnmTool.Inp - Input file for LnmTool %s\n",                  VERSION); 3             fprintf(lnmlst_fp, "# %s\n", __DATE__); '             fprintf(lnmlst_fp, "# \n"); 0             while(strlen(TablePtr->TableName)) {E                 fprintf(lnmlst_fp, "\t%-20s\n", TablePtr->TableName);                  TablePtr++; 
             } '             fprintf(lnmlst_fp, "# \n"); 2             fprintf(lnmlst_fp, "# End of file\n");             fclose(lnmlst_fp);             XtFree(filename);*  %             XtUnmanageChild(SaveDlg);              break;     }            % }%    N /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  *    Function: QuitCBD  * Description: User selected Exit option from File in the menubar. #  *              Exit LnmTool image.   *5  *      Inputs: Parent widget, client data, call data   *     Returns: SS$_NORMAL  *O  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */*A void QuitCB(Widget w, XtPointer client_data, XtPointer call_data)  {      int quitstat;%     char CurTime[24];%#     $DESCRIPTOR(Dsc_Time, CurTime);   .     quitstat = sys$asctim(0, &Dsc_Time, 0, 0);     if(LoggingEnabled) {@         fprintf(lnmlog_fp, "LnmTool Shutdown, %s\n\n", CurTime);         fclose(lnmlog_fp);     }      delete(LnmOptsFile);     exit(SS$_NORMAL);_ }_      N /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *   *    Function: ModifyTableSelCBD  * Description: User selected an item from Modify Table list widget.G  *              If item was previously selected, sound bell and returm. G  *              If new selection, get the list position number and savet.  *              in ModifySelPos for use later.  *&  *      Inputs: Normal callback inputs  *     Returns: None  *O  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */sK void ModifyTableSelCB(Widget w, XtPointer client_data, XtPointer call_data)c {e     int selpos = 0;e     XmString SelTbl;B     XmListCallbackStruct *cb = (XmListCallbackStruct *) call_data;     TABLE_LST *ModifyPtr;u       selpos = cb->item_position;1G     if(ModifySelPos == selpos) { /* if already selected, unselect it */.         selpos--;l'         ModifyPtr = AscModifyTableList;c         ModifyPtr += selpos;C         SelTbl = XmStringCreateLtoR(ModifyPtr->TableName, charset);<0         XmListDeselectItem(ModifyListW, SelTbl);         XmStringFree(SelTbl);u)         XtSetSensitive(RemoveBtn, False);e         ModifySelPos = 0;T         return;e       } 
     else {(         XtSetSensitive(RemoveBtn, True);&         XtSetSensitive(AddBtn, False);         ModifySelPos = selpos;     }* }*      N /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  *    Function: TableSelCBK  * Description: User selected a logical name table from the Main Table listoH  *              widget. Display, in the Logicals list, all logical names4  *              which are defined within that table.G  *              If same item was previously selected, the selection is lA  *              ignored, but user gets a free, but annoying bell.a  *5  *      Inputs: Parent widget, client data, call data*  *     Returns: None  *O  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */oE void TableSelCB(Widget w, XtPointer client_data, XtPointer call_data)  {      int curpos = 0;8     int newpos = 0;      int tblstat;     char ClearBuf[10];     Cursor watch = 0;cB     XmListCallbackStruct *cb = (XmListCallbackStruct *) call_data;     XmString SelTbl;     TABLE_LST *AscTblPtr;s  C         /* Until a concealed lnm selected, button non_functional */   *     XtSetSensitive(TypeOptions[1], FALSE);  G         /* determine which list item was selected. If already selected,e#            sound bell and return */a        newpos  = cb->item_position;     if(TableSelPos == newpos) {e         DoBell(0);         return;      }e  =     memset(&TargetLogicalName, 0, sizeof(TargetLogicalName));d9     memset(&TargetTableName, 0, sizeof(TargetTableName));t  ?         /* clear the soon to be stale info from the Attributes,t:            AccessMode and Equivalence widgets as needed */  /     curpos = XmTextGetLastPosition(EquivTextW);d     if(curpos) {         NumEqv = 0; 2         memset(&ClearBuf, 0x20, sizeof(ClearBuf));         ClearBuf[0] = 0;.         XmTextSetString(EquivTextW, ClearBuf);         startpos = 0; 9         XmTextSetInsertionPosition(EquivTextW, startpos);t     }i  .     curpos = XmTextGetLastPosition(AttrTextW);     if(curpos) {7         memset(&AscAttribStr, 0, sizeof(AscAttribStr));          NumAttr = 0;2         memset(&ClearBuf, 0x20, sizeof(ClearBuf));         ClearBuf[0] = 0;-         XmTextSetString(AttrTextW, ClearBuf);;         startpos = 0;:8         XmTextSetInsertionPosition(AttrTextW, startpos);     }*0     curpos = XmTextGetLastPosition(AccessTextW);     if(curpos) {7         memset(&AscAttribStr, 0, sizeof(AscAttribStr));          NumAttr = 0;2         memset(&ClearBuf, 0x20, sizeof(ClearBuf));         ClearBuf[0] = 0;/         XmTextSetString(AccessTextW, ClearBuf);a         startpos = 0;':         XmTextSetInsertionPosition(AccessTextW, startpos);     }p       TableSelPos = newpos; 
     newpos--;m     AscTblPtr = AscTableList;      AscTblPtr += newpos;2     strcpy(TargetTableName, AscTblPtr->TableName);<     watch = XCreateFontCursor(XtDisplay(LnmForm), XC_watch);@     XDefineCursor(XtDisplay(LnmForm), XtWindow(LnmForm), watch);?     XmUpdateDisplay(LnmForm);    /* startup the Watch cursor */d     tblstat = GetTableList();r      tblstat = LoadLogicalList();:     XUndefineCursor(XtDisplay(LnmForm),XtWindow(LnmForm));$     XmUpdateDisplay(MainTableListW);   }   N /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  *    Function: HelpCB0  * Description: Callback for MenuBar help button  *5  *      Inputs: Parent widget, client data, call data*  *     Returns: None  *O  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */cA void HelpCB(Widget w, XtPointer client_data, XtPointer call_data)  {e     Widget message_box;c        switch( (int) client_data) {         case HELP_OV_BTN: /             if(HelpDlg) XtManageChild(HelpDlg);l             else InitHelpDlg();x             break;           case HELP_CLOSE_BTN:%             XtUnmanageChild(HelpDlg);a             break;           case HELP_VERS_BTN:*+             message_box = CreateVersion(w);*'             XtManageChild(message_box);g             break;     }, }P        