  L /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  *;  *               %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%\ <  *               %% \                                   %% \=  *               %%  \__________________________________%%  \ >  *               %%  |                                  %%   \?  *               %%  |              LnmTool             %%    | ?  *               %%  |        Utilities.c  c2003        %%    | ?  *               %%  |            Lyle W. West          %%    | ?  *               %%  |                                  %%    | ?  *               %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%    | ?  *               \                                        \   | ?  *                \                                        \  | ?  *                 \                                        \ | ?  *                  \________________________________________\|   *  *  *:  *   Copyright (C) 2003 Lyle W. West, All Rights Reserved.  *K  *   Permission is granted to copy and use this program so long as [1] this I  *   copyright notice is preserved, and [2] no financial gain is involved I  *   in copying the program.  This program may not be sold as "shareware" H  *   or "public domain" software without the express, written permission  *   of the author.   *M  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */    #include "version.h"  #pragma module utilities VERSION   #include <stdio.h> #include <clidef.h>  #include <ctype.h> #include <descrip.h> #include <lnmdef.h>  #include <psldef.h>  #include <ssdef.h> #include <string.h>  #include <types.h> #include <X11/cursorfont.h>  #include <X11/Intrinsic.h> #include <X11/StringDefs.h>  #include <X11/Xos.h> #include <X11/Xlib.h>  #include <X11/Xutil.h> #include <Xm/MwmUtil.h>  #include <Xm/Xm.h> #include <Xm/BulletinB.h>  #include <Xm/CascadeB.h> #include <Xm/Frame.h>  #include <Xm/Label.h>  #include <Xm/LabelG.h> #include <Xm/List.h> #include <Xm/MainW.h>  #include <Xm/PushB.h>  #include <Xm/PushBG.h> #include <Xm/RowColumn.h>  #include <Xm/SelectioB.h>  #include <Xm/Text.h> #include <Xm/TextF.h>  #include <Xm/ToggleB.h>  #include "defs.h"  #include "externs.h"   extern void AddModifySelCB();  extern void PopupDoneCB(); extern void RadioPopupCB();  extern int  TableSort();  N /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  *    Function: GetTableListJ  * Description: Given a name table in the global string 'TargetTableName',I  *              spawn a subprocess which uses dcl to read the list of log G  *              names in the specified table into a tempfile. We remove F  *              the intermediate dcl file before exiting this routine.  *  *      Inputs: None  *     Returns: None  *O  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */  void GetTableList()  {      char    comfile[80];     char    outfile[80];     int     flags = 0;     int     gtstat; G     int     taskpid = 0;        /* pid of dcl process from LIB$SPAWN */ #     $DESCRIPTOR (Dsc_Com, comfile); #     $DESCRIPTOR (Dsc_Out, outfile);   6         /* create the input/output filespec strings */  6     sprintf(comfile, "SYS$SCRATCH:CREATE_LNMLIS.COM");?     sprintf(outfile, "SYS$SCRATCH:%s.LNMLIS", TargetTableName);   +     Dsc_Com.dsc$w_length = strlen(comfile); +     Dsc_Out.dsc$w_length = strlen(outfile);   B         /* create the command file to get list of logical names */  $     lnmcom_fp = fopen(comfile, "w");     if(lnmcom_fp == -1) {          if(LoggingEnabled) {H             fprintf(lnmlog_fp, "%%LNMTOOL-E-OPEN, Cannot open '%s'\n\n",                 comfile); O             fprintf(lnmlog_fp, "%%LNMTOOL-E-EXIT, Unrecoverable error exit\n");              fclose(lnmlog_fp);	         } B         printf("%%LNMTOOL-E-OPEN, Cannot open '%s'\n\n", comfile);         exit(1);     } 7     fprintf(lnmcom_fp, "$ set default sys$scratch:\n"); F     fprintf(lnmcom_fp, "$ show logical /table=%s\n", TargetTableName);     fclose(lnmcom_fp);  .         /* set required flags for LIB$SPAWN */  ?     flags = (CLI$M_TRUSTED | CLI$M_AUTHPRIV | CLI$M_SUBSYSTEM);   @         /* then call LIB$SPAWN to get selected table contents */  2     gtstat = lib$spawn(0,       /* command line */0              &Dsc_Com,          /* input file */1              &Dsc_Out,          /* output file */ +              &flags,            /* flags */ 2              0,                 /* process name */0              &taskpid,          /* process id */7              0,                 /* completion status */ 4              0,                 /* event flag num */1              0,                 /* AST address */ 2              0,                 /* AST argument */3              0,                 /* prompt string */ )              0);                /* cli */        if(gtstat != SS$_NORMAL) {         if(LoggingEnabled) {             fprintf(lnmlog_fp,N                 "%%LNMTOOL-E-SPAWN, LIB$SPAWN failed to create LNMLIS.COM\n");O             fprintf(lnmlog_fp, "%%LNMTOOL-E-EXIT, Unrecoverable error exit\n");              fclose(lnmlog_fp);	         } M         printf("%%LNMTOOL-E-SPAWN, LIB$SPAWN failed to create LNMLIS.COM\n"); !         gtstat = delete(comfile);          exit(gtstat);      }      gtstat = delete(comfile);  }     N /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  *    Function: GetOptsList H  * Description: Retrieve a list of all logical name tables defined underF  *              the LNM$SYSTEM_DIRECTORY. By default, the main list ofJ  *              tables are those tables defined by LNM$DCL_LOGICAL for theF  *              invoking user. This routine retrieves all name tables H  *              defined in LNM$SYSTEM_DIRECTORY and loads them into the ;  *              AscOptsMasterList array for subsequent use.   *  *      Inputs: None  *     Returns: None  *O  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */  void GetOptsList() {      int  flags = 0;      int  gslstat; +     int  jpicode = 793;      /* JPI$_PID */ D     int  taskpid = 0;        /* pid of dcl process from LIB$SPAWN */     char buffer[80];     char comfile[80];      char infile[80];     char outfile[80];      char *ptr;     char *bptr;      char *eptr; #     $DESCRIPTOR (Dsc_Com, comfile); #     $DESCRIPTOR (Dsc_Out, outfile);      OPTS_LST *OptsPtr;  *         /* get process id of this image */  <     gslstat = lib$getjpi(&jpicode, 0, 0, &ActivePid, 0, 0 );  6         /* create the input/output filespec strings */  I     sprintf(comfile, "SYS$SCRATCH:CREATE_%X_OPTABLELIST.COM", ActivePid); A     sprintf(outfile, "SYS$SCRATCH:LNMTOOL_%X.LNMLST", ActivePid); !     strcpy(LnmOptsFile, outfile); +     Dsc_Com.dsc$w_length = strlen(comfile); +     Dsc_Out.dsc$w_length = strlen(outfile);   B         /* create the command file to get list of logical names */  $     lnmcom_fp = fopen(comfile, "w");     if(lnmcom_fp == -1) {          if(LoggingEnabled) {             fprintf(lnmlog_fp,C                 "%%LNMTOOL-E-OPEN, Cannot open '%s'\n\n", comfile); O             fprintf(lnmlog_fp, "%%LNMTOOL-E-EXIT, Unrecoverable error exit\n");              fclose(lnmlog_fp);	         } B         printf("%%LNMTOOL-E-OPEN, Cannot open '%s'\n\n", comfile);         exit(1);     } 7     fprintf(lnmcom_fp, "$ set default sys$scratch:\n"); ?     fprintf(lnmcom_fp, "$ sho log/table=lnm$system_directory");      fclose(lnmcom_fp);  .         /* set required flags for LIB$SPAWN */  ?     flags = (CLI$M_TRUSTED | CLI$M_AUTHPRIV | CLI$M_SUBSYSTEM);   B         /* call LIB$SPAWN to collect available tables to a file */  3     gslstat = lib$spawn(0,       /* command line */ 1               &Dsc_Com,          /* input file */ 2               &Dsc_Out,          /* output file */,               &flags,            /* flags */3               0,                 /* process name */ 1               &taskpid,          /* process id */ 8               0,                 /* completion status */5               0,                 /* event flag num */ 2               0,                 /* AST address */3               0,                 /* AST argument */ 4               0,                 /* prompt string */*               0);                /* cli */       if(gslstat != SS$_NORMAL) {          if(lnmcom_fp == -1)               if(LoggingEnabled) {"                 fprintf(lnmlog_fp,P                   "%%LNMTOOL-E-SPAWN, LIB$SPAWN failed to create LNMLIS.COM\n");S                 fprintf(lnmlog_fp, "%%LNMTOOL-E-EXIT, Unrecoverable error exit\n"); "                 fclose(lnmlog_fp);
             }              printfO                 ("%%LNMTOOL-E-SPAWN, LIB$SPAWN failed to create LNMLIS.COM\n"); &             gslstat = delete(comfile);             exit(gslstat);     }      gslstat = delete(comfile);    1         /* open the input file we just created */   (     lnmlst_fp = fopen(LnmOptsFile, "r");     if(lnmlst_fp == -1) {          if(LoggingEnabled) {H             fprintf(lnmlog_fp, "%%LNMTOOL-E-OPEN, Cannot open '%s'\n\n",                 LnmOptsFile); O             fprintf(lnmlog_fp, "%%LNMTOOL-E-EXIT, Unrecoverable error exit\n"); 	         } F         printf("%%LNMTOOL-E-OPEN, Cannot open '%s'\n\n", LnmOptsFile);         fclose(lnmlog_fp);         exit(1);     }   I         /* first get the number of actual tables in lnm$system_directory. =            Read each file line checking for a string match */        gslstat = &buffer;     while(gslstat == &buffer) { =         gslstat = fgets(buffer, sizeof(buffer)-1, lnmlst_fp); (         ptr = strstr(buffer, "[table]");         if(ptr) NumOpts++;     }   G         /* Allocate memory for the table names, rewind the file pointer -            and save the names in the table */   I     AscOptsMasterList = (OPTS_LST *) calloc(NumOpts+1, sizeof(OPTS_LST));       OptsPtr = AscOptsMasterList;        gslstat = rewind(lnmlst_fp);     gslstat = &buffer;     while(gslstat == &buffer) { =         gslstat = fgets(buffer, sizeof(buffer)-1, lnmlst_fp); (         ptr = strstr(buffer, "[table]");         if(ptr) { '             bptr = strchr(buffer, '"'); '             eptr = strchr(bptr+1, '"');              if(bptr && eptr) {C                 *eptr = 0;          /* null terminate the string */ F                 bptr++;             /* point past the double quotes */1                 strcpy(OptsPtr->TableName, bptr); (                 OptsPtr->Active = FALSE;                 OptsPtr++;
             } 	         }      }      fclose(lnmlst_fp);     delete(LnmOptsFile);     NumAvailableOpts = NumOpts;  }       N /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  *    Function: LoadLogicalList E  * Description: Load the logical names from the selected logical name E  *              table. Because SYS$TRNLNM does not present a wildcard D  *              option, it is necessary to use lib$spawn to create aE  *              file of logical names for the selected table and copy D  *              the contents of that file into memory for a list of E  *              logicals currently present within the selected table. (  *              We then delete the file.  *  *      Inputs: none0  *     Returns: TRUE = success, FALSE is failure  *O  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */  int LoadLogicalList()  {      int indx = 0;      int llstat;      char buffer[256];      char infile[80];     char logicalname[80];      char *startptr = 0;      char *endptr;      char *verifyptr;     LNM_LST  *LnmPtr;      TABLE_LST  *TablePtr;   M         /* setup TablePtr so we can update the logname count of this table */        TablePtr = AscTableList;  A         /* if this is not first pass, cleanup some memory hogs */        if(NumLnm) {'         XmListDeleteAllItems(LnmListW);          Free(AscLnmList);          NumLnm = 0;      }   /         /* define the input file we will use */   >     sprintf(infile, "SYS$SCRATCH:%s.LNMLIS", TargetTableName);#     lnmcom_fp = fopen(infile, "r");      if(lnmcom_fp == -1) { A         printf("%%LNMTOOL-E-OPEN, Cannot open '%s'\n\n", infile);          exit(1);     }   I         /* first, read all records in infile to get total record count */        while(!startptr) {<         llstat = fgets(buffer, sizeof(buffer)-1, lnmcom_fp);-         startptr = strstr(buffer, "\" = \"");          if(!startptr) { C             if(strstr(buffer, "SHOW-S-NOTRAN")) startptr = &buffer; 	         }      }      do {F         startptr = &buffer + 3;     /* point to start of lognam str */C         endptr = strchr(startptr, '"');     /* end of lognam str */          if(endptr) {,             verifyptr = strchr(endptr, '=');#             if(verifyptr) NumLnm++; @             llstat = fgets(buffer, sizeof(buffer)-1, lnmcom_fp);1             startptr = strstr(buffer, "\" = \""); 	         } 2         else startptr = strstr(buffer, "\" = \"");         if(!startptr) {              while(!startptr) {D                 llstat = fgets(buffer, sizeof(buffer)-1, lnmcom_fp);,                 if(llstat != &buffer) break;5                 startptr = strstr(buffer, "\" = \""); 
             } 	         }      } while(llstat == &buffer);   3         /* Update logname count for status popup */   
     indx = 0;      while(!indx) {?         if(strcmp(TablePtr->TableName, TargetTableName) == 0) { (             TablePtr->LnmCount = NumLnm;             indx++; 	         }          else TablePtr++;     } 
     indx = 0;   D         /* if NumLnm is still 0 at this point, we have a table whichD            seems to have no zero logical names define. Copy the NoneE            string into the AscLnmList array and into the CsLlistItems :            compound string, increment NumLnm and return */       if(!NumLnm) { <         AscLnmList = (LNM_LST *) calloc(2, sizeof(LNM_LST));         LnmPtr = AscLnmList;,         strcpy(LnmPtr->LogName, "< None >");         CsLlistItems[indx] =G             (XmString)XmStringCreateLtoR(AscLnmList->LogName, charset);          n = 0;7         XtSetArg(args[n], XmNitems, CsLlistItems); n++; 0         XtSetArg(args[n], XmNitemCount, 1); n++;'         XtSetValues(LnmListW, args, n);            fclose(lnmcom_fp);         delete(infile);          return(TRUE);      }   B         /* now we know how many, read file again, get the names */       llstat = rewind(lnmcom_fp);   <         /* reserve the memory for the ascii logical names */  A     AscLnmList = (LNM_LST *) calloc(NumLnm + 1, sizeof(LNM_LST));      LnmPtr = AscLnmList;  =         /* Reread each record to get logical names. Save each 8            logical in 'AscLnmList' and 'CsLlistItems' */  
     indx = 0;      startptr = 0;      while(!startptr) {<         llstat = fgets(buffer, sizeof(buffer)-1, lnmcom_fp);-         startptr = strstr(buffer, "\" = \"");      }      startptr = &buffer + 2;      do {         startptr++; +         endptr = strstr(buffer, "\" = \"");          if(endptr) {             *endptr = 0;.             strcpy(LnmPtr->LogName, startptr);,             CsLlistItems[indx] = (XmString) =                 XmStringCreateLtoR(LnmPtr->LogName, charset);              LnmPtr++;              indx++; 	         } <         llstat = fgets(buffer, sizeof(buffer)-1, lnmcom_fp);$         if(llstat != &buffer) break;-         startptr = strstr(buffer, "\" = \"");          if(!startptr) {              while(!startptr) {D                 llstat = fgets(buffer, sizeof(buffer)-1, lnmcom_fp);,                 if(llstat != &buffer) break;5                 startptr = strstr(buffer, "\" = \""); 
             } 	         }          startptr = &buffer + 2;      } while(indx <= NumLnm);  
     n = 0;3     XtSetArg(args[n], XmNitems, CsLlistItems); n++; 1     XtSetArg(args[n], XmNitemCount, NumLnm); n++; #     XtSetValues(LnmListW, args, n);        XmUpdateDisplay(LnmForm);      fclose(lnmcom_fp);     delete(infile);      XmStringFree(CsLlistItems); =     memset(&TargetLogicalName, 0, sizeof(TargetLogicalName));      return(TRUE);  }       N /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  *    Function: LoadTableList*H  * Description: Determine the number of tables referenced by the logicalI  *              name LNM$FILE_DEV. Use this value to allocate an array of F  *              ascii table names. Then transform the ascii table intoJ  *              compound strings which is then loaded into the List widgetL  *              'MainTableListW. We free the ascii table info at entry if itH  *              it is non-null, ie, was prev used and we need a new one.  *  *      Inputs: None0  *     Returns: TRUE = success, FALSE is anomoly  *O  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */% int LoadTableList()% {%     int indx = 0;      int max_indx = 0;      int status;      short EqvLen = 0;      char ClearBuf[10];     char EquivStr[80];       ITEM_LST  *LnmItem;      TABLE_LST *TablePtr;)     $DESCRIPTOR(Dsc_Lnm, "LNM$FILE_DEV");_1     $DESCRIPTOR(Dsc_Tbl, "LNM$SYSTEM_DIRECTORY");        if(NumTbl) {         Free(AscTableList);h-         XmListDeleteAllItems(MainTableListW);          NumTbl = 0;g     }l  /         /* clear various items if attributes ord3            equivalents were previously displayed */y  *     LnmItem = calloc(3, sizeof(ITEM_LST));)     LnmItem[0].length = sizeof(max_indx);o%     LnmItem[0].code = LNM$_MAX_INDEX;m"     LnmItem[0].buffer = &max_indx;     LnmItem[0].retlen = 0;;     status = sys$trnlnm(0, &Dsc_Tbl, &Dsc_Lnm, 0, LnmItem);"*     if(status != SS$_NORMAL) exit(status);       NumTbl = max_indx + 1;G     AscTableList = (TABLE_LST *) calloc(max_indx+1, sizeof(TABLE_LST));f     TablePtr = AscTableList;  <         /* Reinit LnmItem to get table names. Get each tableD            name and save in 'AscTableList' array and CsTlistItems */  %     LnmItem[0].length = sizeof(indx);u!     LnmItem[0].code = LNM$_INDEX;i     LnmItem[0].buffer = &indx;     LnmItem[0].retlen = 0;)     LnmItem[1].length = sizeof(EquivStr);>"     LnmItem[1].code = LNM$_STRING;!     LnmItem[1].buffer = EquivStr;>      LnmItem[1].retlen = &EqvLen;  -     for(indx = 0; indx <= max_indx; indx++) {m?         status = sys$trnlnm(0, &Dsc_Tbl, &Dsc_Lnm, 0, LnmItem); .         if(status != SS$_NORMAL) exit(status);         EquivStr[EqvLen] = 0;u.         strcpy(TablePtr->TableName, EquivStr);K         TablePtr->LnmCount = 32768;      /* says value not valid (X8000) */          TablePtr++;r     }        TablePtr = AscTableList;  *         /* sort new list of table names */  B     qsort((void *)TablePtr, NumTbl, sizeof(TABLE_LST), TableSort);  8         /* Move table list onto compound string array */       TablePtr = AscTableList;-     for(indx = 0; indx <= max_indx; indx++) { '         CsTlistItems[indx] = (XmString)e=             XmStringCreateLtoR(TablePtr->TableName, charset);i         TablePtr++;      }   C         /* Update the target table list with new number of items */*  
     n = 0;3     XtSetArg(args[n], XmNitems, CsTlistItems); n++;(1     XtSetArg(args[n], XmNitemCount, NumTbl); n++;l3     XtSetArg(args[n], XmNvisibleItemCount, 5); n++; )     XtSetValues(MainTableListW, args, n);c       Free(LnmItem);     XmStringFree(CsTlistItems);      return(TRUE);S }P      N /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *"  *    Function: VerifyAddTableNameF  * Description: User has entered a logical name table string into the H  *              Modify Popup tablename widget. By default, this routine I  *              is called to verify entered table is in this list. If theiH  *              process logical LNMTOOL_VERIFY is defined to False, thisL  *              routine is not called. Final implementation of this function&  *              has not be determined.  *  *      Inputs: NoneB  *     Returns: Success = SS$_NORMAL, else SS$_ITEMNOTFOUND (2640)  *O  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */T' int VerifyAddTableName(char *nametable)e {      int indx = 0;      int vtnstat;     char buffer[256];l     OPTS_LST *OptsPtr;  E         /* check each array element for a string match of the entered @            table name. If a match is found, return SS$_NORMAL */       OptsPtr = AscOptsTableList;C     vtnstat = &buffer;       while(indx < NumOpts) {aJ         if(strcmp(nametable, OptsPtr->TableName) == 0) return(SS$_NORMAL);         else {             OptsPtr++;             indx++;i	         }/     }      return(SS$_ITEMNOTFOUND);t }       N /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *"  *    Function: CreateDisplayPopupI  * Description: This routine creates a bulletinboard dialog which is usedoK  *              by various display functions to display user requested info H  *              collected by LnmTool. Three widgets are created at imageG  *              startup; the display dialog, a scrolled text work area, H  *              and an exit pushbutton. Functions which use this routineK  *              must set up the banner, geometry, etc each time it is used. H  *              Note that 'DisplayDlg' is created unmanaged, that too isA  *              the reponsiblity of functions using this routine.t  *  *      Inputs: None  *     Returns: None  *O  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */  void CreateDisplayPopup()l {      XmString CpStr;)    /         /* Create BulletinBoard Dialog for main*0            popup and assciated button widgets */  
     n = 0;1     CpStr = XmStringCreateSimple("Display Root");D2     XtSetArg(args[n], XmNdialogTitle, CpStr); n++;*     XtSetArg(args[n], XmNwidth, 535); n++;+     XtSetArg(args[n], XmNheight, 410); n++; L     XtSetArg(args[n], XmNdialogStyle, XmDIALOG_FULL_APPLICATION_MODAL); n++;5     XtSetArg(args[n], XmNdefaultPosition, True); n++; P     DisplayDlg = XmCreateBulletinBoardDialog(LnmForm, "DisplayDialog", args, n);     XmStringFree(CpStr);  9         /* Create ScrolledText to display textual info */   
     n = 0;%     XtSetArg(args[n], XmNx, 10); n++;*%     XtSetArg(args[n], XmNy, 20); n++;*/     XtSetArg(args[n], XmNeditable, False); n++;n;     XtSetArg(args[n], XmNeditMode, XmMULTI_LINE_EDIT); n++; <     XtSetArg(args[n], XmNcursorPositionVisible, False); n++;(     XtSetArg(args[n], XmNrows, 24); n++;+     XtSetArg(args[n], XmNcolumns, 80); n++;l<     XtSetArg(args[n], XmNscrollingPolicy, XmAUTOMATIC); n++;C     XtSetArg(args[n], XmNscrollBarDisplayPolicy, XmAS_NEEDED); n++;RM     DisplayTextW = XmCreateScrolledText(DisplayDlg, "DisplayTextW", args, n);       XtManageChild(DisplayTextW);  .         /* Create PushButton to close popup */  1     CpStr = XmStringCreateLtoR("Close", charset);/
     n = 0;)     XtSetArg(args[n], XmNwidth, 80); n++;L*     XtSetArg(args[n], XmNheight, 30); n++;&     XtSetArg(args[n], XmNx, 240); n++;&     XtSetArg(args[n], XmNy, 375); n++;2     XtSetArg(args[n], XmNlabelString, CpStr); n++;I     CloseBtn = XmCreatePushButtonGadget(DisplayDlg, "CloseBtn", args, n); J     XtAddCallback(CloseBtn, XmNactivateCallback, PopupDoneCB, DISP_POPUP);     XtManageChild(CloseBtn);     XmStringFree(CpStr);   }       N /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *'  *    Function: CreateDispRootModePopup"D  * Description: Select 4 Columns 2 Columns, or 1 Column mode for theG  *              Display Root screen output. This routine is called from'B  *              application startup and is displayed when the user@  *              selects the menu bar Options => Format sequence.  *  *      Inputs: None  *     Returns: None  *O  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */T void CreateDispRootModePopup() {E     char    titlestr[20];$     char    actionstr[80];     XmString Title;      XmString Action;B     Widget button, Col1ToglBtnLbl, Col2ToglBtnLbl, Col4ToglBtnLbl;G     Widget RadioRC, RadioParent, Col1ToglBtn, Col2ToglBtn, Col4ToglBtn;         sprintf(titlestr, "Format");8     sprintf(actionstr, " Root  Display\nColumn Format");  2     Title = XmStringCreateLtoR(titlestr, charset);5     Action = XmStringCreateLtoR(actionstr, charset);    
     n = 0;2     XtSetArg(args[n], XmNdialogTitle, Title); n++;5     XtSetArg(args[n], XmNmessageString, Action); n++; L     XtSetArg(args[n], XmNdialogStyle, XmDIALOG_FULL_APPLICATION_MODAL); n++;*     XtSetArg(args[n], XmNwidth, 150); n++;L     DispRootModePopup = XmCreateQuestionDialog(LnmForm, "DispRootModePopup",8                                                args, n);O     XtAddCallback (DispRootModePopup, XmNokCallback, PopupDoneCB, RADIO_POPUP);L     XmStringFree(Action);      XmStringFree(Title);  %         /* remove unneeded buttons */nK     button = XmMessageBoxGetChild(DispRootModePopup, XmDIALOG_HELP_BUTTON);      XtUnmanageChild(button);M     button = XmMessageBoxGetChild(DispRootModePopup, XmDIALOG_CANCEL_BUTTON);e     XtUnmanageChild(button);  M         /* Create a row column widget for the 'Root Display' radio buttons */i  
     n = 0;%     XtSetArg(args[n], XmNx, 44); n++;t$     XtSetArg(args[n], XmNy, 0); n++;*     XtSetArg(args[n], XmNwidth, 180); n++;2     XtSetArg(args[n], XmNshadowThickness, 3); n++;4     XtSetArg(args[n], XmNradioAlwaysOne, True); n++;3     XtSetArg(args[n], XmNradioBehavior, True); n++; ?     XtSetArg(args[n], XmNentryAlignment, XmALIGNMENT_END); n++;aG     RadioRC = XmCreateRowColumn(DispRootModePopup, "RadioRC", args, n);x     XtManageChild(RadioRC);f  
     n = 0;7     XtSetArg(args[n], XmNorientation, XmVERTICAL); n++; *     XtSetArg(args[n], XmNwidth, 160); n++;B     XtSetArg(args[n], XmNentryAlignment, XmALIGNMENT_CENTER); n++;D     RadioParent = XmCreateRadioBox(RadioRC, "RadioParent", args, n);     XtManageChild(RadioParent);e  O     Col1ToglBtnLbl = XmStringCreateLtoR("1 Column ", XmSTRING_DEFAULT_CHARSET);eO     Col2ToglBtnLbl = XmStringCreateLtoR("2 Columns", XmSTRING_DEFAULT_CHARSET); O     Col4ToglBtnLbl = XmStringCreateLtoR("4 Columns", XmSTRING_DEFAULT_CHARSET);   @         /* Create toggle buttons for Root Display Column mode */  2     n = 0;      /* first the '4 Columns' button */%     XtSetArg(args[n], XmNx, 30); n++;f;     XtSetArg(args[n], XmNlabelString, Col4ToglBtnLbl); n++;e2     XtSetArg(args[n], XmNshadowThickness, 0); n++;+     XtSetArg(args[n], XmNspacing, 15); n++;rL     Col4ToglBtn = XmCreateToggleButton(RadioParent, "Col4ToglBtn", args, n);     XtManageChild(Col4ToglBtn); !     XmStringFree(Col4ToglBtnLbl);   1     n = 0;      /* then the '2 Columns' button */ %     XtSetArg(args[n], XmNx, 30); n++; ;     XtSetArg(args[n], XmNlabelString, Col2ToglBtnLbl); n++;+2     XtSetArg(args[n], XmNshadowThickness, 0); n++;L     Col2ToglBtn = XmCreateToggleButton(RadioParent, "Col2ToglBtn", args, n);     XtManageChild(Col2ToglBtn);*!     XmStringFree(Col2ToglBtnLbl);*  0     n = 0;      /* last the '1 Column' button */%     XtSetArg(args[n], XmNx, 30); n++;f;     XtSetArg(args[n], XmNlabelString, Col1ToglBtnLbl); n++;e2     XtSetArg(args[n], XmNshadowThickness, 0); n++;L     Col1ToglBtn = XmCreateToggleButton(RadioParent, "Col1ToglBtn", args, n);     XtManageChild(Col1ToglBtn);t!     XmStringFree(Col1ToglBtnLbl);   I         /* set startup state to same as DisplayRootMode value, default issK            COLSMODE_2, unless modified by startup logical LNMTOOL_FORMAT */e       switch(DisplayRootMode) {o         case COLSMODE_4:<             XmToggleButtonSetState(Col4ToglBtn, TRUE, TRUE);             break;         case COLSMODE_2:<             XmToggleButtonSetState(Col2ToglBtn, TRUE, TRUE);             break;         case COLSMODE_1:<             XmToggleButtonSetState(Col1ToglBtn, TRUE, TRUE);             break;     }h  -         /* Add Callbacks for radio buttons */_  I     XtAddCallback(Col4ToglBtn, XmNarmCallback, RadioPopupCB, COLSMODE_4);uI     XtAddCallback(Col2ToglBtn, XmNarmCallback, RadioPopupCB, COLSMODE_2);iI     XtAddCallback(Col1ToglBtn, XmNarmCallback, RadioPopupCB, COLSMODE_1);    }t    AllItems(LnmListW);          Free(AscLnmList);          NumLnm = 0;      }   /         /* define the input file we will use */   >     sprintf(infile, "SYS$SCRATCH:%s.LNMLIS", TargetTableName);#     lnmcom_fp = fopen(infile, "r");      if(lnmcom_fp == -1) { A                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         