/*
 * The Apache Software License, Version 1.1
 *
 *
 * Copyright (c) 1999 The Apache Software Foundation.  All rights 
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer. 
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:  
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "Xalan" and "Apache Software Foundation" must
 *    not be used to endorse or promote products derived from this
 *    software without prior written permission. For written 
 *    permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache",
 *    nor may "Apache" appear in their name, without prior written
 *    permission of the Apache Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation and was
 * originally based on software copyright (c) 1999, International
 * Business Machines, Inc., http://www.ibm.com.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */
#if !defined(XALANDECIMALFORMAT_HEADER_GUARD_1357924680)
#define XALANDECIMALFORMAT_HEADER_GUARD_1357924680



// Base include file.  Must be first.
#include <PlatformSupport/PlatformSupportDefinitions.hpp>



#include <XalanDOM/XalanDOMString.hpp>



// Base class header file.
#include <PlatformSupport/XalanDecimalFormatSymbols.hpp>
#include <PlatformSupport/XalanNumberFormat.hpp>



class XALAN_PLATFORMSUPPORT_EXPORT XalanDecimalFormat : public XalanNumberFormat
{
public:

	/**
	 * Constructor
	 * 
	 * @param thePatternString string defining how output should be formatted
	 * @param theSymbols       class defining the symbols used for output, for
	 *                         example, symbol for currency
	 */
	explicit
	XalanDecimalFormat(
			const XalanDOMString&				thePatternString = XalanDOMString(),
			const XalanDecimalFormatSymbols&	theSymbols = XalanDecimalFormatSymbols());

	virtual
	~XalanDecimalFormat();

	// From NumberFormat...
	virtual XalanDOMString
	format(double	theValue);

	virtual XalanDOMString
	format(int	theValue);

	virtual XalanDOMString
	format(unsigned int		theValue);

	virtual XalanDOMString
	format(long		theValue);

	virtual XalanDOMString
	format(unsigned long	theValue);


	// New for XalanDecimalFormat...

	/**
	 * Retrieve class defining symbols used for output
	 * 
	 * @return class defining the symbols used for output, for example, symbol
	 *         for currency
	 */
	const XalanDecimalFormatSymbols&
	getDecimalFormatSymbols() const
	{
		return m_decimalFormatSymbols;
	}

	/**
	 * Set class defining symbols used for output
	 * 
	 * @param class defining the symbols used for output, for example, symbol
	 *        for currency
	 */
	void
	setDecimalFormatSymbols(const XalanDecimalFormatSymbols&	theDecimalFormatSymbols)
	{
		m_decimalFormatSymbols = theDecimalFormatSymbols;
	}

	void
	applyPattern(const XalanDOMString&	thePattern);

	void
	applyLocalizedPattern(const XalanDOMString&		thePattern);

protected:

	XalanDOMString
	getNormalizedPattern(const XalanDOMString&	thePattern);

private:

	// Not implemented
	XalanDecimalFormat(const XalanDecimalFormat&);

	XalanDecimalFormat&
	operator=(const XalanDecimalFormat&);

	bool
	operator==(const XalanDecimalFormat&);


	// Data members...
	XalanDOMString					m_patternString;

	XalanDecimalFormatSymbols		m_decimalFormatSymbols;

	static const XalanDOMString		s_defaultPatternString;
};


#endif	// XALANDECIMALFORMAT_HEADER_GUARD_1357924680
