/*
 * The Apache Software License, Version 1.1
 *
 *
 * Copyright (c) 1999 The Apache Software Foundation.  All rights 
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer. 
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:  
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "Xalan" and "Apache Software Foundation" must
 *    not be used to endorse or promote products derived from this
 *    software without prior written permission. For written 
 *    permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache",
 *    nor may "Apache" appear in their name, without prior written
 *    permission of the Apache Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation and was
 * originally based on software copyright (c) 1999, International
 * Business Machines, Inc., http://www.ibm.com.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 *
 * @author <a href="mailto:david_n_bertoni@lotus.com">David N. Bertoni</a>
 */

#include "Constants.hpp"



#include <PlatformSupport/DOMStringHelper.hpp>



static XalanDOMString		ATTRNAME_AMOUNT;
static XalanDOMString		ATTRNAME_ANCESTOR;
static XalanDOMString		ATTRNAME_ARCHIVE;
static XalanDOMString		ATTRNAME_ATTRIBUTE;
static XalanDOMString		ATTRNAME_ATTRIBUTE_SET;
static XalanDOMString		ATTRNAME_CASEORDER;
static XalanDOMString		ATTRNAME_CLASS;
static XalanDOMString		ATTRNAME_CLASSID;
static XalanDOMString		ATTRNAME_CODEBASE;
static XalanDOMString		ATTRNAME_CODETYPE;
static XalanDOMString		ATTRNAME_COMPONENTS;
static XalanDOMString		ATTRNAME_CONDITION;
static XalanDOMString		ATTRNAME_COPYTYPE;
static XalanDOMString		ATTRNAME_COUNT;
static XalanDOMString		ATTRNAME_DATATYPE;
static XalanDOMString		ATTRNAME_DECIMALSEPARATOR;
static XalanDOMString		ATTRNAME_DEFAULT;
static XalanDOMString		ATTRNAME_DEFAULTSPACE;
static XalanDOMString		ATTRNAME_DEPTH;
static XalanDOMString		ATTRNAME_DIGIT;
static XalanDOMString		ATTRNAME_DIGITGROUPSEP;
static XalanDOMString		ATTRNAME_DISABLE_OUTPUT_ESCAPING;
static XalanDOMString		ATTRNAME_ELEMENT;
static XalanDOMString		ATTRNAME_ELEMENTS;
static XalanDOMString		ATTRNAME_EXCLUDE_RESULT_PREFIXES;
static XalanDOMString		ATTRNAME_EXPR;
static XalanDOMString		ATTRNAME_EXTENSIONELEMENTPREFIXES;
static XalanDOMString		ATTRNAME_FORMAT;
static XalanDOMString		ATTRNAME_FROM;
static XalanDOMString		ATTRNAME_FUNCTIONS;
static XalanDOMString		ATTRNAME_GROUPINGSEPARATOR;
static XalanDOMString		ATTRNAME_GROUPINGSIZE;
static XalanDOMString		ATTRNAME_HREF;
static XalanDOMString		ATTRNAME_ID;
static XalanDOMString		ATTRNAME_IMPORTANCE;
static XalanDOMString		ATTRNAME_INDENTRESULT;
static XalanDOMString		ATTRNAME_INFINITY;
static XalanDOMString		ATTRNAME_LANG;
static XalanDOMString		ATTRNAME_LETTERVALUE;
static XalanDOMString		ATTRNAME_LEVEL;
static XalanDOMString		ATTRNAME_MATCH;
static XalanDOMString		ATTRNAME_METHOD;
static XalanDOMString		ATTRNAME_MINUSSIGN;
static XalanDOMString		ATTRNAME_MODE;
static XalanDOMString		ATTRNAME_NAME;
static XalanDOMString		ATTRNAME_NAMESPACE;
static XalanDOMString		ATTRNAME_NAN;
static XalanDOMString		ATTRNAME_NDIGITSPERGROUP;
static XalanDOMString		ATTRNAME_NS;
static XalanDOMString		ATTRNAME_ONLY;
static XalanDOMString		ATTRNAME_ORDER;
static XalanDOMString		ATTRNAME_OUTPUT_CDATA_SECTION_ELEMENTS;
static XalanDOMString		ATTRNAME_OUTPUT_DOCTYPE_PUBLIC;
static XalanDOMString		ATTRNAME_OUTPUT_DOCTYPE_SYSTEM;
static XalanDOMString		ATTRNAME_OUTPUT_ENCODING;
static XalanDOMString		ATTRNAME_OUTPUT_INDENT;
static XalanDOMString		ATTRNAME_OUTPUT_MEDIATYPE;
static XalanDOMString		ATTRNAME_OUTPUT_METHOD;
static XalanDOMString		ATTRNAME_OUTPUT_OMITXMLDECL;
static XalanDOMString		ATTRNAME_OUTPUT_STANDALONE;
static XalanDOMString		ATTRNAME_OUTPUT_VERSION;
static XalanDOMString		ATTRNAME_PATTERNSEPARATOR;
static XalanDOMString		ATTRNAME_PERCENT;
static XalanDOMString		ATTRNAME_PERMILLE;
static XalanDOMString		ATTRNAME_PREFIX;
static XalanDOMString		ATTRNAME_PRIORITY;
static XalanDOMString		ATTRNAME_REFID;
static XalanDOMString		ATTRNAME_RESULTNS;
static XalanDOMString		ATTRNAME_RESULT_PREFIX;
static XalanDOMString		ATTRNAME_SCRIPT;
static XalanDOMString		ATTRNAME_SELECT;
static XalanDOMString		ATTRNAME_SEQUENCESRC;
static XalanDOMString		ATTRNAME_SRC;
static XalanDOMString		ATTRNAME_STYLE;
static XalanDOMString		ATTRNAME_STYLESHEET_PREFIX;
static XalanDOMString		ATTRNAME_TERMINATE;
static XalanDOMString		ATTRNAME_TEST;
static XalanDOMString		ATTRNAME_TOSTRING;
static XalanDOMString		ATTRNAME_TYPE;
static XalanDOMString		ATTRNAME_USE;
static XalanDOMString		ATTRNAME_USEATTRIBUTESETS;
static XalanDOMString		ATTRNAME_VALUE;
static XalanDOMString		ATTRNAME_VERSION;
static XalanDOMString		ATTRNAME_XMLNS;
static XalanDOMString		ATTRNAME_XMLNSDEF;
static XalanDOMString		ATTRNAME_XMLSPACE;
static XalanDOMString		ATTRNAME_ZERODIGIT;

static XalanDOMString		ATTRTYPE_CDATA;

static XalanDOMString		ATTRVAL_ALPHABETIC;
static XalanDOMString		ATTRVAL_ANCESTOR;
static XalanDOMString		ATTRVAL_ANY;
static XalanDOMString		ATTRVAL_CASEORDER_LOWER;
static XalanDOMString		ATTRVAL_CASEORDER_UPPER;
static XalanDOMString		ATTRVAL_DATATYPE_NUMBER;
static XalanDOMString		ATTRVAL_DATATYPE_TEXT;
static XalanDOMString		ATTRVAL_DEFAULT;
static XalanDOMString		ATTRVAL_DEFAULT_PREFIX;
static XalanDOMString		ATTRVAL_DEFAULT_TEXT_RULE;
static XalanDOMString		ATTRVAL_ID;
static XalanDOMString		ATTRVAL_INFINITY;
static XalanDOMString		ATTRVAL_MULTI;
static XalanDOMString		ATTRVAL_NAN;
static XalanDOMString		ATTRVAL_NO;
static XalanDOMString		ATTRVAL_ORDER_ASCENDING;
static XalanDOMString		ATTRVAL_ORDER_DESCENDING;
static XalanDOMString		ATTRVAL_OTHER;
static XalanDOMString		ATTRVAL_OUTPUT_METHOD_HTML;
static XalanDOMString		ATTRVAL_OUTPUT_METHOD_TEXT;
static XalanDOMString		ATTRVAL_OUTPUT_METHOD_XML;
static XalanDOMString		ATTRVAL_PARENT;
static XalanDOMString		ATTRVAL_PRESERVE;
static XalanDOMString		ATTRVAL_SIMPLE;
static XalanDOMString		ATTRVAL_SINGLE;
static XalanDOMString		ATTRVAL_STRIP;
static XalanDOMString		ATTRVAL_THIS;
static XalanDOMString		ATTRVAL_YES;

static XalanDOMString		DEFAULT_DECIMAL_FORMAT;
static XalanDOMString		DEFAULT_WHITESPACE_SEPARATOR_STRING;

static XalanDOMString		ELEMNAME_ANCHOR_STRING;
static XalanDOMString		ELEMNAME_ANY_STRING;
static XalanDOMString		ELEMNAME_APPLY_IMPORTS_STRING;
static XalanDOMString		ELEMNAME_APPLY_TEMPLATES_STRING;
static XalanDOMString		ELEMNAME_APPLY_TEMPLATES_WITH_PREFIX_STRING;
static XalanDOMString		ELEMNAME_ARG_STRING;
static XalanDOMString		ELEMNAME_ATTRIBUTESET_STRING;
static XalanDOMString		ELEMNAME_ATTRIBUTE_STRING;
static XalanDOMString		ELEMNAME_CALLTEMPLATEARG_STRING;
static XalanDOMString		ELEMNAME_CALLTEMPLATE_STRING;
static XalanDOMString		ELEMNAME_CALL_STRING;
static XalanDOMString		ELEMNAME_CHILDREN_STRING;
static XalanDOMString		ELEMNAME_CHOOSE_STRING;
static XalanDOMString		ELEMNAME_COMMENT_STRING;
static XalanDOMString		ELEMNAME_COMPONENT_STRING;
static XalanDOMString		ELEMNAME_CONSTRUCT_STRING;
static XalanDOMString		ELEMNAME_CONTENTS_STRING;
static XalanDOMString		ELEMNAME_COPY_OF_STRING;
static XalanDOMString		ELEMNAME_COPY_STRING;
static XalanDOMString		ELEMNAME_COUNTERINCREMENT_STRING;
static XalanDOMString		ELEMNAME_COUNTERRESET_STRING;
static XalanDOMString		ELEMNAME_COUNTERSCOPE_STRING;
static XalanDOMString		ELEMNAME_COUNTERS_STRING;
static XalanDOMString		ELEMNAME_COUNTER_STRING;
static XalanDOMString		ELEMNAME_DECIMALFORMAT_STRING;
static XalanDOMString		ELEMNAME_DISPLAYIF_STRING;
static XalanDOMString		ELEMNAME_ELEMENT_STRING;
static XalanDOMString		ELEMNAME_EMPTY_STRING;
static XalanDOMString		ELEMNAME_EVAL_STRING;
static XalanDOMString		ELEMNAME_EXPECTEDCHILDREN_STRING;
static XalanDOMString		ELEMNAME_EXTENSIONHANDLER_STRING;
static XalanDOMString		ELEMNAME_EXTENSION_STRING;
static XalanDOMString		ELEMNAME_FALLBACK_STRING;
static XalanDOMString		ELEMNAME_FOREACH_STRING;
static XalanDOMString		ELEMNAME_HTML_STRING;
static XalanDOMString		ELEMNAME_IF_STRING;
static XalanDOMString		ELEMNAME_IMPORT_STRING;
static XalanDOMString		ELEMNAME_INCLUDE_STRING;
static XalanDOMString		ELEMNAME_KEY_STRING;
static XalanDOMString		ELEMNAME_LOCALE_STRING;
static XalanDOMString		ELEMNAME_MESSAGE_STRING;
static XalanDOMString		ELEMNAME_NSALIAS_STRING;
static XalanDOMString		ELEMNAME_NUMBER_STRING;
static XalanDOMString		ELEMNAME_OTHERWISE_STRING;
static XalanDOMString		ELEMNAME_OUTPUT_STRING;
static XalanDOMString		ELEMNAME_PARAMVARIABLE_STRING;
static XalanDOMString		ELEMNAME_PI_OLD_STRING;
static XalanDOMString		ELEMNAME_PI_STRING;
static XalanDOMString		ELEMNAME_PRESERVESPACE_STRING;
static XalanDOMString		ELEMNAME_ROOT_STRING;
static XalanDOMString		ELEMNAME_SCRIPT_STRING;
static XalanDOMString		ELEMNAME_SORT_STRING;
static XalanDOMString		ELEMNAME_STRIPSPACE_STRING;
static XalanDOMString		ELEMNAME_STYLESHEET_STRING;
static XalanDOMString		ELEMNAME_TARGETATTRIBUTE_STRING;
static XalanDOMString		ELEMNAME_TARGETCOMMENT_STRING;
static XalanDOMString		ELEMNAME_TARGETELEMENT_STRING;
static XalanDOMString		ELEMNAME_TARGETPI_STRING;
static XalanDOMString		ELEMNAME_TARGETTEXT_STRING;
static XalanDOMString		ELEMNAME_TEMPLATE_STRING;
static XalanDOMString		ELEMNAME_TEMPLATE_WITH_PREFIX_STRING;
static XalanDOMString		ELEMNAME_TEXT_STRING;
static XalanDOMString		ELEMNAME_TRANSFORM_STRING;
static XalanDOMString		ELEMNAME_URL_STRING;
static XalanDOMString		ELEMNAME_USE_STRING;
static XalanDOMString		ELEMNAME_VALUEOF_STRING;
static XalanDOMString		ELEMNAME_VALUEOF_WITH_PREFIX_STRING;
static XalanDOMString		ELEMNAME_VARIABLE_STRING;
static XalanDOMString		ELEMNAME_WHEN_STRING;
static XalanDOMString		ELEMNAME_WITHPARAM_STRING;

static XalanDOMString		PSEUDONAME_ANY;
static XalanDOMString		PSEUDONAME_COMMENT;
static XalanDOMString		PSEUDONAME_NODE;
static XalanDOMString		PSEUDONAME_OTHER;
static XalanDOMString		PSEUDONAME_PI;
static XalanDOMString		PSEUDONAME_ROOT;
static XalanDOMString		PSEUDONAME_TEXT;



const XalanDOMString&		Constants::ATTRNAME_AMOUNT = ::ATTRNAME_AMOUNT;
const XalanDOMString&		Constants::ATTRNAME_ANCESTOR = ::ATTRNAME_ANCESTOR;
const XalanDOMString&		Constants::ATTRNAME_ARCHIVE = ::ATTRNAME_ARCHIVE;
const XalanDOMString&		Constants::ATTRNAME_ATTRIBUTE = ::ATTRNAME_ATTRIBUTE;
const XalanDOMString&		Constants::ATTRNAME_ATTRIBUTE_SET = ::ATTRNAME_ATTRIBUTE_SET;
const XalanDOMString&		Constants::ATTRNAME_CASEORDER = ::ATTRNAME_CASEORDER;
const XalanDOMString&		Constants::ATTRNAME_CLASS = ::ATTRNAME_CLASS;
const XalanDOMString&		Constants::ATTRNAME_CLASSID = ::ATTRNAME_CLASSID;
const XalanDOMString&		Constants::ATTRNAME_CODEBASE = ::ATTRNAME_CODEBASE;
const XalanDOMString&		Constants::ATTRNAME_CODETYPE = ::ATTRNAME_CODETYPE;
const XalanDOMString&		Constants::ATTRNAME_COMPONENTS = ::ATTRNAME_COMPONENTS;
const XalanDOMString&		Constants::ATTRNAME_CONDITION = ::ATTRNAME_CONDITION;
const XalanDOMString&		Constants::ATTRNAME_COPYTYPE = ::ATTRNAME_COPYTYPE;
const XalanDOMString&		Constants::ATTRNAME_COUNT = ::ATTRNAME_COUNT;
const XalanDOMString&		Constants::ATTRNAME_DATATYPE = ::ATTRNAME_DATATYPE;
const XalanDOMString&		Constants::ATTRNAME_DECIMALSEPARATOR = ::ATTRNAME_DECIMALSEPARATOR;
const XalanDOMString&		Constants::ATTRNAME_DEFAULT = ::ATTRNAME_DEFAULT;
const XalanDOMString&		Constants::ATTRNAME_DEFAULTSPACE = ::ATTRNAME_DEFAULTSPACE;
const XalanDOMString&		Constants::ATTRNAME_DEPTH = ::ATTRNAME_DEPTH;
const XalanDOMString&		Constants::ATTRNAME_DIGIT = ::ATTRNAME_DIGIT;
const XalanDOMString&		Constants::ATTRNAME_DIGITGROUPSEP = ::ATTRNAME_DIGITGROUPSEP;
const XalanDOMString&		Constants::ATTRNAME_DISABLE_OUTPUT_ESCAPING  = ::ATTRNAME_DISABLE_OUTPUT_ESCAPING;
const XalanDOMString&		Constants::ATTRNAME_ELEMENT = ::ATTRNAME_ELEMENT;
const XalanDOMString&		Constants::ATTRNAME_ELEMENTS = ::ATTRNAME_ELEMENTS;
const XalanDOMString&		Constants::ATTRNAME_EXCLUDE_RESULT_PREFIXES = ::ATTRNAME_EXCLUDE_RESULT_PREFIXES;
const XalanDOMString&		Constants::ATTRNAME_EXPR = ::ATTRNAME_EXPR;
const XalanDOMString&		Constants::ATTRNAME_EXTENSIONELEMENTPREFIXES = ::ATTRNAME_EXTENSIONELEMENTPREFIXES;
const XalanDOMString&		Constants::ATTRNAME_FORMAT = ::ATTRNAME_FORMAT;
const XalanDOMString&		Constants::ATTRNAME_FROM = ::ATTRNAME_FROM;
const XalanDOMString&		Constants::ATTRNAME_FUNCTIONS = ::ATTRNAME_FUNCTIONS;
const XalanDOMString&		Constants::ATTRNAME_GROUPINGSEPARATOR = ::ATTRNAME_GROUPINGSEPARATOR;
const XalanDOMString&		Constants::ATTRNAME_GROUPINGSIZE = ::ATTRNAME_GROUPINGSIZE;
const XalanDOMString&		Constants::ATTRNAME_HREF = ::ATTRNAME_HREF;
const XalanDOMString&		Constants::ATTRNAME_ID = ::ATTRNAME_ID;
const XalanDOMString&		Constants::ATTRNAME_IMPORTANCE = ::ATTRNAME_IMPORTANCE;
const XalanDOMString&		Constants::ATTRNAME_INDENTRESULT = ::ATTRNAME_INDENTRESULT;
const XalanDOMString&		Constants::ATTRNAME_INFINITY = ::ATTRNAME_INFINITY;
const XalanDOMString&		Constants::ATTRNAME_LANG = ::ATTRNAME_LANG;
const XalanDOMString&		Constants::ATTRNAME_LETTERVALUE = ::ATTRNAME_LETTERVALUE;
const XalanDOMString&		Constants::ATTRNAME_LEVEL = ::ATTRNAME_LEVEL;
const XalanDOMString&		Constants::ATTRNAME_MATCH = ::ATTRNAME_MATCH;
const XalanDOMString&		Constants::ATTRNAME_METHOD = ::ATTRNAME_METHOD;
const XalanDOMString&		Constants::ATTRNAME_MINUSSIGN = ::ATTRNAME_MINUSSIGN;
const XalanDOMString&		Constants::ATTRNAME_MODE = ::ATTRNAME_MODE;
const XalanDOMString&		Constants::ATTRNAME_NAME = ::ATTRNAME_NAME;
const XalanDOMString&		Constants::ATTRNAME_NAMESPACE = ::ATTRNAME_NAMESPACE;
const XalanDOMString&		Constants::ATTRNAME_NAN = ::ATTRNAME_NAN;
const XalanDOMString&		Constants::ATTRNAME_NDIGITSPERGROUP = ::ATTRNAME_NDIGITSPERGROUP;
const XalanDOMString&		Constants::ATTRNAME_NS = ::ATTRNAME_NS;
const XalanDOMString&		Constants::ATTRNAME_ONLY = ::ATTRNAME_ONLY;
const XalanDOMString&		Constants::ATTRNAME_ORDER = ::ATTRNAME_ORDER;
const XalanDOMString&		Constants::ATTRNAME_OUTPUT_CDATA_SECTION_ELEMENTS  = ::ATTRNAME_OUTPUT_CDATA_SECTION_ELEMENTS;
const XalanDOMString&		Constants::ATTRNAME_OUTPUT_DOCTYPE_PUBLIC = ::ATTRNAME_OUTPUT_DOCTYPE_PUBLIC;
const XalanDOMString&		Constants::ATTRNAME_OUTPUT_DOCTYPE_SYSTEM = ::ATTRNAME_OUTPUT_DOCTYPE_SYSTEM;
const XalanDOMString&		Constants::ATTRNAME_OUTPUT_ENCODING = ::ATTRNAME_OUTPUT_ENCODING;
const XalanDOMString&		Constants::ATTRNAME_OUTPUT_INDENT = ::ATTRNAME_OUTPUT_INDENT;
const XalanDOMString&		Constants::ATTRNAME_OUTPUT_MEDIATYPE = ::ATTRNAME_OUTPUT_MEDIATYPE;
const XalanDOMString&		Constants::ATTRNAME_OUTPUT_METHOD = ::ATTRNAME_OUTPUT_METHOD;
const XalanDOMString&		Constants::ATTRNAME_OUTPUT_OMITXMLDECL = ::ATTRNAME_OUTPUT_OMITXMLDECL;
const XalanDOMString&		Constants::ATTRNAME_OUTPUT_STANDALONE  = ::ATTRNAME_OUTPUT_STANDALONE;
const XalanDOMString&		Constants::ATTRNAME_OUTPUT_VERSION = ::ATTRNAME_OUTPUT_VERSION;
const XalanDOMString&		Constants::ATTRNAME_PATTERNSEPARATOR = ::ATTRNAME_PATTERNSEPARATOR;
const XalanDOMString&		Constants::ATTRNAME_PERCENT = ::ATTRNAME_PERCENT;
const XalanDOMString&		Constants::ATTRNAME_PERMILLE = ::ATTRNAME_PERMILLE;
const XalanDOMString&		Constants::ATTRNAME_PREFIX = ::ATTRNAME_PREFIX;
const XalanDOMString&		Constants::ATTRNAME_PRIORITY = ::ATTRNAME_PRIORITY;
const XalanDOMString&		Constants::ATTRNAME_REFID = ::ATTRNAME_REFID;
const XalanDOMString&		Constants::ATTRNAME_RESULTNS = ::ATTRNAME_RESULTNS;
const XalanDOMString&		Constants::ATTRNAME_RESULT_PREFIX = ::ATTRNAME_RESULT_PREFIX;
const XalanDOMString&		Constants::ATTRNAME_SCRIPT = ::ATTRNAME_SCRIPT;
const XalanDOMString&		Constants::ATTRNAME_SELECT = ::ATTRNAME_SELECT;
const XalanDOMString&		Constants::ATTRNAME_SEQUENCESRC = ::ATTRNAME_SEQUENCESRC;
const XalanDOMString&		Constants::ATTRNAME_SRC = ::ATTRNAME_SRC;
const XalanDOMString&		Constants::ATTRNAME_STYLE = ::ATTRNAME_STYLE;
const XalanDOMString&		Constants::ATTRNAME_STYLESHEET_PREFIX = ::ATTRNAME_STYLESHEET_PREFIX;
const XalanDOMString&		Constants::ATTRNAME_TERMINATE = ::ATTRNAME_TERMINATE;
const XalanDOMString&		Constants::ATTRNAME_TEST = ::ATTRNAME_TEST;
const XalanDOMString&		Constants::ATTRNAME_TOSTRING = ::ATTRNAME_TOSTRING;
const XalanDOMString&		Constants::ATTRNAME_TYPE = ::ATTRNAME_TYPE;
const XalanDOMString&		Constants::ATTRNAME_USE = ::ATTRNAME_USE;
const XalanDOMString&		Constants::ATTRNAME_USEATTRIBUTESETS = ::ATTRNAME_USEATTRIBUTESETS;
const XalanDOMString&		Constants::ATTRNAME_VALUE = ::ATTRNAME_VALUE;
const XalanDOMString&		Constants::ATTRNAME_VERSION = ::ATTRNAME_VERSION;
const XalanDOMString&		Constants::ATTRNAME_XMLNS = ::ATTRNAME_XMLNS;
const XalanDOMString&		Constants::ATTRNAME_XMLNSDEF = ::ATTRNAME_XMLNSDEF;
const XalanDOMString&		Constants::ATTRNAME_XMLSPACE = ::ATTRNAME_XMLSPACE;
const XalanDOMString&		Constants::ATTRNAME_ZERODIGIT = ::ATTRNAME_ZERODIGIT;

const XalanDOMString&		Constants::ATTRTYPE_CDATA = ::ATTRTYPE_CDATA;

const XalanDOMString&		Constants::ATTRVAL_ALPHABETIC = ::ATTRVAL_ALPHABETIC;
const XalanDOMString&		Constants::ATTRVAL_ANCESTOR = ::ATTRVAL_ANCESTOR;
const XalanDOMString&		Constants::ATTRVAL_ANY = ::ATTRVAL_ANY;
const XalanDOMString&		Constants::ATTRVAL_CASEORDER_LOWER = ::ATTRVAL_CASEORDER_LOWER;
const XalanDOMString&		Constants::ATTRVAL_CASEORDER_UPPER = ::ATTRVAL_CASEORDER_UPPER;
const XalanDOMString&		Constants::ATTRVAL_DATATYPE_NUMBER = ::ATTRVAL_DATATYPE_NUMBER;
const XalanDOMString&		Constants::ATTRVAL_DATATYPE_TEXT = ::ATTRVAL_DATATYPE_TEXT;
const XalanDOMString&		Constants::ATTRVAL_DEFAULT = ::ATTRVAL_DEFAULT;
const XalanDOMString&		Constants::ATTRVAL_DEFAULT_PREFIX = ::ATTRVAL_DEFAULT_PREFIX;
const XalanDOMString&		Constants::ATTRVAL_DEFAULT_TEXT_RULE = ::ATTRVAL_DEFAULT_TEXT_RULE;
const XalanDOMString&		Constants::ATTRVAL_ID = ::ATTRVAL_ID;
const XalanDOMString&		Constants::ATTRVAL_INFINITY = ::ATTRVAL_INFINITY;
const XalanDOMString&		Constants::ATTRVAL_MULTI = ::ATTRVAL_MULTI;
const XalanDOMString&		Constants::ATTRVAL_NAN = ::ATTRVAL_NAN;
const XalanDOMString&		Constants::ATTRVAL_NO = ::ATTRVAL_NO;
const XalanDOMString&		Constants::ATTRVAL_ORDER_ASCENDING = ::ATTRVAL_ORDER_ASCENDING;
const XalanDOMString&		Constants::ATTRVAL_ORDER_DESCENDING = ::ATTRVAL_ORDER_DESCENDING;
const XalanDOMString&		Constants::ATTRVAL_OTHER = ::ATTRVAL_OTHER;
const XalanDOMString&		Constants::ATTRVAL_OUTPUT_METHOD_HTML = ::ATTRVAL_OUTPUT_METHOD_HTML;
const XalanDOMString&		Constants::ATTRVAL_OUTPUT_METHOD_TEXT = ::ATTRVAL_OUTPUT_METHOD_TEXT;
const XalanDOMString&		Constants::ATTRVAL_OUTPUT_METHOD_XML = ::ATTRVAL_OUTPUT_METHOD_XML;
const XalanDOMString&		Constants::ATTRVAL_PARENT = ::ATTRVAL_PARENT;
const XalanDOMString&		Constants::ATTRVAL_PRESERVE = ::ATTRVAL_PRESERVE;
const XalanDOMString&		Constants::ATTRVAL_SIMPLE = ::ATTRVAL_SIMPLE;
const XalanDOMString&		Constants::ATTRVAL_SINGLE = ::ATTRVAL_SINGLE;
const XalanDOMString&		Constants::ATTRVAL_STRIP = ::ATTRVAL_STRIP;
const XalanDOMString&		Constants::ATTRVAL_THIS = ::ATTRVAL_THIS;
const XalanDOMString&		Constants::ATTRVAL_YES = ::ATTRVAL_YES;

const XalanDOMString&		Constants::DEFAULT_DECIMAL_FORMAT = ::DEFAULT_DECIMAL_FORMAT;
const XalanDOMString&		Constants::DEFAULT_WHITESPACE_SEPARATOR_STRING = ::DEFAULT_WHITESPACE_SEPARATOR_STRING;

const XalanDOMString&		Constants::ELEMNAME_ANCHOR_STRING = ::ELEMNAME_ANCHOR_STRING;
const XalanDOMString&		Constants::ELEMNAME_ANY_STRING = ::ELEMNAME_ANY_STRING;
const XalanDOMString&		Constants::ELEMNAME_APPLY_IMPORTS_STRING = ::ELEMNAME_APPLY_IMPORTS_STRING;
const XalanDOMString&		Constants::ELEMNAME_APPLY_TEMPLATES_STRING = ::ELEMNAME_APPLY_TEMPLATES_STRING;
const XalanDOMString&		Constants::ELEMNAME_APPLY_TEMPLATES_WITH_PREFIX_STRING = ::ELEMNAME_APPLY_TEMPLATES_WITH_PREFIX_STRING;
const XalanDOMString&		Constants::ELEMNAME_ARG_STRING = ::ELEMNAME_ARG_STRING;
const XalanDOMString&		Constants::ELEMNAME_ATTRIBUTESET_STRING = ::ELEMNAME_ATTRIBUTESET_STRING;
const XalanDOMString&		Constants::ELEMNAME_ATTRIBUTE_STRING = ::ELEMNAME_ATTRIBUTE_STRING;
const XalanDOMString&		Constants::ELEMNAME_CALLTEMPLATEARG_STRING = ::ELEMNAME_CALLTEMPLATEARG_STRING;
const XalanDOMString&		Constants::ELEMNAME_CALLTEMPLATE_STRING = ::ELEMNAME_CALLTEMPLATE_STRING;
const XalanDOMString&		Constants::ELEMNAME_CALL_STRING = ::ELEMNAME_CALL_STRING;
const XalanDOMString&		Constants::ELEMNAME_CHILDREN_STRING = ::ELEMNAME_CHILDREN_STRING;
const XalanDOMString&		Constants::ELEMNAME_CHOOSE_STRING = ::ELEMNAME_CHOOSE_STRING;
const XalanDOMString&		Constants::ELEMNAME_COMMENT_STRING = ::ELEMNAME_COMMENT_STRING;
const XalanDOMString&		Constants::ELEMNAME_COMPONENT_STRING = ::ELEMNAME_COMPONENT_STRING;
const XalanDOMString&		Constants::ELEMNAME_CONSTRUCT_STRING = ::ELEMNAME_CONSTRUCT_STRING;
const XalanDOMString&		Constants::ELEMNAME_CONTENTS_STRING = ::ELEMNAME_CONTENTS_STRING;
const XalanDOMString&		Constants::ELEMNAME_COPY_OF_STRING = ::ELEMNAME_COPY_OF_STRING;
const XalanDOMString&		Constants::ELEMNAME_COPY_STRING = ::ELEMNAME_COPY_STRING;
const XalanDOMString&		Constants::ELEMNAME_COUNTERINCREMENT_STRING = ::ELEMNAME_COUNTERINCREMENT_STRING;
const XalanDOMString&		Constants::ELEMNAME_COUNTERRESET_STRING = ::ELEMNAME_COUNTERRESET_STRING;
const XalanDOMString&		Constants::ELEMNAME_COUNTERSCOPE_STRING = ::ELEMNAME_COUNTERSCOPE_STRING;
const XalanDOMString&		Constants::ELEMNAME_COUNTERS_STRING = ::ELEMNAME_COUNTERS_STRING;
const XalanDOMString&		Constants::ELEMNAME_COUNTER_STRING = ::ELEMNAME_COUNTER_STRING;
const XalanDOMString&		Constants::ELEMNAME_DECIMALFORMAT_STRING = ::ELEMNAME_DECIMALFORMAT_STRING;
const XalanDOMString&		Constants::ELEMNAME_DISPLAYIF_STRING = ::ELEMNAME_DISPLAYIF_STRING;
const XalanDOMString&		Constants::ELEMNAME_ELEMENT_STRING = ::ELEMNAME_ELEMENT_STRING;
const XalanDOMString&		Constants::ELEMNAME_EMPTY_STRING = ::ELEMNAME_EMPTY_STRING;
const XalanDOMString&		Constants::ELEMNAME_EVAL_STRING = ::ELEMNAME_EVAL_STRING;
const XalanDOMString&		Constants::ELEMNAME_EXPECTEDCHILDREN_STRING = ::ELEMNAME_EXPECTEDCHILDREN_STRING;
const XalanDOMString&		Constants::ELEMNAME_EXTENSIONHANDLER_STRING = ::ELEMNAME_EXTENSIONHANDLER_STRING;
const XalanDOMString&		Constants::ELEMNAME_EXTENSION_STRING = ::ELEMNAME_EXTENSION_STRING;
const XalanDOMString&		Constants::ELEMNAME_FALLBACK_STRING = ::ELEMNAME_FALLBACK_STRING;
const XalanDOMString&		Constants::ELEMNAME_FOREACH_STRING = ::ELEMNAME_FOREACH_STRING;
const XalanDOMString&		Constants::ELEMNAME_HTML_STRING = ::ELEMNAME_HTML_STRING;
const XalanDOMString&		Constants::ELEMNAME_IF_STRING = ::ELEMNAME_IF_STRING;
const XalanDOMString&		Constants::ELEMNAME_IMPORT_STRING = ::ELEMNAME_IMPORT_STRING;
const XalanDOMString&		Constants::ELEMNAME_INCLUDE_STRING = ::ELEMNAME_INCLUDE_STRING;
const XalanDOMString&		Constants::ELEMNAME_KEY_STRING = ::ELEMNAME_KEY_STRING;
const XalanDOMString&		Constants::ELEMNAME_LOCALE_STRING = ::ELEMNAME_LOCALE_STRING;
const XalanDOMString&		Constants::ELEMNAME_MESSAGE_STRING = ::ELEMNAME_MESSAGE_STRING;
const XalanDOMString&		Constants::ELEMNAME_NSALIAS_STRING = ::ELEMNAME_NSALIAS_STRING;
const XalanDOMString&		Constants::ELEMNAME_NUMBER_STRING = ::ELEMNAME_NUMBER_STRING;
const XalanDOMString&		Constants::ELEMNAME_OTHERWISE_STRING = ::ELEMNAME_OTHERWISE_STRING;
const XalanDOMString&		Constants::ELEMNAME_OUTPUT_STRING = ::ELEMNAME_OUTPUT_STRING;
const XalanDOMString&		Constants::ELEMNAME_PARAMVARIABLE_STRING = ::ELEMNAME_PARAMVARIABLE_STRING;
const XalanDOMString&		Constants::ELEMNAME_PI_OLD_STRING = ::ELEMNAME_PI_OLD_STRING;
const XalanDOMString&		Constants::ELEMNAME_PI_STRING = ::ELEMNAME_PI_STRING;
const XalanDOMString&		Constants::ELEMNAME_PRESERVESPACE_STRING = ::ELEMNAME_PRESERVESPACE_STRING;
const XalanDOMString&		Constants::ELEMNAME_ROOT_STRING = ::ELEMNAME_ROOT_STRING;
const XalanDOMString&		Constants::ELEMNAME_SCRIPT_STRING = ::ELEMNAME_SCRIPT_STRING;
const XalanDOMString&		Constants::ELEMNAME_SORT_STRING = ::ELEMNAME_SORT_STRING;
const XalanDOMString&		Constants::ELEMNAME_STRIPSPACE_STRING = ::ELEMNAME_STRIPSPACE_STRING;
const XalanDOMString&		Constants::ELEMNAME_STYLESHEET_STRING = ::ELEMNAME_STYLESHEET_STRING;
const XalanDOMString&		Constants::ELEMNAME_TARGETATTRIBUTE_STRING = ::ELEMNAME_TARGETATTRIBUTE_STRING;
const XalanDOMString&		Constants::ELEMNAME_TARGETCOMMENT_STRING = ::ELEMNAME_TARGETCOMMENT_STRING;
const XalanDOMString&		Constants::ELEMNAME_TARGETELEMENT_STRING = ::ELEMNAME_TARGETELEMENT_STRING;
const XalanDOMString&		Constants::ELEMNAME_TARGETPI_STRING = ::ELEMNAME_TARGETPI_STRING;
const XalanDOMString&		Constants::ELEMNAME_TARGETTEXT_STRING = ::ELEMNAME_TARGETTEXT_STRING;
const XalanDOMString&		Constants::ELEMNAME_TEMPLATE_STRING = ::ELEMNAME_TEMPLATE_STRING;
const XalanDOMString&		Constants::ELEMNAME_TEMPLATE_WITH_PREFIX_STRING = ::ELEMNAME_TEMPLATE_WITH_PREFIX_STRING;
const XalanDOMString&		Constants::ELEMNAME_TEXT_STRING = ::ELEMNAME_TEXT_STRING;
const XalanDOMString&		Constants::ELEMNAME_TRANSFORM_STRING = ::ELEMNAME_TRANSFORM_STRING;
const XalanDOMString&		Constants::ELEMNAME_URL_STRING = ::ELEMNAME_URL_STRING;
const XalanDOMString&		Constants::ELEMNAME_USE_STRING = ::ELEMNAME_USE_STRING;
const XalanDOMString&		Constants::ELEMNAME_VALUEOF_STRING = ::ELEMNAME_VALUEOF_STRING;
const XalanDOMString&		Constants::ELEMNAME_VALUEOF_WITH_PREFIX_STRING = ::ELEMNAME_VALUEOF_WITH_PREFIX_STRING;
const XalanDOMString&		Constants::ELEMNAME_VARIABLE_STRING = ::ELEMNAME_VARIABLE_STRING;
const XalanDOMString&		Constants::ELEMNAME_WHEN_STRING = ::ELEMNAME_WHEN_STRING;
const XalanDOMString&		Constants::ELEMNAME_WITHPARAM_STRING = ::ELEMNAME_WITHPARAM_STRING;

const XalanDOMString&		Constants::PSEUDONAME_ANY = ::PSEUDONAME_ANY;
const XalanDOMString&		Constants::PSEUDONAME_COMMENT = ::PSEUDONAME_COMMENT;
const XalanDOMString&		Constants::PSEUDONAME_OTHER = ::PSEUDONAME_OTHER;
const XalanDOMString&		Constants::PSEUDONAME_PI = ::PSEUDONAME_PI;
const XalanDOMString&		Constants::PSEUDONAME_ROOT = ::PSEUDONAME_ROOT;
const XalanDOMString&		Constants::PSEUDONAME_TEXT = ::PSEUDONAME_TEXT;



void
Constants::initialize()
{
	::ATTRNAME_AMOUNT = XALAN_STATIC_UCODE_STRING("amount");
	::ATTRNAME_ANCESTOR = XALAN_STATIC_UCODE_STRING("ancestor");
	::ATTRNAME_ARCHIVE = XALAN_STATIC_UCODE_STRING("archive");
	::ATTRNAME_ATTRIBUTE = XALAN_STATIC_UCODE_STRING("attribute");
	::ATTRNAME_ATTRIBUTE_SET = XALAN_STATIC_UCODE_STRING("attribute-set");
	::ATTRNAME_CASEORDER = XALAN_STATIC_UCODE_STRING("case-order");
	::ATTRNAME_CLASS = XALAN_STATIC_UCODE_STRING("class");
	::ATTRNAME_CLASSID = XALAN_STATIC_UCODE_STRING("classid");
	::ATTRNAME_CODEBASE = XALAN_STATIC_UCODE_STRING("codebase");
	::ATTRNAME_CODETYPE = XALAN_STATIC_UCODE_STRING("type");
	::ATTRNAME_COMPONENTS = XALAN_STATIC_UCODE_STRING("component");
	::ATTRNAME_CONDITION = XALAN_STATIC_UCODE_STRING("condition");
	::ATTRNAME_COPYTYPE = XALAN_STATIC_UCODE_STRING("copy-type");
	::ATTRNAME_COUNT = XALAN_STATIC_UCODE_STRING("count");
	::ATTRNAME_DATATYPE = XALAN_STATIC_UCODE_STRING("data-type");
	::ATTRNAME_DECIMALSEPARATOR = XALAN_STATIC_UCODE_STRING("decimal-separator");
	::ATTRNAME_DEFAULT = XALAN_STATIC_UCODE_STRING("default");
	::ATTRNAME_DEFAULTSPACE = XALAN_STATIC_UCODE_STRING("default-space");
	::ATTRNAME_DEPTH = XALAN_STATIC_UCODE_STRING("with-children");
	::ATTRNAME_DIGIT = XALAN_STATIC_UCODE_STRING("digit");
	::ATTRNAME_DIGITGROUPSEP = XALAN_STATIC_UCODE_STRING("digit-group-sep");
	::ATTRNAME_DISABLE_OUTPUT_ESCAPING  = XALAN_STATIC_UCODE_STRING("disable-output-escaping");
	::ATTRNAME_ELEMENT = XALAN_STATIC_UCODE_STRING("element");
	::ATTRNAME_ELEMENTS = XALAN_STATIC_UCODE_STRING("elements");
	::ATTRNAME_EXCLUDE_RESULT_PREFIXES = XALAN_STATIC_UCODE_STRING("exclude-result-prefixes");
	::ATTRNAME_EXPR = XALAN_STATIC_UCODE_STRING("expr");
	::ATTRNAME_EXTENSIONELEMENTPREFIXES = XALAN_STATIC_UCODE_STRING("extension-element-prefixes");
	::ATTRNAME_FORMAT = XALAN_STATIC_UCODE_STRING("format");
	::ATTRNAME_FROM = XALAN_STATIC_UCODE_STRING("from");
	::ATTRNAME_FUNCTIONS = XALAN_STATIC_UCODE_STRING("functions");
	::ATTRNAME_GROUPINGSEPARATOR = XALAN_STATIC_UCODE_STRING("grouping-separator");
	::ATTRNAME_GROUPINGSIZE = XALAN_STATIC_UCODE_STRING("grouping-size");
	::ATTRNAME_HREF = XALAN_STATIC_UCODE_STRING("href");
	::ATTRNAME_ID = XALAN_STATIC_UCODE_STRING("id");
	::ATTRNAME_IMPORTANCE = XALAN_STATIC_UCODE_STRING("importance");
	::ATTRNAME_INDENTRESULT = XALAN_STATIC_UCODE_STRING("indent-result");
	::ATTRNAME_INFINITY = XALAN_STATIC_UCODE_STRING("infinity");
	::ATTRNAME_LANG = XALAN_STATIC_UCODE_STRING("lang");
	::ATTRNAME_LETTERVALUE = XALAN_STATIC_UCODE_STRING("letter-value");
	::ATTRNAME_LEVEL = XALAN_STATIC_UCODE_STRING("level");
	::ATTRNAME_MATCH = XALAN_STATIC_UCODE_STRING("match");
	::ATTRNAME_METHOD = XALAN_STATIC_UCODE_STRING("calls");
	::ATTRNAME_MINUSSIGN = XALAN_STATIC_UCODE_STRING("minus-sign");
	::ATTRNAME_MODE = XALAN_STATIC_UCODE_STRING("mode");
	::ATTRNAME_NAME = XALAN_STATIC_UCODE_STRING("name");
	::ATTRNAME_NAMESPACE = XALAN_STATIC_UCODE_STRING("namespace");
	::ATTRNAME_NAN = XALAN_STATIC_UCODE_STRING("NaN");
	::ATTRNAME_NDIGITSPERGROUP = XALAN_STATIC_UCODE_STRING("n-digits-per-group");
	::ATTRNAME_NS = XALAN_STATIC_UCODE_STRING("ns");
	::ATTRNAME_ONLY = XALAN_STATIC_UCODE_STRING("only");
	::ATTRNAME_ORDER = XALAN_STATIC_UCODE_STRING("order");
	::ATTRNAME_OUTPUT_CDATA_SECTION_ELEMENTS  = XALAN_STATIC_UCODE_STRING("cdata-section-elements");
	::ATTRNAME_OUTPUT_DOCTYPE_PUBLIC = XALAN_STATIC_UCODE_STRING("doctype-public");
	::ATTRNAME_OUTPUT_DOCTYPE_SYSTEM = XALAN_STATIC_UCODE_STRING("doctype-system");
	::ATTRNAME_OUTPUT_ENCODING = XALAN_STATIC_UCODE_STRING("encoding");
	::ATTRNAME_OUTPUT_INDENT = XALAN_STATIC_UCODE_STRING("indent");
	::ATTRNAME_OUTPUT_MEDIATYPE = XALAN_STATIC_UCODE_STRING("media-type");
	::ATTRNAME_OUTPUT_METHOD = XALAN_STATIC_UCODE_STRING("method");
	::ATTRNAME_OUTPUT_OMITXMLDECL = XALAN_STATIC_UCODE_STRING("omit-xml-declaration");
	::ATTRNAME_OUTPUT_STANDALONE  = XALAN_STATIC_UCODE_STRING("standalone");
	::ATTRNAME_OUTPUT_VERSION = XALAN_STATIC_UCODE_STRING("version");
	::ATTRNAME_PATTERNSEPARATOR = XALAN_STATIC_UCODE_STRING("pattern-separator");
	::ATTRNAME_PERCENT = XALAN_STATIC_UCODE_STRING("percent");
	::ATTRNAME_PERMILLE = XALAN_STATIC_UCODE_STRING("per-mille");
	::ATTRNAME_PREFIX = XALAN_STATIC_UCODE_STRING("prefix");
	::ATTRNAME_PRIORITY = XALAN_STATIC_UCODE_STRING("priority");
	::ATTRNAME_REFID = XALAN_STATIC_UCODE_STRING("refID");
	::ATTRNAME_RESULTNS = XALAN_STATIC_UCODE_STRING("result-ns");
	::ATTRNAME_RESULT_PREFIX = XALAN_STATIC_UCODE_STRING("result-prefix");
	::ATTRNAME_SCRIPT = XALAN_STATIC_UCODE_STRING("script");
	::ATTRNAME_SELECT = XALAN_STATIC_UCODE_STRING("select");
	::ATTRNAME_SEQUENCESRC = XALAN_STATIC_UCODE_STRING("sequence-src");
	::ATTRNAME_SRC = XALAN_STATIC_UCODE_STRING("src");
	::ATTRNAME_STYLE = XALAN_STATIC_UCODE_STRING("style");
	::ATTRNAME_STYLESHEET_PREFIX = XALAN_STATIC_UCODE_STRING("stylesheet-prefix");
	::ATTRNAME_TERMINATE = XALAN_STATIC_UCODE_STRING("terminate");
	::ATTRNAME_TEST = XALAN_STATIC_UCODE_STRING("test");
	::ATTRNAME_TOSTRING = XALAN_STATIC_UCODE_STRING("to-string");
	::ATTRNAME_TYPE = XALAN_STATIC_UCODE_STRING("type");
	::ATTRNAME_USE = XALAN_STATIC_UCODE_STRING("use");
	::ATTRNAME_USEATTRIBUTESETS = XALAN_STATIC_UCODE_STRING("use-attribute-sets");
	::ATTRNAME_VALUE = XALAN_STATIC_UCODE_STRING("value");
	::ATTRNAME_VERSION = XALAN_STATIC_UCODE_STRING("version");
	::ATTRNAME_XMLNS = XALAN_STATIC_UCODE_STRING("xmlns:");
	::ATTRNAME_XMLNSDEF = XALAN_STATIC_UCODE_STRING("xmlns");
	::ATTRNAME_XMLSPACE = XALAN_STATIC_UCODE_STRING("xml:space");
	::ATTRNAME_ZERODIGIT = XALAN_STATIC_UCODE_STRING("zero-digit");

	::ATTRTYPE_CDATA = XALAN_STATIC_UCODE_STRING("CDATA");

	::ATTRVAL_ALPHABETIC = XALAN_STATIC_UCODE_STRING("alphabetic");
	::ATTRVAL_ANCESTOR = XALAN_STATIC_UCODE_STRING("ancestor");
	::ATTRVAL_ANY = XALAN_STATIC_UCODE_STRING("any");
	::ATTRVAL_CASEORDER_LOWER = XALAN_STATIC_UCODE_STRING("lower-first");
	::ATTRVAL_CASEORDER_UPPER = XALAN_STATIC_UCODE_STRING("upper-first");
	::ATTRVAL_DATATYPE_NUMBER = XALAN_STATIC_UCODE_STRING("number");
	::ATTRVAL_DATATYPE_TEXT = XALAN_STATIC_UCODE_STRING("text");
	::ATTRVAL_DEFAULT = XALAN_STATIC_UCODE_STRING("default");
	::ATTRVAL_DEFAULT_PREFIX = XALAN_STATIC_UCODE_STRING("#default");
	::ATTRVAL_DEFAULT_TEXT_RULE = XALAN_STATIC_UCODE_STRING("text() | @*");
	::ATTRVAL_ID = XALAN_STATIC_UCODE_STRING("id");
	::ATTRVAL_INFINITY = XALAN_STATIC_UCODE_STRING("Infinity");
	::ATTRVAL_MULTI = XALAN_STATIC_UCODE_STRING("multiple");
	::ATTRVAL_NAN = XALAN_STATIC_UCODE_STRING("NaN");
	::ATTRVAL_NO = XALAN_STATIC_UCODE_STRING("no");
	::ATTRVAL_ORDER_ASCENDING = XALAN_STATIC_UCODE_STRING("ascending");
	::ATTRVAL_ORDER_DESCENDING = XALAN_STATIC_UCODE_STRING("descending");
	::ATTRVAL_OTHER = XALAN_STATIC_UCODE_STRING("other");
	::ATTRVAL_OUTPUT_METHOD_HTML = XALAN_STATIC_UCODE_STRING("html");
	::ATTRVAL_OUTPUT_METHOD_TEXT = XALAN_STATIC_UCODE_STRING("text");
	::ATTRVAL_OUTPUT_METHOD_XML = XALAN_STATIC_UCODE_STRING("xml");
	::ATTRVAL_PARENT = XALAN_STATIC_UCODE_STRING("..");
	::ATTRVAL_PRESERVE = XALAN_STATIC_UCODE_STRING("preserve");
	::ATTRVAL_SIMPLE = XALAN_STATIC_UCODE_STRING("simple");
	::ATTRVAL_SINGLE = XALAN_STATIC_UCODE_STRING("single");
	::ATTRVAL_STRIP = XALAN_STATIC_UCODE_STRING("strip");
	::ATTRVAL_THIS = XALAN_STATIC_UCODE_STRING(".");
	::ATTRVAL_YES = XALAN_STATIC_UCODE_STRING("yes");

	::DEFAULT_DECIMAL_FORMAT = XALAN_STATIC_UCODE_STRING("#default");
	::DEFAULT_WHITESPACE_SEPARATOR_STRING = XALAN_STATIC_UCODE_STRING(" \t\n\r");

	::ELEMNAME_ANCHOR_STRING = XALAN_STATIC_UCODE_STRING("anchor");
	::ELEMNAME_ANY_STRING = XALAN_STATIC_UCODE_STRING("any");
	::ELEMNAME_APPLY_IMPORTS_STRING = XALAN_STATIC_UCODE_STRING("apply-imports");
	::ELEMNAME_APPLY_TEMPLATES_STRING = XALAN_STATIC_UCODE_STRING("apply-templates");
	::ELEMNAME_APPLY_TEMPLATES_WITH_PREFIX_STRING = XALAN_STATIC_UCODE_STRING("xsl:apply-templates");
	::ELEMNAME_ARG_STRING = XALAN_STATIC_UCODE_STRING("arg");
	::ELEMNAME_ATTRIBUTESET_STRING = XALAN_STATIC_UCODE_STRING("attribute-set");
	::ELEMNAME_ATTRIBUTE_STRING = XALAN_STATIC_UCODE_STRING("attribute");
	::ELEMNAME_CALLTEMPLATEARG_STRING = XALAN_STATIC_UCODE_STRING("invoke-arg");
	::ELEMNAME_CALLTEMPLATE_STRING = XALAN_STATIC_UCODE_STRING("call-template");
	::ELEMNAME_CALL_STRING = XALAN_STATIC_UCODE_STRING("call");
	::ELEMNAME_CHILDREN_STRING = XALAN_STATIC_UCODE_STRING("children");
	::ELEMNAME_CHOOSE_STRING = XALAN_STATIC_UCODE_STRING("choose");
	::ELEMNAME_COMMENT_STRING = XALAN_STATIC_UCODE_STRING("comment");
	::ELEMNAME_COMPONENT_STRING = XALAN_STATIC_UCODE_STRING("component");
	::ELEMNAME_CONSTRUCT_STRING = XALAN_STATIC_UCODE_STRING("construct");
	::ELEMNAME_CONTENTS_STRING = XALAN_STATIC_UCODE_STRING("contents");
	::ELEMNAME_COPY_OF_STRING = XALAN_STATIC_UCODE_STRING("copy-of");
	::ELEMNAME_COPY_STRING = XALAN_STATIC_UCODE_STRING("copy");
	::ELEMNAME_COUNTERINCREMENT_STRING = XALAN_STATIC_UCODE_STRING("counter-increment");
	::ELEMNAME_COUNTERRESET_STRING = XALAN_STATIC_UCODE_STRING("counter-reset");
	::ELEMNAME_COUNTERSCOPE_STRING = XALAN_STATIC_UCODE_STRING("counter-scope");
	::ELEMNAME_COUNTERS_STRING = XALAN_STATIC_UCODE_STRING("counters");
	::ELEMNAME_COUNTER_STRING = XALAN_STATIC_UCODE_STRING("counter");
	::ELEMNAME_DECIMALFORMAT_STRING = XALAN_STATIC_UCODE_STRING("decimal-format");
	::ELEMNAME_DISPLAYIF_STRING = XALAN_STATIC_UCODE_STRING("display-if");
	::ELEMNAME_ELEMENT_STRING = XALAN_STATIC_UCODE_STRING("element");
	::ELEMNAME_EMPTY_STRING = XALAN_STATIC_UCODE_STRING("empty");
	::ELEMNAME_EVAL_STRING = XALAN_STATIC_UCODE_STRING("eval");
	::ELEMNAME_EXPECTEDCHILDREN_STRING = XALAN_STATIC_UCODE_STRING("expectedchildren");
	::ELEMNAME_EXTENSIONHANDLER_STRING = XALAN_STATIC_UCODE_STRING("code-dispatcher");
	::ELEMNAME_EXTENSION_STRING = XALAN_STATIC_UCODE_STRING("functions");
	::ELEMNAME_FALLBACK_STRING = XALAN_STATIC_UCODE_STRING("fallback");
	::ELEMNAME_FOREACH_STRING = XALAN_STATIC_UCODE_STRING("for-each");
	::ELEMNAME_HTML_STRING = XALAN_STATIC_UCODE_STRING("HTML");
	::ELEMNAME_IF_STRING = XALAN_STATIC_UCODE_STRING("if");
	::ELEMNAME_IMPORT_STRING = XALAN_STATIC_UCODE_STRING("import");
	::ELEMNAME_INCLUDE_STRING = XALAN_STATIC_UCODE_STRING("include");
	::ELEMNAME_KEY_STRING = XALAN_STATIC_UCODE_STRING("key");
	::ELEMNAME_LOCALE_STRING = XALAN_STATIC_UCODE_STRING("locale");
	::ELEMNAME_MESSAGE_STRING = XALAN_STATIC_UCODE_STRING("message");
	::ELEMNAME_NSALIAS_STRING = XALAN_STATIC_UCODE_STRING("namespace-alias");
	::ELEMNAME_NUMBER_STRING = XALAN_STATIC_UCODE_STRING("number");
	::ELEMNAME_OTHERWISE_STRING = XALAN_STATIC_UCODE_STRING("otherwise");
	::ELEMNAME_OUTPUT_STRING = XALAN_STATIC_UCODE_STRING("output");
	::ELEMNAME_PARAMVARIABLE_STRING = XALAN_STATIC_UCODE_STRING("param");
	::ELEMNAME_PI_OLD_STRING = XALAN_STATIC_UCODE_STRING("pi");
	::ELEMNAME_PI_STRING = XALAN_STATIC_UCODE_STRING("processing-instruction");
	::ELEMNAME_PRESERVESPACE_STRING = XALAN_STATIC_UCODE_STRING("preserve-space");
	::ELEMNAME_ROOT_STRING = XALAN_STATIC_UCODE_STRING("root");
	::ELEMNAME_SCRIPT_STRING = XALAN_STATIC_UCODE_STRING("script");
	::ELEMNAME_SORT_STRING = XALAN_STATIC_UCODE_STRING("sort");
	::ELEMNAME_STRIPSPACE_STRING = XALAN_STATIC_UCODE_STRING("strip-space");
	::ELEMNAME_STYLESHEET_STRING = XALAN_STATIC_UCODE_STRING("stylesheet");
	::ELEMNAME_TARGETATTRIBUTE_STRING = XALAN_STATIC_UCODE_STRING("target-attribute");
	::ELEMNAME_TARGETCOMMENT_STRING = XALAN_STATIC_UCODE_STRING("target-comment");
	::ELEMNAME_TARGETELEMENT_STRING = XALAN_STATIC_UCODE_STRING("target-element");
	::ELEMNAME_TARGETPI_STRING = XALAN_STATIC_UCODE_STRING("target-pi");
	::ELEMNAME_TARGETTEXT_STRING = XALAN_STATIC_UCODE_STRING("target-text");
	::ELEMNAME_TEMPLATE_STRING = XALAN_STATIC_UCODE_STRING("template");
	::ELEMNAME_TEMPLATE_WITH_PREFIX_STRING = XALAN_STATIC_UCODE_STRING("xsl:template");
	::ELEMNAME_TEXT_STRING = XALAN_STATIC_UCODE_STRING("text");
	::ELEMNAME_TRANSFORM_STRING = XALAN_STATIC_UCODE_STRING("transform");
	::ELEMNAME_URL_STRING = XALAN_STATIC_UCODE_STRING("uri");
	::ELEMNAME_USE_STRING = XALAN_STATIC_UCODE_STRING("use");
	::ELEMNAME_VALUEOF_STRING = XALAN_STATIC_UCODE_STRING("value-of");
	::ELEMNAME_VALUEOF_WITH_PREFIX_STRING = XALAN_STATIC_UCODE_STRING("xsl:value-of");
	::ELEMNAME_VARIABLE_STRING = XALAN_STATIC_UCODE_STRING("variable");
	::ELEMNAME_WHEN_STRING = XALAN_STATIC_UCODE_STRING("when");
	::ELEMNAME_WITHPARAM_STRING = XALAN_STATIC_UCODE_STRING("with-param");

	::PSEUDONAME_ANY = XALAN_STATIC_UCODE_STRING("*");
	::PSEUDONAME_COMMENT = XALAN_STATIC_UCODE_STRING("#comment");
	::PSEUDONAME_NODE = XALAN_STATIC_UCODE_STRING("node()");
	::PSEUDONAME_OTHER = XALAN_STATIC_UCODE_STRING("*");
	::PSEUDONAME_PI = XALAN_STATIC_UCODE_STRING("#pi");
	::PSEUDONAME_ROOT = XALAN_STATIC_UCODE_STRING("/");
	::PSEUDONAME_TEXT = XALAN_STATIC_UCODE_STRING("#text");
}



void
Constants::terminate()
{
	clear(::ATTRNAME_AMOUNT);
	clear(::ATTRNAME_ANCESTOR);
	clear(::ATTRNAME_ARCHIVE);
	clear(::ATTRNAME_ATTRIBUTE);
	clear(::ATTRNAME_ATTRIBUTE_SET);
	clear(::ATTRNAME_CASEORDER);
	clear(::ATTRNAME_CLASS);
	clear(::ATTRNAME_CLASSID);
	clear(::ATTRNAME_CODEBASE);
	clear(::ATTRNAME_CODETYPE);
	clear(::ATTRNAME_COMPONENTS);
	clear(::ATTRNAME_CONDITION);
	clear(::ATTRNAME_COPYTYPE);
	clear(::ATTRNAME_COUNT);
	clear(::ATTRNAME_DATATYPE);
	clear(::ATTRNAME_DECIMALSEPARATOR);
	clear(::ATTRNAME_DEFAULT);
	clear(::ATTRNAME_DEFAULTSPACE);
	clear(::ATTRNAME_DEPTH);
	clear(::ATTRNAME_DIGIT);
	clear(::ATTRNAME_DIGITGROUPSEP);
	clear(::ATTRNAME_DISABLE_OUTPUT_ESCAPING);
	clear(::ATTRNAME_ELEMENT);
	clear(::ATTRNAME_ELEMENTS);
	clear(::ATTRNAME_EXCLUDE_RESULT_PREFIXES);
	clear(::ATTRNAME_EXPR);
	clear(::ATTRNAME_EXTENSIONELEMENTPREFIXES);
	clear(::ATTRNAME_FORMAT);
	clear(::ATTRNAME_FROM);
	clear(::ATTRNAME_FUNCTIONS);
	clear(::ATTRNAME_GROUPINGSEPARATOR);
	clear(::ATTRNAME_GROUPINGSIZE);
	clear(::ATTRNAME_HREF);
	clear(::ATTRNAME_ID);
	clear(::ATTRNAME_IMPORTANCE);
	clear(::ATTRNAME_INDENTRESULT);
	clear(::ATTRNAME_INFINITY);
	clear(::ATTRNAME_LANG);
	clear(::ATTRNAME_LETTERVALUE);
	clear(::ATTRNAME_LEVEL);
	clear(::ATTRNAME_MATCH);
	clear(::ATTRNAME_METHOD);
	clear(::ATTRNAME_MINUSSIGN);
	clear(::ATTRNAME_MODE);
	clear(::ATTRNAME_NAME);
	clear(::ATTRNAME_NAMESPACE);
	clear(::ATTRNAME_NAN);
	clear(::ATTRNAME_NDIGITSPERGROUP);
	clear(::ATTRNAME_NS);
	clear(::ATTRNAME_ONLY);
	clear(::ATTRNAME_ORDER);
	clear(::ATTRNAME_OUTPUT_CDATA_SECTION_ELEMENTS);
	clear(::ATTRNAME_OUTPUT_DOCTYPE_PUBLIC);
	clear(::ATTRNAME_OUTPUT_DOCTYPE_SYSTEM);
	clear(::ATTRNAME_OUTPUT_ENCODING);
	clear(::ATTRNAME_OUTPUT_INDENT);
	clear(::ATTRNAME_OUTPUT_MEDIATYPE);
	clear(::ATTRNAME_OUTPUT_METHOD);
	clear(::ATTRNAME_OUTPUT_OMITXMLDECL);
	clear(::ATTRNAME_OUTPUT_STANDALONE);
	clear(::ATTRNAME_OUTPUT_VERSION);
	clear(::ATTRNAME_PATTERNSEPARATOR);
	clear(::ATTRNAME_PERCENT);
	clear(::ATTRNAME_PERMILLE);
	clear(::ATTRNAME_PREFIX);
	clear(::ATTRNAME_PRIORITY);
	clear(::ATTRNAME_REFID);
	clear(::ATTRNAME_RESULTNS);
	clear(::ATTRNAME_RESULT_PREFIX);
	clear(::ATTRNAME_SCRIPT);
	clear(::ATTRNAME_SELECT);
	clear(::ATTRNAME_SEQUENCESRC);
	clear(::ATTRNAME_SRC);
	clear(::ATTRNAME_STYLE);
	clear(::ATTRNAME_STYLESHEET_PREFIX);
	clear(::ATTRNAME_TERMINATE);
	clear(::ATTRNAME_TEST);
	clear(::ATTRNAME_TOSTRING);
	clear(::ATTRNAME_TYPE);
	clear(::ATTRNAME_USE);
	clear(::ATTRNAME_USEATTRIBUTESETS);
	clear(::ATTRNAME_VALUE);
	clear(::ATTRNAME_VERSION);
	clear(::ATTRNAME_XMLNS);
	clear(::ATTRNAME_XMLNSDEF);
	clear(::ATTRNAME_XMLSPACE);
	clear(::ATTRNAME_ZERODIGIT);

	clear(::ATTRVAL_ALPHABETIC);
	clear(::ATTRVAL_ANCESTOR);
	clear(::ATTRVAL_ANY);
	clear(::ATTRVAL_CASEORDER_LOWER);
	clear(::ATTRVAL_CASEORDER_UPPER);
	clear(::ATTRVAL_DATATYPE_NUMBER);
	clear(::ATTRVAL_DATATYPE_TEXT);
	clear(::ATTRVAL_DEFAULT);
	clear(::ATTRVAL_DEFAULT_PREFIX);
	clear(::ATTRVAL_DEFAULT_TEXT_RULE);
	clear(::ATTRVAL_ID);
	clear(::ATTRVAL_INFINITY);
	clear(::ATTRVAL_MULTI);
	clear(::ATTRVAL_NAN);
	clear(::ATTRVAL_NO);
	clear(::ATTRVAL_ORDER_ASCENDING);
	clear(::ATTRVAL_ORDER_DESCENDING);
	clear(::ATTRVAL_OTHER);
	clear(::ATTRVAL_OUTPUT_METHOD_HTML);
	clear(::ATTRVAL_OUTPUT_METHOD_TEXT);
	clear(::ATTRVAL_OUTPUT_METHOD_XML);
	clear(::ATTRVAL_PARENT);
	clear(::ATTRVAL_PRESERVE);
	clear(::ATTRVAL_SIMPLE);
	clear(::ATTRVAL_SINGLE);
	clear(::ATTRVAL_STRIP);
	clear(::ATTRVAL_THIS);
	clear(::ATTRVAL_YES);

	clear(::DEFAULT_DECIMAL_FORMAT);
	clear(::DEFAULT_WHITESPACE_SEPARATOR_STRING);

	clear(::ELEMNAME_ANCHOR_STRING);
	clear(::ELEMNAME_ANY_STRING);
	clear(::ELEMNAME_APPLY_IMPORTS_STRING);
	clear(::ELEMNAME_APPLY_TEMPLATES_STRING);
	clear(::ELEMNAME_APPLY_TEMPLATES_WITH_PREFIX_STRING);
	clear(::ELEMNAME_ARG_STRING);
	clear(::ELEMNAME_ATTRIBUTESET_STRING);
	clear(::ELEMNAME_ATTRIBUTE_STRING);
	clear(::ELEMNAME_CALLTEMPLATEARG_STRING);
	clear(::ELEMNAME_CALLTEMPLATE_STRING);
	clear(::ELEMNAME_CALL_STRING);
	clear(::ELEMNAME_CHILDREN_STRING);
	clear(::ELEMNAME_CHOOSE_STRING);
	clear(::ELEMNAME_COMMENT_STRING);
	clear(::ELEMNAME_COMPONENT_STRING);
	clear(::ELEMNAME_CONSTRUCT_STRING);
	clear(::ELEMNAME_CONTENTS_STRING);
	clear(::ELEMNAME_COPY_OF_STRING);
	clear(::ELEMNAME_COPY_STRING);
	clear(::ELEMNAME_COUNTERINCREMENT_STRING);
	clear(::ELEMNAME_COUNTERRESET_STRING);
	clear(::ELEMNAME_COUNTERSCOPE_STRING);
	clear(::ELEMNAME_COUNTERS_STRING);
	clear(::ELEMNAME_COUNTER_STRING);
	clear(::ELEMNAME_DECIMALFORMAT_STRING);
	clear(::ELEMNAME_DISPLAYIF_STRING);
	clear(::ELEMNAME_ELEMENT_STRING);
	clear(::ELEMNAME_EMPTY_STRING);
	clear(::ELEMNAME_EVAL_STRING);
	clear(::ELEMNAME_EXPECTEDCHILDREN_STRING);
	clear(::ELEMNAME_EXTENSIONHANDLER_STRING);
	clear(::ELEMNAME_EXTENSION_STRING);
	clear(::ELEMNAME_FALLBACK_STRING);
	clear(::ELEMNAME_FOREACH_STRING);
	clear(::ELEMNAME_HTML_STRING);
	clear(::ELEMNAME_IF_STRING);
	clear(::ELEMNAME_IMPORT_STRING);
	clear(::ELEMNAME_INCLUDE_STRING);
	clear(::ELEMNAME_KEY_STRING);
	clear(::ELEMNAME_LOCALE_STRING);
	clear(::ELEMNAME_MESSAGE_STRING);
	clear(::ELEMNAME_NSALIAS_STRING);
	clear(::ELEMNAME_NUMBER_STRING);
	clear(::ELEMNAME_OTHERWISE_STRING);
	clear(::ELEMNAME_OUTPUT_STRING);
	clear(::ELEMNAME_PARAMVARIABLE_STRING);
	clear(::ELEMNAME_PI_OLD_STRING);
	clear(::ELEMNAME_PI_STRING);
	clear(::ELEMNAME_PRESERVESPACE_STRING);
	clear(::ELEMNAME_ROOT_STRING);
	clear(::ELEMNAME_SCRIPT_STRING);
	clear(::ELEMNAME_SORT_STRING);
	clear(::ELEMNAME_STRIPSPACE_STRING);
	clear(::ELEMNAME_STYLESHEET_STRING);
	clear(::ELEMNAME_TARGETATTRIBUTE_STRING);
	clear(::ELEMNAME_TARGETCOMMENT_STRING);
	clear(::ELEMNAME_TARGETELEMENT_STRING);
	clear(::ELEMNAME_TARGETPI_STRING);
	clear(::ELEMNAME_TARGETTEXT_STRING);
	clear(::ELEMNAME_TEMPLATE_STRING);
	clear(::ELEMNAME_TEMPLATE_WITH_PREFIX_STRING);
	clear(::ELEMNAME_TEXT_STRING);
	clear(::ELEMNAME_TRANSFORM_STRING);
	clear(::ELEMNAME_URL_STRING);
	clear(::ELEMNAME_USE_STRING);
	clear(::ELEMNAME_VALUEOF_STRING);
	clear(::ELEMNAME_VALUEOF_WITH_PREFIX_STRING);
	clear(::ELEMNAME_VARIABLE_STRING);
	clear(::ELEMNAME_WHEN_STRING);
	clear(::ELEMNAME_WITHPARAM_STRING);

	clear(::PSEUDONAME_ANY);
	clear(::PSEUDONAME_COMMENT);
	clear(::PSEUDONAME_NODE);
	clear(::PSEUDONAME_OTHER);
	clear(::PSEUDONAME_PI);
	clear(::PSEUDONAME_ROOT);
	clear(::PSEUDONAME_TEXT);
}
