$! Xalan 1, Samples
$! xal_sample.com
$!
$! P1 - Appended to the ".EXE" of the resultant linked image.
$!	If it contains "DEBUG" then compile and link will be /debug/nooptim.
$!
$! --------------------------------------------------------------------------------------------------
$! Modification History
$!
$! 20-Jan-2001  Shafiq Ahmed
$!      Organized the tests in Apache order.
$!      Made changes to pass more command line operators for test 3 and 6.
$!      Fixed a bug in do_link to create correct cxx_repository locale to 
$!        resolve linking error of test 6.
$!      Added do_run_spc for multiple running with 4 parameters (Test 6).
$!      
$! 19-Jan-2001	Karl Puder
$!	Further improvements to subroutines.
$!
$! 17-Jan-2001	Karl Puder
$!	Added /NoOptimiz to /Debug.
$!
$! 12-Jan-2001	Karl Puder
$!	Restructured subroutines.
$!	Put test files (.OBJ, .EXE, [.cxx_repository]) in the test directory.
$!	Run the test in its own directory.
$!
$! 12-Jan-2001	Karl Puder
$!	Cloned xer_sample.com to create this file.
$!
$! 09-Jan-2001	Karl Puder
$!	Included compile and link commands directly in this file.
$!	Added P1 as name extension and debug flag.
$!      
$! 06-Jan-2001  Karl Puder
$!      First Draft
$!
$! --------------------------------------------------------------------------------------------------
$do_cpp: SUBROUTINE
$ write sys$output "C++: Compiling Sample program ''p1' ''p2'"
$ src_file = f$parse(p1,".cpp")
$ obj_file = f$parse(".obj;",p1)
$ list_file = f$parse(".lis;",p1)
$ repos = f$parse("A.B",p1,"[];") - "]A.B;" + ".CXX_REPOSITORY]"
$ cxx 'src_file' 'p2' -
	/listing='list_file' -
	/OBJECT='obj_file' -
	/DEFINE=(VMS, __ALPHA__, CIM_VMS,NDEBUG, __USE_STD_IOSTREAM=1) -
	/INCLUDE=(CXX$USER_INCLUDE, INC$DIR) -
	/ERROR_LIMIT=2 -
	/repository=('repos',CXX_REPOSITORY:)
$
$ exit
$ ENDSUBROUTINE
$! --------------------------------------------------------------------------------------------------
$do_link: SUBROUTINE
$ write sys$output "C++: Linking Object Module ''p1' ''p2'"
$ first_name = f$element(0,",",f$element(0,"+",p1))
$ exec_file = f$parse(".exe''p3'",first_name)
$ map_file = f$parse(".map''p3'",first_name)
$! Since we put the .obj file in the source directory, this finds
$! the same directory as the line like it in do_cpp.
$ repos = f$parse("A.B",first_name,"[];") - "]A.B;" + ".CXX_REPOSITORY]"
$ cxxlink 'p1', -
        [-.lib]Xalan'p3'.olb/library, -
	[--.xerces-c-src1_3_0.lib]Xerces'p3'.olb/library -
	/EXECUTABLE='exec_file' -
	/map='map_file' -
	'p2' -
	/repository=('repos',CXX_REPOSITORY:)
$ exit
$ ENDSUBROUTINE
$! --------------------------------------------------------------------------------------------------
$do_run: SUBROUTINE
$ olddefdir = f$environment("default")
$ on error then goto recover
$ on control_y then goto recover
$ fullname = f$parse(p1,".exe")
$ defdir = f$parse("A.B;",p1) - "A.B;"
$ set default 'defdir'
$
$ write sys$output "VMS: Running ''p1'"
$ write sys$output ""
$ exename = "$''fullname'"
$
$ if p3 .nes. ""
$ then
$    if p2 .nes. ""
$    then
$       exename "''p2'" "''p3'"
$    else
$       write sys$output "---< Invalid order of empty parameters (''p1' : ''p3') >---"
$    endif
$ else
$    if p2 .nes. ""
$    then
$       exename "''p2'"
$    else
$       exename
$    endif
$ endif
$
$ write sys$output ""
$ write sys$output ""
$
$recover:
$ set default 'olddefdir'
$
$ exit
$ ENDSUBROUTINE
$! --------------------------------------------------------------------------------------------------
$do_run_spc: SUBROUTINE
$ olddefdir = f$environment("default")
$ on error then goto recover
$ on control_y then goto recover
$ fullname = f$parse(p1,".exe")
$ defdir = f$parse("A.B;",p1) - "A.B;"
$ set default 'defdir'
$
$ write sys$output "VMS: Running ''p1'"
$ write sys$output ""
$ exename = "$''fullname'"
$
$ exename "''p2'" "''p3'" "''p4'"
$
$ write sys$output ""
$ write sys$output ""
$
$recover:
$ set default 'olddefdir'
$
$ exit
$ ENDSUBROUTINE
$! --------------------------------------------------------------------------------------------------
$do_build_link_run: SUBROUTINE
$ call do_cpp "''p1'" "''p3'"
$
$ if p2 .nes. ""
$ then
$   call do_cpp "''p2'" "''p3'"
$   call do_link "''p1'+''p2'" "''p4'" "''p7'"
$ else
$   call do_link "''p1'" "''p4'" "''p7'"
$ endif
$
$ call do_run  "''p1'" "''p5'" "''p6'"
$ exit
$ ENDSUBROUTINE
$! --------------------------------------------------------------------------------------------------
$do_build_link: SUBROUTINE
$ call do_cpp "''p1'" "''p3'"
$
$ if p2 .nes. ""
$ then
$   call do_cpp "''p2'" "''p3'"
$   call do_link "''p1'+''p2'" "''p4'" "''p5'"
$ else
$   call do_link "''p1'" "''p4'" "''p5'"
$ endif
$
$ exit
$ ENDSUBROUTINE
$! --------------------------------------------------------------------------------------------------
$ if p1 - "DEBUG" .nes. p1
$ then
$  debug_qual = "/debug/nooptimiz"
$  link_debug_qual = "/debug"
$ else
$  debug_qual = ""
$  link_debug_qual = ""
$ endif
$ DEFINE CXX$USER_INCLUDE DISK$USERSPACE:[xml.Xalan-C_1_0-OpenVMS]
$ DEFINE INC$DIR DISK$USERSPACE:[xml.Xalan-C_1_0-OpenVMS.vmsinc]
$ define CXX_REPOSITORY -
	DISK$USERSPACE:[XML.XALAN-C_1_0-OPENVMS.SRC.CXX_REPOSITORY],-
	DISK$USERSPACE:[XML.XERCES-C-SRC1_3_0.SRC.CXX_REPOSITORY]
$! --------------------------------------------------------------------------------------------------
$ write sys$output "++++++++++++++++++++++++++ Cleaning Sample Area +++++++++++++++++++++++++++++++++"
$ purge  [-.samples...]
$ write sys$output "+++++++++++++++++++++++++++ Cleaning complete +++++++++++++++++++++++++++++++++++"

$ write sys$output ""
$ write sys$output ""
$ write sys$output "++++++++++++++++++++++++++++ (5) ThreadSafe +++++++++++++++++++++++++++++++++++++"
$
$ call do_build_link_run "[-.samples.ThreadSafe]ThreadSafeHtml" "" "''debug_qual'" "''link_debug_qual'" "" "" "''p1'"
$ write sys$output ""
$ write sys$output "++++++++++++++++++++++++++ End of All Xalan C++ Tests +++++++++++++++++++++++++++"
$ exit
