/*
 * Decompiled with CFR 0.152.
 */
package org.apache.serialize;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.serialize.OutputFormat;
import org.apache.serialize.Serializer;

public abstract class SerializerFactory {
    public static final String PropertiesResource = "serializer.properties";
    public static final String PropertyMethods = "serialize.methods";
    public static final String PropertySerializerPrefix = "serialize.";
    public static final String PropertyFormatPrefix = "serialize.format.";
    private static Hashtable _serializers = new Hashtable();
    private static Hashtable _formats = new Hashtable();
    static /* synthetic */ Class class$org$apache$serialize$SerializerFactory;

    public static Serializer getSerializer(String string) {
        Serializer serializer;
        Class clazz = (Class)_serializers.get(string);
        if (clazz == null) {
            return null;
        }
        try {
            serializer = (Serializer)clazz.newInstance();
        }
        catch (Exception exception) {
            return null;
        }
        return serializer;
    }

    public static Serializer getSerializer(OutputFormat outputFormat) {
        Serializer serializer;
        if (outputFormat.getMethod() == null) {
            throw new IllegalArgumentException("The output format has not method name");
        }
        Class clazz = (Class)_serializers.get(outputFormat.getMethod());
        if (clazz == null) {
            return null;
        }
        try {
            serializer = (Serializer)clazz.newInstance();
        }
        catch (Exception exception) {
            return null;
        }
        serializer.setOutputFormat(outputFormat);
        return serializer;
    }

    public static OutputFormat getOutputFormat(String string) {
        Class clazz = (Class)_formats.get(string);
        if (clazz != null) {
            try {
                OutputFormat outputFormat = (OutputFormat)clazz.newInstance();
                return outputFormat;
            }
            catch (Exception exception) {}
        }
        OutputFormat outputFormat = new OutputFormat();
        outputFormat.setMethod(string);
        return outputFormat;
    }

    public Enumeration listMethods() {
        return _serializers.keys();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        try {
            Properties properties = new Properties();
            InputStream inputStream = (class$org$apache$serialize$SerializerFactory != null ? class$org$apache$serialize$SerializerFactory : (class$org$apache$serialize$SerializerFactory = SerializerFactory.class$("org.apache.serialize.SerializerFactory"))).getResourceAsStream(PropertiesResource);
            if (inputStream == null) {
                System.err.println("Can't get serializer property file: serializer.properties");
            }
            properties.load(inputStream);
            if (properties.getProperty(PropertyMethods) == null) {
                System.err.println("Serializer property file has no serialize.methods property");
            } else {
                StringTokenizer stringTokenizer = new StringTokenizer(properties.getProperty(PropertyMethods), ", ");
                while (stringTokenizer.hasMoreElements()) {
                    Class<?> clazz;
                    String string = stringTokenizer.nextToken();
                    String string2 = properties.getProperty(PropertySerializerPrefix + string);
                    if (string2 == null) {
                        System.err.println("Could not find property for serializer implementing output method " + string);
                    } else {
                        try {
                            clazz = Class.forName(string2);
                            _serializers.put(string, clazz);
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            System.err.println("Could not locate serializer class " + string2);
                        }
                    }
                    string2 = properties.getProperty(PropertyFormatPrefix + string);
                    if (string2 == null) continue;
                    try {
                        clazz = Class.forName(string2);
                        _formats.put(string, clazz);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        System.err.println("Could not locate output format class " + string2);
                    }
                }
            }
        }
        catch (IOException iOException) {
            System.err.println("Error loading serializer.properties: " + iOException.toString());
        }
    }
}

