/*
 * Decompiled with CFR 0.152.
 */
package org.apache.trax;

import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.serialize.OutputFormat;
import org.apache.serialize.Serializer;
import org.apache.serialize.SerializerFactory;
import org.apache.trax.Processor;
import org.apache.trax.ProcessorException;
import org.apache.trax.ProcessorFactoryException;
import org.apache.trax.Result;
import org.apache.trax.Templates;
import org.apache.trax.TemplatesBuilder;
import org.apache.trax.TransformException;
import org.apache.trax.Transformer;
import org.w3c.dom.Document;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class Examples {
    public static void main(String[] stringArray) throws ProcessorException, ProcessorFactoryException, TransformException, SAXException, IOException, ParserConfigurationException {
        System.out.println("==== exampleSimple ====");
        Examples.exampleSimple("foo.xml", "foo.xsl");
        System.out.println("\n==== exampleSAX2SAX ====");
        Examples.exampleSAX2SAX("foo.xml", "foo.xsl");
        System.out.println("\n==== exampleXMLFilter ====");
        Examples.exampleXMLFilter("foo.xml", "foo.xsl");
        System.out.println("\n==== exampleXMLFilterChain ====");
        Examples.exampleXMLFilterChain("foo.xml", "foo.xsl", "foo2.xsl", "foo.xsl");
        System.out.println("\n==== exampleDOM2DOM ====");
        Examples.exampleDOM2DOM("foo.xml", "foo.xsl");
        System.out.println("\n==== exampleParam ====");
        Examples.exampleParam("foo.xml", "param.xsl");
        System.out.println("\n==== exampleOutputFormat ====");
        Examples.exampleOutputFormat("foo.xml", "foo.xsl");
        System.out.println("==== exampleUseAssociated ====");
    }

    public static void exampleSimple(String string, String string2) throws ProcessorException, ProcessorFactoryException, TransformException, SAXException, IOException {
        Processor processor = Processor.newInstance("xslt");
        Templates templates = processor.process(new InputSource(string2));
        Transformer transformer = templates.newTransformer();
        transformer.transform(new InputSource(string), new Result(System.out));
    }

    public static void exampleSAX2SAX(String string, String string2) throws SAXException, IOException {
        Processor processor = Processor.newInstance("xslt");
        XMLReader xMLReader = XMLReaderFactory.createXMLReader();
        TemplatesBuilder templatesBuilder = processor.getTemplatesBuilder();
        xMLReader.setContentHandler(templatesBuilder);
        if (templatesBuilder instanceof LexicalHandler) {
            xMLReader.setProperty("http://xml.org/sax/properties/lexical-handler", templatesBuilder);
        }
        xMLReader.parse(string2);
        Templates templates = templatesBuilder.getTemplates();
        Transformer transformer = templates.newTransformer();
        Serializer serializer = SerializerFactory.getSerializer("xml");
        serializer.setOutputStream(System.out);
        transformer.setContentHandler(serializer.asContentHandler());
        ContentHandler contentHandler = transformer.getInputContentHandler();
        xMLReader.setContentHandler(contentHandler);
        if (contentHandler instanceof LexicalHandler) {
            xMLReader.setProperty("http://xml.org/sax/properties/lexical-handler", contentHandler);
        } else {
            xMLReader.setProperty("http://xml.org/sax/properties/lexical-handler", null);
        }
        xMLReader.parse(string);
    }

    public static void exampleXMLFilter(String string, String string2) throws SAXException, IOException {
        Processor processor = Processor.newInstance("xslt");
        Templates templates = processor.process(new InputSource(string2));
        Transformer transformer = templates.newTransformer();
        Serializer serializer = SerializerFactory.getSerializer(new OutputFormat());
        serializer.setOutputStream(System.out);
        transformer.setContentHandler(serializer.asContentHandler());
        XMLReader xMLReader = XMLReaderFactory.createXMLReader();
        transformer.setParent(xMLReader);
        transformer.parse(new InputSource(string));
    }

    public static void exampleXMLFilterChain(String string, String string2, String string3, String string4) throws SAXException, IOException {
        Processor processor = Processor.newInstance("xslt");
        Templates templates = processor.process(new InputSource(string2));
        Transformer transformer = templates.newTransformer();
        Templates templates2 = processor.process(new InputSource(string3));
        Transformer transformer2 = templates2.newTransformer();
        Templates templates3 = processor.process(new InputSource(string4));
        Transformer transformer3 = templates3.newTransformer();
        XMLReader xMLReader = XMLReaderFactory.createXMLReader();
        transformer.setParent(xMLReader);
        transformer2.setParent(transformer);
        transformer3.setParent(transformer2);
        Serializer serializer = SerializerFactory.getSerializer(new OutputFormat());
        serializer.setOutputStream(System.out);
        transformer3.setContentHandler(serializer.asContentHandler());
        transformer3.parse(new InputSource(string));
    }

    public static void exampleDOM2DOM(String string, String string2) throws SAXException, IOException, ParserConfigurationException {
        Processor processor = Processor.newInstance("xslt");
        if (processor.getFeature("http://xml.org/trax/features/dom/input")) {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            documentBuilderFactory.setValidating(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            documentBuilder.newDocument();
            Document document = documentBuilder.parse(new InputSource(string2));
            Templates templates = processor.processFromNode(document);
            Transformer transformer = templates.newTransformer();
            DocumentBuilderFactory documentBuilderFactory2 = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder2 = documentBuilderFactory2.newDocumentBuilder();
            Document document2 = documentBuilder2.newDocument();
            Document document3 = documentBuilder2.parse(new InputSource(string));
            transformer.transformNode(document3, new Result(document2));
            Serializer serializer = SerializerFactory.getSerializer(new OutputFormat());
            serializer.setOutputStream(System.out);
            serializer.asDOMSerializer().serialize(document2);
            return;
        }
        throw new SAXNotSupportedException("DOM node processing not supported!");
    }

    public static void exampleParam(String string, String string2) throws ProcessorException, ProcessorFactoryException, TransformException, SAXException, IOException {
        Processor processor = Processor.newInstance("xslt");
        Templates templates = processor.process(new InputSource(string2));
        Transformer transformer = templates.newTransformer();
        transformer.setParameter("my-param", null, "hello to you!");
        transformer.transform(new InputSource(string), new Result(System.out));
    }

    public static void exampleOutputFormat(String string, String string2) throws ProcessorException, ProcessorFactoryException, TransformException, SAXException, IOException {
        Processor processor = Processor.newInstance("xslt");
        Templates templates = processor.process(new InputSource(string2));
        OutputFormat outputFormat = templates.getOutputFormat();
        outputFormat.setIndent(true);
        Transformer transformer = templates.newTransformer();
        transformer.setOutputFormat(outputFormat);
        transformer.transform(new InputSource(string), new Result(System.out));
    }

    public static void exampleUseAssociated() throws ProcessorException, ProcessorFactoryException, TransformException, SAXException, IOException {
        InputSource inputSource;
        Processor processor = Processor.newInstance("xslt");
        InputSource[] inputSourceArray = processor.getAssociatedStylesheets(inputSource = new InputSource("foo.xml"), "text/xslt", null, null);
        Templates templates = inputSourceArray != null ? processor.processMultiple(inputSourceArray) : processor.process(new InputSource("default.xsl"));
        Transformer transformer = templates.newTransformer();
        transformer.transform(inputSource, new Result(System.out));
    }
}

