/*
 * Decompiled with CFR 0.152.
 */
package org.apache.trax;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.trax.ProcessorException;
import org.apache.trax.ProcessorFactoryException;
import org.apache.trax.Templates;
import org.apache.trax.TemplatesBuilder;
import org.apache.trax.URIResolver;
import org.w3c.dom.Node;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;

public abstract class Processor {
    private static String platformDefaultFactoryName = null;
    public static String PropertiesResource = "trax.properties";
    private XMLReader reader;
    private URIResolver resolver;
    ErrorHandler errorHandler;
    private EntityResolver entityResolver;
    static /* synthetic */ Class class$org$apache$trax$Processor;

    public static void setPlatformDefaultProcessor(String string) {
        platformDefaultFactoryName = string;
    }

    private static String getFactoryNameFromResourceStream(String string) {
        try {
            Properties properties = new Properties();
            InputStream inputStream = (class$org$apache$trax$Processor != null ? class$org$apache$trax$Processor : (class$org$apache$trax$Processor = Processor.class$("org.apache.trax.Processor"))).getResourceAsStream(PropertiesResource);
            if (inputStream == null) {
                return null;
            }
            properties.load(inputStream);
            return properties.getProperty(string);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static Processor newInstance(String string) throws ProcessorFactoryException {
        Processor processor = null;
        try {
            String string2 = "trax.processor." + string;
            String string3 = null;
            try {
                string3 = System.getProperty(string2);
            }
            catch (SecurityException securityException) {}
            if (string3 == null) {
                try {
                    string3 = Processor.getFactoryNameFromResourceStream(string2);
                }
                catch (SecurityException securityException) {}
            }
            if (string3 == null) {
                string3 = platformDefaultFactoryName;
            }
            if (string3 == null) {
                throw new ProcessorFactoryException("Can't find trax property: " + string2, null);
            }
            Class<?> clazz = Class.forName(string3);
            processor = (Processor)clazz.newInstance();
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ProcessorFactoryException("Transformation Processor can not be accessed!", illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            throw new ProcessorFactoryException("Not able to create Transformation Processor!", instantiationException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ProcessorFactoryException("Transformation Processor not found!", classNotFoundException);
        }
        return processor;
    }

    public abstract Templates process(InputSource var1) throws ProcessorException, SAXException, IOException;

    public abstract Templates processFromNode(Node var1) throws ProcessorException;

    public abstract Templates processFromNode(Node var1, String var2) throws ProcessorException;

    public abstract Templates processMultiple(InputSource[] var1) throws ProcessorException;

    public abstract InputSource[] getAssociatedStylesheets(InputSource var1, String var2, String var3, String var4) throws ProcessorException;

    public abstract TemplatesBuilder getTemplatesBuilder() throws ProcessorException;

    public void setXMLReader(XMLReader xMLReader) {
        this.reader = xMLReader;
    }

    public XMLReader getXMLReader() {
        return this.reader;
    }

    public boolean getFeature(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
        throw new SAXNotRecognizedException(string);
    }

    public void setFeature(String string, boolean bl) throws SAXNotRecognizedException, SAXNotSupportedException {
        throw new SAXNotRecognizedException(string);
    }

    public void setURIResolver(URIResolver uRIResolver) {
        this.resolver = uRIResolver;
    }

    public URIResolver getURIResolver() {
        return this.resolver;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        if (errorHandler == null) {
            throw new NullPointerException("Null error handler");
        }
        this.errorHandler = errorHandler;
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.entityResolver = entityResolver;
    }

    public EntityResolver getEntityResolver() {
        return this.entityResolver;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

