/*
 * Decompiled with CFR 0.152.
 */
package org.apache.trax;

import java.io.PrintStream;
import java.io.PrintWriter;
import org.apache.trax.ProcessorException;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.LocatorImpl;

public class TransformException
extends SAXParseException {
    public TransformException(String string) {
        super(string, new LocatorImpl());
    }

    public TransformException(Exception exception) {
        super(exception.getMessage(), new LocatorImpl(), exception);
    }

    public TransformException(Exception exception, Locator locator) {
        super(exception.getMessage(), locator, exception);
    }

    public TransformException(String string, Exception exception) {
        super(string, new LocatorImpl(), exception);
    }

    public TransformException(String string, Locator locator) {
        super(string, locator);
    }

    public TransformException(String string, Locator locator, Exception exception) {
        super(string, locator, exception);
    }

    public TransformException(String string, String string2, String string3, int n, int n2) {
        super(string, string2, string3, n, n2);
    }

    public TransformException(String string, String string2, String string3, int n, int n2, Exception exception) {
        super(string, string2, string3, n, n2, exception);
    }

    public void printStackTrace(PrintStream printStream) {
        if (printStream == null) {
            printStream = System.err;
        }
        try {
            super.printStackTrace(printStream);
        }
        catch (Exception exception) {}
        Exception exception = this.getException();
        int n = 0;
        while (n < 10 && exception != null) {
            printStream.println("---------");
            exception.printStackTrace(printStream);
            if (exception instanceof SAXException) {
                Exception exception2 = exception;
                SAXException sAXException = (SAXException)exception;
                if (exception2 == (exception = sAXException.getException())) {
                    return;
                }
            } else {
                exception = null;
            }
            ++n;
        }
    }

    private boolean isSimilar(Exception exception, Exception exception2) {
        boolean bl = false;
        if (exception instanceof SAXParseException && exception2 instanceof SAXParseException) {
            SAXParseException sAXParseException = (SAXParseException)exception;
            String string = sAXParseException.getSystemId();
            int n = sAXParseException.getLineNumber();
            int n2 = sAXParseException.getColumnNumber();
            SAXParseException sAXParseException2 = (SAXParseException)exception2;
            String string2 = sAXParseException2.getSystemId();
            int n3 = sAXParseException2.getLineNumber();
            int n4 = sAXParseException2.getColumnNumber();
            if (string == null) {
                string = "";
            }
            if (string2 == null) {
                string2 = "";
            }
            bl = string.equals(string2) && n == n3 && n2 == n4;
        }
        return bl;
    }

    private void appendMessageAndInfo(StringBuffer stringBuffer) {
        String string = super.getMessage();
        String string2 = this.getSystemId();
        int n = this.getLineNumber();
        int n2 = this.getColumnNumber();
        if (string != null) {
            stringBuffer.append(string);
        }
        if (string2 != null) {
            stringBuffer.append("; SystemID: ");
            stringBuffer.append(string2);
        }
        if (n != 0) {
            stringBuffer.append("; Line#: ");
            stringBuffer.append(n);
        }
        if (n2 != 0) {
            stringBuffer.append("; Column#: ");
            stringBuffer.append(n2);
        }
    }

    public String getMessage() {
        StringBuffer stringBuffer = new StringBuffer();
        this.appendMessageAndInfo(stringBuffer);
        Exception exception = this;
        Exception exception2 = this.getException();
        while (exception2 != null) {
            Object object;
            if (!(exception2 instanceof TransformException) && !(exception2 instanceof ProcessorException) && exception2 instanceof SAXException) {
                if (exception2 instanceof SAXParseException) {
                    if (!this.isSimilar(exception, exception2)) {
                        object = (SAXParseException)exception2;
                        String string = ((SAXException)object).getMessage();
                        if (string != null) {
                            stringBuffer.append("\n (");
                            stringBuffer.append(object.getClass().getName());
                            stringBuffer.append("): ");
                            stringBuffer.append(string);
                        }
                        if (((SAXParseException)object).getSystemId() != null) {
                            stringBuffer.append("; SystemID: ");
                            stringBuffer.append(((SAXParseException)object).getSystemId());
                        }
                        if (((SAXParseException)object).getLineNumber() != 0) {
                            stringBuffer.append("; Line#: ");
                            stringBuffer.append(((SAXParseException)object).getLineNumber());
                        }
                        if (((SAXParseException)object).getColumnNumber() != 0) {
                            stringBuffer.append("; Column#: ");
                            stringBuffer.append(((SAXParseException)object).getColumnNumber());
                        }
                    }
                } else if (!this.isSimilar(exception, exception2) && (object = exception2.getMessage()) != null) {
                    stringBuffer.append("\n (");
                    stringBuffer.append(exception2.getClass().getName());
                    stringBuffer.append("): ");
                    stringBuffer.append((String)object);
                }
                exception = exception2;
                exception2 = ((SAXException)exception2).getException();
                continue;
            }
            if (this.isSimilar(exception, exception2)) continue;
            object = exception2.getMessage();
            if (object != null) {
                stringBuffer.append("\n (");
                stringBuffer.append(exception2.getClass().getName());
                stringBuffer.append("): ");
                stringBuffer.append((String)object);
            }
            exception2 = null;
        }
        return stringBuffer.toString();
    }

    public void printStackTrace(PrintWriter printWriter) {
        if (printWriter == null) {
            printWriter = new PrintWriter(System.err);
        }
        try {
            super.printStackTrace(printWriter);
        }
        catch (Exception exception) {}
        Exception exception = this.getException();
        int n = 0;
        while (n < 10 && exception != null) {
            printWriter.println("---------");
            try {
                exception.printStackTrace(printWriter);
            }
            catch (Exception exception2) {
                printWriter.println("Could not print stack trace...");
            }
            if (exception instanceof SAXException) {
                Exception exception3 = exception;
                SAXException sAXException = (SAXException)exception;
                if (exception3 == (exception = sAXException.getException())) {
                    exception = null;
                    return;
                }
            } else {
                exception = null;
            }
            ++n;
        }
    }
}

