/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.client;

import java.applet.Applet;
import java.awt.Graphics;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.trax.Processor;
import org.apache.trax.ProcessorFactoryException;
import org.apache.trax.Templates;
import org.apache.trax.TemplatesBuilder;
import org.apache.trax.TransformException;
import org.apache.xalan.res.XSLMessages;
import org.apache.xalan.stree.SourceTreeHandler;
import org.apache.xalan.transformer.TransformerImpl;
import org.apache.xml.serialize.transition.HTMLSerializer;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class XSLTProcessorApplet
extends Applet {
    Processor m_processor;
    String m_processorName = "org.apache.xalan.processor.StylesheetProcessor";
    XMLReader m_reader;
    TemplatesBuilder m_templatesBuilder;
    private String m_styleURL;
    private String m_documentURL;
    private final String PARAM_styleURL = "styleURL";
    private final String PARAM_documentURL = "documentURL";
    private final String PARAM_parser = "parser";
    private String whichParser;
    private String m_styleURLOfCached;
    private String m_documentURLOfCached;
    private URL m_codeBase;
    private URL m_documentBase;
    private Templates m_styleTree;
    private transient Thread m_callThread;
    private transient TrustedAgent m_trustedAgent;
    private transient Thread m_trustedWorker;
    private transient String m_htmlText;
    private transient String m_nameOfIDAttrOfElemToModify;
    private transient String m_elemIdToModify;
    private transient String m_attrNameToSet;
    private transient String m_attrValueToSet;
    transient String m_key;
    transient String m_expression;

    public String getAppletInfo() {
        return "Name: XSLTProcessorApplet\r\nAuthor: Scott Boag";
    }

    public String[][] getParameterInfo() {
        String[][] stringArray = new String[][]{{"styleURL", "String", "URL to a XSL style sheet"}, {"documentURL", "String", "URL to a XML document"}, {"parser", "String", "Which parser to use: Xerces or ANY"}};
        return stringArray;
    }

    public void init() {
        String string = this.getParameter("parser");
        this.whichParser = string != null ? string : "ANY";
        string = this.getParameter("styleURL");
        if (string != null) {
            this.setStyleURL(string);
        }
        if ((string = this.getParameter("documentURL")) != null) {
            this.setDocumentURL(string);
        }
        this.m_codeBase = this.getCodeBase();
        this.m_documentBase = this.getDocumentBase();
        this.resize(320, 240);
    }

    protected void initLiaison() {
    }

    Processor newProcessorInstance() throws ProcessorFactoryException {
        Processor processor = null;
        try {
            Class<?> clazz = Class.forName(this.m_processorName);
            processor = (Processor)clazz.newInstance();
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ProcessorFactoryException("Transformation Processor can not be accessed!", illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            throw new ProcessorFactoryException("Not able to create Transformation Processor!", instantiationException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ProcessorFactoryException("Transformation Processor not found!", classNotFoundException);
        }
        return processor;
    }

    void transform(TransformerImpl transformerImpl, InputSource inputSource) throws SAXException, TransformException, IOException {
        try {
            this.m_reader.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
        }
        catch (SAXException sAXException) {}
        try {
            SourceTreeHandler sourceTreeHandler = new SourceTreeHandler(transformerImpl);
            this.m_reader.setContentHandler(sourceTreeHandler);
            this.m_reader.setProperty("http://xml.org/sax/properties/lexical-handler", sourceTreeHandler);
            transformerImpl.getXPathContext().setPrimaryReader(this.m_reader);
            this.m_reader.parse(inputSource);
            return;
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
            throw new TransformException(sAXException);
        }
        catch (IOException iOException) {
            throw new TransformException(iOException);
        }
    }

    public void destroy() {
        if (this.m_trustedWorker != null) {
            this.m_trustedWorker.stop();
            this.m_trustedWorker = null;
        }
        this.m_styleURLOfCached = null;
        this.m_documentURLOfCached = null;
    }

    public void paint(Graphics graphics) {
    }

    public void start() {
        this.m_trustedAgent = new TrustedAgent();
        Thread thread = Thread.currentThread();
        this.m_trustedWorker = new Thread(thread.getThreadGroup(), this.m_trustedAgent);
        this.m_trustedWorker.start();
        try {
            this.showStatus("Causing Xalan and Xerces to Load and JIT...");
            StringReader stringReader = new StringReader("<?xml version='1.0'?><foo/>");
            StringReader stringReader2 = new StringReader("<?xml version='1.0'?><xsl:stylesheet xmlns:xsl='http://www.w3.org/1999/XSL/Transform' version='1.0'><xsl:template match='foo'><out/></xsl:template></xsl:stylesheet>");
            PrintWriter printWriter = new PrintWriter(new StringWriter());
            this.m_processor = this.newProcessorInstance();
            this.m_reader = XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser");
            this.m_templatesBuilder = this.m_processor.getTemplatesBuilder();
            this.m_reader.setContentHandler(this.m_templatesBuilder);
            Processor processor = this.m_processor;
            synchronized (processor) {
                this.m_reader.parse(new InputSource(stringReader2));
                Templates templates = this.m_templatesBuilder.getTemplates();
                TransformerImpl transformerImpl = (TransformerImpl)templates.newTransformer();
                HTMLSerializer hTMLSerializer = new HTMLSerializer();
                hTMLSerializer.setWriter(printWriter);
                ContentHandler contentHandler = hTMLSerializer.asContentHandler();
                transformerImpl.setContentHandler(contentHandler);
                transformerImpl.setParent(this.m_reader);
                this.transform(transformerImpl, new InputSource(stringReader));
                this.showStatus("PRIMED the pump!");
            }
            System.out.println("Primed the pump!");
            this.showStatus("Ready to click!");
            return;
        }
        catch (Exception exception) {
            this.showStatus("Could not prime the pump!");
            System.out.println("Could not prime the pump!");
            exception.printStackTrace();
            return;
        }
    }

    public void stop() {
        if (this.m_trustedWorker != null) {
            this.m_trustedWorker.stop();
            this.m_trustedWorker = null;
        }
        this.m_styleURLOfCached = null;
        this.m_documentURLOfCached = null;
    }

    public void setStyleURL(String string) {
        this.m_styleURL = string;
    }

    public void setDocumentURL(String string) {
        this.m_documentURL = string;
    }

    public void freeCache() {
        this.m_styleURLOfCached = null;
        this.m_documentURLOfCached = null;
    }

    public void setStyleSheetAttribute(String string, String string2, String string3, String string4) {
        this.m_nameOfIDAttrOfElemToModify = string;
        this.m_elemIdToModify = string2;
        this.m_attrNameToSet = string3;
        this.m_attrValueToSet = string4;
    }

    public void setStylesheetParam(String string, String string2) {
        this.m_key = string;
        this.m_expression = string2;
    }

    public String escapeString(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (c == '<') {
                stringBuffer.append("&lt;");
            } else if (c == '>') {
                stringBuffer.append("&gt;");
            } else if (c == '&') {
                stringBuffer.append("&amp;");
            } else if (c >= '\ud800' && c < '\udc00') {
                int n3;
                if (n2 + 1 >= n) {
                    throw new RuntimeException(XSLMessages.createMessage(100, new Object[]{Integer.toHexString(c)}));
                }
                if ((n3 = string.charAt(++n2)) < 56320 || n3 >= 57344) {
                    throw new RuntimeException(XSLMessages.createMessage(100, new Object[]{String.valueOf(Integer.toHexString(c)) + " " + Integer.toHexString(n3)}));
                }
                n3 = (c - 55296 << 10) + n3 - 56320 + 65536;
                stringBuffer.append("&#x");
                stringBuffer.append(Integer.toHexString(n3));
                stringBuffer.append(";");
            } else {
                stringBuffer.append(c);
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    public String getHtmlText() {
        this.m_trustedAgent.m_getData = true;
        this.m_callThread = Thread.currentThread();
        try {
            Thread thread = this.m_callThread;
            synchronized (thread) {
                this.m_callThread.wait();
            }
        }
        catch (InterruptedException interruptedException) {
            System.out.println(interruptedException.getMessage());
        }
        return this.m_htmlText;
    }

    public String getTreeAsText(String string) throws IOException {
        String string2 = "";
        byte[] byArray = new byte[50000];
        try {
            int n;
            URL uRL = new URL(this.m_documentBase, string);
            InputStream inputStream = uRL.openStream();
            while ((n = inputStream.read(byArray, 0, byArray.length)) != -1) {
                string2 = String.valueOf(string2) + new String(byArray, 0, n);
            }
            inputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string2;
    }

    public String getSourceTreeAsText() throws Exception {
        return this.getTreeAsText(this.m_documentURL);
    }

    public String getStyleTreeAsText() throws Exception {
        return this.getTreeAsText(this.m_styleURL);
    }

    public String getResultTreeAsText() throws Exception {
        return this.escapeString(this.getHtmlText());
    }

    public String transformToHtml(String string, String string2) {
        if (string != null) {
            this.m_documentURL = string;
        }
        if (string2 != null) {
            this.m_styleURL = string2;
        }
        return this.getHtmlText();
    }

    public String transformToHtml(String string) {
        if (string != null) {
            this.m_documentURL = string;
        }
        this.m_styleURL = null;
        return this.getHtmlText();
    }

    private String doTransformation(Processor processor) throws SAXException {
        Object object;
        URL uRL = null;
        URL uRL2 = null;
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter((Writer)stringWriter, false);
        this.showStatus("Begin Transformation...");
        try {
            this.m_templatesBuilder = this.m_processor.getTemplatesBuilder();
            this.m_reader.setContentHandler(this.m_templatesBuilder);
            uRL = new URL(this.m_codeBase, this.m_documentURL);
            object = new InputSource(uRL.toString());
            uRL2 = new URL(this.m_codeBase, this.m_styleURL);
            InputSource inputSource = new InputSource(uRL2.toString());
            this.m_reader.parse(inputSource);
            Templates templates = this.m_templatesBuilder.getTemplates();
            TransformerImpl transformerImpl = (TransformerImpl)templates.newTransformer();
            if (this.m_key != null) {
                transformerImpl.setParameter(this.m_key, null, this.m_expression);
            }
            HTMLSerializer hTMLSerializer = new HTMLSerializer();
            this.showStatus("serializer is " + hTMLSerializer);
            hTMLSerializer.setWriter(printWriter);
            ContentHandler contentHandler = hTMLSerializer.asContentHandler();
            transformerImpl.setContentHandler(contentHandler);
            transformerImpl.setParent(this.m_reader);
            this.transform(transformerImpl, (InputSource)object);
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
            System.exit(-1);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            System.exit(-1);
        }
        this.showStatus("Transformation Done!");
        object = stringWriter.toString();
        return object;
    }

    private String processTransformation() throws SAXException {
        String string;
        block6: {
            string = null;
            try {
                if (this.whichParser.trim().equals("Xerces") || this.whichParser.trim().equals("ANY")) {
                    this.showStatus("Waiting for Xalan and Xerces to finish loading and JITing...");
                    Processor processor = this.m_processor;
                    synchronized (processor) {
                        string = this.doTransformation(this.m_processor);
                        break block6;
                    }
                }
                System.out.println("Problem with XML parser!");
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                System.out.println("Can not find " + this.whichParser + " XML Processor!!");
            }
        }
        return string;
    }

    static /* synthetic */ Thread access$0(XSLTProcessorApplet xSLTProcessorApplet) {
        return xSLTProcessorApplet.m_trustedWorker;
    }

    static /* synthetic */ String access$1(XSLTProcessorApplet xSLTProcessorApplet) {
        return xSLTProcessorApplet.m_htmlText;
    }

    class TrustedAgent
    implements Runnable {
        public boolean m_getData = false;

        public void run() {
            while (true) {
                Thread.yield();
                if (this.m_getData) {
                    Thread thread;
                    Object var2_3;
                    try {
                        try {
                            this.m_getData = false;
                            XSLTProcessorApplet.this.m_htmlText = null;
                            XSLTProcessorApplet.this.m_htmlText = XSLTProcessorApplet.this.processTransformation();
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                        var2_3 = null;
                    }
                    catch (Throwable throwable) {
                        var2_3 = null;
                        thread = XSLTProcessorApplet.this.m_callThread;
                        synchronized (thread) {
                            XSLTProcessorApplet.this.m_callThread.notify();
                        }
                        throw throwable;
                    }
                    thread = XSLTProcessorApplet.this.m_callThread;
                    synchronized (thread) {
                        XSLTProcessorApplet.this.m_callThread.notify();
                    }
                }
                try {
                    Thread.sleep(50L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                    continue;
                }
                break;
            }
        }

        TrustedAgent() {
            XSLTProcessorApplet.this = XSLTProcessorApplet.this;
        }
    }
}

