/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.lib.sql;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Hashtable;
import org.apache.xalan.lib.sql.StreamableNode;
import org.apache.xalan.lib.sql.XStatement;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ColumnAttribute
extends StreamableNode
implements Attr {
    Element m_owner;
    ResultSetMetaData m_metadata;
    String m_name;
    int m_type;
    int m_columnIndex;
    ColumnAttribute m_columnAttr;
    static final String S_ISTRUE = "true";
    static final String S_ISFALSE = "false";
    public static final int CATALOGUE_NAME = 0;
    public static final int DISPLAY_SIZE = 1;
    public static final int COLUMN_LABEL = 2;
    public static final int COLUMN_NAME = 3;
    public static final int COLUMN_TYPE = 4;
    public static final int COLUMN_TYPENAME = 5;
    public static final int PRECISION = 6;
    public static final int SCALE = 7;
    public static final int SCHEMA_NAME = 8;
    public static final int TABLE_NAME = 9;
    public static final int CASESENSITIVE = 10;
    public static final int DEFINATELYWRITABLE = 11;
    public static final int ISNULLABLE = 12;
    public static final int ISSIGNED = 13;
    public static final int ISWRITEABLE = 14;
    public static final int ISSEARCHABLE = 15;
    public static final int NUMBER_ATTRIBUTES = 16;
    public static final String S_CATALOGUE_NAME = "catalogue-name";
    public static final String S_DISPLAY_SIZE = "column-display-size";
    public static final String S_COLUMN_LABEL = "column-label";
    public static final String S_COLUMN_NAME = "column-name";
    public static final String S_COLUMN_TYPE = "column-type";
    public static final String S_COLUMN_TYPENAME = "column-type-name";
    public static final String S_PRECISION = "precision";
    public static final String S_SCALE = "scale";
    public static final String S_SCHEMA_NAME = "schema-name";
    public static final String S_TABLE_NAME = "table-name";
    public static final String S_CASESENSITIVE = "case-sensitive";
    public static final String S_DEFINATELYWRITABLE = "definitely-writable";
    public static final String S_ISNULLABLE = "nullable";
    public static final String S_ISSIGNED = "signed";
    public static final String S_ISWRITEABLE = "writable";
    public static final String S_ISSEARCHABLE = "searchable";
    static Hashtable m_namelookup = new Hashtable();

    public ColumnAttribute(XStatement xStatement, Element element, int n, int n2, ResultSetMetaData resultSetMetaData) {
        super(xStatement);
        this.m_owner = element;
        this.m_metadata = resultSetMetaData;
        this.m_columnIndex = n;
        this.m_type = n2;
    }

    static String getAttrNameFromPos(int n) {
        switch (n) {
            case 0: {
                return S_CATALOGUE_NAME;
            }
            case 1: {
                return S_DISPLAY_SIZE;
            }
            case 2: {
                return S_COLUMN_LABEL;
            }
            case 3: {
                return S_COLUMN_NAME;
            }
            case 4: {
                return S_COLUMN_TYPE;
            }
            case 5: {
                return S_COLUMN_TYPENAME;
            }
            case 6: {
                return S_PRECISION;
            }
            case 7: {
                return S_SCALE;
            }
            case 8: {
                return S_SCHEMA_NAME;
            }
            case 9: {
                return S_TABLE_NAME;
            }
            case 10: {
                return S_CASESENSITIVE;
            }
            case 11: {
                return S_DEFINATELYWRITABLE;
            }
            case 12: {
                return S_ISNULLABLE;
            }
            case 13: {
                return S_ISSIGNED;
            }
            case 14: {
                return S_ISWRITEABLE;
            }
            case 15: {
                return S_ISSEARCHABLE;
            }
        }
        return null;
    }

    static int getAttrPosFromName(String string) {
        Integer n = (Integer)m_namelookup.get(string);
        if (n != null) {
            return n;
        }
        return -1;
    }

    public boolean setName(String string) {
        this.m_name = string;
        int n = ColumnAttribute.getAttrPosFromName(string);
        return n >= 0;
    }

    public String getNodeName() {
        return this.m_name;
    }

    public String getName() {
        return this.m_name;
    }

    public boolean getSpecified() {
        return true;
    }

    public String getNodeValue() {
        return this.getValue();
    }

    public String getValue() {
        int n = this.m_columnIndex + 1;
        try {
            switch (this.m_type) {
                case 0: {
                    return this.m_metadata.getCatalogName(n);
                }
                case 1: {
                    return Integer.toString(this.m_metadata.getColumnDisplaySize(n));
                }
                case 2: {
                    return this.m_metadata.getColumnLabel(n);
                }
                case 3: {
                    return this.m_metadata.getColumnName(n);
                }
                case 4: {
                    return Integer.toString(this.m_metadata.getColumnType(n));
                }
                case 5: {
                    return this.m_metadata.getColumnTypeName(n);
                }
                case 6: {
                    return Integer.toString(this.m_metadata.getPrecision(n));
                }
                case 7: {
                    return Integer.toString(this.m_metadata.getScale(n));
                }
                case 8: {
                    return this.m_metadata.getSchemaName(n);
                }
                case 9: {
                    return this.m_metadata.getTableName(n);
                }
                case 10: {
                    if (this.m_metadata.isCaseSensitive(n)) {
                        return S_ISTRUE;
                    }
                    return S_ISFALSE;
                }
                case 11: {
                    if (this.m_metadata.isDefinitelyWritable(n)) {
                        return S_ISTRUE;
                    }
                    return S_ISFALSE;
                }
                case 12: {
                    return Integer.toString(this.m_metadata.isNullable(n));
                }
                case 13: {
                    if (this.m_metadata.isSigned(n)) {
                        return S_ISTRUE;
                    }
                    return S_ISFALSE;
                }
                case 14: {
                    if (this.m_metadata.isWritable(n)) {
                        return S_ISTRUE;
                    }
                    return S_ISFALSE;
                }
                case 15: {
                    if (this.m_metadata.isSearchable(n)) {
                        return S_ISTRUE;
                    }
                    return S_ISFALSE;
                }
            }
            return "";
        }
        catch (SQLException sQLException) {
            return "SQL ERROR!";
        }
    }

    public void setValue(String string) throws DOMException {
        this.error(80);
    }

    public Element getOwnerElement() {
        return this.m_owner;
    }

    public Node getParentNode() {
        return null;
    }

    public short getNodeType() {
        return 2;
    }

    static {
        m_namelookup.put(S_CATALOGUE_NAME, new Integer(0));
        m_namelookup.put(S_DISPLAY_SIZE, new Integer(1));
        m_namelookup.put(S_COLUMN_LABEL, new Integer(2));
        m_namelookup.put(S_COLUMN_NAME, new Integer(3));
        m_namelookup.put(S_COLUMN_TYPE, new Integer(4));
        m_namelookup.put(S_COLUMN_TYPENAME, new Integer(5));
        m_namelookup.put(S_PRECISION, new Integer(6));
        m_namelookup.put(S_SCALE, new Integer(7));
        m_namelookup.put(S_SCHEMA_NAME, new Integer(8));
        m_namelookup.put(S_TABLE_NAME, new Integer(9));
        m_namelookup.put(S_CASESENSITIVE, new Integer(10));
        m_namelookup.put(S_DEFINATELYWRITABLE, new Integer(11));
        m_namelookup.put(S_ISNULLABLE, new Integer(12));
        m_namelookup.put(S_ISSIGNED, new Integer(13));
        m_namelookup.put(S_ISWRITEABLE, new Integer(14));
        m_namelookup.put(S_ISSEARCHABLE, new Integer(15));
    }
}

