/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.lib.sql;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.apache.xalan.lib.sql.Column;
import org.apache.xalan.lib.sql.RowSet;
import org.apache.xalan.lib.sql.StreamableNode;
import org.apache.xalan.lib.sql.XStatement;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class Row
extends StreamableNode {
    int m_childCount;
    Column[] m_columns;
    ResultSetMetaData m_metadata;
    boolean m_isStreamable = false;
    Row m_next;
    private static final boolean DEBUG = false;
    RowSet m_parent;

    public Row(XStatement xStatement, RowSet rowSet) {
        super(xStatement);
        try {
            ResultSetMetaData resultSetMetaData;
            this.m_parent = rowSet;
            XStatement xStatement2 = this.getXStatement();
            ResultSet resultSet = xStatement2.getResultSet();
            this.m_metadata = resultSetMetaData = resultSet.getMetaData();
            this.m_childCount = resultSetMetaData.getColumnCount();
            this.m_columns = new Column[this.m_childCount];
            int n = 0;
            while (n < this.m_childCount) {
                this.m_columns[n] = new Column(xStatement2, this, n, resultSetMetaData);
                ++n;
            }
            return;
        }
        catch (SQLException sQLException) {
            return;
        }
    }

    public Document getOwnerDocument() {
        return this.getXStatement();
    }

    public String getNodeName() {
        return "row";
    }

    public Node getFirstChild() {
        if (this.hasChildNodes()) {
            return this.m_columns[0];
        }
        return null;
    }

    public Node getNextSibling() {
        XStatement xStatement = this.getXStatement();
        ResultSet resultSet = xStatement.getResultSet();
        try {
            if (this.m_isStreamable) {
                if (resultSet.next()) {
                    return this;
                }
                return null;
            }
            if (this.m_next == null) {
                try {
                    if (resultSet.next()) {
                        this.m_next = new Row(this.getXStatement(), this.m_parent);
                    }
                }
                catch (SQLException sQLException) {}
            }
            return this.m_next;
        }
        catch (SQLException sQLException) {
            return null;
        }
    }

    public Node getParentNode() {
        return this.m_parent;
    }

    public boolean hasChildNodes() {
        return this.m_childCount > 0;
    }
}

