/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.processor;

import java.io.IOException;
import org.apache.trax.URIResolver;
import org.apache.xalan.processor.StylesheetHandler;
import org.apache.xalan.processor.XSLTElementProcessor;
import org.apache.xalan.utils.SystemIDResolver;
import org.apache.xalan.utils.TreeWalker;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

class ProcessorInclude
extends XSLTElementProcessor {
    private String m_href;

    public String getHref() {
        return this.m_href;
    }

    public void setHref(String string) {
        this.m_href = string;
    }

    public void startElement(StylesheetHandler stylesheetHandler, String string, String string2, String string3, Attributes attributes) throws SAXException {
        this.setPropertiesFromAttributes(stylesheetHandler, string3, attributes, this);
        int n = stylesheetHandler.getStylesheetType();
        stylesheetHandler.setStylesheetType(2);
        try {
            this.parse(stylesheetHandler, string, string2, string3, attributes);
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            stylesheetHandler.setStylesheetType(n);
            stylesheetHandler.popStylesheet();
            throw throwable;
        }
        Object var8_7 = null;
        stylesheetHandler.setStylesheetType(n);
        stylesheetHandler.popStylesheet();
    }

    protected void parse(StylesheetHandler stylesheetHandler, String string, String string2, String string3, Attributes attributes) throws SAXException {
        URIResolver uRIResolver = stylesheetHandler.getStylesheetProcessor().getURIResolver();
        try {
            TreeWalker treeWalker;
            Object object;
            InputSource inputSource;
            XMLReader xMLReader = null;
            boolean bl = true;
            EntityResolver entityResolver = stylesheetHandler.getStylesheetProcessor().getEntityResolver();
            if (entityResolver != null) {
                inputSource = entityResolver.resolveEntity(null, this.getHref());
            } else {
                object = SystemIDResolver.getAbsoluteURI(this.getHref(), stylesheetHandler.getBaseIdentifier());
                inputSource = new InputSource((String)object);
            }
            if (uRIResolver != null) {
                bl = false;
                xMLReader = uRIResolver.getXMLReader(inputSource);
                if (xMLReader == null) {
                    object = uRIResolver.getDOMNode(inputSource);
                    if (object != null) {
                        treeWalker = new TreeWalker(stylesheetHandler);
                        treeWalker.traverse((Node)object);
                    } else {
                        bl = true;
                    }
                }
            }
            if (bl) {
                xMLReader = stylesheetHandler.getStylesheetProcessor().getXMLReader();
                if (xMLReader == null) {
                    xMLReader = XMLReaderFactory.createXMLReader();
                } else {
                    object = xMLReader.getClass();
                    xMLReader = (XMLReader)((Class)object).newInstance();
                }
            }
            if (xMLReader != null) {
                if (entityResolver != null) {
                    xMLReader.setEntityResolver(entityResolver);
                }
                xMLReader.setContentHandler(stylesheetHandler);
                xMLReader.setFeature("http://apache.org/xml/features/validation/dynamic", true);
                stylesheetHandler.pushBaseIndentifier(inputSource.getSystemId());
                try {
                    xMLReader.parse(inputSource);
                    return;
                }
                finally {
                    treeWalker = null;
                    stylesheetHandler.popBaseIndentifier();
                }
            }
        }
        catch (InstantiationException instantiationException) {
            stylesheetHandler.error("Could not clone parser!", instantiationException);
            return;
        }
        catch (IllegalAccessException illegalAccessException) {
            stylesheetHandler.error("Can not access class!", illegalAccessException);
            return;
        }
        catch (IOException iOException) {
            stylesheetHandler.error(37, new Object[]{this.getHref()}, iOException);
            return;
        }
        catch (SAXException sAXException) {
            stylesheetHandler.error(37, new Object[]{this.getHref()}, sAXException);
        }
    }

    ProcessorInclude() {
    }
}

