/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.processor;

import java.util.EmptyStackException;
import java.util.Stack;
import org.apache.trax.ProcessorException;
import org.apache.trax.Templates;
import org.apache.trax.TemplatesBuilder;
import org.apache.trax.TransformException;
import org.apache.xalan.processor.StylesheetProcessor;
import org.apache.xalan.processor.XSLTElementDef;
import org.apache.xalan.processor.XSLTElementProcessor;
import org.apache.xalan.processor.XSLTSchema;
import org.apache.xalan.res.XSLMessages;
import org.apache.xalan.templates.ElemTemplateElement;
import org.apache.xalan.templates.FuncDocument;
import org.apache.xalan.templates.FuncFormatNumb;
import org.apache.xalan.templates.Stylesheet;
import org.apache.xalan.templates.StylesheetRoot;
import org.apache.xalan.utils.NodeConsumer;
import org.apache.xalan.utils.PrefixResolver;
import org.apache.xalan.utils.XMLCharacterRecognizer;
import org.apache.xpath.XPath;
import org.apache.xpath.compiler.FunctionTable;
import org.apache.xpath.compiler.XPathParser;
import org.apache.xpath.functions.Function2Args;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.LocatorImpl;
import org.xml.sax.helpers.NamespaceSupport;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class StylesheetHandler
implements EntityResolver,
DTDHandler,
ContentHandler,
ErrorHandler,
TemplatesBuilder,
PrefixResolver,
NodeConsumer {
    private static boolean m_xpathFunctionsInited;
    private int m_stylesheetLevel = -1;
    private boolean m_shouldProcess = true;
    private String m_fragmentIDString;
    private int m_elementID;
    private int m_fragmentID;
    private StylesheetProcessor m_stylesheetProcessor;
    static final int STYPE_ROOT = 1;
    static final int STYPE_INCLUDE = 2;
    static final int STYPE_IMPORT = 3;
    private int m_stylesheetType = 1;
    private Stack m_stylesheets = new Stack();
    private Stack m_processors = new Stack();
    private XSLTSchema m_schema = new XSLTSchema();
    private Stack m_elems = new Stack();
    private boolean m_foundNotImport = false;
    private static XSLMessages m_XSLMessages;
    Stack m_baseIdentifiers = new Stack();
    private Stack m_stylesheetLocatorStack = new Stack();
    private Stack m_importStack = new Stack();
    private boolean warnedAboutOldXSLTNamespace = false;
    private XPathParser m_xpathProcessor = new XPathParser();
    private NamespaceSupport m_nsSupport = new NamespaceSupport();
    private Node m_originatingNode;

    public StylesheetHandler(StylesheetProcessor stylesheetProcessor) throws ProcessorException {
        this.init(stylesheetProcessor);
    }

    void init(StylesheetProcessor stylesheetProcessor) {
        if (!m_xpathFunctionsInited) {
            StylesheetHandler stylesheetHandler = this;
            synchronized (stylesheetHandler) {
                if (!m_xpathFunctionsInited) {
                    m_xpathFunctionsInited = true;
                    Function2Args function2Args = new FuncDocument();
                    FunctionTable.installFunction("document", function2Args);
                    function2Args = new FuncFormatNumb();
                    FunctionTable.installFunction("format-number", function2Args);
                }
            }
        }
        this.m_stylesheetProcessor = stylesheetProcessor;
        this.m_processors.push(this.m_schema.getElementProcessor());
    }

    public XPath createXPath(String string) throws SAXException {
        return new XPath(string, this.getLocator(), this, 0);
    }

    XPath createMatchPatternXPath(String string) throws SAXException {
        return new XPath(string, this.getLocator(), this, 1);
    }

    public String getNamespaceForPrefix(String string) {
        return this.m_nsSupport.getURI(string);
    }

    public String getNamespaceForPrefix(String string, Node node) {
        this.assert(true, "can't process a context node in StylesheetHandler!");
        return null;
    }

    public String getBaseIdentifier() {
        Locator locator = this.getLocator();
        if (locator == null) {
            return "";
        }
        return locator.getSystemId();
    }

    private boolean stackContains(Stack stack, String string) {
        int n = stack.size();
        boolean bl = false;
        int n2 = 0;
        while (n2 < n) {
            String string2 = (String)stack.elementAt(n2);
            if (string2.equals(string)) {
                bl = true;
                break;
            }
            ++n2;
        }
        return bl;
    }

    public Templates getTemplates() throws TransformException {
        return this.getStylesheetRoot();
    }

    public void setBaseID(String string) {
        this.pushBaseIndentifier(string);
    }

    public InputSource resolveEntity(String string, String string2) throws SAXException {
        return this.getCurrentProcessor().resolveEntity(this, string, string2);
    }

    public void notationDecl(String string, String string2, String string3) {
        this.getCurrentProcessor().notationDecl(this, string, string2, string3);
    }

    public void unparsedEntityDecl(String string, String string2, String string3, String string4) {
        this.getCurrentProcessor().unparsedEntityDecl(this, string, string2, string3, string4);
    }

    XSLTElementProcessor getProcessorFor(String string, String string2, String string3) throws SAXException {
        XSLTElementProcessor xSLTElementProcessor = this.getCurrentProcessor();
        XSLTElementDef xSLTElementDef = xSLTElementProcessor.getElemDef();
        XSLTElementProcessor xSLTElementProcessor2 = xSLTElementDef.getProcessorFor(string, string2);
        if (xSLTElementProcessor2 == null && Double.valueOf(this.getStylesheet().getVersion()) > 1.0) {
            xSLTElementProcessor2 = xSLTElementDef.getProcessorForUnknown(string, string2);
        }
        if (xSLTElementProcessor2 == null) {
            this.error(String.valueOf(string3) + " is not allowed in this position in the stylesheet!", null);
        }
        return xSLTElementProcessor2;
    }

    public void setDocumentLocator(Locator locator) {
        this.m_stylesheetLocatorStack.push(locator);
    }

    public void startDocument() throws SAXException {
        ++this.m_stylesheetLevel;
    }

    public void endDocument() throws SAXException {
        if (this.getStylesheetRoot() != null) {
            if (this.m_stylesheetLevel == 0) {
                this.getStylesheetRoot().recompose();
            }
        } else {
            throw new SAXException("Did not find the stylesheet root!");
        }
        this.getStylesheet().resolvePrefixTables();
        XSLTElementProcessor xSLTElementProcessor = this.getCurrentProcessor();
        if (xSLTElementProcessor != null) {
            xSLTElementProcessor.startNonText(this);
        }
        --this.m_stylesheetLevel;
    }

    public void startPrefixMapping(String string, String string2) throws SAXException {
        this.m_nsSupport.declarePrefix(string, string2);
    }

    public void endPrefixMapping(String string) throws SAXException {
    }

    private void flushCharacters() throws SAXException {
        XSLTElementProcessor xSLTElementProcessor = this.getCurrentProcessor();
        if (xSLTElementProcessor != null) {
            xSLTElementProcessor.startNonText(this);
        }
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        ++this.m_elementID;
        this.checkForFragmentID(attributes);
        if (!this.m_shouldProcess) {
            return;
        }
        this.flushCharacters();
        XSLTElementProcessor xSLTElementProcessor = this.getProcessorFor(string, string2, string3);
        this.pushProcessor(xSLTElementProcessor);
        xSLTElementProcessor.startElement(this, string, string2, string3, attributes);
        this.m_nsSupport.pushContext();
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        --this.m_elementID;
        if (!this.m_shouldProcess) {
            return;
        }
        if (this.m_elementID + 1 == this.m_fragmentID) {
            this.m_shouldProcess = false;
        }
        this.flushCharacters();
        XSLTElementProcessor xSLTElementProcessor = this.getCurrentProcessor();
        xSLTElementProcessor.endElement(this, string, string2, string3);
        this.popProcessor();
        this.m_nsSupport.popContext();
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (!this.m_shouldProcess) {
            return;
        }
        XSLTElementProcessor xSLTElementProcessor = this.getCurrentProcessor();
        XSLTElementDef xSLTElementDef = xSLTElementProcessor.getElemDef();
        if (xSLTElementDef.getType() != 2) {
            xSLTElementProcessor = xSLTElementDef.getProcessorFor(null, "text()");
        }
        if (xSLTElementProcessor == null) {
            if (!XMLCharacterRecognizer.isWhiteSpace(cArray, n, n2)) {
                this.error("Non-whitespace text is not allowed in this position in the stylesheet!", null);
                return;
            }
        } else {
            xSLTElementProcessor.characters(this, cArray, n, n2);
        }
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        if (!this.m_shouldProcess) {
            return;
        }
        this.getCurrentProcessor().ignorableWhitespace(this, cArray, n, n2);
    }

    public void processingInstruction(String string, String string2) throws SAXException {
        if (!this.m_shouldProcess) {
            return;
        }
        this.flushCharacters();
        this.getCurrentProcessor().processingInstruction(this, string, string2);
    }

    public void skippedEntity(String string) throws SAXException {
        if (!this.m_shouldProcess) {
            return;
        }
        this.getCurrentProcessor().skippedEntity(this, string);
    }

    public void warn(int n, Object[] objectArray) throws SAXException {
        String string = XSLMessages.createWarning(n, objectArray);
        Locator locator = this.getLocator();
        ErrorHandler errorHandler = this.m_stylesheetProcessor.getErrorHandler();
        if (errorHandler != null) {
            errorHandler.warning(new ProcessorException(string, locator));
        }
    }

    private void assert(boolean bl, String string) {
        if (!bl) {
            throw new RuntimeException(string);
        }
    }

    protected void error(String string, Exception exception) throws SAXException {
        ProcessorException processorException;
        Locator locator = this.getLocator();
        ErrorHandler errorHandler = this.m_stylesheetProcessor.getErrorHandler();
        ProcessorException processorException2 = processorException = exception == null ? new ProcessorException(string, locator) : new ProcessorException(string, locator, exception);
        if (errorHandler != null) {
            errorHandler.fatalError(processorException);
            return;
        }
        throw processorException;
    }

    protected void error(int n, Object[] objectArray, Exception exception) throws SAXException {
        String string = XSLMessages.createMessage(n, objectArray);
        this.error(string, exception);
    }

    public void warning(SAXParseException sAXParseException) throws SAXException {
        System.out.println("WARNING: " + sAXParseException.getMessage());
        System.out.println(" ID: " + sAXParseException.getSystemId() + " Line #" + sAXParseException.getLineNumber() + " Column #" + sAXParseException.getColumnNumber());
    }

    public void error(SAXParseException sAXParseException) throws SAXException {
        System.out.println("RECOVERABLE ERROR: " + sAXParseException.getMessage());
        System.out.println(" ID: " + sAXParseException.getSystemId() + " Line #" + sAXParseException.getLineNumber() + " Column #" + sAXParseException.getColumnNumber());
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        throw sAXParseException;
    }

    private void checkForFragmentID(Attributes attributes) {
        if (!this.m_shouldProcess && attributes != null && this.m_fragmentIDString != null) {
            int n = attributes.getLength();
            int n2 = 0;
            while (n2 < n) {
                String string;
                String string2 = attributes.getType(n2);
                if (string2.equalsIgnoreCase("ID") && (string = attributes.getValue(n2)).equalsIgnoreCase(this.m_fragmentIDString)) {
                    this.m_shouldProcess = true;
                    this.m_fragmentID = this.m_elementID;
                }
                ++n2;
            }
        }
    }

    StylesheetProcessor getStylesheetProcessor() {
        return this.m_stylesheetProcessor;
    }

    int getStylesheetType() {
        return this.m_stylesheetType;
    }

    void setStylesheetType(int n) {
        this.m_stylesheetType = n;
    }

    Stylesheet getStylesheet() {
        return (Stylesheet)this.m_stylesheets.peek();
    }

    public StylesheetRoot getStylesheetRoot() {
        if (this.m_stylesheets.size() > 0) {
            return (StylesheetRoot)this.m_stylesheets.elementAt(0);
        }
        return null;
    }

    void pushStylesheet(Stylesheet stylesheet) {
        this.m_stylesheets.push(stylesheet);
    }

    Stylesheet popStylesheet() {
        this.m_stylesheetLocatorStack.pop();
        return (Stylesheet)this.m_stylesheets.pop();
    }

    XSLTElementProcessor getCurrentProcessor() {
        return (XSLTElementProcessor)this.m_processors.peek();
    }

    void pushProcessor(XSLTElementProcessor xSLTElementProcessor) {
        this.m_processors.push(xSLTElementProcessor);
    }

    XSLTElementProcessor popProcessor() {
        return (XSLTElementProcessor)this.m_processors.pop();
    }

    XSLTSchema getSchema() {
        return this.m_schema;
    }

    ElemTemplateElement getElemTemplateElement() {
        try {
            return (ElemTemplateElement)this.m_elems.peek();
        }
        catch (EmptyStackException emptyStackException) {
            return null;
        }
    }

    void pushElemTemplateElement(ElemTemplateElement elemTemplateElement) {
        this.m_elems.push(elemTemplateElement);
    }

    ElemTemplateElement popElemTemplateElement() {
        return (ElemTemplateElement)this.m_elems.pop();
    }

    XSLMessages getXSLMessages() {
        return m_XSLMessages;
    }

    void pushBaseIndentifier(String string) {
        if (string != null) {
            int n = string.indexOf(35);
            if (n > -1) {
                this.m_fragmentIDString = string.substring(n + 1);
                this.m_shouldProcess = false;
            } else {
                this.m_shouldProcess = true;
            }
        } else {
            this.m_shouldProcess = true;
        }
        this.m_baseIdentifiers.push(string);
    }

    String popBaseIndentifier() {
        return (String)this.m_baseIdentifiers.pop();
    }

    public Locator getLocator() {
        if (this.m_stylesheetLocatorStack.isEmpty()) {
            LocatorImpl locatorImpl = new LocatorImpl();
            locatorImpl.setSystemId(this.getStylesheetProcessor().getDOMsystemID());
            this.m_stylesheetLocatorStack.push(locatorImpl);
        }
        return (Locator)this.m_stylesheetLocatorStack.peek();
    }

    void pushImportURL(String string) {
        this.m_importStack.push(string);
    }

    boolean importStackContains(String string) {
        return this.stackContains(this.m_importStack, string);
    }

    String popImportURL() {
        return (String)this.m_importStack.pop();
    }

    NamespaceSupport getNamespaceSupport() {
        return this.m_nsSupport;
    }

    public void setOriginatingNode(Node node) {
        this.m_originatingNode = node;
    }

    public Node getOriginatingNode() {
        return this.m_originatingNode;
    }

    static {
        m_XSLMessages = new XSLMessages();
    }
}

