/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.processor;

import java.io.BufferedInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import org.apache.trax.Processor;
import org.apache.trax.ProcessorException;
import org.apache.trax.Templates;
import org.apache.trax.TemplatesBuilder;
import org.apache.xalan.processor.StopParseException;
import org.apache.xalan.processor.StylesheetHandler;
import org.apache.xalan.processor.StylesheetPIHandler;
import org.apache.xalan.utils.TreeWalker;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class StylesheetProcessor
extends Processor {
    public static String XSLT_PROPERTIES = "/org/apache/xalan/res/XSLTInfo.properties";
    private static boolean isInited;
    private String m_DOMsystemID = "";
    static /* synthetic */ Class class$java$lang$Process;

    public StylesheetProcessor() {
        StylesheetProcessor.loadPropertyFileToSystem(XSLT_PROPERTIES);
    }

    private static void loadPropertyFileToSystem(String string) {
        if (!isInited) {
            try {
                try {
                    Properties properties = new Properties();
                    InputStream inputStream = (class$java$lang$Process != null ? class$java$lang$Process : (class$java$lang$Process = StylesheetProcessor.class$("java.lang.Process"))).getResourceAsStream(string);
                    BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
                    properties.load(bufferedInputStream);
                    ((FilterInputStream)bufferedInputStream).close();
                    Properties properties2 = System.getProperties();
                    Enumeration<?> enumeration = properties.propertyNames();
                    while (enumeration.hasMoreElements()) {
                        String string2 = (String)enumeration.nextElement();
                        if (((Hashtable)properties2).containsKey(string2)) continue;
                        ((Hashtable)properties2).put(string2, properties.getProperty(string2));
                    }
                    System.setProperties(properties2);
                    isInited = true;
                    return;
                }
                catch (Exception exception) {
                    return;
                }
            }
            catch (SecurityException securityException) {
                return;
            }
        }
    }

    public Templates process(InputSource inputSource) throws ProcessorException, SAXException, IOException {
        TemplatesBuilder templatesBuilder = this.getTemplatesBuilder();
        templatesBuilder.setBaseID(inputSource.getSystemId());
        XMLReader xMLReader = this.getXMLReader();
        if (xMLReader == null) {
            xMLReader = XMLReaderFactory.createXMLReader();
        }
        try {
            xMLReader.setFeature("http://apache.org/xml/features/validation/dynamic", true);
        }
        catch (SAXException sAXException) {}
        xMLReader.setContentHandler(templatesBuilder);
        xMLReader.parse(inputSource);
        return templatesBuilder.getTemplates();
    }

    public Templates processFromNode(Node node) throws ProcessorException {
        try {
            TemplatesBuilder templatesBuilder = this.getTemplatesBuilder();
            TreeWalker treeWalker = new TreeWalker(templatesBuilder);
            treeWalker.traverse(node);
            return templatesBuilder.getTemplates();
        }
        catch (SAXException sAXException) {
            throw new ProcessorException("processFromNode failed", sAXException);
        }
    }

    String getDOMsystemID() {
        return this.m_DOMsystemID;
    }

    public Templates processFromNode(Node node, String string) throws ProcessorException {
        this.m_DOMsystemID = string;
        return this.processFromNode(node);
    }

    public Templates processMultiple(InputSource[] inputSourceArray) throws ProcessorException {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.println("<?xml version='1.0'?>");
        printWriter.println("<xsl:stylesheet xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\" version=\"1.0\">");
        int n = inputSourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            printWriter.print("<xsl:import href=\"");
            printWriter.print(inputSourceArray[n2].getSystemId());
            printWriter.println("\"/>");
            ++n2;
        }
        printWriter.println("</xsl:stylesheet>");
        printWriter.close();
        String string = stringWriter.toString();
        StringReader stringReader = new StringReader(string);
        try {
            return this.process(new InputSource(stringReader));
        }
        catch (ProcessorException processorException) {
            throw processorException;
        }
        catch (Exception exception) {
            throw new ProcessorException("processMultiple failed", exception);
        }
    }

    public InputSource[] getAssociatedStylesheets(InputSource inputSource, String string, String string2, String string3) throws ProcessorException {
        StylesheetPIHandler stylesheetPIHandler = new StylesheetPIHandler(inputSource, string, string2, string3);
        try {
            XMLReader xMLReader = this.getXMLReader();
            if (xMLReader == null) {
                xMLReader = XMLReaderFactory.createXMLReader();
            }
            xMLReader.setContentHandler(stylesheetPIHandler);
            xMLReader.parse(inputSource);
        }
        catch (StopParseException stopParseException) {
        }
        catch (SAXException sAXException) {
            throw new ProcessorException("getAssociatedStylesheets failed", sAXException);
        }
        catch (IOException iOException) {
            throw new ProcessorException("getAssociatedStylesheets failed", iOException);
        }
        return stylesheetPIHandler.getAssociatedStylesheets();
    }

    public TemplatesBuilder getTemplatesBuilder() throws ProcessorException {
        return new StylesheetHandler(this);
    }

    public boolean getFeature(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
        if ("http://xml.org/trax/features/sax/input".equals(string)) {
            return true;
        }
        if ("http://xml.org/trax/features/dom/input".equals(string)) {
            return true;
        }
        throw new SAXNotRecognizedException(string);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

