/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.res;

import java.text.MessageFormat;
import java.util.ListResourceBundle;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.xalan.res.XSLResourceBundle;

public class XSLMessages {
    private Locale fLocale = Locale.getDefault();
    private static XSLResourceBundle XSLTBundle = null;
    private static XSLResourceBundle XPATHBundle = null;
    private static final String XSLT_ERROR_RESOURCES = "org.apache.xalan.res.XSLTErrorResources";
    private static final String XPATH_ERROR_RESOURCES = "org.apache.xpath.res.XPATHErrorResources";
    private static String BAD_CODE = "BAD_CODE";
    private static String FORMAT_FAILED = "FORMAT_FAILED";

    public void setLocale(Locale locale) {
        this.fLocale = locale;
    }

    public Locale getLocale() {
        return this.fLocale;
    }

    public static final String createXPATHWarning(int n, Object[] objectArray) {
        XSLResourceBundle xSLResourceBundle;
        if (XPATHBundle == null) {
            XPATHBundle = (XSLResourceBundle)XSLMessages.loadResourceBundle(XPATH_ERROR_RESOURCES);
        }
        if ((xSLResourceBundle = XPATHBundle) != null) {
            String string = xSLResourceBundle.getWarningKey(n);
            return XSLMessages.createXPATHMsg(xSLResourceBundle, string, objectArray);
        }
        return "Could not load any resource bundles.";
    }

    public static final String createXPATHMessage(int n, Object[] objectArray) {
        XSLResourceBundle xSLResourceBundle;
        if (XPATHBundle == null) {
            XPATHBundle = (XSLResourceBundle)XSLMessages.loadResourceBundle(XPATH_ERROR_RESOURCES);
        }
        if ((xSLResourceBundle = XPATHBundle) != null) {
            String string = xSLResourceBundle.getMessageKey(n);
            return XSLMessages.createXPATHMsg(xSLResourceBundle, string, objectArray);
        }
        return "Could not load any resource bundles.";
    }

    public static final String createXPATHMsg(XSLResourceBundle xSLResourceBundle, String string, Object[] objectArray) {
        String string2 = null;
        boolean bl = false;
        String string3 = null;
        if (string != null) {
            string3 = xSLResourceBundle.getString(string);
        }
        if (string3 == null) {
            string3 = xSLResourceBundle.getString("BAD_CODE");
            bl = true;
        }
        if (objectArray != null) {
            try {
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    if (objectArray[n2] == null) {
                        objectArray[n2] = "";
                    }
                    ++n2;
                }
                string2 = MessageFormat.format(string3, objectArray);
            }
            catch (Exception exception) {
                string2 = xSLResourceBundle.getString("FORMAT_FAILED");
                string2 = String.valueOf(string2) + " " + string3;
            }
        } else {
            string2 = string3;
        }
        if (bl) {
            throw new RuntimeException(string2);
        }
        return string2;
    }

    public static final String createWarning(int n, Object[] objectArray) {
        XSLResourceBundle xSLResourceBundle;
        if (XSLTBundle == null) {
            XSLTBundle = (XSLResourceBundle)XSLMessages.loadResourceBundle(XSLT_ERROR_RESOURCES);
        }
        if ((xSLResourceBundle = XSLTBundle) != null) {
            String string = xSLResourceBundle.getWarningKey(n);
            return XSLMessages.createMsg(xSLResourceBundle, string, objectArray);
        }
        return "Could not load any resource bundles.";
    }

    public static final String createMessage(int n, Object[] objectArray) {
        XSLResourceBundle xSLResourceBundle;
        if (XSLTBundle == null) {
            XSLTBundle = (XSLResourceBundle)XSLMessages.loadResourceBundle(XSLT_ERROR_RESOURCES);
        }
        if ((xSLResourceBundle = XSLTBundle) != null) {
            String string = xSLResourceBundle.getMessageKey(n);
            return XSLMessages.createMsg(xSLResourceBundle, string, objectArray);
        }
        return "Could not load any resource bundles.";
    }

    public static final String createMsg(XSLResourceBundle xSLResourceBundle, String string, Object[] objectArray) {
        String string2 = null;
        boolean bl = false;
        String string3 = null;
        if (string != null) {
            string3 = xSLResourceBundle.getString(string);
        }
        if (string3 == null) {
            string3 = xSLResourceBundle.getString(BAD_CODE);
            bl = true;
        }
        if (objectArray != null) {
            try {
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    if (objectArray[n2] == null) {
                        objectArray[n2] = "";
                    }
                    ++n2;
                }
                string2 = MessageFormat.format(string3, objectArray);
            }
            catch (Exception exception) {
                string2 = xSLResourceBundle.getString(FORMAT_FAILED);
                string2 = String.valueOf(string2) + " " + string3;
            }
        } else {
            string2 = string3;
        }
        if (bl) {
            throw new RuntimeException(string2);
        }
        return string2;
    }

    public String createMessage(String string, int n, Object[] objectArray) throws Exception {
        boolean bl = false;
        String string2 = null;
        XSLResourceBundle xSLResourceBundle = null;
        xSLResourceBundle = (XSLResourceBundle)XSLMessages.loadResourceBundle(string);
        String string3 = xSLResourceBundle.getMessageKey(n);
        String string4 = null;
        if (string3 != null) {
            string4 = xSLResourceBundle.getString(string3);
        }
        if (string4 == null) {
            string4 = xSLResourceBundle.getString(BAD_CODE);
            bl = true;
        }
        if (objectArray != null) {
            try {
                int n2 = objectArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    if (objectArray[n3] == null) {
                        objectArray[n3] = "";
                    }
                    ++n3;
                }
                string2 = MessageFormat.format(string4, objectArray);
            }
            catch (Exception exception) {
                string2 = xSLResourceBundle.getString(FORMAT_FAILED);
                string2 = String.valueOf(string2) + " " + string4;
            }
        } else {
            string2 = string4;
        }
        if (bl) {
            throw new RuntimeException(string2);
        }
        return string2;
    }

    public static final ListResourceBundle loadResourceBundle(String string) throws MissingResourceException {
        Locale locale = Locale.getDefault();
        try {
            return (ListResourceBundle)ResourceBundle.getBundle(string, locale);
        }
        catch (MissingResourceException missingResourceException) {
            try {
                return (ListResourceBundle)ResourceBundle.getBundle(XSLT_ERROR_RESOURCES, new Locale("en", "US"));
            }
            catch (MissingResourceException missingResourceException2) {
                throw new MissingResourceException("Could not load any resource bundles." + string, string, "");
            }
        }
    }

    private static final String getResourceSuffix(Locale locale) {
        String string = "_" + locale.getLanguage();
        String string2 = locale.getCountry();
        if (string2.equals("TW")) {
            string = String.valueOf(string) + "_" + string2;
        }
        return string;
    }
}

