/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.stree;

import java.util.Hashtable;
import org.apache.xalan.stree.CDATASectionImpl;
import org.apache.xalan.stree.CommentImpl;
import org.apache.xalan.stree.DocumentFragmentImpl;
import org.apache.xalan.stree.DocumentTypeImpl;
import org.apache.xalan.stree.ElementImpl;
import org.apache.xalan.stree.ElementImplWithNS;
import org.apache.xalan.stree.IndexedElemImpl;
import org.apache.xalan.stree.IndexedElemWithNS;
import org.apache.xalan.stree.LevelIndexer;
import org.apache.xalan.stree.Parent;
import org.apache.xalan.stree.ProcessingInstructionImpl;
import org.apache.xalan.stree.SourceTreeHandler;
import org.apache.xalan.stree.TextImpl;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMException;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public class DocumentImpl
extends Parent {
    private SourceTreeHandler m_sourceTreeHandler;
    private boolean indexedLookup = false;
    private LevelIndexer m_bUpIndexer;
    DocumentTypeImpl m_docType;
    private int m_docOrderCount = 1;
    private boolean m_useMultiThreading = false;
    ElementImpl m_docElement;
    Hashtable m_idAttributes = new Hashtable();

    DocumentImpl() {
        super(null);
        this.setDoc(this);
        this.m_bUpIndexer = new LevelIndexer();
    }

    DocumentImpl(SourceTreeHandler sourceTreeHandler) {
        super(null);
        this.setDoc(this);
        this.m_bUpIndexer = new LevelIndexer();
        this.m_sourceTreeHandler = sourceTreeHandler;
    }

    DocumentImpl(DocumentType documentType) {
        super(null);
        this.setDoc(this);
        if (documentType != null) {
            this.m_docType = (DocumentTypeImpl)documentType;
        }
        this.m_bUpIndexer = new LevelIndexer();
    }

    SourceTreeHandler getSourceTreeHandler() {
        return this.m_sourceTreeHandler;
    }

    void setSourceTreeHandler(SourceTreeHandler sourceTreeHandler) {
        this.m_sourceTreeHandler = sourceTreeHandler;
    }

    public LevelIndexer getLevelIndexer() {
        return this.m_bUpIndexer;
    }

    protected void incrementDocOrderCount() {
        ++this.m_docOrderCount;
    }

    protected int getDocOrderCount() {
        return this.m_docOrderCount;
    }

    public DocumentType getDoctype() {
        return this.m_docType;
    }

    public void setUseMultiThreading(boolean bl) {
        this.m_useMultiThreading = bl;
    }

    public boolean getUseMultiThreading() {
        return this.m_useMultiThreading;
    }

    public Element getDocumentElement() {
        return this.m_docElement;
    }

    public Hashtable getIDAttributes() {
        return this.m_idAttributes;
    }

    public void setIDAttribute(String string, String string2, String string3, Element element) {
        this.m_idAttributes.put(string3, element);
    }

    public Node appendChild(Node node) throws DOMException {
        short s = node.getNodeType();
        if (s == 1) {
            if (this.m_docElement != null) {
                throw new DOMException(3, "DOM006 Hierarchy request error");
            }
            this.m_docElement = (ElementImpl)node;
        } else if (s == 10) {
            this.m_docType = (DocumentTypeImpl)node;
        }
        return super.appendChild(node);
    }

    public short getNodeType() {
        return 9;
    }

    public String getNodeName() {
        return "#document";
    }

    public String getLocalName() {
        return "#document";
    }

    public Element createElement(String string) throws DOMException {
        if (this.indexedLookup) {
            return new IndexedElemImpl(this, string);
        }
        return new ElementImpl(this, string);
    }

    public DocumentFragment createDocumentFragment() {
        return new DocumentFragmentImpl();
    }

    public Text createTextNode(String string) {
        return new TextImpl(this, string);
    }

    public Comment createComment(String string) {
        return new CommentImpl(this, string);
    }

    public CDATASection createCDATASection(String string) throws DOMException {
        return new CDATASectionImpl(this, string);
    }

    public ProcessingInstruction createProcessingInstruction(String string, String string2) throws DOMException {
        return new ProcessingInstructionImpl(this, string, string2);
    }

    public Node importNode(Node node, boolean bl) throws DOMException {
        return super.importNode(node, bl);
    }

    public Element createElementNS(String string, String string2) throws DOMException {
        if (this.indexedLookup) {
            return new IndexedElemWithNS(this, string, string2);
        }
        return new ElementImplWithNS(this, string, string2);
    }

    public Attr createAttributeNS(String string, String string2) throws DOMException {
        return super.createAttributeNS(string, string2);
    }

    public Element getElementById(String string) {
        Element element = (Element)this.m_idAttributes.get(string);
        if (element == null && !this.isComplete()) {
            Object object;
            Object object2 = object = this.getSynchObject();
            synchronized (object2) {
                try {
                    while (!this.isComplete()) {
                        object.wait();
                        this.throwIfParseError();
                        element = (Element)this.m_idAttributes.get(string);
                        if (element == null) continue;
                        Element element2 = element;
                        Object var6_6 = null;
                        return element2;
                    }
                }
                catch (InterruptedException interruptedException) {
                    this.throwIfParseError();
                }
            }
            element = (Element)this.m_idAttributes.get(string);
        }
        return element;
    }
}

