/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.stree;

import java.util.Stack;
import org.apache.xalan.stree.DocumentImpl;
import org.apache.xalan.stree.IndexedDocImpl;
import org.apache.xalan.stree.Parent;
import org.apache.xalan.stree.StreeDOMBuilder;
import org.apache.xalan.stree.StreeDOMHelper;
import org.apache.xalan.transformer.TransformerImpl;
import org.apache.xalan.utils.DOMBuilder;
import org.apache.xalan.utils.XMLCharacterRecognizer;
import org.apache.xpath.XPathContext;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

public class SourceTreeHandler
implements ContentHandler,
LexicalHandler {
    private TransformerImpl m_transformer;
    private DOMBuilder m_sourceTreeHandler;
    private Document m_root;
    InputSource m_inputSource;
    private boolean m_useMultiThreading = false;
    private boolean indexedLookup = false;
    private int m_eventsCount;
    private int m_maxEventsToNotify = 10;
    private boolean m_isCData = false;
    private static Boolean S_TRUE = new Boolean(true);
    private static Boolean S_FALSE = new Boolean(false);
    private Stack m_shouldStripWhitespace = new Stack();

    public SourceTreeHandler(TransformerImpl transformerImpl) {
        this.m_transformer = transformerImpl;
        XPathContext xPathContext = transformerImpl.getXPathContext();
        xPathContext.setDOMHelper(new StreeDOMHelper());
        this.m_root = this.indexedLookup ? new IndexedDocImpl() : new DocumentImpl(this);
        String string = transformerImpl.getBaseURLOfSource();
        if (this.m_inputSource == null) {
            this.m_inputSource = new InputSource(string);
        }
        transformerImpl.getXPathContext().getSourceTreeManager().putDocumentInCache(this.m_root, this.m_inputSource);
    }

    public SourceTreeHandler() {
    }

    public TransformerImpl getTransformer() {
        return this.m_transformer;
    }

    Object getSynchObject() {
        if (this.m_transformer != null) {
            return this.m_transformer;
        }
        return this;
    }

    public Node getRoot() {
        return this.m_root;
    }

    public void setRoot(Document document) {
        this.m_root = document;
    }

    public void setInputSource(InputSource inputSource) {
        this.m_inputSource = inputSource;
    }

    public InputSource getInputSource() {
        return this.m_inputSource;
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void setUseMultiThreading(boolean bl) {
        this.m_useMultiThreading = bl;
    }

    public boolean getUseMultiThreading() {
        return this.m_useMultiThreading;
    }

    private void notifyWaiters() {
        if (this.m_useMultiThreading && this.m_eventsCount >= this.m_maxEventsToNotify) {
            Object object;
            Object object2 = object = this.getSynchObject();
            synchronized (object2) {
                object.notifyAll();
            }
            this.m_eventsCount = 0;
            return;
        }
        ++this.m_eventsCount;
    }

    public void startDocument() throws SAXException {
        Object object = this.getSynchObject();
        synchronized (object) {
            if (this.m_root == null) {
                this.m_root = this.indexedLookup ? new IndexedDocImpl() : new DocumentImpl(this);
                if (this.m_transformer != null) {
                    String string = this.m_transformer.getBaseURLOfSource();
                    if (this.m_inputSource == null) {
                        this.m_inputSource = new InputSource(string);
                    }
                    this.m_transformer.getXPathContext().getSourceTreeManager().putDocumentInCache(this.m_root, this.m_inputSource);
                }
            }
            ((DocumentImpl)this.m_root).setSourceTreeHandler(this);
            ((DocumentImpl)this.m_root).setUid(1);
            ((DocumentImpl)this.m_root).setLevel(new Integer(1).shortValue());
            ((DocumentImpl)this.m_root).setUseMultiThreading(this.getUseMultiThreading());
            this.m_sourceTreeHandler = new StreeDOMBuilder(this.m_root);
            this.pushShouldStripWhitespace(false);
            this.m_sourceTreeHandler.startDocument();
        }
        if (this.m_useMultiThreading && this.m_transformer != null && this.m_transformer.isParserEventsOnMain()) {
            this.m_transformer.setSourceTreeDocForThread(this.m_root);
            object = new Thread(this.m_transformer);
            this.m_transformer.setTransformThread((Thread)object);
            ((Thread)object).start();
        }
        this.notifyWaiters();
    }

    public void endDocument() throws SAXException {
        Object object;
        Object object2 = object = this.getSynchObject();
        synchronized (object2) {
            ((Parent)this.m_root).setComplete(true);
            this.m_sourceTreeHandler.endDocument();
            this.popShouldStripWhitespace();
            if (!this.m_useMultiThreading && this.m_transformer != null) {
                this.m_transformer.transformNode(this.m_root);
            }
        }
        this.m_eventsCount = this.m_maxEventsToNotify;
        this.notifyWaiters();
        if (this.m_useMultiThreading && this.m_transformer != null && (object2 = this.m_transformer.getTransformThread()) != null) {
            try {
                ((Thread)object2).join();
                this.m_transformer.setTransformThread(null);
                return;
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        Object object = this.getSynchObject();
        synchronized (object) {
            this.pushShouldStripWhitespace(this.getShouldStripWhitespace());
            this.m_sourceTreeHandler.startElement(string, string2, string3, attributes);
        }
        this.notifyWaiters();
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        Object object = this.getSynchObject();
        synchronized (object) {
            ((Parent)this.m_sourceTreeHandler.getCurrentNode()).setComplete(true);
            this.m_sourceTreeHandler.endElement(string, string2, string3);
            this.popShouldStripWhitespace();
        }
        this.notifyWaiters();
    }

    public void startCDATA() throws SAXException {
        this.m_isCData = true;
    }

    public void endCDATA() throws SAXException {
        this.m_isCData = false;
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        Object object = this.getSynchObject();
        synchronized (object) {
            if (XMLCharacterRecognizer.isWhiteSpace(cArray, n, n2) && this.getShouldStripWhitespace()) {
                Object var5_5 = null;
                return;
            }
            if (this.m_isCData) {
                this.m_sourceTreeHandler.cdata(cArray, n, n2);
            } else {
                this.m_sourceTreeHandler.characters(cArray, n, n2);
            }
        }
        this.notifyWaiters();
    }

    public void charactersRaw(char[] cArray, int n, int n2) throws SAXException {
        Object object = this.getSynchObject();
        synchronized (object) {
            this.m_sourceTreeHandler.charactersRaw(cArray, n, n2);
        }
        this.notifyWaiters();
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        Object object = this.getSynchObject();
        synchronized (object) {
            this.m_sourceTreeHandler.charactersRaw(cArray, n, n2);
        }
        this.notifyWaiters();
    }

    public void processingInstruction(String string, String string2) throws SAXException {
        Object object = this.getSynchObject();
        synchronized (object) {
            this.m_sourceTreeHandler.processingInstruction(string, string2);
        }
        this.notifyWaiters();
    }

    public void comment(char[] cArray, int n, int n2) throws SAXException {
        Object object = this.getSynchObject();
        synchronized (object) {
            this.m_sourceTreeHandler.comment(cArray, n, n2);
        }
        this.notifyWaiters();
    }

    public void startEntity(String string) throws SAXException {
        Object object = this.getSynchObject();
        synchronized (object) {
            this.m_sourceTreeHandler.startEntity(string);
        }
        this.notifyWaiters();
    }

    public void endEntity(String string) throws SAXException {
        Object object = this.getSynchObject();
        synchronized (object) {
            this.m_sourceTreeHandler.endEntity(string);
        }
        this.notifyWaiters();
    }

    public void startDTD(String string, String string2, String string3) throws SAXException {
    }

    public void endDTD() throws SAXException {
    }

    public void startPrefixMapping(String string, String string2) throws SAXException {
        Object object = this.getSynchObject();
        synchronized (object) {
            this.m_sourceTreeHandler.startPrefixMapping(string, string2);
            return;
        }
    }

    public void endPrefixMapping(String string) throws SAXException {
        this.m_sourceTreeHandler.endPrefixMapping(string);
    }

    public void skippedEntity(String string) throws SAXException {
    }

    boolean getShouldStripWhitespace() {
        if (this.m_shouldStripWhitespace.empty()) {
            return false;
        }
        return this.m_shouldStripWhitespace.peek() == S_TRUE;
    }

    void pushShouldStripWhitespace(boolean bl) {
        this.m_shouldStripWhitespace.push(bl ? S_TRUE : S_FALSE);
    }

    void popShouldStripWhitespace() {
        this.m_shouldStripWhitespace.pop();
    }

    void setShouldStripWhitespace(boolean bl) {
        this.popShouldStripWhitespace();
        this.pushShouldStripWhitespace(bl);
    }
}

