/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.templates;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.xalan.res.XSLMessages;
import org.apache.xalan.templates.Stylesheet;
import org.apache.xalan.templates.StylesheetComposed;
import org.apache.xalan.templates.StylesheetRoot;
import org.apache.xalan.templates.XMLNSDecl;
import org.apache.xalan.transformer.ResultTreeHandler;
import org.apache.xalan.transformer.TransformerImpl;
import org.apache.xalan.utils.PrefixResolver;
import org.apache.xalan.utils.QName;
import org.apache.xalan.utils.UnImplNode;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.NamespaceSupport;

public class ElemTemplateElement
extends UnImplNode
implements PrefixResolver,
Serializable,
Locator {
    private int m_lineNumber;
    private int m_columnNumber;
    private boolean m_defaultSpace = true;
    private Vector m_declaredPrefixes;
    Vector m_prefixTable;
    protected ElemTemplateElement m_parentNode;
    protected ElemTemplateElement m_nextSibling;
    protected ElemTemplateElement m_firstChild;
    private Node m_DOMBackPointer;

    public boolean isCompiledTemplate() {
        return false;
    }

    public int getXSLToken() {
        return -1;
    }

    public String getNodeName() {
        return "Unknown XSLT Element";
    }

    public void runtimeInit(TransformerImpl transformerImpl) throws SAXException {
    }

    public void execute(TransformerImpl transformerImpl, Node node, QName qName) throws SAXException {
    }

    public StylesheetComposed getStylesheetComposed() {
        return this.m_parentNode.getStylesheetComposed();
    }

    public Stylesheet getStylesheet() {
        return this.m_parentNode.getStylesheet();
    }

    public StylesheetRoot getStylesheetRoot() {
        return this.m_parentNode.getStylesheetRoot();
    }

    public void compose() {
    }

    protected boolean isValidNCName(String string) {
        int n = string.length();
        char c = string.charAt(0);
        if (!Character.isLetter(c) && c != '_') {
            return false;
        }
        if (n > 0) {
            int n2 = 1;
            while (n2 < n) {
                c = string.charAt(n2);
                if (!Character.isLetterOrDigit(c) && c != '_' && c != '-' && c != '.') {
                    return false;
                }
                ++n2;
            }
        }
        return true;
    }

    public void error(int n, Object[] objectArray) {
        String string = XSLMessages.createMessage(n, objectArray);
        throw new RuntimeException(XSLMessages.createMessage(19, new Object[]{string}));
    }

    public Node appendChild(Node node) throws DOMException {
        if (node == null) {
            this.error(20, null);
        }
        ElemTemplateElement elemTemplateElement = (ElemTemplateElement)node;
        if (this.m_firstChild == null) {
            this.m_firstChild = elemTemplateElement;
        } else {
            ElemTemplateElement elemTemplateElement2 = (ElemTemplateElement)this.getLastChild();
            elemTemplateElement2.m_nextSibling = elemTemplateElement;
        }
        elemTemplateElement.m_parentNode = this;
        return node;
    }

    public boolean hasChildNodes() {
        return this.m_firstChild != null;
    }

    public short getNodeType() {
        return 1;
    }

    public NodeList getChildNodes() {
        return this;
    }

    public Node removeChild(ElemTemplateElement elemTemplateElement) throws DOMException {
        if (elemTemplateElement == null || elemTemplateElement.m_parentNode != this) {
            return null;
        }
        if (elemTemplateElement == this.m_firstChild) {
            this.m_firstChild = elemTemplateElement.m_nextSibling;
        } else {
            ElemTemplateElement elemTemplateElement2 = (ElemTemplateElement)elemTemplateElement.getPreviousSibling();
            elemTemplateElement2.m_nextSibling = elemTemplateElement.m_nextSibling;
        }
        elemTemplateElement.m_parentNode = null;
        elemTemplateElement.m_nextSibling = null;
        return elemTemplateElement;
    }

    public Node replaceChild(Node node, Node node2) throws DOMException {
        if (node2 == null || node2.getParentNode() != this) {
            return null;
        }
        ElemTemplateElement elemTemplateElement = (ElemTemplateElement)node;
        ElemTemplateElement elemTemplateElement2 = (ElemTemplateElement)node2;
        ElemTemplateElement elemTemplateElement3 = (ElemTemplateElement)elemTemplateElement2.getPreviousSibling();
        if (elemTemplateElement3 != null) {
            elemTemplateElement3.m_nextSibling = elemTemplateElement;
        }
        if (this.m_firstChild == elemTemplateElement2) {
            this.m_firstChild = elemTemplateElement;
        }
        elemTemplateElement.m_parentNode = this;
        elemTemplateElement2.m_parentNode = null;
        elemTemplateElement.m_nextSibling = elemTemplateElement2.m_nextSibling;
        elemTemplateElement2.m_nextSibling = null;
        return elemTemplateElement;
    }

    public int getLength() {
        int n = 0;
        ElemTemplateElement elemTemplateElement = this.m_firstChild;
        while (elemTemplateElement != null) {
            ++n;
            elemTemplateElement = elemTemplateElement.m_nextSibling;
        }
        return n;
    }

    public Node item(int n) {
        ElemTemplateElement elemTemplateElement = this.m_firstChild;
        int n2 = 0;
        while (n2 < n && elemTemplateElement != null) {
            elemTemplateElement = elemTemplateElement.m_nextSibling;
            ++n2;
        }
        return elemTemplateElement;
    }

    public Document getOwnerDocument() {
        return this.getStylesheet();
    }

    public String getTagName() {
        return this.getNodeName();
    }

    public String getBaseIdentifier() {
        return this.getSystemId();
    }

    public int getLineNumber() {
        return this.m_lineNumber;
    }

    public int getColumnNumber() {
        return this.m_columnNumber;
    }

    public String getPublicId() {
        if (this.m_parentNode != null) {
            return this.m_parentNode.getPublicId();
        }
        return null;
    }

    public String getSystemId() {
        return this.getStylesheet().getHref();
    }

    public void setLocaterInfo(Locator locator) {
        this.m_lineNumber = locator.getLineNumber();
        this.m_columnNumber = locator.getColumnNumber();
    }

    public void setXmlSpace(boolean bl) {
        this.m_defaultSpace = bl;
    }

    public boolean getXmlSpace() {
        return this.m_defaultSpace;
    }

    public Vector getDeclaredPrefixes() {
        return this.m_declaredPrefixes;
    }

    public void setPrefixes(NamespaceSupport namespaceSupport) throws SAXException {
        this.setPrefixes(namespaceSupport, false);
    }

    public void setPrefixes(NamespaceSupport namespaceSupport, boolean bl) throws SAXException {
        Enumeration enumeration = namespaceSupport.getDeclaredPrefixes();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (this.m_declaredPrefixes == null) {
                this.m_declaredPrefixes = new Vector();
            }
            String string2 = namespaceSupport.getURI(string);
            if (bl && string2.equals("http://www.w3.org/1999/XSL/Transform")) continue;
            XMLNSDecl xMLNSDecl = new XMLNSDecl(string, string2, false);
            this.m_declaredPrefixes.addElement(xMLNSDecl);
        }
    }

    public String getNamespaceForPrefix(String string, Node node) {
        this.error(16, null);
        return null;
    }

    public String getNamespaceForPrefix(String string) {
        Vector vector = this.m_declaredPrefixes;
        if (vector != null) {
            int n = vector.size();
            int n2 = 0;
            while (n2 < n) {
                XMLNSDecl xMLNSDecl = (XMLNSDecl)vector.elementAt(n2);
                if (string.equals(xMLNSDecl.getPrefix())) {
                    return xMLNSDecl.getURI();
                }
                ++n2;
            }
        }
        if (this.m_parentNode != null) {
            return this.m_parentNode.getNamespaceForPrefix(string);
        }
        return null;
    }

    public Vector getPrefixes() {
        return this.m_prefixTable;
    }

    private boolean excludeResultNSDecl(String string, String string2) throws SAXException {
        if (string2 != null) {
            if (string2.equals("http://www.w3.org/1999/XSL/Transform") || this.getStylesheet().containsExtensionElementURI(string2) || string2.equals("http://xml.apache.org/xslt") || string2.equals("http://xsl.lotus.com/") || string2.equals("http://xsl.lotus.com")) {
                return true;
            }
            if (this.getStylesheet().containsExcludeResultPrefix(string)) {
                return true;
            }
        }
        return false;
    }

    public void resolvePrefixTables() throws SAXException {
        ElemTemplateElement elemTemplateElement;
        boolean bl;
        Object object;
        this.m_prefixTable = null;
        if (this.m_declaredPrefixes != null) {
            int n = this.m_declaredPrefixes.size();
            int n2 = 0;
            while (n2 < n) {
                XMLNSDecl xMLNSDecl = (XMLNSDecl)this.m_declaredPrefixes.elementAt(n2);
                String string = xMLNSDecl.getPrefix();
                object = xMLNSDecl.getURI();
                bl = this.excludeResultNSDecl(string, (String)object);
                if (this.m_prefixTable == null) {
                    this.m_prefixTable = new Vector();
                }
                this.m_prefixTable.addElement(new XMLNSDecl(string, (String)object, bl));
                ++n2;
            }
        }
        if ((elemTemplateElement = (ElemTemplateElement)this.getParentNode()) != null) {
            Vector vector = elemTemplateElement.m_prefixTable;
            if (this.m_prefixTable == null) {
                this.m_prefixTable = elemTemplateElement.m_prefixTable;
            } else {
                int n = vector.size();
                int n3 = 0;
                while (n3 < n) {
                    object = (XMLNSDecl)vector.elementAt(n3);
                    bl = this.excludeResultNSDecl(((XMLNSDecl)object).getPrefix(), ((XMLNSDecl)object).getURI());
                    if (bl != ((XMLNSDecl)object).getIsExcluded()) {
                        object = new XMLNSDecl(((XMLNSDecl)object).getPrefix(), ((XMLNSDecl)object).getURI(), bl);
                    }
                    this.m_prefixTable.addElement(object);
                    ++n3;
                }
            }
        } else if (this.m_prefixTable == null) {
            this.m_prefixTable = new Vector();
        }
        ElemTemplateElement elemTemplateElement2 = this.m_firstChild;
        while (elemTemplateElement2 != null) {
            elemTemplateElement2.resolvePrefixTables();
            elemTemplateElement2 = elemTemplateElement2.m_nextSibling;
        }
    }

    void executeNSDecls(TransformerImpl transformerImpl) throws SAXException {
        ResultTreeHandler resultTreeHandler = transformerImpl.getResultTreeHandler();
        int n = this.m_prefixTable.size();
        int n2 = n - 1;
        while (n2 >= 0) {
            XMLNSDecl xMLNSDecl = (XMLNSDecl)this.m_prefixTable.elementAt(n2);
            if (!xMLNSDecl.getIsExcluded()) {
                resultTreeHandler.startPrefixMapping(xMLNSDecl.getPrefix(), xMLNSDecl.getURI(), true);
            }
            --n2;
        }
    }

    void unexecuteNSDecls(TransformerImpl transformerImpl) throws SAXException {
        ResultTreeHandler resultTreeHandler = transformerImpl.getResultTreeHandler();
        int n = this.m_prefixTable.size();
        int n2 = 0;
        while (n2 < n) {
            XMLNSDecl xMLNSDecl = (XMLNSDecl)this.m_prefixTable.elementAt(n2);
            if (!xMLNSDecl.getIsExcluded()) {
                resultTreeHandler.endPrefixMapping(xMLNSDecl.getPrefix());
            }
            ++n2;
        }
    }

    public Node getParentNode() {
        return this.m_parentNode;
    }

    public ElemTemplateElement getParentElem() {
        return this.m_parentNode;
    }

    public Node getNextSibling() {
        return this.m_nextSibling;
    }

    public Node getPreviousSibling() {
        Node node = this.getParentNode();
        Node node2 = null;
        if (node != null) {
            node = node.getFirstChild();
            while (node != null) {
                if (node == this) {
                    return node2;
                }
                node2 = node;
                node = node.getNextSibling();
            }
        }
        return null;
    }

    public ElemTemplateElement getNextSiblingElem() {
        return this.m_nextSibling;
    }

    public Node getFirstChild() {
        return this.m_firstChild;
    }

    public ElemTemplateElement getFirstChildElem() {
        return this.m_firstChild;
    }

    public Node getLastChild() {
        ElemTemplateElement elemTemplateElement = null;
        ElemTemplateElement elemTemplateElement2 = this.m_firstChild;
        while (elemTemplateElement2 != null) {
            elemTemplateElement = elemTemplateElement2;
            elemTemplateElement2 = elemTemplateElement2.m_nextSibling;
        }
        return elemTemplateElement;
    }

    public Node getDOMBackPointer() {
        return this.m_DOMBackPointer;
    }

    public void setDOMBackPointer(Node node) {
        this.m_DOMBackPointer = node;
    }
}

