/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.templates;

import java.text.DecimalFormatSymbols;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.xalan.templates.DecimalFormatProperties;
import org.apache.xalan.templates.ElemAttributeSet;
import org.apache.xalan.templates.ElemParam;
import org.apache.xalan.templates.ElemTemplate;
import org.apache.xalan.templates.ElemVariable;
import org.apache.xalan.templates.KeyDeclaration;
import org.apache.xalan.templates.NamespaceAlias;
import org.apache.xalan.templates.Stylesheet;
import org.apache.xalan.templates.StylesheetRoot;
import org.apache.xalan.templates.TemplateList;
import org.apache.xalan.templates.WhiteSpaceInfo;
import org.apache.xalan.templates.WhitespaceList;
import org.apache.xalan.utils.QName;
import org.apache.xpath.XPath;
import org.apache.xpath.XPathContext;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class StylesheetComposed
extends Stylesheet {
    private int m_importNumber = -1;
    private transient Vector m_includesComposed;
    private transient Hashtable m_decimalFormatSymbols;
    private transient WhitespaceList m_whiteSpaceInfoList;
    private transient Vector m_keyDecls;
    private transient Hashtable m_attrSets;
    private transient Hashtable m_variables;
    private transient Hashtable m_params;
    private transient TemplateList m_templateList = new TemplateList(this);
    private transient Hashtable m_namespaceAliasComposed;

    public StylesheetComposed(Stylesheet stylesheet) {
        super(stylesheet);
    }

    public boolean isAggregatedType() {
        return true;
    }

    void recomposeImports() {
        this.m_importNumber = this.getStylesheetRoot().getImportNumber(this);
    }

    public StylesheetComposed getImportComposed(int n) throws ArrayIndexOutOfBoundsException {
        StylesheetRoot stylesheetRoot = this.getStylesheetRoot();
        return stylesheetRoot.getGlobalImport(1 + this.m_importNumber + n);
    }

    public int getImportCountComposed() {
        StylesheetRoot stylesheetRoot = this.getStylesheetRoot();
        int n = stylesheetRoot.getGlobalImportCount();
        return n - this.m_importNumber - 1;
    }

    void recomposeIncludes(Stylesheet stylesheet) {
        int n = stylesheet.getIncludeCount();
        if (n > 0) {
            if (this.m_includesComposed == null) {
                this.m_includesComposed = new Vector();
            }
            int n2 = 0;
            while (n2 < n) {
                Stylesheet stylesheet2 = stylesheet.getInclude(n2);
                this.m_includesComposed.addElement(stylesheet2);
                this.recomposeIncludes(stylesheet2);
                ++n2;
            }
        }
    }

    public Stylesheet getIncludeComposed(int n) throws ArrayIndexOutOfBoundsException {
        if (this.m_includesComposed == null) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return (Stylesheet)this.m_includesComposed.elementAt(n);
    }

    public int getIncludeCountComposed() {
        if (this.m_includesComposed != null) {
            return this.m_includesComposed.size();
        }
        return 0;
    }

    void recomposeDecimalFormats() {
        this.m_decimalFormatSymbols = new Hashtable();
        int n = this.getImportCountComposed();
        int n2 = -1;
        while (n2 < n) {
            StylesheetComposed stylesheetComposed = n2 < 0 ? this : this.getImportComposed(n2);
            int n3 = stylesheetComposed.getDecimalFormatCount();
            int n4 = 0;
            while (n4 < n3) {
                DecimalFormatProperties decimalFormatProperties = stylesheetComposed.getDecimalFormat(n4);
                this.m_decimalFormatSymbols.put(decimalFormatProperties.getName(), decimalFormatProperties.getDecimalFormatSymbols());
                ++n4;
            }
            int n5 = stylesheetComposed.getIncludeCountComposed();
            int n6 = 0;
            while (n6 < n5) {
                Stylesheet stylesheet = stylesheetComposed.getIncludeComposed(n6);
                n3 = stylesheet.getDecimalFormatCount();
                int n7 = 0;
                while (n7 < n3) {
                    DecimalFormatProperties decimalFormatProperties = stylesheet.getDecimalFormat(n7);
                    this.m_decimalFormatSymbols.put(decimalFormatProperties.getName(), decimalFormatProperties.getDecimalFormatSymbols());
                    ++n7;
                }
                ++n6;
            }
            ++n2;
        }
    }

    public DecimalFormatSymbols getDecimalFormatComposed(QName qName) {
        return (DecimalFormatSymbols)this.m_decimalFormatSymbols.get(qName);
    }

    void recomposeWhiteSpaceInfo() throws SAXException {
        this.m_whiteSpaceInfoList = new WhitespaceList(this);
        int n = this.getIncludeCountComposed();
        int n2 = -1;
        while (n2 < n) {
            StylesheetComposed stylesheetComposed = n2 == -1 ? this : this.getIncludeComposed(n2);
            int n3 = stylesheetComposed.getStripSpaceCount();
            int n4 = 0;
            while (n4 < n3) {
                XPath xPath = stylesheetComposed.getStripSpace(n4);
                this.m_whiteSpaceInfoList.setTemplate(new WhiteSpaceInfo(xPath, true));
                ++n4;
            }
            n3 = stylesheetComposed.getPreserveSpaceCount();
            int n5 = 0;
            while (n5 < n3) {
                XPath xPath = stylesheetComposed.getPreserveSpace(n5);
                this.m_whiteSpaceInfoList.setTemplate(new WhiteSpaceInfo(xPath, false));
                ++n5;
            }
            ++n2;
        }
    }

    public WhiteSpaceInfo getWhiteSpaceInfo(XPathContext xPathContext, Element element) throws SAXException {
        return (WhiteSpaceInfo)this.m_whiteSpaceInfoList.getTemplate(xPathContext, element, null, false);
    }

    void recomposeKeys() {
        this.m_keyDecls = new Vector();
        int n = this.getImportCountComposed();
        int n2 = -1;
        while (n2 < n) {
            StylesheetComposed stylesheetComposed = n2 < 0 ? this : this.getImportComposed(n2);
            int n3 = stylesheetComposed.getKeyCount();
            int n4 = 0;
            while (n4 < n3) {
                KeyDeclaration keyDeclaration = stylesheetComposed.getKey(n4);
                this.m_keyDecls.addElement(keyDeclaration);
                ++n4;
            }
            int n5 = stylesheetComposed.getIncludeCountComposed();
            int n6 = 0;
            while (n6 < n5) {
                Stylesheet stylesheet = stylesheetComposed.getIncludeComposed(n6);
                n3 = stylesheet.getKeyCount();
                int n7 = 0;
                while (n7 < n3) {
                    KeyDeclaration keyDeclaration = stylesheet.getKey(n7);
                    this.m_keyDecls.addElement(keyDeclaration);
                    ++n7;
                }
                ++n6;
            }
            ++n2;
        }
    }

    public Vector getKeysComposed() {
        return this.m_keyDecls;
    }

    void recomposeAttributeSets() {
        this.m_attrSets = new Hashtable();
        int n = this.getImportCountComposed();
        int n2 = -1;
        while (n2 < n) {
            StylesheetComposed stylesheetComposed = n2 < 0 ? this : this.getImportComposed(n2);
            int n3 = stylesheetComposed.getAttributeSetCount();
            int n4 = 0;
            while (n4 < n3) {
                ElemAttributeSet elemAttributeSet = stylesheetComposed.getAttributeSet(n4);
                Vector<ElemAttributeSet> vector = (Vector<ElemAttributeSet>)this.m_attrSets.get(elemAttributeSet.getName());
                if (vector == null) {
                    vector = new Vector<ElemAttributeSet>();
                    this.m_attrSets.put(elemAttributeSet.getName(), vector);
                }
                vector.addElement(elemAttributeSet);
                ++n4;
            }
            int n5 = stylesheetComposed.getIncludeCountComposed();
            int n6 = 0;
            while (n6 < n5) {
                Stylesheet stylesheet = stylesheetComposed.getIncludeComposed(n6);
                n3 = stylesheet.getAttributeSetCount();
                int n7 = 0;
                while (n7 < n3) {
                    ElemAttributeSet elemAttributeSet = stylesheet.getAttributeSet(n7);
                    Vector<ElemAttributeSet> vector = (Vector<ElemAttributeSet>)this.m_attrSets.get(elemAttributeSet.getName());
                    if (vector == null) {
                        vector = new Vector<ElemAttributeSet>();
                        this.m_attrSets.put(elemAttributeSet.getName(), vector);
                    }
                    vector.addElement(elemAttributeSet);
                    ++n7;
                }
                ++n6;
            }
            ++n2;
        }
    }

    public Vector getAttributeSetComposed(QName qName) throws ArrayIndexOutOfBoundsException {
        return (Vector)this.m_attrSets.get(qName);
    }

    void recomposeVariables() {
        this.m_variables = new Hashtable();
        int n = this.getImportCountComposed();
        int n2 = -1;
        while (n2 < n) {
            StylesheetComposed stylesheetComposed = n2 < 0 ? this : this.getImportComposed(n2);
            int n3 = stylesheetComposed.getVariableCount();
            int n4 = 0;
            while (n4 < n3) {
                ElemVariable elemVariable = stylesheetComposed.getVariable(n4);
                if (this.m_variables.get(elemVariable.getName()) == null) {
                    this.m_variables.put(elemVariable.getName(), elemVariable);
                }
                ++n4;
            }
            int n5 = stylesheetComposed.getIncludeCountComposed();
            int n6 = 0;
            while (n6 < n5) {
                Stylesheet stylesheet = stylesheetComposed.getIncludeComposed(n6);
                n3 = stylesheet.getVariableCount();
                int n7 = 0;
                while (n7 < n3) {
                    ElemVariable elemVariable = stylesheet.getVariable(n7);
                    if (this.m_variables.get(elemVariable.getName()) == null) {
                        this.m_variables.put(elemVariable.getName(), elemVariable);
                    }
                    ++n7;
                }
                ++n6;
            }
            ++n2;
        }
    }

    public ElemVariable getVariableComposed(QName qName) {
        return (ElemVariable)this.m_variables.get(qName);
    }

    public Enumeration getVariablesComposed() {
        return this.m_variables.elements();
    }

    void recomposeParams() {
        this.m_params = new Hashtable();
        int n = this.getImportCountComposed();
        int n2 = -1;
        while (n2 < n) {
            StylesheetComposed stylesheetComposed = n2 < 0 ? this : this.getImportComposed(n2);
            int n3 = stylesheetComposed.getParamCount();
            int n4 = 0;
            while (n4 < n3) {
                ElemParam elemParam = stylesheetComposed.getParam(n4);
                if (this.m_params.get(elemParam.getName()) == null) {
                    this.m_params.put(elemParam.getName(), elemParam);
                }
                ++n4;
            }
            int n5 = stylesheetComposed.getIncludeCountComposed();
            int n6 = 0;
            while (n6 < n5) {
                Stylesheet stylesheet = stylesheetComposed.getIncludeComposed(n6);
                n3 = stylesheet.getParamCount();
                int n7 = 0;
                while (n7 < n3) {
                    ElemParam elemParam = stylesheet.getParam(n7);
                    if (this.m_params.get(elemParam.getName()) == null) {
                        this.m_params.put(elemParam.getName(), elemParam);
                    }
                    ++n7;
                }
                ++n6;
            }
            ++n2;
        }
    }

    public ElemParam getParamComposed(QName qName) {
        return (ElemParam)this.m_params.get(qName);
    }

    public Enumeration getParamsComposed() {
        return this.m_params.elements();
    }

    public final TemplateList getTemplateListComposed() {
        return this.m_templateList;
    }

    public void recomposeTemplates() throws SAXException {
        int n = this.getIncludeCountComposed();
        int n2 = n - 1;
        while (n2 >= -1) {
            StylesheetComposed stylesheetComposed = n2 == -1 ? this : this.getIncludeComposed(n2);
            int n3 = stylesheetComposed.getTemplateCount();
            int n4 = 0;
            while (n4 < n3) {
                this.m_templateList.setTemplate(stylesheetComposed.getTemplate(n4));
                ++n4;
            }
            --n2;
        }
        this.m_templateList.compose();
    }

    public void recomposeTemplates(boolean bl) throws SAXException {
        if (bl) {
            this.m_templateList = new TemplateList(this);
        }
        this.recomposeTemplates();
    }

    public ElemTemplate getTemplateComposed(XPathContext xPathContext, Node node, QName qName, boolean bl) throws SAXException {
        return this.m_templateList.getTemplate(xPathContext, node, qName, bl);
    }

    public ElemTemplate getTemplateComposed(QName qName) {
        return this.m_templateList.getTemplate(qName);
    }

    void recomposeNamespaceAliases() {
        this.m_namespaceAliasComposed = new Hashtable();
        int n = this.getImportCountComposed();
        int n2 = -1;
        while (n2 < n) {
            StylesheetComposed stylesheetComposed = n2 < 0 ? this : this.getImportComposed(n2);
            int n3 = stylesheetComposed.getNamespaceAliasCount();
            int n4 = 0;
            while (n4 < n3) {
                NamespaceAlias namespaceAlias = stylesheetComposed.getNamespaceAlias(n4);
                this.m_namespaceAliasComposed.put(namespaceAlias.getStylesheetPrefix(), namespaceAlias.getResultPrefix());
                ++n4;
            }
            int n5 = stylesheetComposed.getIncludeCountComposed();
            int n6 = 0;
            while (n6 < n5) {
                Stylesheet stylesheet = stylesheetComposed.getIncludeComposed(n6);
                n3 = stylesheet.getNamespaceAliasCount();
                int n7 = 0;
                while (n7 < n3) {
                    NamespaceAlias namespaceAlias = stylesheet.getNamespaceAlias(n7);
                    this.m_namespaceAliasComposed.put(namespaceAlias.getStylesheetPrefix(), namespaceAlias.getResultPrefix());
                    ++n7;
                }
                ++n6;
            }
            ++n2;
        }
    }

    public String getNamespaceAliasComposed(String string) {
        return (String)this.m_namespaceAliasComposed.get(string);
    }
}

