/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.templates;

import java.io.Serializable;
import java.util.Vector;
import org.apache.serialize.OutputFormat;
import org.apache.trax.ProcessorException;
import org.apache.trax.Templates;
import org.apache.trax.Transformer;
import org.apache.xalan.templates.ElemApplyTemplates;
import org.apache.xalan.templates.ElemTemplate;
import org.apache.xalan.templates.ElemTemplateElement;
import org.apache.xalan.templates.ElemValueOf;
import org.apache.xalan.templates.OutputFormatExtended;
import org.apache.xalan.templates.Stylesheet;
import org.apache.xalan.templates.StylesheetComposed;
import org.apache.xalan.transformer.TransformerImpl;
import org.apache.xpath.XPath;
import org.xml.sax.SAXException;

public class StylesheetRoot
extends StylesheetComposed
implements Serializable,
Templates {
    private OutputFormat m_outputFormatComposed;
    private boolean m_outputMethodSet = false;
    private transient Vector m_globalImportList;
    private ElemTemplate m_defaultTextRule;
    private ElemTemplate m_defaultRule;
    private ElemTemplate m_defaultRootRule;

    public StylesheetRoot() throws ProcessorException {
        super(null);
        this.setStylesheetRoot(this);
        try {
            this.initDefaultRule();
            return;
        }
        catch (SAXException sAXException) {
            throw new ProcessorException("Can't init default templates!", sAXException);
        }
    }

    public boolean isRoot() {
        return true;
    }

    public Transformer newTransformer() {
        return new TransformerImpl(this);
    }

    public OutputFormat getOutputFormat() {
        OutputFormatExtended outputFormatExtended = new OutputFormatExtended();
        if (this.m_outputFormatComposed instanceof OutputFormatExtended) {
            outputFormatExtended.copyFrom((OutputFormatExtended)this.m_outputFormatComposed);
        } else {
            outputFormatExtended.copyFrom(this.m_outputFormatComposed);
        }
        return outputFormatExtended;
    }

    public void recompose() throws SAXException {
        this.recomposeImports();
        this.recomposeOutput();
        int n = this.getGlobalImportCount();
        int n2 = 0;
        while (n2 < n) {
            StylesheetComposed stylesheetComposed = this.getGlobalImport(n2);
            if (stylesheetComposed != this) {
                stylesheetComposed.recomposeImports();
                stylesheetComposed.recomposeIncludes(stylesheetComposed);
                stylesheetComposed.recomposeAttributeSets();
                stylesheetComposed.recomposeDecimalFormats();
                stylesheetComposed.recomposeKeys();
                stylesheetComposed.recomposeNamespaceAliases();
                stylesheetComposed.recomposeParams();
                stylesheetComposed.recomposeTemplates();
                stylesheetComposed.recomposeVariables();
                stylesheetComposed.recomposeWhiteSpaceInfo();
            }
            ++n2;
        }
        this.recomposeIncludes(this);
        this.recomposeAttributeSets();
        this.recomposeDecimalFormats();
        this.recomposeKeys();
        this.recomposeNamespaceAliases();
        this.recomposeParams();
        this.recomposeTemplates();
        this.recomposeVariables();
        this.recomposeWhiteSpaceInfo();
        this.composeTemplates(this);
    }

    void composeTemplates(ElemTemplateElement elemTemplateElement) {
        elemTemplateElement.compose();
        ElemTemplateElement elemTemplateElement2 = elemTemplateElement.getFirstChildElem();
        while (elemTemplateElement2 != null) {
            this.composeTemplates(elemTemplateElement2);
            elemTemplateElement2 = elemTemplateElement2.getNextSiblingElem();
        }
    }

    public OutputFormat getOutputComposed() {
        return this.m_outputFormatComposed;
    }

    public void recomposeOutput() {
        this.m_outputFormatComposed = new OutputFormatExtended();
        this.m_outputFormatComposed.setPreserveSpace(true);
        this.recomposeOutput(this);
    }

    private void recomposeOutput(Stylesheet stylesheet) {
        OutputFormatExtended outputFormatExtended;
        Stylesheet stylesheet2;
        int n;
        int n2 = stylesheet.getImportCount();
        if (n2 > 0) {
            n = 0;
            while (n < n2) {
                stylesheet2 = stylesheet.getImport(n);
                this.recomposeOutput(stylesheet2);
                ++n;
            }
        }
        if ((n2 = stylesheet.getIncludeCount()) > 0) {
            n = 0;
            while (n < n2) {
                stylesheet2 = stylesheet.getInclude(n);
                this.recomposeOutput(stylesheet2);
                ++n;
            }
        }
        if ((outputFormatExtended = this.getOutput()) != null) {
            ((OutputFormatExtended)this.m_outputFormatComposed).copyFrom(outputFormatExtended);
        }
    }

    public boolean isOutputMethodSet() {
        return this.m_outputMethodSet;
    }

    protected void addImports(Stylesheet stylesheet, boolean bl) {
        Stylesheet stylesheet2;
        int n;
        int n2 = stylesheet.getImportCount();
        if (n2 > 0) {
            n = 0;
            while (n < n2) {
                stylesheet2 = stylesheet.getImport(n);
                this.m_globalImportList.insertElementAt(stylesheet2, 0);
                this.addImports(stylesheet2, false);
                ++n;
            }
        }
        if ((n2 = stylesheet.getIncludeCount()) > 0) {
            n = 0;
            while (n < n2) {
                stylesheet2 = stylesheet.getInclude(n);
                this.addImports(stylesheet2, false);
                ++n;
            }
        }
        if (bl) {
            this.m_globalImportList.insertElementAt(stylesheet, 0);
        }
    }

    protected void recomposeImports() {
        if (this.m_globalImportList == null) {
            this.m_globalImportList = new Vector();
            int n = this.getImportCount();
            int n2 = 0;
            while (n2 < n) {
                StylesheetComposed stylesheetComposed = this.getImport(n2);
                this.addImports(stylesheetComposed, true);
                ++n2;
            }
            n = this.getIncludeCount();
            int n3 = 0;
            while (n3 < n) {
                Stylesheet stylesheet = this.getInclude(n3);
                this.addImports(stylesheet, false);
                ++n3;
            }
            this.m_globalImportList.insertElementAt(this, 0);
        }
        super.recomposeImports();
    }

    public StylesheetComposed getGlobalImport(int n) {
        return (StylesheetComposed)this.m_globalImportList.elementAt(n);
    }

    public int getGlobalImportCount() {
        return this.m_globalImportList.size();
    }

    public int getImportNumber(StylesheetComposed stylesheetComposed) {
        if (this == stylesheetComposed) {
            return 0;
        }
        int n = this.getGlobalImportCount();
        int n2 = 0;
        while (n2 < n) {
            if (stylesheetComposed == this.getGlobalImport(n2)) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public final ElemTemplate getDefaultTextRule() {
        return this.m_defaultTextRule;
    }

    public final ElemTemplate getDefaultRule() {
        return this.m_defaultRule;
    }

    public final ElemTemplate getDefaultRootRule() {
        return this.m_defaultRootRule;
    }

    private void initDefaultRule() throws SAXException {
        this.m_defaultRule = new ElemTemplate();
        this.m_defaultRule.setStylesheet(this);
        XPath xPath = new XPath("*", this, this, 1);
        this.m_defaultRule.setMatch(xPath);
        ElemApplyTemplates elemApplyTemplates = new ElemApplyTemplates();
        elemApplyTemplates.setIsDefaultTemplate(true);
        this.m_defaultRule.appendChild(elemApplyTemplates);
        this.m_defaultTextRule = new ElemTemplate();
        this.m_defaultTextRule.setStylesheet(this);
        xPath = new XPath("text() | @*", this, this, 1);
        this.m_defaultTextRule.setMatch(xPath);
        ElemValueOf elemValueOf = new ElemValueOf();
        this.m_defaultTextRule.appendChild(elemValueOf);
        XPath xPath2 = new XPath(".", this, this, 0);
        elemValueOf.setSelect(xPath2);
        this.m_defaultRootRule = new ElemTemplate();
        this.m_defaultRootRule.setStylesheet(this);
        xPath = new XPath("/", this, this, 1);
        this.m_defaultRootRule.setMatch(xPath);
        elemApplyTemplates = new ElemApplyTemplates();
        elemApplyTemplates.setIsDefaultTemplate(true);
        this.m_defaultRootRule.appendChild(elemApplyTemplates);
    }
}

