/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.templates;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.xalan.templates.ElemTemplate;
import org.apache.xalan.templates.ElemTemplateElement;
import org.apache.xalan.templates.Stylesheet;
import org.apache.xalan.templates.StylesheetComposed;
import org.apache.xalan.templates.TemplateSubPatternAssociation;
import org.apache.xalan.utils.QName;
import org.apache.xpath.Expression;
import org.apache.xpath.XPath;
import org.apache.xpath.XPathContext;
import org.apache.xpath.patterns.NodeTest;
import org.apache.xpath.patterns.StepPattern;
import org.apache.xpath.patterns.UnionPattern;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class TemplateList
implements Serializable {
    boolean DEBUG = false;
    private Stylesheet m_stylesheet;
    private ElemTemplateElement m_firstTemplate;
    private Hashtable m_namedTemplates = new Hashtable();
    private Hashtable m_patternTable = new Hashtable();
    private TemplateSubPatternAssociation m_wildCardPatterns;

    TemplateList(Stylesheet stylesheet) {
        this.m_stylesheet = stylesheet;
    }

    public void setTemplate(ElemTemplate elemTemplate) {
        Serializable serializable;
        int n = 0;
        if (this.m_firstTemplate == null) {
            this.m_firstTemplate = elemTemplate;
        } else {
            serializable = this.m_firstTemplate;
            while (serializable != null) {
                if (((ElemTemplateElement)serializable).m_nextSibling == null) {
                    ((ElemTemplateElement)serializable).m_nextSibling = elemTemplate;
                    elemTemplate.m_nextSibling = null;
                    break;
                }
                if (elemTemplate.equals(((ElemTemplateElement)serializable).m_nextSibling)) {
                    ++n;
                    break;
                }
                ++n;
                serializable = ((ElemTemplateElement)serializable).m_nextSibling;
            }
        }
        if (elemTemplate.getName() != null) {
            if (this.m_namedTemplates.get(elemTemplate.getName()) == null) {
                this.m_namedTemplates.put(elemTemplate.getName(), elemTemplate);
            } else {
                elemTemplate.error(105, new Object[]{elemTemplate.getName()});
            }
        }
        if ((serializable = elemTemplate.getMatch()) != null) {
            Expression expression = ((XPath)serializable).getExpression();
            if (expression instanceof StepPattern) {
                this.insertPatternInTable((StepPattern)expression, elemTemplate, n);
            }
            if (expression instanceof UnionPattern) {
                UnionPattern unionPattern = (UnionPattern)expression;
                StepPattern[] stepPatternArray = unionPattern.getPatterns();
                int n2 = stepPatternArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    this.insertPatternInTable(stepPatternArray[n3], elemTemplate, n);
                    ++n3;
                }
            }
        }
    }

    void dumpAssociationTables() {
        TemplateSubPatternAssociation templateSubPatternAssociation;
        Enumeration enumeration = this.m_patternTable.elements();
        while (enumeration.hasMoreElements()) {
            templateSubPatternAssociation = (TemplateSubPatternAssociation)enumeration.nextElement();
            while (templateSubPatternAssociation != null) {
                System.out.print("(" + templateSubPatternAssociation.getTargetString() + ", " + templateSubPatternAssociation.getPattern() + ")");
                templateSubPatternAssociation = templateSubPatternAssociation.getNext();
            }
            System.out.println("\n.....");
        }
        templateSubPatternAssociation = this.m_wildCardPatterns;
        System.out.print("wild card list: ");
        while (templateSubPatternAssociation != null) {
            System.out.print("(" + templateSubPatternAssociation.getTargetString() + ", " + templateSubPatternAssociation.getPattern() + ")");
            templateSubPatternAssociation = templateSubPatternAssociation.getNext();
        }
        System.out.println("\n.....");
    }

    public void compose() {
        if (this.DEBUG) {
            System.out.println("Before wildcard insert...");
            this.dumpAssociationTables();
        }
        if (this.m_wildCardPatterns != null) {
            Enumeration enumeration = this.m_patternTable.elements();
            while (enumeration.hasMoreElements()) {
                TemplateSubPatternAssociation templateSubPatternAssociation = (TemplateSubPatternAssociation)enumeration.nextElement();
                TemplateSubPatternAssociation templateSubPatternAssociation2 = this.m_wildCardPatterns;
                while (templateSubPatternAssociation2 != null) {
                    try {
                        this.insertAssociationIntoList(templateSubPatternAssociation, (TemplateSubPatternAssociation)templateSubPatternAssociation2.clone(), true);
                    }
                    catch (CloneNotSupportedException cloneNotSupportedException) {}
                    templateSubPatternAssociation2 = templateSubPatternAssociation2.getNext();
                }
            }
        }
        if (this.DEBUG) {
            System.out.println("After wildcard insert...");
            this.dumpAssociationTables();
        }
    }

    private void insertAssociationIntoList(TemplateSubPatternAssociation templateSubPatternAssociation, TemplateSubPatternAssociation templateSubPatternAssociation2, boolean bl) {
        TemplateSubPatternAssociation templateSubPatternAssociation3;
        double d = this.getPriorityOrScore(templateSubPatternAssociation2);
        while ((templateSubPatternAssociation3 = templateSubPatternAssociation.getNext()) != null && this.getPriorityOrScore(templateSubPatternAssociation3) > d) {
            templateSubPatternAssociation = templateSubPatternAssociation3;
        }
        if (bl) {
            if (this.getPriorityOrScore(templateSubPatternAssociation) < d) {
                templateSubPatternAssociation2.setNext(templateSubPatternAssociation);
                String string = templateSubPatternAssociation.getTargetString();
                templateSubPatternAssociation2.setTargetString(string);
                this.putHead(string, templateSubPatternAssociation2);
                return;
            }
            templateSubPatternAssociation2.setNext(templateSubPatternAssociation3);
            templateSubPatternAssociation.setNext(templateSubPatternAssociation2);
            return;
        }
        if (this.getPriorityOrScore(templateSubPatternAssociation) <= d) {
            templateSubPatternAssociation2.setNext(templateSubPatternAssociation);
            if (templateSubPatternAssociation.isWild() || templateSubPatternAssociation2.isWild()) {
                this.m_wildCardPatterns = templateSubPatternAssociation2;
                return;
            }
            this.putHead(templateSubPatternAssociation2.getTargetString(), templateSubPatternAssociation2);
            return;
        }
        templateSubPatternAssociation2.setNext(templateSubPatternAssociation3);
        templateSubPatternAssociation.setNext(templateSubPatternAssociation2);
    }

    private void insertPatternInTable(StepPattern stepPattern, ElemTemplate elemTemplate, int n) {
        String string = stepPattern.getTargetString();
        if (string != null) {
            TemplateSubPatternAssociation templateSubPatternAssociation;
            String string2 = elemTemplate.getMatch().getPatternString();
            TemplateSubPatternAssociation templateSubPatternAssociation2 = new TemplateSubPatternAssociation(elemTemplate, stepPattern, string2, n);
            boolean bl = templateSubPatternAssociation2.isWild();
            TemplateSubPatternAssociation templateSubPatternAssociation3 = templateSubPatternAssociation = bl ? this.m_wildCardPatterns : this.getHead(string);
            if (templateSubPatternAssociation == null) {
                if (bl) {
                    this.m_wildCardPatterns = templateSubPatternAssociation2;
                    return;
                }
                this.putHead(string, templateSubPatternAssociation2);
                return;
            }
            this.insertAssociationIntoList(templateSubPatternAssociation, templateSubPatternAssociation2, false);
        }
    }

    private double getPriorityOrScore(TemplateSubPatternAssociation templateSubPatternAssociation) {
        StepPattern stepPattern;
        double d = templateSubPatternAssociation.getTemplate().getPriority();
        if (d == Double.NEGATIVE_INFINITY && (stepPattern = templateSubPatternAssociation.getStepPattern()) instanceof NodeTest) {
            return ((NodeTest)stepPattern).getDefaultScore();
        }
        return d;
    }

    public ElemTemplate getTemplate(QName qName) {
        ElemTemplate elemTemplate = (ElemTemplate)this.m_namedTemplates.get(qName);
        if (elemTemplate == null) {
            StylesheetComposed stylesheetComposed = this.getStylesheet().getStylesheetComposed();
            int n = stylesheetComposed.getImportCountComposed();
            int n2 = 0;
            while (n2 < n) {
                StylesheetComposed stylesheetComposed2 = stylesheetComposed.getImportComposed(n2);
                elemTemplate = stylesheetComposed2.getTemplateComposed(qName);
                if (elemTemplate != null) break;
                ++n2;
            }
        }
        return elemTemplate;
    }

    TemplateSubPatternAssociation getHead(XPathContext xPathContext, Node node) {
        TemplateSubPatternAssociation templateSubPatternAssociation;
        short s = node.getNodeType();
        switch (s) {
            case 1: 
            case 2: 
            case 7: {
                String string = xPathContext.getDOMHelper().getLocalNameOfNode(node);
                templateSubPatternAssociation = this.getHead(string);
                break;
            }
            case 3: 
            case 4: {
                templateSubPatternAssociation = this.getHead("#text");
                break;
            }
            case 8: {
                templateSubPatternAssociation = this.getHead("#comment");
                break;
            }
            case 9: {
                templateSubPatternAssociation = this.getHead("/");
                break;
            }
            case 11: {
                templateSubPatternAssociation = this.getHead("*");
                break;
            }
            default: {
                templateSubPatternAssociation = this.getHead(node.getNodeName());
            }
        }
        if (templateSubPatternAssociation == null) {
            templateSubPatternAssociation = this.m_wildCardPatterns;
        }
        return templateSubPatternAssociation;
    }

    public ElemTemplate getTemplate(XPathContext xPathContext, Node node, QName qName, boolean bl) throws SAXException {
        TemplateSubPatternAssociation templateSubPatternAssociation = this.getHead(xPathContext, node);
        if (templateSubPatternAssociation != null) {
            try {
                xPathContext.pushCurrentNodeAndExpression(node, node);
                do {
                    if (templateSubPatternAssociation.m_stepPattern.execute(xPathContext) == NodeTest.SCORE_NONE || !templateSubPatternAssociation.matchMode(qName)) continue;
                    if (bl) {
                        this.checkConflicts(templateSubPatternAssociation, xPathContext, node, qName);
                    }
                    ElemTemplate elemTemplate = templateSubPatternAssociation.getTemplate();
                    Object var8_8 = null;
                    xPathContext.popCurrentNodeAndExpression();
                    return elemTemplate;
                } while ((templateSubPatternAssociation = templateSubPatternAssociation.getNext()) != null);
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                xPathContext.popCurrentNodeAndExpression();
                throw throwable;
            }
            Object var8_9 = null;
            xPathContext.popCurrentNodeAndExpression();
        }
        StylesheetComposed stylesheetComposed = this.getStylesheet().getStylesheetComposed();
        int n = stylesheetComposed.getImportCountComposed();
        int n2 = 0;
        while (n2 < n) {
            StylesheetComposed stylesheetComposed2 = stylesheetComposed.getImportComposed(n2);
            ElemTemplate elemTemplate = this.getTemplate(stylesheetComposed2, xPathContext, node, qName, bl);
            if (elemTemplate != null) {
                return elemTemplate;
            }
            ++n2;
        }
        return null;
    }

    private void checkConflicts(TemplateSubPatternAssociation templateSubPatternAssociation, XPathContext xPathContext, Node node, QName qName) {
    }

    protected ElemTemplate getTemplate(StylesheetComposed stylesheetComposed, XPathContext xPathContext, Node node, QName qName, boolean bl) throws SAXException {
        return stylesheetComposed.getTemplateComposed(xPathContext, node, qName, bl);
    }

    private void addObjectIfNotFound(Object object, Vector vector) {
        int n = vector.size();
        boolean bl = true;
        int n2 = 0;
        while (n2 < n) {
            if (vector.elementAt(n2) == object) {
                bl = false;
                break;
            }
            ++n2;
        }
        if (bl) {
            vector.addElement(object);
        }
    }

    private Stylesheet getStylesheet() {
        return this.m_stylesheet;
    }

    private ElemTemplateElement getFirstTemplate() {
        return this.m_firstTemplate;
    }

    private Hashtable getNamedTemplates() {
        return this.m_namedTemplates;
    }

    private void setNamedTemplates(Hashtable hashtable) {
        this.m_namedTemplates = hashtable;
    }

    private TemplateSubPatternAssociation locateHead(String string, boolean bl) {
        TemplateSubPatternAssociation templateSubPatternAssociation = this.getHead(string);
        if (templateSubPatternAssociation == null && bl) {
            return this.m_wildCardPatterns;
        }
        return templateSubPatternAssociation;
    }

    private TemplateSubPatternAssociation getHead(String string) {
        return (TemplateSubPatternAssociation)this.m_patternTable.get(string);
    }

    private void putHead(String string, TemplateSubPatternAssociation templateSubPatternAssociation) {
        this.m_patternTable.put(string, templateSubPatternAssociation);
    }
}

