/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.trace;

import java.util.TooManyListenersException;
import java.util.Vector;
import org.apache.xalan.templates.ElemTemplateElement;
import org.apache.xalan.trace.GenerateEvent;
import org.apache.xalan.trace.SelectionEvent;
import org.apache.xalan.trace.TraceListener;
import org.apache.xalan.trace.TracerEvent;
import org.apache.xalan.transformer.TransformerImpl;
import org.apache.xalan.utils.QName;
import org.apache.xpath.XPath;
import org.apache.xpath.objects.XObject;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class TraceManager {
    private TransformerImpl m_transformer;
    private Vector m_traceListeners;

    public TraceManager(TransformerImpl transformerImpl) {
        this.m_transformer = transformerImpl;
    }

    public void addTraceListener(TraceListener traceListener) throws TooManyListenersException {
        TransformerImpl.S_DEBUG = true;
        if (this.m_traceListeners == null) {
            this.m_traceListeners = new Vector();
        }
        this.m_traceListeners.addElement(traceListener);
    }

    public void removeTraceListener(TraceListener traceListener) {
        if (this.m_traceListeners != null) {
            this.m_traceListeners.removeElement(traceListener);
        }
    }

    public void fireGenerateEvent(GenerateEvent generateEvent) {
        if (this.m_traceListeners != null) {
            int n = this.m_traceListeners.size();
            int n2 = 0;
            while (n2 < n) {
                TraceListener traceListener = (TraceListener)this.m_traceListeners.elementAt(n2);
                traceListener.generated(generateEvent);
                ++n2;
            }
        }
    }

    public boolean hasTraceListeners() {
        return this.m_traceListeners != null;
    }

    public void fireTraceEvent(Node node, QName qName, ElemTemplateElement elemTemplateElement) {
        if (this.hasTraceListeners()) {
            this.fireTraceEvent(new TracerEvent(this.m_transformer, node, qName, elemTemplateElement));
        }
    }

    public void fireTraceEvent(TracerEvent tracerEvent) {
        if (this.hasTraceListeners()) {
            int n = this.m_traceListeners.size();
            int n2 = 0;
            while (n2 < n) {
                TraceListener traceListener = (TraceListener)this.m_traceListeners.elementAt(n2);
                traceListener.trace(tracerEvent);
                ++n2;
            }
        }
    }

    public void fireSelectedEvent(Node node, ElemTemplateElement elemTemplateElement, String string, XPath xPath, XObject xObject) throws SAXException {
        if (this.hasTraceListeners()) {
            this.fireSelectedEvent(new SelectionEvent(this.m_transformer, node, elemTemplateElement, string, xPath, xObject));
        }
    }

    public void fireSelectedEvent(SelectionEvent selectionEvent) throws SAXException {
        if (this.hasTraceListeners()) {
            int n = this.m_traceListeners.size();
            int n2 = 0;
            while (n2 < n) {
                TraceListener traceListener = (TraceListener)this.m_traceListeners.elementAt(n2);
                traceListener.selected(selectionEvent);
                ++n2;
            }
        }
    }
}

