/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.transformer;

import org.apache.trax.TransformException;
import org.apache.xalan.res.XSLMessages;
import org.apache.xalan.transformer.TransformerImpl;
import org.w3c.dom.Node;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;

public class MsgMgr {
    private TransformerImpl m_transformer;
    private static XSLMessages m_XSLMessages = new XSLMessages();

    public MsgMgr(TransformerImpl transformerImpl) {
        this.m_transformer = transformerImpl;
    }

    public void message(String string, boolean bl) throws SAXException {
        ErrorHandler errorHandler = this.m_transformer.getErrorHandler();
        if (errorHandler != null) {
            if (bl) {
                errorHandler.fatalError(new TransformException(string));
                return;
            }
            errorHandler.warning(new TransformException(string));
            return;
        }
        if (bl) {
            throw new TransformException(string);
        }
        System.out.println(string);
    }

    public void warn(int n) throws SAXException {
        this.warn(null, null, n, null);
    }

    public void warn(int n, Object[] objectArray) throws SAXException {
        this.warn(null, null, n, objectArray);
    }

    public void warn(Node node, Node node2, int n) throws SAXException {
        this.warn(node, node2, n, null);
    }

    public void warn(Node node, Node node2, int n, Object[] objectArray) throws SAXException {
        String string = XSLMessages.createWarning(n, objectArray);
        ErrorHandler errorHandler = this.m_transformer.getErrorHandler();
        if (errorHandler != null) {
            errorHandler.warning(new TransformException(string));
            return;
        }
        System.out.println(string);
    }

    public void error(String string) throws SAXException {
        ErrorHandler errorHandler = this.m_transformer.getErrorHandler();
        if (errorHandler != null) {
            errorHandler.fatalError(new TransformException(string));
            return;
        }
        throw new TransformException(string);
    }

    public void error(int n) throws SAXException {
        this.error(null, null, n, null);
    }

    public void error(int n, Object[] objectArray) throws SAXException {
        this.error(null, null, n, objectArray);
    }

    public void error(int n, Exception exception) throws SAXException {
        this.error(n, null, exception);
    }

    public void error(int n, Object[] objectArray, Exception exception) throws SAXException {
        String string = XSLMessages.createMessage(n, objectArray);
        ErrorHandler errorHandler = this.m_transformer.getErrorHandler();
        if (errorHandler != null) {
            errorHandler.fatalError(new TransformException(string));
            return;
        }
        throw new TransformException(string);
    }

    public void error(Node node, Node node2, int n) throws SAXException {
        this.error(node, node2, n, null);
    }

    public void error(Node node, Node node2, int n, Object[] objectArray) throws SAXException {
        String string = XSLMessages.createMessage(n, objectArray);
        ErrorHandler errorHandler = this.m_transformer.getErrorHandler();
        if (errorHandler != null) {
            errorHandler.warning(new TransformException(string));
            return;
        }
        throw new TransformException(string);
    }
}

