/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.transformer;

import java.util.Enumeration;
import org.apache.serialize.SerializerHandler;
import org.apache.xalan.templates.StylesheetRoot;
import org.apache.xalan.trace.GenerateEvent;
import org.apache.xalan.trace.TraceManager;
import org.apache.xalan.transformer.ClonerToResultTree;
import org.apache.xalan.transformer.QueuedEvents;
import org.apache.xalan.transformer.QueuedSAXEvent;
import org.apache.xalan.transformer.QueuedStartDocument;
import org.apache.xalan.transformer.QueuedStartElement;
import org.apache.xalan.transformer.SerializerSwitcher;
import org.apache.xalan.transformer.TransformerImpl;
import org.apache.xalan.utils.MutableAttrListImpl;
import org.apache.xalan.utils.QName;
import org.apache.xalan.utils.TreeWalker;
import org.apache.xalan.utils.XMLCharacterRecognizer;
import org.apache.xpath.DOMHelper;
import org.apache.xpath.XPathContext;
import org.apache.xpath.objects.XObject;
import org.w3c.dom.Attr;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.NamespaceSupport;

public class ResultTreeHandler
extends QueuedEvents
implements ContentHandler,
SerializerHandler,
LexicalHandler {
    private static final boolean DEBUG = false;
    boolean m_nsContextPushed = false;
    private NamespaceSupport m_nsSupport = new NamespaceSupport();
    private TransformerImpl m_transformer;
    private ContentHandler m_contentHandler;
    private StylesheetRoot m_stylesheetRoot;
    private int m_uniqueNSValue;
    private static final String S_NAMESPACEPREFIX = "ns";
    ClonerToResultTree m_cloner;
    private TraceManager m_tracer;
    private static final int EVT_SETDOCUMENTLOCATOR = 1;
    private static final int EVT_STARTDOCUMENT = 2;
    private static final int EVT_ENDDOCUMENT = 3;
    private static final int EVT_STARTPREFIXMAPPING = 4;
    private static final int EVT_ENDPREFIXMAPPING = 5;
    private static final int EVT_STARTELEMENT = 6;
    private static final int EVT_ENDELEMENT = 7;
    private static final int EVT_CHARACTERS = 8;
    private static final int EVT_IGNORABLEWHITESPACE = 9;
    private static final int EVT_PROCESSINGINSTRUCTION = 10;
    private static final int EVT_SKIPPEDENTITY = 11;
    private static final int EVT_COMMENT = 12;
    private static final int EVT_ENTITYREF = 13;
    private static final int EVT_STARTENTITY = 14;
    private static final int EVT_ENDENTITY = 15;
    private static final int EVT_STARTDTD = 16;
    private static final int EVT_ENDDTD = 17;
    private static final int EVT_STARTNONESCAPING = 18;
    private static final int EVT_ENDNONESCAPING = 19;
    private static final int EVT_STARTPRESERVING = 20;
    private static final int EVT_ENDENDPRESERVING = 21;
    private static final int EVT_STARTCDATA = 22;
    private static final int EVT_ENDCDATA = 23;
    private static final int EVT_NODE = 24;

    public ResultTreeHandler() {
    }

    public ResultTreeHandler(TransformerImpl transformerImpl, ContentHandler contentHandler) {
        this.init(transformerImpl, contentHandler);
    }

    public void init(TransformerImpl transformerImpl, ContentHandler contentHandler) {
        this.m_transformer = transformerImpl;
        this.m_tracer = transformerImpl.getTraceManager();
        this.m_contentHandler = contentHandler;
        this.m_cloner = new ClonerToResultTree(transformerImpl, this);
        if (this.m_transformer != null) {
            this.m_stylesheetRoot = this.m_transformer.getStylesheet();
        }
        this.pushDocumentEvent();
    }

    public void startDocument() throws SAXException {
    }

    public void endDocument() throws SAXException {
        this.flushPending(3);
        this.getQueuedDocAtBottom().flushEnd();
    }

    public void startElement(String string, String string2, String string3) throws SAXException {
        this.startElement(string, string2, string3, null);
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        QueuedStartElement queuedStartElement = this.getQueuedElem();
        this.checkForSerializerSwitch(string, string2);
        this.flushPending(6);
        if (!this.m_nsContextPushed) {
            this.m_nsSupport.pushContext();
        }
        this.ensurePrefixIsDeclared(string, string3);
        this.pushElementEvent(string, string2, string3, attributes);
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        this.flushPending(7);
        QueuedStartElement queuedStartElement = this.getQueuedElem();
        queuedStartElement.flushEnd();
        this.sendEndPrefixMappings();
        this.popEvent();
        this.m_nsSupport.popContext();
    }

    public void startPrefixMapping(String string, String string2) throws SAXException {
        this.startPrefixMapping(string, string2, false);
    }

    public void startPrefixMapping(String string, String string2, boolean bl) throws SAXException {
        String string3;
        if (bl) {
            this.flushPending(4);
        }
        if (!this.m_nsContextPushed) {
            this.m_nsSupport.pushContext();
            this.m_nsContextPushed = true;
        }
        if (string == null) {
            string = "";
        }
        if ((string3 = this.m_nsSupport.getURI(string)) == null || !string3.equals(string2)) {
            this.m_nsSupport.declarePrefix(string, string2);
        }
    }

    public void endPrefixMapping(String string) throws SAXException {
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        QueuedStartDocument queuedStartDocument = this.getQueuedDoc();
        if (queuedStartDocument != null && queuedStartDocument.isPending && XMLCharacterRecognizer.isWhiteSpace(cArray, n, n2)) {
            return;
        }
        this.flushPending(8);
        this.getContentHandler().characters(cArray, n, n2);
        this.m_tracer.fireGenerateEvent(new GenerateEvent(this.m_transformer, 5, cArray, n, n2));
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        QueuedStartDocument queuedStartDocument = this.getQueuedDoc();
        if (queuedStartDocument != null && queuedStartDocument.isPending && XMLCharacterRecognizer.isWhiteSpace(cArray, n, n2)) {
            return;
        }
        this.flushPending(9);
        this.getContentHandler().ignorableWhitespace(cArray, n, n2);
        this.m_tracer.fireGenerateEvent(new GenerateEvent(this.m_transformer, 6, cArray, n, n2));
    }

    public void processingInstruction(String string, String string2) throws SAXException {
        this.flushPending(10);
        this.getContentHandler().processingInstruction(string, string2);
        this.m_tracer.fireGenerateEvent(new GenerateEvent(this.m_transformer, 7, string, string2));
    }

    public void comment(String string) throws SAXException {
        this.flushPending(12);
        if (this.getContentHandler() instanceof LexicalHandler) {
            ((LexicalHandler)((Object)this.getContentHandler())).comment(string.toCharArray(), 0, string.length());
        }
        this.m_tracer.fireGenerateEvent(new GenerateEvent(this.m_transformer, 8, string));
    }

    public void comment(char[] cArray, int n, int n2) throws SAXException {
        this.flushPending(12);
        if (this.getContentHandler() instanceof LexicalHandler) {
            ((LexicalHandler)((Object)this.getContentHandler())).comment(cArray, n, n2);
        }
        this.m_tracer.fireGenerateEvent(new GenerateEvent(this.m_transformer, 8, new String(cArray, n, n2)));
    }

    public void entityReference(String string) throws SAXException {
        this.flushPending(13);
        if (this.getContentHandler() instanceof LexicalHandler) {
            ((LexicalHandler)((Object)this.getContentHandler())).startEntity(string);
            ((LexicalHandler)((Object)this.getContentHandler())).endEntity(string);
        }
        this.m_tracer.fireGenerateEvent(new GenerateEvent(this.m_transformer, 9, string));
    }

    public void startEntity(String string) throws SAXException {
        this.flushPending(14);
        if (this.getContentHandler() instanceof LexicalHandler) {
            ((LexicalHandler)((Object)this.getContentHandler())).startEntity(string);
        }
    }

    public void endEntity(String string) throws SAXException {
        this.flushPending(15);
        if (this.getContentHandler() instanceof LexicalHandler) {
            ((LexicalHandler)((Object)this.getContentHandler())).endEntity(string);
        }
        this.m_tracer.fireGenerateEvent(new GenerateEvent(this.m_transformer, 9, string));
    }

    public void startDTD(String string, String string2, String string3) throws SAXException {
        this.flushPending(16);
        if (this.getContentHandler() instanceof LexicalHandler) {
            ((LexicalHandler)((Object)this.getContentHandler())).startDTD(string, string2, string3);
        }
    }

    public void endDTD() throws SAXException {
        this.flushPending(17);
        if (this.getContentHandler() instanceof LexicalHandler) {
            ((LexicalHandler)((Object)this.getContentHandler())).endDTD();
        }
    }

    public void startNonEscaping() throws SAXException {
        this.flushPending(18);
        if (this.getContentHandler() instanceof SerializerHandler) {
            ((SerializerHandler)((Object)this.getContentHandler())).startNonEscaping();
        }
    }

    public void endNonEscaping() throws SAXException {
        this.flushPending(19);
        if (this.getContentHandler() instanceof SerializerHandler) {
            ((SerializerHandler)((Object)this.getContentHandler())).endNonEscaping();
        }
    }

    public void startPreserving() throws SAXException {
        this.flushPending(20);
        if (this.getContentHandler() instanceof SerializerHandler) {
            ((SerializerHandler)((Object)this.getContentHandler())).startPreserving();
        }
    }

    public void endPreserving() throws SAXException {
        this.flushPending(21);
        if (this.getContentHandler() instanceof SerializerHandler) {
            ((SerializerHandler)((Object)this.getContentHandler())).endPreserving();
        }
    }

    public void startCDATA() throws SAXException {
        this.flushPending(22);
        if (this.getContentHandler() instanceof LexicalHandler) {
            ((LexicalHandler)((Object)this.getContentHandler())).startCDATA();
        }
    }

    public void endCDATA() throws SAXException {
        this.flushPending(23);
        if (this.getContentHandler() instanceof LexicalHandler) {
            ((LexicalHandler)((Object)this.getContentHandler())).endCDATA();
        }
    }

    public void skippedEntity(String string) throws SAXException {
    }

    public void flushPending() throws SAXException {
        this.flushPending(24);
    }

    public void flushPending(int n) throws SAXException {
        QueuedStartElement queuedStartElement = this.getQueuedElem();
        QueuedStartDocument queuedStartDocument = this.getQueuedDocAtBottom();
        if (n != 4 && queuedStartDocument.isPending) {
            queuedStartDocument.flush();
        }
        if (queuedStartElement != null && queuedStartElement.isPending) {
            if (!queuedStartElement.nsDeclsHaveBeenAdded()) {
                this.addNSDeclsToAttrs();
            }
            this.sendStartPrefixMappings();
            queuedStartElement.flush();
            this.m_nsContextPushed = false;
        }
    }

    public void outputResultTreeFragment(XObject xObject, XPathContext xPathContext) throws SAXException {
        DocumentFragment documentFragment = xObject.rtree(xPathContext);
        NodeList nodeList = documentFragment.getChildNodes();
        int n = nodeList.getLength();
        TreeWalker treeWalker = new TreeWalker(this);
        int n2 = 0;
        while (n2 < n) {
            this.flushPending(24);
            treeWalker.traverse(nodeList.item(n2));
            ++n2;
        }
    }

    public void cloneToResultTree(Node node, boolean bl) throws SAXException {
        this.m_cloner.cloneToResultTree(node, bl);
    }

    public void setDocumentLocator(Locator locator) {
    }

    void ensurePrefixIsDeclared(String string, String string2) throws SAXException {
        if (string != null && string.length() > 0) {
            String string3;
            String string4;
            int n = string2.indexOf(":");
            String string5 = string4 = n < 0 ? "" : string2.substring(0, n);
            if (!(string4 == null || (string3 = this.m_nsSupport.getURI(string4)) != null && string3.equals(string))) {
                this.startPrefixMapping(string4, string, false);
            }
        }
    }

    protected void sendStartPrefixMappings() throws SAXException {
        Enumeration enumeration = this.m_nsSupport.getDeclaredPrefixes();
        ContentHandler contentHandler = this.getContentHandler();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            contentHandler.startPrefixMapping(string, this.m_nsSupport.getURI(string));
        }
    }

    protected void sendEndPrefixMappings() throws SAXException {
        Enumeration enumeration = this.m_nsSupport.getDeclaredPrefixes();
        ContentHandler contentHandler = this.getContentHandler();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            contentHandler.endPrefixMapping(string);
        }
    }

    private void checkForSerializerSwitch(String string, String string2) throws SAXException {
        QueuedStartDocument queuedStartDocument = this.getQueuedDocAtBottom();
        if (queuedStartDocument.isPending) {
            SerializerSwitcher.switchSerializerIfHTML(this.m_transformer, string, string2);
        }
    }

    protected void addNSDeclsToAttrs() {
        Enumeration enumeration = this.m_nsSupport.getDeclaredPrefixes();
        QueuedStartElement queuedStartElement = this.getQueuedElem();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            boolean bl = string.length() == 0;
            String string2 = bl ? "xmlns" : "xmlns:" + string;
            String string3 = this.m_nsSupport.getURI(string);
            queuedStartElement.addAttribute("http://www.w3.org/2000/xmlns/", string, string2, "CDATA", string3);
        }
        queuedStartElement.setNSDeclsHaveBeenAdded(true);
    }

    public void processNSDecls(Node node) throws SAXException {
        Node node2;
        short s = node.getNodeType();
        if ((s == 1 || s == 5) && (node2 = node.getParentNode()) != null) {
            this.processNSDecls(node2);
        }
        if (s == 1) {
            NamedNodeMap namedNodeMap = node.getAttributes();
            int n = namedNodeMap.getLength();
            int n2 = 0;
            while (n2 < n) {
                Node node3 = namedNodeMap.item(n2);
                String string = node3.getNodeName();
                if (QName.isXMLNSDecl(string)) {
                    String string2 = QName.getPrefixFromXMLNSDecl(string);
                    String string3 = this.getURI(string2);
                    String string4 = node3.getNodeValue();
                    if (!string4.equalsIgnoreCase(string3)) {
                        this.startPrefixMapping(string2, string4);
                    }
                }
                ++n2;
            }
        }
    }

    public String getURI(String string) {
        return this.m_nsSupport.getURI(string);
    }

    public String getPrefix(String string) {
        Enumeration enumeration = this.m_nsSupport.getPrefixes();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (!this.m_nsSupport.getURI(string2).equals(string)) continue;
            return string2;
        }
        return null;
    }

    public NamespaceSupport getNamespaceSupport() {
        return this.m_nsSupport;
    }

    protected void initQSE(QueuedSAXEvent queuedSAXEvent) {
        queuedSAXEvent.setContentHandler(this.m_contentHandler);
        queuedSAXEvent.setTransformer(this.m_transformer);
        queuedSAXEvent.setTraceManager(this.m_tracer);
    }

    public ContentHandler getContentHandler() {
        return this.m_contentHandler;
    }

    public void setContentHandler(ContentHandler contentHandler) {
        this.m_contentHandler = contentHandler;
        this.reInitEvents();
    }

    public int getUniqueNSValue() {
        return this.m_uniqueNSValue++;
    }

    public String getNewUniqueNSPrefix() {
        return S_NAMESPACEPREFIX + String.valueOf(this.getUniqueNSValue());
    }

    public MutableAttrListImpl getPendingAttributes() {
        return this.getQueuedElem().getAttrs();
    }

    public void addAttribute(String string, String string2, String string3, String string4, String string5) throws SAXException {
        QueuedStartElement queuedStartElement = this.getQueuedElem();
        if (!queuedStartElement.nsDeclsHaveBeenAdded()) {
            this.addNSDeclsToAttrs();
        }
        this.ensurePrefixIsDeclared(string, string3);
        queuedStartElement.addAttribute(string, string2, string3, string4, string5);
    }

    public boolean isDefinedNSDecl(Attr attr) {
        int n;
        String string;
        String string2;
        String string3 = attr.getNodeName();
        return (string3.equals("xmlns") || string3.startsWith("xmlns:")) && (string2 = this.getURI(string = (n = string3.indexOf(":")) < 0 ? "" : string3.substring(0, n))) != null && string2.equals(attr.getValue());
    }

    public void addAttribute(Attr attr) throws SAXException {
        if (this.isDefinedNSDecl(attr)) {
            return;
        }
        DOMHelper dOMHelper = this.m_transformer.getXPathContext().getDOMHelper();
        this.addAttribute(dOMHelper.getNamespaceOfNode(attr), dOMHelper.getLocalNameOfNode(attr), attr.getNodeName(), "CDATA", attr.getValue());
    }

    public void addAttributes(Node node) throws SAXException {
        NamedNodeMap namedNodeMap = node.getAttributes();
        int n = namedNodeMap.getLength();
        int n2 = 0;
        while (n2 < n) {
            Attr attr = (Attr)namedNodeMap.item(n2);
            this.addAttribute(attr);
            ++n2;
        }
    }

    public boolean isElementPending() {
        QueuedStartElement queuedStartElement = this.getQueuedElem();
        if (queuedStartElement != null) {
            return queuedStartElement.isPending;
        }
        return false;
    }
}

